/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger;

import com.jetbrains.cidr.ArchitectureType;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.debugger.LLDBBinaries;
import org.rust.debugger.RsLLDBDriverConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/rust/debugger/RsCustomBinariesLLDBDriverConfiguration;", "Lorg/rust/debugger/RsLLDBDriverConfiguration;", "binaries", "Lorg/rust/debugger/LLDBBinaries;", "isElevated", "", "emulateTerminal", "<init>", "(Lorg/rust/debugger/LLDBBinaries;ZZ)V", "getDriverName", "", "getLLDBFrameworkFile", "Ljava/io/File;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "getLLDBFrontendFile", "useSTLRenderers", "useNatVisRenderers", "intellij.rustrover.debugger"})
final class RsCustomBinariesLLDBDriverConfiguration
extends RsLLDBDriverConfiguration {
    @NotNull
    private final LLDBBinaries binaries;

    public RsCustomBinariesLLDBDriverConfiguration(@NotNull LLDBBinaries binaries, boolean isElevated, boolean emulateTerminal) {
        Intrinsics.checkNotNullParameter((Object)binaries, (String)"binaries");
        super(isElevated, emulateTerminal);
        this.binaries = binaries;
    }

    @NotNull
    public String getDriverName() {
        return "Rust LLDB";
    }

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architectureType) {
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        File file = this.binaries.getFrameworkFile().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architectureType) {
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        File file = this.binaries.getFrontendFile().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @Override
    public boolean useSTLRenderers() {
        return false;
    }

    public boolean useNatVisRenderers() {
        return false;
    }
}

