/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.debugger.GDBBinaries;
import org.rust.debugger.RsGDBDriverConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/rust/debugger/RsCustomBinariesGDBDriverConfigurationBase;", "Lorg/rust/debugger/RsGDBDriverConfiguration;", "binaries", "Lorg/rust/debugger/GDBBinaries;", "isElevated", "", "emulateTerminal", "<init>", "(Lorg/rust/debugger/GDBBinaries;ZZ)V", "getBinaries", "()Lorg/rust/debugger/GDBBinaries;", "getDriverName", "", "getGDBExecutablePath", "getWinbreakFile", "Ljava/io/File;", "name", "intellij.rustrover.debugger"})
public class RsCustomBinariesGDBDriverConfigurationBase
extends RsGDBDriverConfiguration {
    @NotNull
    private final GDBBinaries binaries;

    public RsCustomBinariesGDBDriverConfigurationBase(@NotNull GDBBinaries binaries, boolean isElevated, boolean emulateTerminal) {
        Intrinsics.checkNotNullParameter((Object)binaries, (String)"binaries");
        super(isElevated, emulateTerminal);
        this.binaries = binaries;
    }

    @NotNull
    protected final GDBBinaries getBinaries() {
        return this.binaries;
    }

    @NotNull
    public String getDriverName() {
        return "Rust GDB";
    }

    @NotNull
    protected String getGDBExecutablePath() {
        return ((Object)this.binaries.getGdbFile()).toString();
    }

    @NotNull
    public File getWinbreakFile(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        File file = this.binaries.getGdbDir().resolve("bin/" + name2).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }
}

