/*
 * Decompiled with CFR 0.152.
 */
package org.rust.debugger;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBExpressionPlaceholder;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.debugger.RsBackendConsoleInjectionHelper;
import org.rust.lang.RsDebugInjectionListener;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/rust/debugger/RsBackendConsoleInjectionHelper;", "Lcom/jetbrains/cidr/execution/debugger/BackendConsoleInjectionHelper;", "<init>", "()V", "subscribeToInjection", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "originalDocument", "Lcom/intellij/openapi/editor/Document;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "getOriginalDocument", "(Lcom/intellij/psi/PsiLanguageInjectionHost;)Lcom/intellij/openapi/editor/Document;", "intellij.rustrover.debugger"})
public final class RsBackendConsoleInjectionHelper
implements BackendConsoleInjectionHelper {
    public void subscribeToInjection(@NotNull XDebugSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        MessageBusConnection connection = session2.getProject().getMessageBus().connect();
        RsDebugInjectionListener listener2 = new RsDebugInjectionListener(this, session2, connection){
            private volatile Document document;
            final /* synthetic */ RsBackendConsoleInjectionHelper this$0;
            final /* synthetic */ XDebugSession $session;
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                this.$connection = $connection;
            }

            public void evalDebugContext(PsiLanguageInjectionHost host, RsDebugInjectionListener.DebugContext context) {
                RsElement rsElement;
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Document document = RsBackendConsoleInjectionHelper.access$getOriginalDocument(this.this$0, host);
                if (document == null) {
                    return;
                }
                Document document2 = document;
                CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)document2.getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY);
                if (cidrDebugProcess == null) {
                    return;
                }
                CidrDebugProcess process2 = cidrDebugProcess;
                PsiElement psiElement2 = process2.getDebuggerContext();
                if (psiElement2 != null) {
                    PsiElement $this$ancestorOrSelf$iv = psiElement2;
                    boolean $i$f$ancestorOrSelf = false;
                    rsElement = (RsElement)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsElement.class, (boolean)false);
                } else {
                    rsElement = null;
                }
                context.setElement(rsElement);
            }

            public void didInject(PsiLanguageInjectionHost host) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                if (host instanceof GDBExpressionPlaceholder) {
                    this.document = RsBackendConsoleInjectionHelper.access$getOriginalDocument(this.this$0, host);
                }
            }

            public void stackFrameChanged() {
                Document document = this.document;
                if (document == null || (document = UtilsKt.getVirtualFile(document)) == null) {
                    return;
                }
                Document file = document;
                ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), () -> subscribeToInjection.listener.1.stackFrameChanged$lambda$0(this.$session, (VirtualFile)file));
            }

            public void sessionStopped() {
                this.$connection.disconnect();
            }

            private static final Unit stackFrameChanged$lambda$0(XDebugSession $session, VirtualFile $file) {
                PsiDocumentManager.getInstance((Project)$session.getProject()).reparseFiles((Collection)SetsKt.setOf((Object)$file), true);
                return Unit.INSTANCE;
            }
        };
        connection.subscribe(RsDebugInjectionListener.INJECTION_TOPIC, (Object)listener2);
        session2.addSessionListener((XDebugSessionListener)listener2);
    }

    private final Document getOriginalDocument(PsiLanguageInjectionHost $this$originalDocument) {
        return $this$originalDocument.getContainingFile().getOriginalFile().getViewProvider().getDocument();
    }

    public static final /* synthetic */ Document access$getOriginalDocument(RsBackendConsoleInjectionHelper $this, PsiLanguageInjectionHost $receiver) {
        return $this.getOriginalDocument($receiver);
    }
}

