/*
 * Decompiled with CFR 0.152.
 */
package org.rust.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.coverage.LcovCoverageReport;
import org.rust.coverage.RsCoverageEngine;
import org.rust.coverage.RsCoverageSuite;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/rust/coverage/RsCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "<init>", "()V", "getPresentableName", "", "getDataFileExtension", "getId", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "loadCoverageData", "Lcom/intellij/coverage/CoverageLoadingResult;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "reporter", "Lcom/intellij/coverage/CoverageLoadErrorReporter;", "readProjectData", "dataFile", "coverageSuite", "Lorg/rust/coverage/RsCoverageSuite;", "Companion", "intellij.rustrover.coverage"})
@SourceDebugExtension(value={"SMAP\nRsCoverageRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCoverageRunner.kt\norg/rust/coverage/RsCoverageRunner\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,95:1\n13#2:96\n*S KotlinDebug\n*F\n+ 1 RsCoverageRunner.kt\norg/rust/coverage/RsCoverageRunner\n*L\n92#1:96\n*E\n"})
public final class RsCoverageRunner
extends CoverageRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public String getPresentableName() {
        return "Rust";
    }

    @NotNull
    public String getDataFileExtension() {
        return "info";
    }

    @NotNull
    public String getId() {
        return "RsCoverageRunner";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof RsCoverageEngine;
    }

    @NotNull
    protected CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        CoverageLoadingResult coverageLoadingResult;
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(baseCoverageSuite instanceof RsCoverageSuite)) {
            Object object = baseCoverageSuite;
            String message = "Wrong suite type: Expected Rust coverage suite, got " + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null);
            return (CoverageLoadingResult)new FailedCoverageLoadingResult(message);
        }
        try {
            CoverageLoadingResult coverageLoadingResult2;
            if (UtilsKt.isDispatchThread()) {
                Project project = ((RsCoverageSuite)baseCoverageSuite).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                coverageLoadingResult2 = (CoverageLoadingResult)UtilsKt.computeWithCancelableProgress(project, RsBundle.INSTANCE.message("progress.title.loading.coverage.data", new Object[0]), () -> RsCoverageRunner.loadCoverageData$lambda$0(this, sessionDataFile, baseCoverageSuite));
            } else {
                coverageLoadingResult2 = this.readProjectData(sessionDataFile, (RsCoverageSuite)baseCoverageSuite);
            }
            coverageLoadingResult = coverageLoadingResult2;
        }
        catch (IOException e) {
            LOG.warn("Can't read coverage data", (Throwable)e);
            coverageLoadingResult = (CoverageLoadingResult)new FailedCoverageLoadingResult((Exception)e, true);
        }
        return coverageLoadingResult;
    }

    private final CoverageLoadingResult readProjectData(File dataFile, RsCoverageSuite coverageSuite) throws IOException {
        ProcessHandler coverageProcess = coverageSuite.getCoverageProcess();
        if (coverageProcess != null && !coverageProcess.isProcessTerminated()) {
            for (int i2 = 0; i2 < 100 && !coverageProcess.waitFor(100L); ++i2) {
                ProgressManager.checkCanceled();
            }
            if (!coverageProcess.isProcessTerminated()) {
                coverageProcess.destroyProcess();
                return (CoverageLoadingResult)new FailedCoverageLoadingResult("The process was terminated");
            }
        }
        ProjectData projectData = new ProjectData();
        LcovCoverageReport report = null;
        try {
            report = LcovCoverageReport.Serialization.INSTANCE.readLcov(dataFile, coverageSuite.getContextFilePath());
        }
        catch (IllegalStateException e) {
            LOG.warn("Couldn't parse LCOV file", (Throwable)e);
            return (CoverageLoadingResult)new FailedCoverageLoadingResult("Couldn't parse LCOV file: " + e.getMessage(), (Exception)e, projectData);
        }
        for (Map.Entry<String, List<LcovCoverageReport.LineHits>> entry2 : report.getRecords()) {
            String filePath = entry2.getKey();
            List<LcovCoverageReport.LineHits> lineHitsList = entry2.getValue();
            ClassData classData = projectData.getOrCreateClassData(filePath);
            LcovCoverageReport.LineHits lineHits = (LcovCoverageReport.LineHits)CollectionsKt.lastOrNull(lineHitsList);
            int max = lineHits != null ? lineHits.getLineNumber() : 0;
            LineData[] lines = new LineData[max + 1];
            for (LcovCoverageReport.LineHits lineHits2 : lineHitsList) {
                LineData lineData = new LineData(lineHits2.getLineNumber(), null);
                lineData.setHits(lineHits2.getHits());
                lines[lineHits2.getLineNumber()] = lineData;
            }
            classData.setLines(lines);
        }
        return (CoverageLoadingResult)new SuccessCoverageLoadingResult(projectData);
    }

    private static final CoverageLoadingResult loadCoverageData$lambda$0(RsCoverageRunner this$0, File $sessionDataFile, CoverageSuite $baseCoverageSuite) {
        return this$0.readProjectData($sessionDataFile, (RsCoverageSuite)$baseCoverageSuite);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsCoverageRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/coverage/RsCoverageRunner$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

