/*
 * Decompiled with CFR 0.152.
 */
package org.rust.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.coverage.LcovCoverageReport;
import org.rust.coverage.RsCoverageAnnotator;
import org.rust.coverage.RsCoverageEnabledConfiguration;
import org.rust.coverage.RsCoverageSuite;
import org.rust.coverage.RsCoverageViewExtension;
import org.rust.lang.RsFileType;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 S2\u00020\u0001:\u0001SB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0014J(\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\u00020\n2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0006H\u0016J \u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010-\u001a\u00020.H\u0016J\u0014\u0010/\u001a\u00020\n2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J+\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d012\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0006032\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u00104J \u00105\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\rH\u0016J \u00109\u001a\u00020:2\u0006\u0010\"\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u0010;\u001a\u00020\rH\u0016J\u0010\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020\u0015H\u0002J\u0010\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\rH\u0002J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020A012\u0006\u0010B\u001a\u00020CH\u0002J \u0010D\u001a\n\u0012\u0004\u0012\u00020E\u0018\u0001012\u0006\u0010F\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010G\u001a\u0004\u0018\u00010&2\u0006\u0010H\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010I\u001a\u00020(2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0016J:\u0010G\u001a\u0004\u0018\u00010&2\u0006\u0010H\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010I\u001a\u00020(2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0010H\u0016J\u0018\u0010O\u001a\u00020P2\u0006\u0010\"\u001a\u00020#2\u0006\u0010Q\u001a\u00020\rH\u0016J\u0012\u0010R\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006T"}, d2={"Lorg/rust/coverage/RsCoverageEngine;", "Lcom/intellij/coverage/CoverageEngine;", "<init>", "()V", "getQualifiedNames", "", "", "sourceFile", "Lcom/intellij/psi/PsiFile;", "acceptedByFilters", "", "psiFile", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "coverageEditorHighlightingApplicableTo", "createCoverageEnabledConfiguration", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "getQualifiedName", "outputFile", "Ljava/io/File;", "includeUntouchedFileInCoverage", "qualifiedName", "coverageProjectViewStatisticsApplicableTo", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTestMethodName", "element", "Lcom/intellij/psi/PsiElement;", "testProxy", "Lcom/intellij/execution/testframework/AbstractTestProxy;", "getCoverageAnnotator", "Lcom/intellij/coverage/CoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "isApplicableTo", "createEmptyCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "coverageRunner", "Lcom/intellij/coverage/CoverageRunner;", "getPresentableText", "recompileProjectAndRerunAction", "module", "Lcom/intellij/openapi/module/Module;", "chooseSuiteAction", "Ljava/lang/Runnable;", "canHavePerTestCoverage", "findTestsByNames", "", "testNames", "", "([Ljava/lang/String;Lcom/intellij/openapi/project/Project;)Ljava/util/List;", "isReportGenerationAvailable", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "currentSuite", "generateReport", "", "currentSuiteBundle", "refresh", "file", "getOutputFileName", "currentSuitesBundle", "convertClassDataToLineHits", "Lorg/rust/coverage/LcovCoverageReport$LineHits;", "classData", "Lcom/intellij/rt/coverage/data/ClassData;", "collectSrcLinesForUntouchedFile", "", "classFile", "createCoverageSuite", "name", "runner", "fileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "timestamp", "", "config", "createCoverageViewExtension", "Lcom/intellij/coverage/view/CoverageViewExtension;", "suiteBundle", "getQName", "Companion", "intellij.rustrover.coverage"})
@SourceDebugExtension(value={"SMAP\nRsCoverageEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCoverageEngine.kt\norg/rust/coverage/RsCoverageEngine\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,183:1\n13#2:184\n*S KotlinDebug\n*F\n+ 1 RsCoverageEngine.kt\norg/rust/coverage/RsCoverageEngine\n*L\n178#1:184\n*E\n"})
public final class RsCoverageEngine
extends CoverageEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        String qName;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        String string = qName = this.getQName(sourceFile);
        return string != null ? SetsKt.setOf((Object)string) : SetsKt.emptySet();
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        return psiFile instanceof RsFile;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof RsFile;
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return new RsCoverageEnabledConfiguration(conf);
    }

    @Nullable
    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.getQName(sourceFile);
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        return false;
    }

    public boolean coverageProjectViewStatisticsApplicableTo(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return !fileOrDir.isDirectory() && Intrinsics.areEqual((Object)fileOrDir.getFileType(), (Object)((Object)RsFileType.INSTANCE));
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)testProxy, (String)"testProxy");
        return null;
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (CoverageAnnotator)RsCoverageAnnotator.Companion.getInstance(project);
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return conf instanceof CargoCommandConfiguration;
    }

    @NotNull
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
        return (CoverageSuite)new RsCoverageSuite();
    }

    @NotNull
    public String getPresentableText() {
        return RsBundle.INSTANCE.message("action.rust.coverage.text", new Object[0]);
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)chooseSuiteAction, (String)"chooseSuiteAction");
        return false;
    }

    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return false;
    }

    @NotNull
    public List<PsiElement> findTestsByNames(@NotNull String[] testNames, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)testNames, (String)"testNames");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.emptyList();
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)currentSuite, (String)"currentSuite");
        return true;
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuiteBundle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)currentSuiteBundle, (String)"currentSuiteBundle");
        LcovCoverageReport coverageReport = new LcovCoverageReport();
        CoverageDataManager dataManager = CoverageDataManager.getInstance((Project)project);
        CoverageSuite[] coverageSuiteArray = currentSuiteBundle.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"getSuites(...)");
        for (CoverageSuite suite : coverageSuiteArray) {
            ProjectData projectData;
            if (suite.getCoverageData(dataManager) == null) continue;
            Map classDataMap = projectData.getClasses();
            Intrinsics.checkNotNull((Object)classDataMap);
            for (Map.Entry entry2 : classDataMap.entrySet()) {
                String filePath = (String)entry2.getKey();
                ClassData classData = (ClassData)entry2.getValue();
                Intrinsics.checkNotNull((Object)classData);
                List<LcovCoverageReport.LineHits> lineHitsList = this.convertClassDataToLineHits(classData);
                Intrinsics.checkNotNull((Object)filePath);
                coverageReport.mergeFileReport(null, filePath, lineHitsList);
            }
        }
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        File outputDir = new File(settings.OUTPUT_DIRECTORY);
        FileUtil.createDirectory((File)outputDir);
        String outputFileName = this.getOutputFileName(currentSuiteBundle);
        String title = RsBundle.INSTANCE.message("dialog.title.coverage.report.generation", new Object[0]);
        try {
            File output = new File(outputDir, outputFileName);
            LcovCoverageReport.Serialization.INSTANCE.writeLcov(coverageReport, output);
            this.refresh(output);
            String url = "https://github.com/linux-test-project/lcov";
            Object[] objectArray = new Object[]{outputFileName, url, url};
            Messages.showInfoMessage((String)RsBundle.INSTANCE.message("dialog.message.html.coverage.report.has.been.successfully.saved.as.file.br.use.instruction.in.href.to.generate.html.output.html", objectArray), (String)title);
        }
        catch (IOException e) {
            LOG.warn("Can not export coverage data", (Throwable)e);
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            Messages.showErrorDialog((String)RsBundle.INSTANCE.message("dialog.message.can.not.generate.coverage.report", objectArray), (String)title);
        }
    }

    private final void refresh(File file) {
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (vFile != null) {
            ActionsKt.runWriteAction(() -> RsCoverageEngine.refresh$lambda$0(vFile));
        }
    }

    private final String getOutputFileName(CoverageSuitesBundle currentSuitesBundle) {
        StringBuilder stringBuilder;
        StringBuilder $this$getOutputFileName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CoverageSuite[] coverageSuiteArray = currentSuitesBundle.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"getSuites(...)");
        for (CoverageSuite suite : coverageSuiteArray) {
            String presentableName = suite.getPresentableName();
            $this$getOutputFileName_u24lambda_u240.append(presentableName);
        }
        $this$getOutputFileName_u24lambda_u240.append(".lcov");
        return stringBuilder.toString();
    }

    private final List<LcovCoverageReport.LineHits> convertClassDataToLineHits(ClassData classData) {
        int lineCount = classData.getLines().length;
        ArrayList<LcovCoverageReport.LineHits> lineHitsList = new ArrayList<LcovCoverageReport.LineHits>(lineCount);
        for (int lineInd = 0; lineInd < lineCount; ++lineInd) {
            LineData lineData = classData.getLineData(lineInd);
            if (lineData == null) continue;
            LcovCoverageReport.LineHits lineHits = new LcovCoverageReport.LineHits(lineData.getLineNumber(), lineData.getHits());
            lineHitsList.add(lineHits);
        }
        return lineHitsList;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        return null;
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name2, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        return null;
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name2, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp, @NotNull CoverageEnabledConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!(config instanceof RsCoverageEnabledConfiguration)) {
            return null;
        }
        RunConfigurationBase runConfigurationBase = ((RsCoverageEnabledConfiguration)config).getConfiguration();
        CargoCommandConfiguration cargoCommandConfiguration = runConfigurationBase instanceof CargoCommandConfiguration ? (CargoCommandConfiguration)runConfigurationBase : null;
        if (cargoCommandConfiguration == null) {
            return null;
        }
        CargoCommandConfiguration configuration = cargoCommandConfiguration;
        return (CoverageSuite)new RsCoverageSuite(project, name2, fileProvider, runner, configuration.getWorkingDirectory(), ((RsCoverageEnabledConfiguration)config).getCoverageProcess());
    }

    @NotNull
    public CoverageViewExtension createCoverageViewExtension(@NotNull Project project, @NotNull CoverageSuitesBundle suiteBundle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suiteBundle, (String)"suiteBundle");
        return (CoverageViewExtension)new RsCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle);
    }

    private final String getQName(PsiFile sourceFile) {
        VirtualFile virtualFile = sourceFile.getVirtualFile();
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    private static final Unit refresh$lambda$0(VirtualFile $vFile) {
        $vFile.refresh(false, false);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsCoverageEngine.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/coverage/RsCoverageEngine$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

