/*
 * Decompiled with CFR 0.152.
 */
package org.rust.coverage;

import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.stdext.CollectionBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/rust/coverage/LcovCoverageReport;", "", "<init>", "()V", "info", "", "", "", "Lorg/rust/coverage/LcovCoverageReport$LineHits;", "records", "", "", "getRecords", "()Ljava/util/Set;", "mergeFileReport", "", "basePath", "filePath", "report", "LineHits", "Serialization", "Companion", "intellij.rustrover.coverage"})
public final class LcovCoverageReport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<LineHits>> info = new HashMap();

    @NotNull
    public final Set<Map.Entry<String, List<LineHits>>> getRecords() {
        return this.info.entrySet();
    }

    public final void mergeFileReport(@Nullable String basePath, @NotNull String filePath, @NotNull List<LineHits> report) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(report, (String)"report");
        File it2 = new File(filePath);
        boolean bl = false;
        File file = it2.isAbsolute() || basePath == null ? it2 : new File(basePath, filePath);
        String normalizedFilePath = FileUtilKt.getSystemIndependentPath((File)file);
        List<LineHits> oldReport = this.info.get(normalizedFilePath);
        List it3 = LcovCoverageReport.Companion.normalizeLineHitsList(report);
        boolean bl2 = false;
        List<LineHits> list = oldReport;
        List result2 = list == null ? it3 : LcovCoverageReport.Companion.doMerge(list, report);
        this.info.put(normalizedFilePath, result2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/rust/coverage/LcovCoverageReport$Companion;", "", "<init>", "()V", "normalizeLineHitsList", "", "Lorg/rust/coverage/LcovCoverageReport$LineHits;", "lineHits", "doMerge", "list1", "list2", "intellij.rustrover.coverage"})
    @SourceDebugExtension(value={"SMAP\nLcovCoverageReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LcovCoverageReport.kt\norg/rust/coverage/LcovCoverageReport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Collections.kt\norg/rust/stdext/CollectionsKt\n*L\n1#1,138:1\n1056#2:139\n1669#2,8:140\n13#3:148\n31#3:149\n23#3,10:150\n*S KotlinDebug\n*F\n+ 1 LcovCoverageReport.kt\norg/rust/coverage/LcovCoverageReport$Companion\n*L\n111#1:139\n111#1:140,8\n113#1:148\n113#1:149\n113#1:150,10\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<LineHits> normalizeLineHitsList(List<LineHits> lineHits) {
            Iterable $this$sortedBy$iv = lineHits;
            boolean $i$f$sortedBy = false;
            Iterable $this$distinctBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LineHits it2 = (LineHits)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it2.getLineNumber());
                    it2 = (LineHits)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it2.getLineNumber()));
                }
            });
            boolean $i$f$distinctBy = false;
            HashSet<Integer> set$iv = new HashSet<Integer>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                LineHits it2 = (LineHits)e$iv;
                boolean bl = false;
                Integer key$iv = it2.getLineNumber();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            return list$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LineHits> doMerge(List<LineHits> list1, List<LineHits> list2) {
            void result$iv$iv;
            boolean $i$f$buildList = false;
            Collection collection = new ArrayList();
            boolean $i$f$buildCollection = false;
            CollectionBuilder $this$doMerge_u24lambda_u240 = new CollectionBuilder<LineHits>((Collection)result$iv$iv){
                final /* synthetic */ Collection $result;
                {
                    this.$result = $result;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public void add(Object item) {
                    this.$result.add(item);
                }

                public void addAll(Collection<? extends LineHits> items) {
                    Intrinsics.checkNotNullParameter(items, (String)"items");
                    this.$result.addAll(items);
                }
            };
            boolean bl = false;
            PeekableIteratorWrapper iter1 = new PeekableIteratorWrapper(list1.iterator());
            PeekableIteratorWrapper iter2 = new PeekableIteratorWrapper(list2.iterator());
            while (iter1.hasNext() && iter2.hasNext()) {
                LineHits lineHits;
                LineHits head1 = (LineHits)iter1.peek();
                LineHits head2 = (LineHits)iter2.peek();
                if (head1.getLineNumber() < head2.getLineNumber()) {
                    lineHits = (LineHits)iter1.next();
                } else if (head1.getLineNumber() > head2.getLineNumber()) {
                    lineHits = (LineHits)iter2.next();
                } else {
                    head1.addHits(head2.getHits());
                    iter1.next();
                    iter2.next();
                    lineHits = head1;
                }
                LineHits next = lineHits;
                $this$doMerge_u24lambda_u240.add(next);
            }
            iter1.forEachRemaining(arg_0 -> Companion.doMerge$lambda$0$0((Function1)new Function1<LineHits, Unit>((Object)$this$doMerge_u24lambda_u240){

                public final void invoke(LineHits p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((CollectionBuilder)this.receiver).add(p0);
                }
            }, arg_0));
            iter2.forEachRemaining(arg_0 -> Companion.doMerge$lambda$0$1((Function1)new Function1<LineHits, Unit>((Object)$this$doMerge_u24lambda_u240){

                public final void invoke(LineHits p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((CollectionBuilder)this.receiver).add(p0);
                }
            }, arg_0));
            return (List)result$iv$iv;
        }

        private static final void doMerge$lambda$0$0(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void doMerge$lambda$0$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/rust/coverage/LcovCoverageReport$LineHits;", "", "lineNumber", "", "hits", "<init>", "(II)V", "getLineNumber", "()I", "value", "getHits", "addHits", "", "hitCount", "intellij.rustrover.coverage"})
    public static final class LineHits {
        private final int lineNumber;
        private int hits;

        public LineHits(int lineNumber, int hits) {
            this.lineNumber = lineNumber;
            this.hits = hits;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final int getHits() {
            return this.hits;
        }

        public final void addHits(int hitCount) {
            if (this.hits == -1) {
                return;
            }
            this.hits = hitCount == -1 ? hitCount : (this.hits += hitCount);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/coverage/LcovCoverageReport$Serialization;", "", "<init>", "()V", "SOURCE_FILE_PREFIX", "", "LINE_HIT_PREFIX", "END_OF_RECORD", "readLcov", "Lorg/rust/coverage/LcovCoverageReport;", "lcovFile", "Ljava/io/File;", "localBaseDir", "writeLcov", "", "report", "outputFile", "intellij.rustrover.coverage"})
    @SourceDebugExtension(value={"SMAP\nLcovCoverageReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LcovCoverageReport.kt\norg/rust/coverage/LcovCoverageReport$Serialization\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1#2:139\n739#3,9:140\n*S KotlinDebug\n*F\n+ 1 LcovCoverageReport.kt\norg/rust/coverage/LcovCoverageReport$Serialization\n*L\n68#1:140,9\n*E\n"})
    public static final class Serialization {
        @NotNull
        public static final Serialization INSTANCE = new Serialization();
        @NotNull
        private static final String SOURCE_FILE_PREFIX = "SF:";
        @NotNull
        private static final String LINE_HIT_PREFIX = "DA:";
        @NotNull
        private static final String END_OF_RECORD = "end_of_record";

        private Serialization() {
        }

        @NotNull
        public final LcovCoverageReport readLcov(@NotNull File lcovFile, @Nullable String localBaseDir) {
            Intrinsics.checkNotNullParameter((Object)lcovFile, (String)"lcovFile");
            LcovCoverageReport report = new LcovCoverageReport();
            Ref.ObjectRef currentFileName = new Ref.ObjectRef();
            Ref.ObjectRef lineDataList = new Ref.ObjectRef();
            Ref.IntRef lineNumber = new Ref.IntRef();
            lineNumber.element = 1;
            FilesKt.forEachLine$default((File)lcovFile, null, arg_0 -> Serialization.readLcov$lambda$0(currentFileName, lineDataList, report, localBaseDir, lineNumber, arg_0), (int)1, null);
            if (!(lineDataList.element == null)) {
                boolean bl = false;
                String string = "Unexpected end of report: expected end_of_record";
                throw new IllegalStateException(string.toString());
            }
            return report;
        }

        public static /* synthetic */ LcovCoverageReport readLcov$default(Serialization serialization, File file, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return serialization.readLcov(file, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeLcov(@NotNull LcovCoverageReport report, @NotNull File outputFile) {
            Intrinsics.checkNotNullParameter((Object)report, (String)"report");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Closeable closeable = new PrintWriter(outputFile);
            Throwable throwable = null;
            try {
                PrintWriter out = (PrintWriter)closeable;
                boolean bl = false;
                for (Map.Entry entry2 : report.info.entrySet()) {
                    String filePath = (String)entry2.getKey();
                    List fileLineHits = (List)entry2.getValue();
                    out.print(SOURCE_FILE_PREFIX);
                    out.println(filePath);
                    for (LineHits lineHits : fileLineHits) {
                        out.print(LINE_HIT_PREFIX);
                        out.print(lineHits.getLineNumber());
                        out.print(',');
                        out.println(lineHits.getHits());
                    }
                    out.println(END_OF_RECORD);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit readLcov$lambda$0(Ref.ObjectRef $currentFileName, Ref.ObjectRef $lineDataList, LcovCoverageReport $report, String $localBaseDir, Ref.IntRef $lineNumber, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (StringsKt.startsWith$default((String)line, (String)SOURCE_FILE_PREFIX, (boolean)false, (int)2, null)) {
                String string = line.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $currentFileName.element = string;
                $lineDataList.element = new ArrayList();
            } else if (StringsKt.startsWith$default((String)line, (String)LINE_HIT_PREFIX, (boolean)false, (int)2, null)) {
                List values;
                void $this$dropLastWhile$iv;
                if ($lineDataList.element == null) {
                    boolean $i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$22 = false;
                    String $i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$22 = "Unexpected line hit description at line " + $lineNumber.element + ": expected source file definition";
                    throw new IllegalStateException($i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$22.toString());
                }
                String string = line.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                Object $i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$22 = new String[]{","};
                $i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$22 = StringsKt.split$default((CharSequence)string, (String[])$i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$22, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it2 = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it2).length() == 0) continue;
                        v2 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    v2 = values = CollectionsKt.emptyList();
                }
                if (!(values.size() == 2)) {
                    boolean $i$a$-check-LcovCoverageReport$Serialization$readLcov$1$32 = false;
                    String $i$a$-check-LcovCoverageReport$Serialization$readLcov$1$32 = "Unexpected line hit description at line " + $lineNumber.element + ": expected 2 integers, got " + values.size();
                    throw new IllegalStateException($i$a$-check-LcovCoverageReport$Serialization$readLcov$1$32.toString());
                }
                Integer n = StringsKt.toIntOrNull((String)((String)values.get(0)));
                if (n == null) {
                    return Unit.INSTANCE;
                }
                int lineNum = n;
                Integer n2 = StringsKt.toIntOrNull((String)((String)values.get(1)));
                int hitCount = n2 != null ? n2 : -1;
                LineHits lineHits = new LineHits(lineNum, hitCount);
                List list = (List)$lineDataList.element;
                if (list != null) {
                    list.add(lineHits);
                }
            } else if (Intrinsics.areEqual((Object)END_OF_RECORD, (Object)line)) {
                LcovCoverageReport lcovCoverageReport = $report;
                String string = $localBaseDir;
                Object object = $currentFileName.element;
                if (object == null) {
                    String string2 = string;
                    LcovCoverageReport lcovCoverageReport2 = lcovCoverageReport;
                    boolean $i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$52 = false;
                    String string3 = "Unexpected end of record at line " + $lineNumber.element + ": expected source file definition";
                    LcovCoverageReport lcovCoverageReport3 = lcovCoverageReport2;
                    String string4 = string2;
                    String $i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$52 = string3;
                    throw new IllegalStateException($i$a$-checkNotNull-LcovCoverageReport$Serialization$readLcov$1$52.toString());
                }
                String string5 = (String)object;
                Object object2 = $lineDataList.element;
                if (object2 == null) {
                    String string6 = string5;
                    String string7 = string;
                    LcovCoverageReport lcovCoverageReport4 = lcovCoverageReport;
                    boolean bl = false;
                    String string8 = "Unexpected end of record at line " + $lineNumber.element + ": expected source file definition";
                    LcovCoverageReport lcovCoverageReport5 = lcovCoverageReport4;
                    String string9 = string7;
                    String string10 = string6;
                    String string11 = string8;
                    throw new IllegalStateException(string11.toString());
                }
                lcovCoverageReport.mergeFileReport(string, string5, (List)object2);
                $currentFileName.element = null;
                $lineDataList.element = null;
            }
            int n = $lineNumber.element;
            $lineNumber.element = n + 1;
            return Unit.INSTANCE;
        }
    }
}

