/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.runconfig.command.CargoParametersHolderKt;
import org.rust.cargo.util.OptionArgsCountRange;
import org.rust.cargo.util.ParsedCargoArgs;
import org.rust.cargo.util.SplitCargoArgs;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB+\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/util/CargoArgsParser;", "", "cargoArgs", "", "", "optionsToArgsCountRange", "", "Lorg/rust/cargo/util/OptionArgsCountRange;", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "splitArgs", "Lorg/rust/cargo/util/SplitCargoArgs;", "getActualOptionArgsCount", "", "optionIdx", "Companion", "intellij.rustrover.core"})
public final class CargoArgsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> cargoArgs;
    @NotNull
    private final Map<String, OptionArgsCountRange> optionsToArgsCountRange;
    @NotNull
    private static final String OPTION_CHAR_CLASS = "[a-zA-Z0-9]";
    @NotNull
    private static final Regex OPTION_NAME_RE = new Regex("^(-[a-zA-Z0-9])|(--[a-zA-Z0-9]+([-_.][a-zA-Z0-9]+)*)$");
    @NotNull
    private static final Map<String, OptionArgsCountRange> RUN_OPTIONS;
    @NotNull
    private static final Map<String, OptionArgsCountRange> TEST_OPTIONS;

    private CargoArgsParser(List<String> cargoArgs, Map<String, OptionArgsCountRange> optionsToArgsCountRange) {
        this.cargoArgs = cargoArgs;
        this.optionsToArgsCountRange = optionsToArgsCountRange;
    }

    private final SplitCargoArgs splitArgs() {
        List commandOptions = new ArrayList();
        List positionalArguments = new ArrayList();
        int i2 = 0;
        while (i2 < this.cargoArgs.size()) {
            int n;
            String arg = this.cargoArgs.get(i2);
            if (Intrinsics.areEqual((Object)arg, (Object)"--")) {
                positionalArguments.addAll((Collection)this.cargoArgs.subList(i2, this.cargoArgs.size()));
                break;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-", (boolean)false, (int)2, null)) {
                int optionArgsCount = this.getActualOptionArgsCount(i2);
                List<String> optionWithArgs = this.cargoArgs.subList(i2, i2 + optionArgsCount + 1);
                commandOptions.addAll((Collection)optionWithArgs);
                n = optionWithArgs.size();
            } else {
                positionalArguments.add(arg);
                n = 1;
            }
            i2 = i2 + n;
        }
        return new SplitCargoArgs(commandOptions, positionalArguments);
    }

    private final int getActualOptionArgsCount(int optionIdx) {
        String option = this.cargoArgs.get(optionIdx);
        int maxArgsCount = this.optionsToArgsCountRange.getOrDefault(option, OptionArgsCountRange.Companion.getZERO()).component2();
        return SequencesKt.count((Sequence)SequencesKt.take((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)this.cargoArgs), (int)(optionIdx + 1)), CargoArgsParser::getActualOptionArgsCount$lambda$0), (int)maxArgsCount));
    }

    private static final boolean getActualOptionArgsCount$lambda$0(String it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return !Intrinsics.areEqual((Object)it2, (Object)"--") && !OPTION_NAME_RE.matches((CharSequence)it2);
    }

    public /* synthetic */ CargoArgsParser(List cargoArgs, Map optionsToArgsCountRange, DefaultConstructorMarker $constructor_marker) {
        this(cargoArgs, optionsToArgsCountRange);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"--bin", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--example", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"-p", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--package", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"-j", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--jobs", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--color", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--profile", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"-F", (Object)OptionArgsCountRange.Companion.getMANY()), TuplesKt.to((Object)"--features", (Object)OptionArgsCountRange.Companion.getMANY()), TuplesKt.to((Object)"--config", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"-Z", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--target", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--target-dir", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--manifest-path", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--message-format", (Object)OptionArgsCountRange.Companion.getONE())};
        RUN_OPTIONS = MapsKt.hashMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"--test", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--bench", (Object)OptionArgsCountRange.Companion.getONE()), TuplesKt.to((Object)"--exclude", (Object)OptionArgsCountRange.Companion.getONE())};
        TEST_OPTIONS = MapsKt.plus(RUN_OPTIONS, (Map)MapsKt.hashMapOf((Pair[])pairArray));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0016\u0010\n\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u0016\u0010\u000b\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/cargo/util/CargoArgsParser$Companion;", "", "<init>", "()V", "parseArgs", "Lorg/rust/cargo/util/ParsedCargoArgs;", "commandName", "", "cargoArgs", "", "parseRunArgs", "parseTestArgs", "OPTION_CHAR_CLASS", "OPTION_NAME_RE", "Lkotlin/text/Regex;", "RUN_OPTIONS", "", "Lorg/rust/cargo/util/OptionArgsCountRange;", "TEST_OPTIONS", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final ParsedCargoArgs parseArgs(@NotNull String commandName, @NotNull List<String> cargoArgs) {
            ParsedCargoArgs parsedCargoArgs;
            Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
            Intrinsics.checkNotNullParameter(cargoArgs, (String)"cargoArgs");
            String string = commandName;
            switch (string.hashCode()) {
                case 3556498: {
                    if (string.equals("test")) break;
                    throw new IllegalStateException("Unsupported command".toString());
                }
                case 93622832: {
                    if (string.equals("bench")) break;
                    throw new IllegalStateException("Unsupported command".toString());
                }
                case 113291: {
                    if (!string.equals("run")) throw new IllegalStateException("Unsupported command".toString());
                    parsedCargoArgs = this.parseRunArgs(cargoArgs);
                    return parsedCargoArgs;
                }
            }
            parsedCargoArgs = this.parseTestArgs(cargoArgs);
            return parsedCargoArgs;
            throw new IllegalStateException("Unsupported command".toString());
        }

        private final ParsedCargoArgs parseRunArgs(List<String> cargoArgs) {
            CargoArgsParser argsParser = new CargoArgsParser(cargoArgs, RUN_OPTIONS, null);
            SplitCargoArgs splitCargoArgs = argsParser.splitArgs();
            List<String> commandArguments = splitCargoArgs.component1();
            List positionalArguments = splitCargoArgs.component2();
            List executableArguments = !((Collection)positionalArguments).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.first(positionalArguments), (Object)"--") ? CollectionsKt.drop((Iterable)positionalArguments, (int)1) : positionalArguments;
            return new ParsedCargoArgs(commandArguments, executableArguments);
        }

        private final ParsedCargoArgs parseTestArgs(List<String> cargoArgs) {
            CargoArgsParser argsParser = new CargoArgsParser(cargoArgs, TEST_OPTIONS, null);
            SplitCargoArgs splitCargoArgs = argsParser.splitArgs();
            List<String> commandOptions = splitCargoArgs.component1();
            List<String> positionalArguments = splitCargoArgs.component2();
            Pair<List<String>, List<String>> pair = CargoParametersHolderKt.splitOnDoubleDash(positionalArguments);
            List positionalPre = (List)pair.component1();
            List positionalPost = (List)pair.component2();
            List commandArguments = CollectionsKt.plus((Collection)commandOptions, (Iterable)positionalPre);
            List executableArguments = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)CollectionsKt.lastOrNull((List)positionalPre)), (Iterable)positionalPost);
            return new ParsedCargoArgs(commandArguments, executableArguments);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

