/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain.wsl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.wsl.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u000fH\u0016J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lorg/rust/cargo/toolchain/wsl/RsWslToolchain;", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "wslPath", "Lcom/intellij/execution/wsl/WslPath;", "<init>", "(Lcom/intellij/execution/wsl/WslPath;)V", "getWslPath", "()Lcom/intellij/execution/wsl/WslPath;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "linuxPath", "Ljava/nio/file/Path;", "fileSeparator", "", "getFileSeparator", "()Ljava/lang/String;", "executionTimeoutInMilliseconds", "", "getExecutionTimeoutInMilliseconds", "()I", "patchCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "commandLine", "withSudo", "", "toLocalPath", "remotePath", "toRemotePath", "localPath", "expandUserHome", "getExecutableName", "toolName", "pathToExecutable", "remotePathToExecutable", "hasExecutable", "exec", "hasCargoExecutable", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsWslToolchain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsWslToolchain.kt\norg/rust/cargo/toolchain/wsl/RsWslToolchain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1563#2:102\n1634#2,3:103\n216#3,2:106\n1#4:108\n*S KotlinDebug\n*F\n+ 1 RsWslToolchain.kt\norg/rust/cargo/toolchain/wsl/RsWslToolchain\n*L\n35#1:102\n35#1:103,3\n39#1:106,2\n*E\n"})
public final class RsWslToolchain
extends RsToolchainBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WslPath wslPath;
    @NotNull
    private final Path linuxPath;
    @NotNull
    private final String fileSeparator;
    private final int executionTimeoutInMilliseconds;

    public RsWslToolchain(@NotNull WslPath wslPath) {
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        super(org.rust.stdext.UtilsKt.toPath(RsWslToolchain.Companion.getWindowsPathWithFix(wslPath.getDistribution(), wslPath.getLinuxPath())));
        this.wslPath = wslPath;
        this.linuxPath = org.rust.stdext.UtilsKt.toPath(this.wslPath.getLinuxPath());
        this.fileSeparator = "/";
        this.executionTimeoutInMilliseconds = 5000;
    }

    @NotNull
    public final WslPath getWslPath() {
        return this.wslPath;
    }

    private final WSLDistribution getDistribution() {
        return this.wslPath.getDistribution();
    }

    @Override
    @NotNull
    public String getFileSeparator() {
        return this.fileSeparator;
    }

    @Override
    public int getExecutionTimeoutInMilliseconds() {
        return this.executionTimeoutInMilliseconds;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GeneralCommandLine patchCommandLine(@NotNull GeneralCommandLine commandLine, boolean withSudo) {
        String string;
        Iterator $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        String string2 = commandLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExePath(...)");
        commandLine.setExePath(this.toRemotePath(string2));
        List list = commandLine.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it2;
            Object item$iv$iv = iterator2.next();
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            collection.add(((Object)StringsKt.trim((CharSequence)this.toRemotePath((String)it2))).toString());
        }
        List parameters = (List)destination$iv$iv;
        commandLine.getParametersList().clearAll();
        commandLine.getParametersList().addAll(parameters);
        Map map2 = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironment(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach22 = false;
        $this$mapTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $i$f$mapTo2 = element$iv = $this$mapTo$iv$iv.next();
            boolean bl = false;
            String k = (String)$i$f$mapTo2.getKey();
            String v = (String)$i$f$mapTo2.getValue();
            Intrinsics.checkNotNull((Object)v);
            Object object2 = new char[]{File.pathSeparatorChar};
            List paths = StringsKt.split$default((CharSequence)v, (char[])object2, (boolean)false, (int)0, (int)6, null);
            Map map3 = commandLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getEnvironment(...)");
            object2 = map3;
            String string4 = CollectionsKt.joinToString$default((Iterable)paths, (CharSequence)":", null, null, (int)0, null, arg_0 -> RsWslToolchain.patchCommandLine$lambda$1$0(this, arg_0), (int)30, null);
            object2.put(k, string4);
        }
        File file = commandLine.getWorkDirectory();
        if (file != null) {
            File it3 = file;
            boolean bl = false;
            String string5 = it3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string5, (String)this.getFileSeparator(), (boolean)false, (int)2, null)) {
                String string6 = it3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
                commandLine.setWorkDirectory(new File(this.toLocalPath(string6)));
            }
        }
        File $i$f$forEach22 = commandLine.getWorkDirectory();
        if ($i$f$forEach22 != null && (object = $i$f$forEach22.getAbsolutePath()) != null) {
            Object it4 = object;
            boolean bl = false;
            string = this.toRemotePath((String)it4);
        } else {
            string = null;
        }
        String remoteWorkDir = string;
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setLaunchWithWslExe(true).setSudo(withSudo).setRemoteWorkingDirectory(remoteWorkDir).addInitCommand("export PATH=\"" + PathKt.getSystemIndependentPath((Path)this.linuxPath) + ":$PATH\"");
        Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"addInitCommand(...)");
        WSLCommandLineOptions options = wSLCommandLineOptions;
        GeneralCommandLine generalCommandLine = this.getDistribution().patchCommandLine(commandLine, null, options);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"patchCommandLine(...)");
        return generalCommandLine;
    }

    @Override
    @NotNull
    public String toLocalPath(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        return RsWslToolchain.Companion.getWindowsPathWithFix(this.getDistribution(), remotePath);
    }

    @Override
    @NotNull
    public String toRemotePath(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        String string = this.getDistribution().getWslPath(localPath);
        if (string == null) {
            string = localPath;
        }
        return string;
    }

    @Override
    @NotNull
    public String expandUserHome(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        return UtilsKt.expandUserHome(this.getDistribution(), remotePath);
    }

    @Override
    @NotNull
    public String getExecutableName(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return toolName;
    }

    @Override
    @NotNull
    public Path pathToExecutable(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return UtilsKt.pathToExecutableOnWsl(this.linuxPath, toolName);
    }

    @Override
    @NotNull
    public String remotePathToExecutable(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return this.wslPath.getLinuxPath() + this.getFileSeparator() + toolName;
    }

    @Override
    public boolean hasExecutable(@NotNull String exec) {
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(org.rust.stdext.UtilsKt.toPath(RsWslToolchain.Companion.getWindowsPathWithFix(this.getDistribution(), this.remotePathToExecutable(exec))), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @Override
    public boolean hasCargoExecutable(@NotNull String exec) {
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(RsWslToolchain.Companion.getWindowsPath(this.getDistribution(), this.pathToCargoExecutable(exec)), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final CharSequence patchCommandLine$lambda$1$0(RsWslToolchain this$0, String it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.toRemotePath(it2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0014\u0010\b\u001a\u00020\t*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0002\u00a8\u0006\n\u00b2\u0006\u0014\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rX\u008a\u0084\u0002"}, d2={"Lorg/rust/cargo/toolchain/wsl/RsWslToolchain$Companion;", "", "<init>", "()V", "getWindowsPathWithFix", "", "Lcom/intellij/execution/wsl/WSLDistribution;", "wslPath", "getWindowsPath", "Ljava/nio/file/Path;", "intellij.rustrover.core", "mountRoot", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;"})
    public static final class Companion {
        private Companion() {
        }

        private final String getWindowsPathWithFix(WSLDistribution $this$getWindowsPathWithFix, String wslPath) {
            String string;
            String string2 = FileUtil.toSystemIndependentName((String)wslPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            String systemIndependentPath = string2;
            Path path = $this$getWindowsPathWithFix.getUNCRootPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getUNCRootPath(...)");
            String uncRoot = PathsKt.getInvariantSeparatorsPathString((Path)path);
            Lazy mountRoot$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Companion.getWindowsPathWithFix$lambda$0($this$getWindowsPathWithFix));
            if ((StringsKt.startsWith$default((String)systemIndependentPath, (String)uncRoot, (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)systemIndependentPath, (String)"/", (boolean)false, (int)2, null) ? systemIndependentPath : (string = StringsKt.startsWith$default((String)systemIndependentPath, (String)org.rust.cargo.toolchain.wsl.RsWslToolchain$Companion.getWindowsPathWithFix$lambda$1((Lazy<String>)mountRoot$delegate), (boolean)false, (int)2, null) ? WSLUtil.getWindowsPath((String)systemIndependentPath, (String)org.rust.cargo.toolchain.wsl.RsWslToolchain$Companion.getWindowsPathWithFix$lambda$1((Lazy<String>)mountRoot$delegate)) : $this$getWindowsPathWithFix.getWindowsPath(systemIndependentPath))) == null) {
                string = systemIndependentPath;
            }
            return string;
        }

        private final Path getWindowsPath(WSLDistribution $this$getWindowsPath, Path wslPath) {
            return org.rust.stdext.UtilsKt.toPath(this.getWindowsPathWithFix($this$getWindowsPath, ((Object)wslPath).toString()));
        }

        private static final String getWindowsPathWithFix$lambda$0(WSLDistribution $this_getWindowsPathWithFix) {
            return $this_getWindowsPathWithFix.getMntRoot();
        }

        private static final String getWindowsPathWithFix$lambda$1(Lazy<String> $mountRoot$delegate) {
            Lazy<String> lazy = $mountRoot$delegate;
            return (String)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

