/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain.tools;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.RsToolchainProvider;
import org.rust.cargo.toolchain.flavors.RsToolchainFlavor;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.RsTool;
import org.rust.cargo.toolchain.tools.RustcKt;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.cargo.util.DownloadResult;
import org.rust.ide.actions.InstallComponentAction;
import org.rust.ide.actions.InstallTargetAction;
import org.rust.ide.statistics.RsSettingsInteractionUsageCollector;
import org.rust.openapiext.CommandLineExtKt;
import org.rust.openapiext.RsPathManager;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.openapiext.RsProcessResultKt;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;
import org.rust.stdext.RsResultKt;
import org.rust.util.ZipKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u00044567B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JU\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\n0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000fJ \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"J\u0012\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u000fJ\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u000fJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010,J(\u0010-\u001a\b\u0012\u0004\u0012\u00020%0\u001f*\u0018\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020/0.j\b\u0012\u0004\u0012\u00020\u001c`0H\u0002J\u0018\u00101\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u000fH\u0002J\u0018\u00103\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustup;", "Lorg/rust/cargo/toolchain/tools/RsTool;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "projectDirectory", "Ljava/nio/file/Path;", "<init>", "(Lorg/rust/cargo/toolchain/RsToolchainBase;Ljava/nio/file/Path;)V", "executeCommand", "", "T", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "outputLinesProcessor", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "listComponents", "Lorg/rust/cargo/toolchain/tools/Rustup$Component;", "listTargets", "Lorg/rust/cargo/toolchain/tools/Rustup$Target;", "listUpdates", "", "runUpdate", "Lcom/intellij/execution/process/ProcessOutput;", "activeToolchainName", "downloadStdlib", "Lorg/rust/cargo/util/DownloadResult;", "Lcom/intellij/openapi/vfs/VirtualFile;", "listener", "Lcom/intellij/execution/process/ProcessListener;", "tryGetBundledStdlib", "downloadComponent", "", "componentName", "downloadTarget", "targetName", "copyStdLibIfNeeded", "source", "version", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "convertResult", "Lorg/rust/stdext/RsResult;", "Lorg/rust/openapiext/RsProcessExecutionException;", "Lorg/rust/openapiext/RsProcessResult;", "checkComponent", "Lorg/rust/cargo/toolchain/tools/Rustup$Availability;", "checkTarget", "Component", "Target", "Availability", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRustup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rustup.kt\norg/rust/cargo/toolchain/tools/Rustup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,665:1\n1563#2:666\n1634#2,3:667\n1#3:670\n*S KotlinDebug\n*F\n+ 1 Rustup.kt\norg/rust/cargo/toolchain/tools/Rustup\n*L\n100#1:666\n100#1:667,3\n*E\n"})
public final class Rustup
extends RsTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path projectDirectory;
    @NotNull
    public static final String NAME = "rustup";
    @NotNull
    private static final String UNIX_RUSTUP_URL = "https://sh.rustup.rs";
    @NotNull
    private static final String UNIX_RUSTUP_FILENAME = "rustup-init.sh";
    @NotNull
    private static final String WINDOWS_RUSTUP_URL = "https://win.rustup.rs";
    @NotNull
    private static final String WINDOWS_RUSTUP_FILENAME = "rustup-init.exe";
    @NotNull
    private static final String VISUAL_STUDIO_URL = "https://aka.ms/vs/17/release/vs_community.exe";
    @NotNull
    private static final String VISUAL_STUDIO_FILENAME = "vs_setup.exe";
    @NlsSafe
    @NotNull
    private static final String INFO_PREFIX = "info:";
    @NlsSafe
    @NotNull
    private static final String WARNING_PREFIX = "warning:";
    @NlsSafe
    @NotNull
    private static final String VS_SKIP_MESSAGE = "installing msvc toolchain without its prerequisites";

    public Rustup(@NotNull RsToolchainBase toolchain2, @NotNull Path projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        super(NAME, toolchain2);
        this.projectDirectory = projectDirectory;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> executeCommand(Project project, String[] parameters, ProgressIndicator indicator, Function1<? super String, ? extends T> outputLinesProcessor) {
        List list;
        List list2;
        List list3;
        ProcessOutput processOutput = CommandLineExtKt.execute(RsTool.createBaseCommandLine$default((RsTool)this, project, Arrays.copyOf(parameters, parameters.length), this.projectDirectory, null, 8, null), this.getToolchain().getExecutionTimeoutInMilliseconds(), indicator);
        if (processOutput != null && (list3 = processOutput.getStdoutLines()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(outputLinesProcessor.invoke(item$iv$iv));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List executeCommand$default(Rustup rustup, Project project, String[] stringArray, ProgressIndicator progressIndicator, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return rustup.executeCommand(project, stringArray, progressIndicator, function1);
    }

    private final List<Component> listComponents(Project project) {
        String[] stringArray = new String[]{"component", "list"};
        return Rustup.executeCommand$default(this, project, stringArray, null, Rustup::listComponents$lambda$0, 4, null);
    }

    private final List<Target> listTargets(Project project) {
        String[] stringArray = new String[]{"target", "list"};
        return Rustup.executeCommand$default(this, project, stringArray, null, Rustup::listTargets$lambda$0, 4, null);
    }

    @NotNull
    public final Map<String, String> listUpdates(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String[] stringArray = new String[]{"check"};
        return MapsKt.toMap((Iterable)this.executeCommand(project, stringArray, (ProgressIndicator)new EmptyProgressIndicator(), Rustup::listUpdates$lambda$0));
    }

    @Nullable
    public final ProcessOutput runUpdate(@NotNull Project project, @NotNull String activeToolchainName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activeToolchainName, (String)"activeToolchainName");
        String[] stringArray = new String[]{"update", activeToolchainName};
        return CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, this.projectDirectory, null, 8, null), null, null, 2, null);
    }

    @NotNull
    public final DownloadResult<VirtualFile> downloadStdlib(@NotNull Project project, @Nullable ProcessListener listener2) {
        String[] stringArray;
        GeneralCommandLine commandLine;
        ProcessOutput downloadProcessOutput;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile bundledStdlib = this.tryGetBundledStdlib(project);
        if (bundledStdlib != null) {
            return new DownloadResult.Ok<VirtualFile>(bundledStdlib);
        }
        if (this.checkComponent(project, "rust-src").getCanBeInstalled() && !CommandLineExtKt.isSuccess(downloadProcessOutput = RsResultKt.unwrapOrThrow(RsProcessResultKt.ignoreExitCode(CommandLineExtKt.execute$default(commandLine = RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray = new String[]{"component", "add", "rust-src"}, this.projectDirectory, null, 8, null), null, listener2, 1, null))))) {
            Object[] objectArray = new Object[1];
            Object object = downloadProcessOutput;
            if (object == null || (object = object.getStderr()) == null) {
                object = "";
            }
            objectArray[0] = object;
            String message = RsBundle.INSTANCE.message("notification.content.rustup.failed", objectArray);
            RustupKt.access$getLOG$p().warn(message);
            return new DownloadResult.Err(message);
        }
        VirtualFile virtualFile = RustcKt.rustc(this.getToolchain()).getStdlibFromSysroot(project, this.projectDirectory);
        if (virtualFile == null) {
            return new DownloadResult.Err(RsBundle.INSTANCE.message("notification.content.failed.to.find.stdlib.in.sysroot", new Object[0]));
        }
        VirtualFile sources = virtualFile;
        RustupKt.access$getLOG$p().info("stdlib path: " + sources.getPath());
        UtilsKt.fullyRefreshDirectory(sources);
        RustcVersion version = RustcKt.rustc(this.getToolchain()).queryVersion(project, this.projectDirectory);
        VirtualFile virtualFile2 = this.copyStdLibIfNeeded(sources, version);
        if (virtualFile2 == null) {
            return new DownloadResult.Err(RsBundle.INSTANCE.message("notification.content.failed.to.crate.stdlib.copy", new Object[0]));
        }
        VirtualFile newSources = virtualFile2;
        return new DownloadResult.Ok<VirtualFile>(newSources);
    }

    public static /* synthetic */ DownloadResult downloadStdlib$default(Rustup rustup, Project project, ProcessListener processListener, int n, Object object) {
        if ((n & 2) != 0) {
            processListener = null;
        }
        return rustup.downloadStdlib(project, processListener);
    }

    private final VirtualFile tryGetBundledStdlib(Project project) {
        RustcVersion rustcVersion = RustcKt.rustc(this.getToolchain()).queryVersion(project, this.projectDirectory);
        if (rustcVersion == null || (rustcVersion = rustcVersion.getSemver()) == null) {
            return null;
        }
        RustcVersion version = rustcVersion;
        Path stdlibLocalCopy = RsPathManager.INSTANCE.stdlibLocalCopy(EelProviderUtil.getEelDescriptor((Path)this.getToolchain().getLocation())).resolve("bundled-" + (SemVer)version);
        Intrinsics.checkNotNull((Object)stdlibLocalCopy);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(stdlibLocalCopy, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return LocalFileSystem.getInstance().refreshAndFindFileByNioFile(stdlibLocalCopy);
        }
        Path cachesDir = RsPathManager.INSTANCE.bundledCachesDir();
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(cachesDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return null;
        }
        Path rustSrcBundleZip = cachesDir.resolve("rust-src-bundle-" + (SemVer)version + ".zip");
        Intrinsics.checkNotNull((Object)rustSrcBundleZip);
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (!Files.exists(rustSrcBundleZip, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
            return null;
        }
        stdlibLocalCopy.toFile().mkdirs();
        try {
            ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(rustSrcBundleZip, new OpenOption[0]));
            ZipKt.unzipTo(zipStream, stdlibLocalCopy);
            RustupKt.access$getLOG$p().info("Using bundled stdlib sources from " + rustSrcBundleZip);
            return LocalFileSystem.getInstance().refreshAndFindFileByNioFile(stdlibLocalCopy);
        }
        catch (Exception e) {
            RustupKt.access$getLOG$p().warn("Failed to get bundled stdlib sources from " + rustSrcBundleZip, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final DownloadResult<Unit> downloadComponent(@NotNull Project project, @NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        String[] stringArray = new String[]{"component", "add", componentName};
        return this.convertResult(CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, this.projectDirectory, null, 8, null), null, null, 3, null));
    }

    @NotNull
    public final DownloadResult<Unit> downloadTarget(@NotNull Project project, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        String[] stringArray = new String[]{"target", "add", targetName};
        return this.convertResult(CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, this.projectDirectory, null, 8, null), null, null, 3, null));
    }

    @NlsSafe
    @Nullable
    public final String activeToolchainName(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String[] stringArray = new String[]{"show", "active-toolchain"};
        ProcessOutput processOutput = CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, this.projectDirectory, null, 8, null), this.getToolchain().getExecutionTimeoutInMilliseconds(), null, 2, null);
        if (processOutput == null) {
            return null;
        }
        ProcessOutput output = processOutput;
        if (!CommandLineExtKt.isSuccess(output)) {
            return null;
        }
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string));
        return string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)"(", null, (int)2, null)) != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
    }

    @Nullable
    public final VirtualFile copyStdLibIfNeeded(@NotNull VirtualFile source, @Nullable RustcVersion version) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Path stdlibPath = UtilsKt.getPathAsPath(source);
        Path stdlibLocalCopyDir = RsPathManager.INSTANCE.stdlibCopyDir(stdlibPath, version);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(stdlibLocalCopyDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                PathKt.copyRecursively((Path)stdlibPath, (Path)stdlibLocalCopyDir);
            }
            catch (FileAlreadyExistsException e) {
                RustupKt.access$getLOG$p().warn((Throwable)e);
            }
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByNioFile(stdlibLocalCopyDir);
    }

    private final DownloadResult<Unit> convertResult(RsResult<? extends ProcessOutput, ? extends RsProcessExecutionException> $this$convertResult) {
        DownloadResult downloadResult;
        RsResult<? extends ProcessOutput, ? extends RsProcessExecutionException> rsResult = $this$convertResult;
        if (rsResult instanceof RsResult.Ok) {
            downloadResult = new DownloadResult.Ok<Unit>(Unit.INSTANCE);
        } else if (rsResult instanceof RsResult.Err) {
            Object[] objectArray = new Object[1];
            String string = ((RsProcessExecutionException)((RsResult.Err)$this$convertResult).getErr()).getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String message = RsBundle.INSTANCE.message("notification.content.rustup.failed", objectArray);
            RustupKt.access$getLOG$p().warn(message);
            downloadResult = new DownloadResult.Err(message);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return downloadResult;
    }

    private final Availability checkComponent(Project project, String componentName) {
        Object v0;
        block2: {
            Iterable iterable = this.listComponents(project);
            for (Object t : iterable) {
                Component it2 = (Component)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it2.getName(), (String)componentName, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Component component = v0;
        if (component == null) {
            return Availability.UNKNOWN;
        }
        return component.isInstalled() ? Availability.INSTALLED : Availability.NOT_INSTALLED;
    }

    private final Availability checkTarget(Project project, String targetName) {
        Object v0;
        block2: {
            Iterable iterable = this.listTargets(project);
            for (Object t : iterable) {
                Target it2 = (Target)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)targetName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Target target = v0;
        if (target == null) {
            return Availability.UNKNOWN;
        }
        return target.isInstalled() ? Availability.INSTALLED : Availability.NOT_INSTALLED;
    }

    private static final Component listComponents$lambda$0(String it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return Component.Companion.from(it2);
    }

    private static final Target listTargets$lambda$0(String it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return Target.Companion.from(it2);
    }

    private static final Pair listUpdates$lambda$0(String it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        Object object = Regex.find$default((Regex)RustupKt.access$getUpdateAvailableRegexp$p(), (CharSequence)it2, (int)0, (int)2, null);
        if (object == null || (object = object.getGroupValues()) == null) {
            return RustupKt.access$getEMPTY_PAIR$p();
        }
        Object result2 = object;
        if (result2.size() == 4) {
            return new Pair(result2.get(1), CollectionsKt.last((List)result2));
        }
        return RustupKt.access$getEMPTY_PAIR$p();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\r"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustup$Availability;", "", "<init>", "(Ljava/lang/String;I)V", "INSTALLED", "NOT_INSTALLED", "NO_RUSTUP", "UNKNOWN", "isInstalled", "", "()Z", "canBeInstalled", "getCanBeInstalled", "intellij.rustrover.core"})
    public static final class Availability
    extends Enum<Availability> {
        public static final /* enum */ Availability INSTALLED = new Availability();
        public static final /* enum */ Availability NOT_INSTALLED = new Availability();
        public static final /* enum */ Availability NO_RUSTUP = new Availability();
        public static final /* enum */ Availability UNKNOWN = new Availability();
        private static final /* synthetic */ Availability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isInstalled() {
            return this == INSTALLED;
        }

        public final boolean getCanBeInstalled() {
            return this == NOT_INSTALLED;
        }

        public static Availability[] values() {
            return (Availability[])$VALUES.clone();
        }

        public static Availability valueOf(String value) {
            return Enum.valueOf(Availability.class, value);
        }

        @NotNull
        public static EnumEntries<Availability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = availabilityArray = new Availability[]{Availability.INSTALLED, Availability.NOT_INSTALLED, Availability.NO_RUSTUP, Availability.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0013J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0013H\u0002J\u0016\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0017J\"\u0010&\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010%\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010'J\"\u0010(\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010-\u001a\u00020\u0013H\u0002J\u0010\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020,2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00102\u001a\u00020,2\u0006\u0010/\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010/\u001a\u000203H\u0002J\u0018\u00105\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010/\u001a\u000203H\u0002J\u0010\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000208H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0003R\u0016\u0010\u000e\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u0016\u0010\u0010\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u00a8\u00069"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustup$Companion;", "", "<init>", "()V", "NAME", "", "UNIX_RUSTUP_URL", "UNIX_RUSTUP_FILENAME", "WINDOWS_RUSTUP_URL", "WINDOWS_RUSTUP_FILENAME", "VISUAL_STUDIO_URL", "VISUAL_STUDIO_FILENAME", "INFO_PREFIX", "getINFO_PREFIX$annotations", "WARNING_PREFIX", "getWARNING_PREFIX$annotations", "VS_SKIP_MESSAGE", "getVS_SKIP_MESSAGE$annotations", "checkClippy", "", "project", "Lcom/intellij/openapi/project/Project;", "cargoProjectDirectory", "Ljava/nio/file/Path;", "showError", "checkRustfmt", "checkRustfmtAvailability", "Lorg/rust/cargo/toolchain/tools/Rustup$Availability;", "checkRustupComponentAvailability", "componentName", "checkLlvmTools", "checkRustupComponent", "checkWasmTarget", "checkRustupTarget", "targetName", "findRustup", "Lorg/rust/cargo/toolchain/tools/Rustup;", "cargoProjectDir", "installRustup", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doInstallRustup", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "installVisualStudio", "", "hasWindowsSdkLibs", "handleRustupInstallationIOException", "e", "Ljava/io/IOException;", "handleVSInstallationIOException", "handleRustupInstallationExecutionException", "Lorg/rust/openapiext/RsProcessExecutionException;", "handleRustupAmendShellProfileException", "handleVSInstallationExecutionException", "errorMessageFromVSExitCode", "exitCode", "", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRustup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rustup.kt\norg/rust/cargo/toolchain/tools/Rustup$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,665:1\n37#2,2:666\n37#2,2:669\n1#3:668\n*S KotlinDebug\n*F\n+ 1 Rustup.kt\norg/rust/cargo/toolchain/tools/Rustup$Companion\n*L\n420#1:666,2\n510#1:669,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getINFO_PREFIX$annotations() {
        }

        private static /* synthetic */ void getWARNING_PREFIX$annotations() {
        }

        private static /* synthetic */ void getVS_SKIP_MESSAGE$annotations() {
        }

        public final boolean checkClippy(@NotNull Project project, @NotNull Path cargoProjectDirectory, boolean showError) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            return this.checkRustupComponent(project, cargoProjectDirectory, "clippy", showError);
        }

        public final boolean checkRustfmt(@NotNull Project project, @NotNull Path cargoProjectDirectory, boolean showError) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            if (!TrustedProjects.isProjectTrusted((Project)project)) {
                return false;
            }
            return this.checkRustupComponent(project, cargoProjectDirectory, "rustfmt", showError);
        }

        public static /* synthetic */ boolean checkRustfmt$default(Companion companion, Project project, Path path, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.checkRustfmt(project, path, bl);
        }

        @NotNull
        public final Availability checkRustfmtAvailability(@NotNull Project project, @NotNull Path cargoProjectDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            if (!TrustedProjects.isProjectTrusted((Project)project)) {
                return Availability.UNKNOWN;
            }
            return this.checkRustupComponentAvailability(project, cargoProjectDirectory, "rustfmt");
        }

        private final Availability checkRustupComponentAvailability(Project project, Path cargoProjectDirectory, String componentName) {
            RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(project);
            if (toolchain2 != null && toolchain2.hasExecutable(componentName)) {
                return Availability.INSTALLED;
            }
            RsToolchainBase rsToolchainBase = toolchain2;
            Rustup rustup = rsToolchainBase != null ? RustupKt.rustup(rsToolchainBase, cargoProjectDirectory) : null;
            Object object = rustup;
            if (object == null || (object = ((Rustup)object).checkComponent(project, componentName)) == null) {
                object = Availability.NO_RUSTUP;
            }
            return object;
        }

        public final boolean checkLlvmTools(@NotNull Project project, @NotNull Path cargoProjectDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            return this.checkRustupComponent(project, cargoProjectDirectory, "llvm-tools", true);
        }

        private final boolean checkRustupComponent(Project project, Path cargoProjectDirectory, String componentName, boolean showError) {
            Availability availability = this.checkRustupComponentAvailability(project, cargoProjectDirectory, componentName);
            Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[availability.ordinal()]) {
                case 1 -> TuplesKt.to(null, null);
                case 2 -> {
                    Object[] var9_6 = new Object[]{org.rust.stdext.UtilsKt.capitalized(componentName)};
                    yield TuplesKt.to((Object)RsBundle.INSTANCE.message("notification.content.not.installed", var9_6), (Object)((Object)new InstallComponentAction(cargoProjectDirectory, componentName, null, 4, null)));
                }
                case 3 -> {
                    Object[] var9_6 = new Object[]{org.rust.stdext.UtilsKt.capitalized(componentName)};
                    yield TuplesKt.to((Object)RsBundle.INSTANCE.message("notification.content.no.rustup", var9_6), null);
                }
                case 4 -> TuplesKt.to(null, null);
                default -> throw new NoWhenBranchMatchedException();
            };
            String message = (String)pair.component1();
            InstallComponentAction fix = (InstallComponentAction)((Object)pair.component2());
            if (message != null && showError) {
                org.rust.ide.notifications.UtilsKt.showBalloon(project, "component.not.available", message, NotificationType.ERROR, (AnAction)fix);
            }
            return availability.isInstalled();
        }

        static /* synthetic */ boolean checkRustupComponent$default(Companion companion, Project project, Path path, String string, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.checkRustupComponent(project, path, string, bl);
        }

        public final boolean checkWasmTarget(@NotNull Project project, @NotNull Path cargoProjectDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            return this.checkRustupTarget(project, cargoProjectDirectory, "wasm32-unknown-unknown");
        }

        public final boolean checkRustupTarget(@NotNull Project project, @NotNull Path cargoProjectDirectory, @NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
            Rustup rustup = rsToolchainBase != null ? RustupKt.rustup(rsToolchainBase, cargoProjectDirectory) : null;
            Object object = rustup;
            if (object == null || (object = ((Rustup)object).checkTarget(project, targetName)) == null) {
                object = Availability.NO_RUSTUP;
            }
            Rustup availability = object;
            Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)availability)).ordinal()]) {
                case 1 -> TuplesKt.to(null, null);
                case 2 -> {
                    Object[] var9_6 = new Object[]{targetName};
                    yield TuplesKt.to((Object)RsBundle.INSTANCE.message("notification.content.target.not.installed", var9_6), (Object)((Object)new InstallTargetAction(cargoProjectDirectory, targetName)));
                }
                case 3 -> {
                    Object[] var9_6 = new Object[]{targetName};
                    yield TuplesKt.to((Object)RsBundle.INSTANCE.message("notification.content.target.no.rustup", var9_6), null);
                }
                case 4 -> TuplesKt.to(null, null);
                default -> throw new NoWhenBranchMatchedException();
            };
            String message = (String)pair.component1();
            InstallTargetAction fix = (InstallTargetAction)((Object)pair.component2());
            if (message != null) {
                org.rust.ide.notifications.UtilsKt.showBalloon(project, "target.is.not.installed", message, NotificationType.ERROR, (AnAction)fix);
            }
            return ((Availability)((Object)availability)).isInstalled();
        }

        @Nullable
        public final Rustup findRustup(@NotNull Path cargoProjectDir) {
            Intrinsics.checkNotNullParameter((Object)cargoProjectDir, (String)"cargoProjectDir");
            return (Rustup)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)RsToolchainFlavor.Companion.getApplicableFlavors(cargoProjectDir)), arg_0 -> Companion.findRustup$lambda$0(cargoProjectDir, arg_0)), Companion::findRustup$lambda$1), arg_0 -> Companion.findRustup$lambda$2(cargoProjectDir, arg_0)));
        }

        @Nullable
        public final Object installRustup(@NotNull Project project, @NotNull Path cargoProjectDir, @NotNull Continuation<? super Rustup> $completion) {
            return CoroutinesKt.coroutineToIndicator(arg_0 -> Companion.installRustup$lambda$0(project, cargoProjectDir, arg_0), $completion);
        }

        public static /* synthetic */ Object installRustup$default(Companion companion, Project project, Path path, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                Path path2 = Path.of(".", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                path = path2;
            }
            return companion.installRustup(project, path, (Continuation<? super Rustup>)continuation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Rustup doInstallRustup(Project project, Path cargoProjectDir, ProgressIndicator indicator) {
            Rustup rustup;
            block29: {
                String string;
                RsToolchainBase rsToolchainBase;
                String[] stringArray;
                Pair pair;
                indicator.setIndeterminate(true);
                if (SystemInfo.isUnix) {
                    pair = TuplesKt.to((Object)Rustup.UNIX_RUSTUP_URL, (Object)Rustup.UNIX_RUSTUP_FILENAME);
                } else if (SystemInfo.isWindows) {
                    pair = TuplesKt.to((Object)Rustup.WINDOWS_RUSTUP_URL, (Object)Rustup.WINDOWS_RUSTUP_FILENAME);
                } else {
                    return null;
                }
                Pair pair2 = pair;
                String url = (String)pair2.component1();
                String targetFileName = (String)pair2.component2();
                File targetFile = new File(PathManager.getTempPath(), targetFileName);
                Ref.BooleanRef needInstallVisualStudio = new Ref.BooleanRef();
                ProcessAdapter listener2 = new ProcessAdapter(indicator, needInstallVisualStudio){
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ Ref.BooleanRef $needInstallVisualStudio;
                    {
                        this.$indicator = $indicator;
                        this.$needInstallVisualStudio = $needInstallVisualStudio;
                    }

                    public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        String text = event.getText();
                        Intrinsics.checkNotNull((Object)text);
                        if (StringsKt.startsWith$default((String)text, (String)"info:", (boolean)false, (int)2, null)) {
                            this.$indicator.setText2(org.rust.stdext.UtilsKt.capitalized(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)text, (CharSequence)"info:"))).toString()));
                        } else if (StringsKt.startsWith$default((String)text, (String)"warning:", (boolean)false, (int)2, null)) {
                            this.$needInstallVisualStudio.element = this.$needInstallVisualStudio.element || StringsKt.contains$default((CharSequence)text, (CharSequence)"installing msvc toolchain without its prerequisites", (boolean)false, (int)2, null);
                        }
                    }
                };
                Ref.ObjectRef amendShellProfileException = new Ref.ObjectRef();
                try {
                    if (indicator.isCanceled()) {
                        Rustup rustup2 = null;
                        return rustup2;
                    }
                    Object[] objectArray = new Object[]{targetFileName};
                    indicator.setText(RsBundle.INSTANCE.message("rustup.installer.downloading", objectArray));
                    HttpRequests.request((String)url).saveToFile(targetFile, indicator);
                    if (indicator.isCanceled()) {
                        objectArray = null;
                        return objectArray;
                    }
                    if (SystemInfo.isUnix) {
                        targetFile.setExecutable(true);
                        if (indicator.isCanceled()) {
                            objectArray = null;
                            return objectArray;
                        }
                    }
                    objectArray = new Object[]{targetFileName};
                    indicator.setText(RsBundle.INSTANCE.message("rustup.installer.running", objectArray));
                    Object[] objectArray2 = new String[]{targetFile.getAbsolutePath(), "-y", "--component", "rust-src"};
                    List arguments = CollectionsKt.mutableListOf((Object[])objectArray2);
                    Collection $this$toTypedArray$iv = arguments;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    objectArray2 = thisCollection$iv.toArray(new String[0]);
                    RsResultKt.unwrapOrThrow(CommandLineExtKt.execute$default(new GeneralCommandLine((String[])Arrays.copyOf(objectArray2, objectArray2.length)), null, (ProcessListener)listener2, 1, null));
                    if (needInstallVisualStudio.element && org.rust.cargo.toolchain.tools.Rustup$Companion.doInstallRustup$showDialog(project)) {
                        this.installVisualStudio(project, indicator);
                    }
                }
                catch (IOException e) {
                    ActionsKt.invokeLater$default(null, () -> Companion.doInstallRustup$lambda$1(e), (int)1, null);
                }
                catch (RsProcessExecutionException e) {
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"could not amend shell profile", (boolean)false, (int)2, null)) {
                        RsSettingsInteractionUsageCollector.INSTANCE.logAmendShellProfileFailed(project);
                        amendShellProfileException.element = e;
                    } else {
                        ActionsKt.invokeLater$default(null, () -> Companion.doInstallRustup$lambda$2(e), (int)1, null);
                    }
                }
                finally {
                    FileUtil.delete((File)targetFile);
                }
                rustup = this.findRustup(cargoProjectDir);
                if (amendShellProfileException.element != null) {
                    boolean isOk = true;
                    if (rustup != null) {
                        if (indicator.isCanceled()) {
                            return null;
                        }
                        try {
                            stringArray = new String[]{((Object)rustup.getExecutable()).toString(), "default", "stable"};
                            RsResultKt.unwrapOrThrow(CommandLineExtKt.execute$default(new GeneralCommandLine(stringArray), null, (ProcessListener)listener2, 1, null));
                            rustup.downloadStdlib(project, (ProcessListener)listener2);
                        }
                        catch (RsProcessExecutionException e) {
                            isOk = false;
                            ActionsKt.invokeLater$default(null, () -> Companion.doInstallRustup$lambda$3(e), (int)1, null);
                        }
                    }
                    if (isOk) {
                        ActionsKt.invokeLater$default(null, () -> Companion.doInstallRustup$lambda$4(project, amendShellProfileException), (int)1, null);
                    }
                }
                if (rustup == null || (rsToolchainBase = rustup.getToolchain()) == null || (stringArray = RustcKt.rustc(rsToolchainBase)) == null || (string = stringArray.getSysroot(project, cargoProjectDir)) == null) break block29;
                String it2 = string;
                boolean bl = false;
                LocalFileSystem.getInstance().refreshAndFindFileByPath(it2);
            }
            return rustup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void installVisualStudio(Project project, ProgressIndicator indicator) {
            File targetFile = new File(PathManager.getTempPath(), Rustup.VISUAL_STUDIO_FILENAME);
            try {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText(RsBundle.INSTANCE.message("vs.installer.downloading", new Object[0]));
                HttpRequests.request((String)Rustup.VISUAL_STUDIO_URL).saveToFile(targetFile, indicator);
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText(RsBundle.INSTANCE.message("vs.installer.running", new Object[0]));
                indicator.setText2(RsBundle.INSTANCE.message("vs.installer.waiting", new Object[0]));
                Object[] objectArray = new String[]{targetFile.getAbsolutePath(), "--wait", "--focusedUi", "--addProductLang", "En-us", "--add", "Microsoft.VisualStudio.Component.VC.Tools.x86.x64"};
                List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
                if (!this.hasWindowsSdkLibs()) {
                    arguments.add("--add");
                    arguments.add("Microsoft.VisualStudio.Component.Windows11SDK.22000");
                }
                Collection $this$toTypedArray$iv = arguments;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new String[0]);
                RsResultKt.unwrapOrThrow(CommandLineExtKt.execute$default(new GeneralCommandLine((String[])Arrays.copyOf(objectArray, objectArray.length)), null, null, 3, null));
            }
            catch (IOException e) {
                ActionsKt.invokeLater$default(null, () -> Companion.installVisualStudio$lambda$0(e), (int)1, null);
            }
            catch (RsProcessExecutionException e) {
                ActionsKt.invokeLater$default(null, () -> Companion.installVisualStudio$lambda$1(project, e), (int)1, null);
            }
            finally {
                FileUtil.delete((File)targetFile);
            }
        }

        private final boolean hasWindowsSdkLibs() {
            String string = System.getenv("lib");
            if (string == null) {
                return false;
            }
            String libPaths = string;
            Object object = new char[]{File.pathSeparatorChar};
            List paths = StringsKt.split$default((CharSequence)libPaths, (char[])object, (boolean)false, (int)0, (int)6, null);
            object = paths.iterator();
            while (object.hasNext()) {
                String path = (String)object.next();
                File kernel32Lib = new File(path, "kernel32.lib");
                if (!kernel32Lib.exists()) continue;
                return true;
            }
            return false;
        }

        private final void handleRustupInstallationIOException(IOException e) {
            block0: {
                RustupKt.access$getLOG$p().info((Throwable)e);
                String string = e.getMessage();
                if (string == null) break block0;
                String message = string;
                boolean bl = false;
                Throwable throwable = e.getCause();
                PackagesNotificationPanel.showError((String)RsBundle.INSTANCE.message("rustup.failed.to.install.title", new Object[0]), (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(message, null, throwable != null ? throwable.getMessage() : null, RsBundle.INSTANCE.message("rustup.try.to.install.manually", new Object[0])));
            }
        }

        private final void handleVSInstallationIOException(IOException e) {
            block0: {
                RustupKt.access$getLOG$p().info((Throwable)e);
                String string = e.getMessage();
                if (string == null) break block0;
                String message = string;
                boolean bl = false;
                Throwable throwable = e.getCause();
                PackagesNotificationPanel.showError((String)RsBundle.INSTANCE.message("vs.failed.to.install.title", new Object[0]), (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(message, null, throwable != null ? throwable.getMessage() : null, RsBundle.INSTANCE.message("vs.try.to.install.manually", new Object[0])));
            }
        }

        private final void handleRustupInstallationExecutionException(RsProcessExecutionException e) {
            Pair pair;
            RustupKt.access$getLOG$p().info((Throwable)e);
            RsProcessExecutionException rsProcessExecutionException = e;
            if (rsProcessExecutionException instanceof RsProcessExecutionException.Start) {
                pair = TuplesKt.to((Object)RsBundle.INSTANCE.message("rustup.failed.to.install.title", new Object[0]), (Object)RsBundle.INSTANCE.message("rustup.failed.to.start.installation", new Object[0]));
            } else if (rsProcessExecutionException instanceof RsProcessExecutionException.ProcessAborted) {
                ((RsProcessExecutionException.ProcessAborted)e).getOutput().checkSuccess(RustupKt.access$getLOG$p());
                Object[] objectArray = new Object[]{((RsProcessExecutionException.ProcessAborted)e).getOutput().getExitCode()};
                pair = TuplesKt.to((Object)RsBundle.INSTANCE.message("rustup.failed.to.install.title", new Object[0]), (Object)RsBundle.INSTANCE.message("rustup.failed.to.install.exit.code", objectArray));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            String title = (String)pair2.component1();
            String message = (String)pair2.component2();
            PackagesNotificationPanel.showError((String)title, (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(message, e.getCommandLineString(), e.getMessage(), RsBundle.INSTANCE.message("rustup.try.to.install.manually", new Object[0])));
        }

        private final void handleRustupAmendShellProfileException(Project project, RsProcessExecutionException e) {
            RustupKt.access$getLOG$p().info((Throwable)e);
            if (!(e instanceof RsProcessExecutionException.ProcessAborted)) {
                return;
            }
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            String rcfile = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string, (String)"'", null, (int)2, null), (String)"'", null, (int)2, null);
            Object[] objectArray = new Object[]{rcfile};
            Messages.showWarningDialog((Project)project, (String)RsBundle.INSTANCE.message("rustup.could.not.amend.shell.profile", objectArray), (String)RsBundle.INSTANCE.message("rustup.could.not.amend.shell.profile.title", new Object[0]));
        }

        private final void handleVSInstallationExecutionException(Project project, RsProcessExecutionException e) {
            Pair pair;
            RustupKt.access$getLOG$p().info((Throwable)e);
            RsProcessExecutionException rsProcessExecutionException = e;
            if (rsProcessExecutionException instanceof RsProcessExecutionException.Start) {
                pair = TuplesKt.to((Object)RsBundle.INSTANCE.message("vs.failed.to.install.title", new Object[0]), (Object)RsBundle.INSTANCE.message("vs.failed.to.start.installation", new Object[0]));
            } else if (rsProcessExecutionException instanceof RsProcessExecutionException.ProcessAborted) {
                int exitCode = ((RsProcessExecutionException.ProcessAborted)e).getOutput().getExitCode();
                String errorMessage = this.errorMessageFromVSExitCode(exitCode);
                RustupKt.access$getLOG$p().info("Exit code " + exitCode + ": " + errorMessage);
                Object[] objectArray = new Integer[]{1641, 3010};
                if (CollectionsKt.listOf((Object[])objectArray).contains(exitCode)) {
                    org.rust.ide.notifications.UtilsKt.showBalloon$default(project, "visual.studio.installer", RsBundle.INSTANCE.message("vs.installer.title", new Object[0]), errorMessage, NotificationType.WARNING, null, null, 48, null);
                    return;
                }
                pair = TuplesKt.to((Object)RsBundle.INSTANCE.message("vs.failed.to.install.title", new Object[0]), (Object)errorMessage);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            String title = (String)pair2.component1();
            String message = (String)pair2.component2();
            PackagesNotificationPanel.showError((String)title, (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(message, e.getCommandLineString(), e.getMessage(), RsBundle.INSTANCE.message("vs.try.to.install.manually", new Object[0])));
        }

        @NlsSafe
        private final String errorMessageFromVSExitCode(int exitCode) {
            return switch (exitCode) {
                case 740 -> RsBundle.INSTANCE.message("vs.exit.code.740", new Object[0]);
                case 1001 -> RsBundle.INSTANCE.message("vs.exit.code.1001", new Object[0]);
                case 1003 -> RsBundle.INSTANCE.message("vs.exit.code.1003", new Object[0]);
                case 1602 -> RsBundle.INSTANCE.message("vs.exit.code.1602", new Object[0]);
                case 1618 -> RsBundle.INSTANCE.message("vs.exit.code.1618", new Object[0]);
                case 1641 -> RsBundle.INSTANCE.message("vs.exit.code.1641", new Object[0]);
                case 3010 -> RsBundle.INSTANCE.message("vs.exit.code.3010", new Object[0]);
                case 5003 -> RsBundle.INSTANCE.message("vs.exit.code.5003", new Object[0]);
                case 5004 -> RsBundle.INSTANCE.message("vs.exit.code.5004", new Object[0]);
                case 5005 -> RsBundle.INSTANCE.message("vs.exit.code.5005", new Object[0]);
                case 5007 -> RsBundle.INSTANCE.message("vs.exit.code.5007", new Object[0]);
                case 8001 -> RsBundle.INSTANCE.message("vs.exit.code.8001", new Object[0]);
                case 8002 -> RsBundle.INSTANCE.message("vs.exit.code.8002", new Object[0]);
                case 8003 -> RsBundle.INSTANCE.message("vs.exit.code.8003", new Object[0]);
                case 8004 -> RsBundle.INSTANCE.message("vs.exit.code.8004", new Object[0]);
                case 8005 -> RsBundle.INSTANCE.message("vs.exit.code.8005", new Object[0]);
                case 8006 -> RsBundle.INSTANCE.message("vs.exit.code.8006", new Object[0]);
                case -1073720687 -> RsBundle.INSTANCE.message("vs.exit.code.-1073720687", new Object[0]);
                case -1073741510 -> RsBundle.INSTANCE.message("vs.exit.code.-1073741510", new Object[0]);
                default -> {
                    Object[] var2_2 = new Object[]{exitCode};
                    yield RsBundle.INSTANCE.message("vs.exit.code.else", var2_2);
                }
            };
        }

        private static final Sequence findRustup$lambda$0(Path $cargoProjectDir, RsToolchainFlavor it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return it2.suggestHomePaths($cargoProjectDir);
        }

        private static final RsToolchainBase findRustup$lambda$1(Path it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            Path path = it2.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            return RsToolchainProvider.Companion.getToolchain(path);
        }

        private static final Rustup findRustup$lambda$2(Path $cargoProjectDir, RsToolchainBase it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return RustupKt.rustup(it2, $cargoProjectDir);
        }

        private static final Rustup installRustup$lambda$0(Project $project, Path $cargoProjectDir, ProgressIndicator it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            ProgressIndicator indicator = progressIndicator;
            return Companion.doInstallRustup($project, $cargoProjectDir, indicator);
        }

        private static final boolean doInstallRustup$showDialog(Project $project) {
            return (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> Companion.doInstallRustup$showDialog$lambda$0($project), (int)1, null);
        }

        private static final boolean doInstallRustup$showDialog$lambda$0(Project $project) {
            return MessageUtil.showYesNoDialog$default((String)RsBundle.INSTANCE.message("rustup.installer.vs.question.title", new Object[0]), (String)RsBundle.INSTANCE.message("rustup.installer.vs.question", new Object[0]), (Project)$project, null, null, (Icon)Messages.getQuestionIcon(), (int)24, null);
        }

        private static final Unit doInstallRustup$lambda$1(IOException $e) {
            Companion.handleRustupInstallationIOException($e);
            return Unit.INSTANCE;
        }

        private static final Unit doInstallRustup$lambda$2(RsProcessExecutionException $e) {
            Companion.handleRustupInstallationExecutionException($e);
            return Unit.INSTANCE;
        }

        private static final Unit doInstallRustup$lambda$3(RsProcessExecutionException $e) {
            Companion.handleRustupInstallationExecutionException($e);
            return Unit.INSTANCE;
        }

        private static final Unit doInstallRustup$lambda$4(Project $project, Ref.ObjectRef $amendShellProfileException) {
            Companion.handleRustupAmendShellProfileException($project, (RsProcessExecutionException)$amendShellProfileException.element);
            return Unit.INSTANCE;
        }

        private static final Unit installVisualStudio$lambda$0(IOException $e) {
            Companion.handleVSInstallationIOException($e);
            return Unit.INSTANCE;
        }

        private static final Unit installVisualStudio$lambda$1(Project $project, RsProcessExecutionException $e) {
            Companion.handleVSInstallationExecutionException($project, $e);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Availability.values().length];
                try {
                    nArray[Availability.INSTALLED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Availability.NOT_INSTALLED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Availability.NO_RUSTUP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Availability.UNKNOWN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustup$Component;", "", "name", "", "isInstalled", "", "<init>", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.rustrover.core"})
    public static final class Component {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        private final boolean isInstalled;

        public Component(@NotNull String name2, boolean isInstalled) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.isInstalled = isInstalled;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isInstalled() {
            return this.isInstalled;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.isInstalled;
        }

        @NotNull
        public final Component copy(@NotNull String name2, boolean isInstalled) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new Component(name2, isInstalled);
        }

        public static /* synthetic */ Component copy$default(Component component, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = component.name;
            }
            if ((n & 2) != 0) {
                bl = component.isInstalled;
            }
            return component.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Component(name=" + this.name + ", isInstalled=" + this.isInstalled + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInstalled);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Component)) {
                return false;
            }
            Component component = (Component)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)component.name)) {
                return false;
            }
            return this.isInstalled == component.isInstalled;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustup$Component$Companion;", "", "<init>", "()V", "from", "Lorg/rust/cargo/toolchain/tools/Rustup$Component;", "line", "", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Component from(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String name2 = StringsKt.substringBefore$default((String)line, (char)' ', null, (int)2, null);
                Object[] objectArray = new String[]{"(installed)", "(default)"};
                boolean isInstalled = CollectionsKt.listOf((Object[])objectArray).contains(StringsKt.substringAfter$default((String)line, (char)' ', null, (int)2, null));
                return new Component(name2, isInstalled);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustup$Target;", "", "name", "", "isInstalled", "", "<init>", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.rustrover.core"})
    public static final class Target {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        private final boolean isInstalled;

        public Target(@NotNull String name2, boolean isInstalled) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.isInstalled = isInstalled;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isInstalled() {
            return this.isInstalled;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.isInstalled;
        }

        @NotNull
        public final Target copy(@NotNull String name2, boolean isInstalled) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new Target(name2, isInstalled);
        }

        public static /* synthetic */ Target copy$default(Target target, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = target.name;
            }
            if ((n & 2) != 0) {
                bl = target.isInstalled;
            }
            return target.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Target(name=" + this.name + ", isInstalled=" + this.isInstalled + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInstalled);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Target)) {
                return false;
            }
            Target target = (Target)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)target.name)) {
                return false;
            }
            return this.isInstalled == target.isInstalled;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustup$Target$Companion;", "", "<init>", "()V", "from", "Lorg/rust/cargo/toolchain/tools/Rustup$Target;", "line", "", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Target from(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String name2 = StringsKt.substringBefore$default((String)line, (char)' ', null, (int)2, null);
                Object[] objectArray = new String[]{"(installed)", "(default)"};
                boolean isInstalled = CollectionsKt.listOf((Object[])objectArray).contains(StringsKt.substringAfter$default((String)line, (char)' ', null, (int)2, null));
                return new Target(name2, isInstalled);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

