/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain.tools;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.settings.RustfmtProjectSettingsService;
import org.rust.cargo.project.settings.RustfmtProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.RsAnsiEscapeDecoderKt;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.RustChannel;
import org.rust.cargo.toolchain.tools.Cargo;
import org.rust.cargo.toolchain.tools.CargoKt;
import org.rust.cargo.toolchain.tools.RustupComponent;
import org.rust.ide.formatter.RustfmtMessagesService;
import org.rust.ide.notifications.RsNotifications;
import org.rust.ide.statistics.RustfmtUsagesCollector;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.openapiext.CommandLineExtKt;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.stdext.RsResult;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ8\u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\n\u0012\u0004\u0012\u00020\u0010\u0018\u0001`\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u000fj\b\u0012\u0004\u0012\u00020\u001a`\u00122\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u001c"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustfmt;", "Lorg/rust/cargo/toolchain/tools/RustupComponent;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "<init>", "(Lorg/rust/cargo/toolchain/RsToolchainBase;)V", "reformatDocumentTextOrNull", "", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "document", "Lcom/intellij/openapi/editor/Document;", "place", "Lorg/rust/ide/statistics/RustfmtUsagesCollector$Place;", "reformatTextDocument", "Lorg/rust/stdext/RsResult;", "Lcom/intellij/execution/process/ProcessOutput;", "Lorg/rust/openapiext/RsProcessExecutionException;", "Lorg/rust/openapiext/RsProcessResult;", "project", "Lcom/intellij/openapi/project/Project;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "reformatCargoProject", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRustfmt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rustfmt.kt\norg/rust/cargo/toolchain/tools/Rustfmt\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RsResult.kt\norg/rust/stdext/RsResult\n*L\n1#1,214:1\n60#2,4:215\n1#3:219\n29#4,4:220\n34#4,4:224\n*S KotlinDebug\n*F\n+ 1 Rustfmt.kt\norg/rust/cargo/toolchain/tools/Rustfmt\n*L\n51#1:215,4\n148#1:220,4\n149#1:224,4\n*E\n"})
public final class Rustfmt
extends RustupComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "rustfmt";
    @NotNull
    private static final List<String> CONFIG_FILES;
    @NotNull
    private static final Lazy<AnsiEscapeDecoder> DECODER$delegate;

    public Rustfmt(@NotNull RsToolchainBase toolchain2) {
        Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
        super(NAME, toolchain2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String reformatDocumentTextOrNull(@NotNull CargoProject cargoProject, @NotNull Document document, @NotNull RustfmtUsagesCollector.Place place) {
        String string;
        block5: {
            block2: {
                ProcessOutput processOutput;
                block4: {
                    void var10_8;
                    void $this$unwrapOrElse$iv;
                    Project project;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
                        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
                        project = cargoProject.getProject();
                        RsResult<ProcessOutput, RsProcessExecutionException> rsResult = this.reformatTextDocument(cargoProject, document, project);
                        if (rsResult == null) break block2;
                        RsResult<ProcessOutput, RsProcessExecutionException> rsResult2 = rsResult;
                        boolean $i$f$unwrapOrElse = false;
                        var10_8 = $this$unwrapOrElse$iv;
                        if (!(var10_8 instanceof RsResult.Ok)) break block3;
                        processOutput = (ProcessOutput)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
                        if (processOutput == null) break block2;
                        break block4;
                    }
                    if (!(var10_8 instanceof RsResult.Err)) {
                        throw new NoWhenBranchMatchedException();
                    }
                    RsProcessExecutionException e = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                    boolean bl = false;
                    Companion.reportRustfmtError(e, project, org.rust.openapiext.UtilsKt.getVirtualFile(document), place);
                    if (org.rust.openapiext.UtilsKt.isUnitTestMode()) {
                        throw e;
                    }
                    return null;
                }
                string = processOutput.getStdout();
                break block5;
            }
            string = null;
        }
        String stdout = string;
        return StringKt.nullize$default(stdout, (boolean)false, (int)1, null);
    }

    @Nullable
    public final RsResult<ProcessOutput, RsProcessExecutionException> reformatTextDocument(@NotNull CargoProject cargoProject, @NotNull Document document, @NotNull Project project) {
        RsResult rsResult;
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GeneralCommandLine generalCommandLine = this.createCommandLine(cargoProject, document);
        if (generalCommandLine != null) {
            String string = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            rsResult = CommandLineExtKt.execute$default(generalCommandLine, byArray, null, 2, null);
        } else {
            rsResult = null;
        }
        return rsResult;
    }

    private final GeneralCommandLine createCommandLine(CargoProject cargoProject, Document document) {
        VirtualFile virtualFile = org.rust.openapiext.UtilsKt.getVirtualFile(document);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return this.createCommandLine(cargoProject, file);
    }

    @Nullable
    public final GeneralCommandLine createCommandLine(@NotNull CargoProject cargoProject, @NotNull VirtualFile file) {
        int idx;
        String string;
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (RsFileKt.isNotRustFile(file) || !file.isValid()) {
            return null;
        }
        Project project = cargoProject.getProject();
        if (!TrustedProjects.isProjectTrusted((Project)cargoProject.getProject())) {
            return null;
        }
        RustfmtProjectSettingsService settings = RustfmtProjectSettingsServiceKt.getRustfmtSettings(project);
        List list = ParametersListUtil.parse((String)settings.getAdditionalArguments());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        List arguments = list;
        List cleanArguments = new ArrayList();
        String string2 = (String)CollectionsKt.firstOrNull((List)arguments);
        if (string2 != null) {
            String string3;
            String it2 = string3 = string2;
            boolean bl = false;
            string = StringsKt.startsWith$default((String)it2, (String)"+", (boolean)false, (int)2, null) ? string3 : null;
        } else {
            string = null;
        }
        String toolchain2 = string;
        if (settings.getChannel() != RustChannel.DEFAULT) {
            ((Collection)cleanArguments).add("+" + settings.getChannel());
        } else if (toolchain2 != null) {
            ((Collection)cleanArguments).add(toolchain2);
        }
        int n = idx = toolchain2 == null ? 0 : 1;
        while (idx < arguments.size()) {
            String arg = (String)arguments.get(idx);
            if (Intrinsics.areEqual((Object)arg, (Object)"--color") || Intrinsics.areEqual((Object)arg, (Object)"--emit")) {
                idx += 2;
                continue;
            }
            Intrinsics.checkNotNull((Object)arg);
            if (StringsKt.startsWith$default((String)arg, (String)"--color", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)arg, (String)"--emit", (boolean)false, (int)2, null)) {
                ++idx;
                continue;
            }
            ((Collection)cleanArguments).add(arg);
            ++idx;
        }
        cleanArguments.add("--color=always");
        cleanArguments.add("--emit=stdout");
        Rustfmt.Companion.addArgument(cleanArguments, "config-path", (Function0<String>)() -> Rustfmt.createCommandLine$lambda$1(file, cargoProject));
        Rustfmt.Companion.addArgument(cleanArguments, "edition", (Function0<String>)() -> Rustfmt.createCommandLine$lambda$2(cargoProject, project, file));
        return this.createBaseCommandLine(project, cleanArguments, cargoProject.getRootDirPath(), settings.getEnvs()).withEnvironment("TERM", "ansi");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final RsResult<Unit, RsProcessExecutionException> reformatCargoProject(@NotNull CargoProject cargoProject) {
        RsResult rsResult;
        RsResult rsResult2;
        GeneralCommandLine generalCommandLine;
        Cargo cargo;
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        Project project = cargoProject.getProject();
        RustfmtProjectSettingsService settings = RustfmtProjectSettingsServiceKt.getRustfmtSettings(project);
        List list = ParametersListUtil.parse((String)settings.getAdditionalArguments());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        List arguments = CollectionsKt.toMutableList((Collection)list);
        String string = (String)CollectionsKt.firstOrNull((List)arguments);
        String toolchain2 = (string != null ? StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null) : false) ? (String)arguments.removeFirst() : null;
        Object[] objectArray = new String[]{"--all", "--"};
        List list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)arguments);
        RustChannel rustChannel = settings.getChannel();
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create(settings.getEnvs(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
        CargoCommandLine commandLine = CargoCommandLine.Companion.forProject(cargoProject, "fmt", list2, false, toolchain2, rustChannel, environmentVariablesData);
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        if (rsToolchainBase != null && (cargo = CargoKt.cargoOrWrapper(rsToolchainBase, cargoProject.getRootDirPath())) != null && (generalCommandLine = cargo.toGeneralCommandLine(project, commandLine)) != null && (rsResult2 = CommandLineExtKt.execute$default(generalCommandLine, null, null, 3, null)) != null) {
            void this_$iv;
            RsResult rsResult3;
            void this_$iv2;
            RsResult rsResult4 = rsResult2;
            boolean $i$f$map22 = false;
            void var13_15 = this_$iv2;
            if (var13_15 instanceof RsResult.Ok) {
                ProcessOutput it2 = (ProcessOutput)((RsResult.Ok)this_$iv2).getOk();
                boolean bl = false;
                Unit unit = Unit.INSTANCE;
                rsResult3 = new RsResult.Ok<Unit>(unit);
            } else {
                if (!(var13_15 instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
                rsResult3 = new RsResult.Err(((RsResult.Err)this_$iv2).getErr());
            }
            RsResult $i$f$map22 = rsResult3;
            boolean $i$f$mapErr = false;
            void var14_17 = this_$iv;
            if (var14_17 instanceof RsResult.Ok) {
                rsResult = new RsResult.Ok(((RsResult.Ok)this_$iv).getOk());
                return rsResult;
            } else {
                if (!(var14_17 instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
                RsProcessExecutionException e = (RsProcessExecutionException)((RsResult.Err)this_$iv).getErr();
                boolean bl = false;
                Companion.reportRustfmtError(e, project, null, RustfmtUsagesCollector.Place.EXPLICIT);
                RsProcessExecutionException rsProcessExecutionException = e;
                rsResult = new RsResult.Err<RsProcessExecutionException>(rsProcessExecutionException);
            }
            return rsResult;
        } else {
            rsResult = new RsResult.Ok<Unit>(Unit.INSTANCE);
        }
        return rsResult;
    }

    private static final String createCommandLine$lambda$1(VirtualFile $file, CargoProject $cargoProject) {
        VirtualFile virtualFile = $file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        Path path = Rustfmt.Companion.findConfigPathRecursively(virtualFile, $cargoProject.getRootDirPath());
        return path != null ? ((Object)path).toString() : null;
    }

    private static final String createCommandLine$lambda$2(CargoProject $cargoProject, Project $project, VirtualFile $file) {
        RustcInfo rustcInfo = $cargoProject.getRustcInfo();
        if ((rustcInfo != null ? rustcInfo.getVersion() : null) == null) {
            return null;
        }
        CargoWorkspace.Edition edition = (CargoWorkspace.Edition)((Object)ActionsKt.runReadAction(() -> Rustfmt.createCommandLine$lambda$2$0($project, $file)));
        return edition.getPresentation();
    }

    private static final CargoWorkspace.Edition createCommandLine$lambda$2$0(Project $project, VirtualFile $file) {
        Object object = CargoProjectServiceKt.getCargoProjects($project).findPackageForFile($file);
        if (object == null || (object = object.getEdition()) == null) {
            object = CargoWorkspace.Edition.Companion.getDEFAULT();
        }
        return object;
    }

    private static final AnsiEscapeDecoder DECODER_delegate$lambda$0() {
        return new AnsiEscapeDecoder();
    }

    static {
        Object[] objectArray = new String[]{"rustfmt.toml", ".rustfmt.toml"};
        CONFIG_FILES = CollectionsKt.listOf((Object[])objectArray);
        DECODER$delegate = LazyKt.lazy(Rustfmt::DECODER_delegate$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J$\u0010\u0019\u001a\u00020\u000f*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/rust/cargo/toolchain/tools/Rustfmt$Companion;", "", "<init>", "()V", "NAME", "", "CONFIG_FILES", "", "DECODER", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "getDECODER", "()Lcom/intellij/execution/process/AnsiEscapeDecoder;", "DECODER$delegate", "Lkotlin/Lazy;", "addArgument", "", "", "flagName", "value", "Lkotlin/Function0;", "findConfigPathRecursively", "Ljava/nio/file/Path;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "stopAt", "reportRustfmtError", "Lorg/rust/openapiext/RsProcessExecutionException;", "project", "Lcom/intellij/openapi/project/Project;", "file", "place", "Lorg/rust/ide/statistics/RustfmtUsagesCollector$Place;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRustfmt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rustfmt.kt\norg/rust/cargo/toolchain/tools/Rustfmt$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,214:1\n1761#2,3:215\n12970#3,2:218\n*S KotlinDebug\n*F\n+ 1 Rustfmt.kt\norg/rust/cargo/toolchain/tools/Rustfmt$Companion\n*L\n164#1:215,3\n172#1:218,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final AnsiEscapeDecoder getDECODER() {
            Lazy lazy = DECODER$delegate;
            return (AnsiEscapeDecoder)lazy.getValue();
        }

        private final void addArgument(List<String> $this$addArgument, String flagName, Function0<String> value) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = $this$addArgument;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it2, (String)("--" + flagName), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            String string = (String)value.invoke();
            if (string == null) {
                return;
            }
            String flagValue = string;
            $this$addArgument.add("--" + flagName + "=" + flagValue);
        }

        private final Path findConfigPathRecursively(VirtualFile directory, Path stopAt) {
            boolean bl;
            Path path;
            block3: {
                path = org.rust.openapiext.UtilsKt.getPathAsPath(directory);
                if (!path.startsWith(stopAt) || Intrinsics.areEqual((Object)path, (Object)stopAt)) {
                    return null;
                }
                VirtualFile[] virtualFileArray = directory.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                Object[] $this$any$iv = virtualFileArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it2 = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!CONFIG_FILES.contains(it2.getName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return path;
            }
            VirtualFile virtualFile = directory.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            return this.findConfigPathRecursively(virtualFile, stopAt);
        }

        public final void reportRustfmtError(@NotNull RsProcessExecutionException $this$reportRustfmtError, @NotNull Project project, @Nullable VirtualFile file, @NotNull RustfmtUsagesCollector.Place place) {
            String string;
            String cleanText;
            String stderr;
            String string2;
            Intrinsics.checkNotNullParameter((Object)$this$reportRustfmtError, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            RsProcessExecutionException rsProcessExecutionException = $this$reportRustfmtError;
            if (rsProcessExecutionException instanceof RsProcessExecutionException.ProcessAborted) {
                string2 = ((RsProcessExecutionException.ProcessAborted)$this$reportRustfmtError).getOutput().getStderr();
            } else if (rsProcessExecutionException instanceof RsProcessExecutionException.Start) {
                Throwable throwable = $this$reportRustfmtError.getCause();
                string2 = throwable != null ? throwable.getMessage() : null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String string3 = string2;
            if (string2 == null) {
                string3 = stderr = "";
            }
            if (((CharSequence)(cleanText = RsAnsiEscapeDecoderKt.removeEscapeSequences(this.getDECODER(), stderr))).length() == 0) {
                return;
            }
            RustfmtUsagesCollector.INSTANCE.logRustfmtError(project, place);
            if (file != null) {
                String string4 = file.getPresentableUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPresentableUrl(...)");
                string = StringsKt.replace$default((String)stderr, (String)"<stdin>", (String)string4, (boolean)false, (int)4, null);
            } else {
                string = stderr;
            }
            String text = string;
            RustfmtMessagesService consoleService = RustfmtMessagesService.Companion.getInstance(project);
            this.getDECODER().escapeText(text, ProcessOutputTypes.STDOUT, (arg_0, arg_1) -> Companion.reportRustfmtError$lambda$0(consoleService, arg_0, arg_1));
            if (place != RustfmtUsagesCollector.Place.EXPLICIT) {
                return;
            }
            Pair pair = StringsKt.startsWith$default((String)cleanText, (String)"info: ", (boolean)false, (int)2, null) ? TuplesKt.to((Object)StringsKt.removePrefix((String)cleanText, (CharSequence)"info: "), (Object)NotificationType.INFORMATION) : (StringsKt.startsWith$default((String)cleanText, (String)"warning: ", (boolean)false, (int)2, null) ? TuplesKt.to((Object)StringsKt.removePrefix((String)cleanText, (CharSequence)"warning: "), (Object)NotificationType.WARNING) : TuplesKt.to((Object)StringsKt.removePrefix((String)cleanText, (CharSequence)"error: "), (Object)NotificationType.ERROR));
            String content = (String)pair.component1();
            NotificationType type = (NotificationType)pair.component2();
            String line = UtilsKt.capitalized(StringsKt.substringBefore$default((String)content, (char)'\n', null, (int)2, null));
            RsNotifications.INSTANCE.createRustfmtNotification("rustfmt.error", (Function1<? super NotificationGroup, ? extends Notification>)((Function1)arg_0 -> Companion.reportRustfmtError$lambda$1(line, type, project, consoleService, arg_0))).notify(project);
        }

        private static final void reportRustfmtError$lambda$0(RustfmtMessagesService $consoleService, String chunk, Key attributes) {
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
            $consoleService.addMessage(chunk, consoleViewContentType);
        }

        private static final Notification reportRustfmtError$lambda$1(String $line, NotificationType $type, Project $project, RustfmtMessagesService $consoleService, NotificationGroup it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            Notification notification = it2.createNotification(RsBundle.INSTANCE.message("notification.title.rustfmt.error", new Object[0]), $line, $type);
            Notification notification2 = notification.addAction((AnAction)NotificationAction.createSimple((String)RsBundle.INSTANCE.message("notification.rustfmt.show.details.in.console", new Object[0]), () -> Companion.reportRustfmtError$lambda$1$0(notification, $project, $consoleService)));
            Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"addAction(...)");
            return notification2;
        }

        private static final void reportRustfmtError$lambda$1$0(Notification $notification, Project $project, RustfmtMessagesService $consoleService) {
            $notification.expire();
            RustfmtUsagesCollector.INSTANCE.logRustfmtConsoleOpenedViaLink($project);
            $consoleService.showConsoleTabAndScrollToTheEnd();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

