/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain.tools;

import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.cargo.CfgOptions;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.impl.RustcVersionKt;
import org.rust.cargo.toolchain.tools.RsTool;
import org.rust.cargo.toolchain.tools.RustupComponent;
import org.rust.openapiext.CommandLineExtKt;
import org.rust.openapiext.RsPathManager;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ<\u0010\u0006\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\r0\fj\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bJ\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bJ \u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bJ0\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0007\u00a8\u0006\""}, d2={"Lorg/rust/cargo/toolchain/tools/Rustc;", "Lorg/rust/cargo/toolchain/tools/RustupComponent;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "<init>", "(Lorg/rust/cargo/toolchain/RsToolchainBase;)V", "queryVersion", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "Ljava/nio/file/Path;", "Lorg/rust/stdext/RsResult;", "Lorg/rust/openapiext/RsProcessExecutionException;", "Lorg/rust/openapiext/RsProcessResult;", "listener", "Lcom/intellij/execution/process/ProcessListener;", "getSysroot", "", "projectDirectory", "getStdlibPathFromSysroot", "getStdlibFromSysroot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRawCfgOption", "", "getCfgOptions", "Lorg/rust/cargo/CfgOptions;", "getRustcTargets", "compile", "Lcom/intellij/execution/process/ProcessOutput;", "args", "rustFile", "outputDir", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRustc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rustc.kt\norg/rust/cargo/toolchain/tools/Rustc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RsResult.kt\norg/rust/stdext/RsResult\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,126:1\n1#2:127\n29#3,4:128\n37#4,2:132\n*S KotlinDebug\n*F\n+ 1 Rustc.kt\norg/rust/cargo/toolchain/tools/Rustc\n*L\n47#1:128,4\n116#1:132,2\n*E\n"})
public final class Rustc
extends RustupComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "rustc";

    public Rustc(@NotNull RsToolchainBase toolchain2) {
        Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
        super(NAME, toolchain2);
    }

    @Nullable
    public final RustcVersion queryVersion(@Nullable Project project, @Nullable Path workingDirectory) {
        RustcVersion rustcVersion;
        List lines;
        if (!UtilsKt.isUnitTestMode()) {
            UtilsKt.checkIsBackgroundThread();
        }
        String[] stringArray = new String[]{"--version", "--verbose"};
        ProcessOutput processOutput = CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, workingDirectory, null, 8, null), this.getToolchain().getExecutionTimeoutInMilliseconds(), null, 2, null);
        List list = lines = processOutput != null ? processOutput.getStdoutLines() : null;
        if (list != null) {
            List it2 = list;
            boolean bl = false;
            rustcVersion = RustcVersionKt.parseRustcVersion(it2);
        } else {
            rustcVersion = null;
        }
        return rustcVersion;
    }

    public static /* synthetic */ RustcVersion queryVersion$default(Rustc rustc, Project project, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        return rustc.queryVersion(project, path);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RsResult<RustcVersion, RsProcessExecutionException> queryVersion(@NotNull Project project, @NotNull Path workingDirectory, @Nullable ProcessListener listener2) {
        RsResult rsResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        if (!UtilsKt.isUnitTestMode()) {
            UtilsKt.checkIsBackgroundThread();
        }
        Object object = new String[]{"--version", "--verbose"};
        object = CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, object, workingDirectory, null, 8, null), null, listener2, 1, null);
        boolean $i$f$map = false;
        void var6_6 = this_$iv;
        if (var6_6 instanceof RsResult.Ok) {
            ProcessOutput it2 = (ProcessOutput)((RsResult.Ok)this_$iv).getOk();
            boolean bl = false;
            List list = it2.getStdoutLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
            RustcVersion rustcVersion = RustcVersionKt.parseRustcVersion(list);
            rsResult = new RsResult.Ok<RustcVersion>(rustcVersion);
        } else if (var6_6 instanceof RsResult.Err) {
            rsResult = new RsResult.Err(((RsResult.Err)this_$iv).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    public static /* synthetic */ RsResult queryVersion$default(Rustc rustc, Project project, Path path, ProcessListener processListener, int n, Object object) {
        if ((n & 4) != 0) {
            processListener = null;
        }
        return rustc.queryVersion(project, path, processListener);
    }

    @Nullable
    public final String getSysroot(@NotNull Project project, @NotNull Path projectDirectory) {
        ProcessOutput output;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        if (!UtilsKt.isUnitTestMode()) {
            UtilsKt.checkIsBackgroundThread();
        }
        int timeoutMs = UtilsKt.isUnitTestMode() ? 600000 : 10000;
        String[] stringArray = new String[]{"--print", "sysroot"};
        ProcessOutput processOutput = output = CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, projectDirectory, null, 8, null), timeoutMs, null, 2, null);
        if (!(processOutput != null ? CommandLineExtKt.isSuccess(processOutput) : false)) {
            return null;
        }
        RsToolchainBase rsToolchainBase = this.getToolchain();
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return rsToolchainBase.toLocalPath(((Object)StringsKt.trim((CharSequence)string)).toString());
    }

    @Nullable
    public final Path getStdlibPathFromSysroot(@NotNull Project project, @NotNull Path projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        String string = this.getSysroot(project, projectDirectory);
        if (string == null) {
            return null;
        }
        String sysroot = string;
        Path path = Path.of(sysroot, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return RsPathManager.INSTANCE.sysrootStdlibDir(path);
    }

    @Nullable
    public final VirtualFile getStdlibFromSysroot(@NotNull Project project, @NotNull Path projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Path path = this.getStdlibPathFromSysroot(project, projectDirectory);
        if (path == null) {
            return null;
        }
        Path stdlibPath = path;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem fs = localFileSystem;
        return fs.refreshAndFindFileByPath(((Object)stdlibPath).toString());
    }

    private final List<String> getRawCfgOption(Project project, Path projectDirectory) {
        ProcessOutput output;
        int timeoutMs = 10000;
        String[] stringArray = new String[]{"--print", "cfg"};
        ProcessOutput processOutput = output = CommandLineExtKt.execute$default(this.createBaseCommandLine(project, stringArray, projectDirectory, (Map<String, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"RUSTC_BOOTSTRAP", (Object)"1"))), timeoutMs, null, 2, null);
        return (processOutput != null ? CommandLineExtKt.isSuccess(processOutput) : false) ? output.getStdoutLines() : null;
    }

    @NotNull
    public final CfgOptions getCfgOptions(@NotNull Project project, @Nullable Path projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = this.getRawCfgOption(project, projectDirectory);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List rawCfgOptions = list;
        return CfgOptions.Companion.parse(rawCfgOptions);
    }

    @Nullable
    public final List<String> getRustcTargets(@NotNull Project project, @Nullable Path projectDirectory) {
        List list;
        ProcessOutput output;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!UtilsKt.isUnitTestMode()) {
            UtilsKt.checkIsBackgroundThread();
        }
        int timeoutMs = 10000;
        String[] stringArray = new String[]{"--print", "target-list"};
        ProcessOutput processOutput = output = CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, projectDirectory, null, 8, null), timeoutMs, null, 2, null);
        boolean bl = processOutput != null ? CommandLineExtKt.isSuccess(processOutput) : false;
        if (bl) {
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            list = StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString());
        } else {
            list = null;
        }
        return list;
    }

    @TestOnly
    @Nullable
    public final ProcessOutput compile(@NotNull Project project, @NotNull List<String> args, @NotNull Path rustFile, @NotNull Path outputDir) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)rustFile, (String)"rustFile");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        String[] $this$compile_u24lambda_u240 = stringArray = CollectionsKt.toMutableList((Collection)args);
        boolean bl = false;
        $this$compile_u24lambda_u240.add(((Object)PathsKt.relativeTo((Path)rustFile, (Path)outputDir)).toString());
        String[] allArgs = stringArray;
        Collection $this$toTypedArray$iv = (Collection)allArgs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        return CommandLineExtKt.execute$default(this.createBaseCommandLine(project, Arrays.copyOf(stringArray, stringArray.length), outputDir, (Map<String, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"RUSTC_BOOTSTRAP", (Object)"1"))), null, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/toolchain/tools/Rustc$Companion;", "", "<init>", "()V", "NAME", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

