/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain.tools;

import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.settings.RsExternalLinterProjectSettingsService;
import org.rust.cargo.project.settings.RsExternalLinterProjectSettingsServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.toolchain.ExternalLinter;
import org.rust.cargo.toolchain.RustChannel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001a\u001b\u001cB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/rust/cargo/toolchain/tools/CargoCheckArgs;", "", "<init>", "()V", "linter", "Lorg/rust/cargo/toolchain/ExternalLinter;", "getLinter", "()Lorg/rust/cargo/toolchain/ExternalLinter;", "cargoProjectDirectory", "Ljava/nio/file/Path;", "getCargoProjectDirectory", "()Ljava/nio/file/Path;", "rustcTarget", "", "getRustcTarget", "()Ljava/lang/String;", "extraArguments", "getExtraArguments", "channel", "Lorg/rust/cargo/toolchain/RustChannel;", "getChannel", "()Lorg/rust/cargo/toolchain/RustChannel;", "envs", "", "getEnvs", "()Ljava/util/Map;", "SpecificTarget", "FullWorkspace", "Companion", "Lorg/rust/cargo/toolchain/tools/CargoCheckArgs$FullWorkspace;", "Lorg/rust/cargo/toolchain/tools/CargoCheckArgs$SpecificTarget;", "intellij.rustrover.core"})
public abstract sealed class CargoCheckArgs {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private CargoCheckArgs() {
    }

    @NotNull
    public abstract ExternalLinter getLinter();

    @NotNull
    public abstract Path getCargoProjectDirectory();

    @Nullable
    public abstract String getRustcTarget();

    @NotNull
    public abstract String getExtraArguments();

    @NotNull
    public abstract RustChannel getChannel();

    @NotNull
    public abstract Map<String, String> getEnvs();

    public /* synthetic */ CargoCheckArgs(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/rust/cargo/toolchain/tools/CargoCheckArgs$Companion;", "", "<init>", "()V", "forTarget", "Lorg/rust/cargo/toolchain/tools/CargoCheckArgs;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "forCargoProject", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CargoCheckArgs forTarget(@NotNull Project project, @NotNull CargoWorkspace.Target target) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            RsExternalLinterProjectSettingsService settings = RsExternalLinterProjectSettingsServiceKt.getExternalLinterSettings(project);
            return new SpecificTarget(settings.getTool(), target.getPkg().getWorkspace().getWorkspaceRootPath(), RustProjectSettingsServiceKt.getRustSettings(project).getRustcTarget(), target, settings.getAdditionalArguments(), settings.getChannel(), settings.getEnvs());
        }

        @NotNull
        public final CargoCheckArgs forCargoProject(@NotNull CargoProject cargoProject) {
            Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
            RsExternalLinterProjectSettingsService settings = RsExternalLinterProjectSettingsServiceKt.getExternalLinterSettings(cargoProject.getProject());
            return new FullWorkspace(settings.getTool(), cargoProject.getRootDirPath(), RustProjectSettingsServiceKt.getRustSettings(cargoProject.getProject()).getRustcTarget(), RustProjectSettingsServiceKt.getRustSettings(cargoProject.getProject()).getCompileAllTargets(), settings.getAdditionalArguments(), settings.getChannel(), settings.getEnvs());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u00c6\u0003J]\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lorg/rust/cargo/toolchain/tools/CargoCheckArgs$FullWorkspace;", "Lorg/rust/cargo/toolchain/tools/CargoCheckArgs;", "linter", "Lorg/rust/cargo/toolchain/ExternalLinter;", "cargoProjectDirectory", "Ljava/nio/file/Path;", "rustcTarget", "", "allTargets", "", "extraArguments", "channel", "Lorg/rust/cargo/toolchain/RustChannel;", "envs", "", "<init>", "(Lorg/rust/cargo/toolchain/ExternalLinter;Ljava/nio/file/Path;Ljava/lang/String;ZLjava/lang/String;Lorg/rust/cargo/toolchain/RustChannel;Ljava/util/Map;)V", "getLinter", "()Lorg/rust/cargo/toolchain/ExternalLinter;", "getCargoProjectDirectory", "()Ljava/nio/file/Path;", "getRustcTarget", "()Ljava/lang/String;", "getAllTargets", "()Z", "getExtraArguments", "getChannel", "()Lorg/rust/cargo/toolchain/RustChannel;", "getEnvs", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
    public static final class FullWorkspace
    extends CargoCheckArgs {
        @NotNull
        private final ExternalLinter linter;
        @NotNull
        private final Path cargoProjectDirectory;
        @Nullable
        private final String rustcTarget;
        private final boolean allTargets;
        @NotNull
        private final String extraArguments;
        @NotNull
        private final RustChannel channel;
        @NotNull
        private final Map<String, String> envs;

        public FullWorkspace(@NotNull ExternalLinter linter, @NotNull Path cargoProjectDirectory, @Nullable String rustcTarget, boolean allTargets, @NotNull String extraArguments, @NotNull RustChannel channel, @NotNull Map<String, String> envs) {
            Intrinsics.checkNotNullParameter((Object)((Object)linter), (String)"linter");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            Intrinsics.checkNotNullParameter((Object)extraArguments, (String)"extraArguments");
            Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            super(null);
            this.linter = linter;
            this.cargoProjectDirectory = cargoProjectDirectory;
            this.rustcTarget = rustcTarget;
            this.allTargets = allTargets;
            this.extraArguments = extraArguments;
            this.channel = channel;
            this.envs = envs;
        }

        @Override
        @NotNull
        public ExternalLinter getLinter() {
            return this.linter;
        }

        @Override
        @NotNull
        public Path getCargoProjectDirectory() {
            return this.cargoProjectDirectory;
        }

        @Override
        @Nullable
        public String getRustcTarget() {
            return this.rustcTarget;
        }

        public final boolean getAllTargets() {
            return this.allTargets;
        }

        @Override
        @NotNull
        public String getExtraArguments() {
            return this.extraArguments;
        }

        @Override
        @NotNull
        public RustChannel getChannel() {
            return this.channel;
        }

        @Override
        @NotNull
        public Map<String, String> getEnvs() {
            return this.envs;
        }

        @NotNull
        public final ExternalLinter component1() {
            return this.linter;
        }

        @NotNull
        public final Path component2() {
            return this.cargoProjectDirectory;
        }

        @Nullable
        public final String component3() {
            return this.rustcTarget;
        }

        public final boolean component4() {
            return this.allTargets;
        }

        @NotNull
        public final String component5() {
            return this.extraArguments;
        }

        @NotNull
        public final RustChannel component6() {
            return this.channel;
        }

        @NotNull
        public final Map<String, String> component7() {
            return this.envs;
        }

        @NotNull
        public final FullWorkspace copy(@NotNull ExternalLinter linter, @NotNull Path cargoProjectDirectory, @Nullable String rustcTarget, boolean allTargets, @NotNull String extraArguments, @NotNull RustChannel channel, @NotNull Map<String, String> envs) {
            Intrinsics.checkNotNullParameter((Object)((Object)linter), (String)"linter");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            Intrinsics.checkNotNullParameter((Object)extraArguments, (String)"extraArguments");
            Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            return new FullWorkspace(linter, cargoProjectDirectory, rustcTarget, allTargets, extraArguments, channel, envs);
        }

        public static /* synthetic */ FullWorkspace copy$default(FullWorkspace fullWorkspace, ExternalLinter externalLinter, Path path, String string, boolean bl, String string2, RustChannel rustChannel, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                externalLinter = fullWorkspace.linter;
            }
            if ((n & 2) != 0) {
                path = fullWorkspace.cargoProjectDirectory;
            }
            if ((n & 4) != 0) {
                string = fullWorkspace.rustcTarget;
            }
            if ((n & 8) != 0) {
                bl = fullWorkspace.allTargets;
            }
            if ((n & 0x10) != 0) {
                string2 = fullWorkspace.extraArguments;
            }
            if ((n & 0x20) != 0) {
                rustChannel = fullWorkspace.channel;
            }
            if ((n & 0x40) != 0) {
                map2 = fullWorkspace.envs;
            }
            return fullWorkspace.copy(externalLinter, path, string, bl, string2, rustChannel, map2);
        }

        @NotNull
        public String toString() {
            return "FullWorkspace(linter=" + this.linter + ", cargoProjectDirectory=" + this.cargoProjectDirectory + ", rustcTarget=" + this.rustcTarget + ", allTargets=" + this.allTargets + ", extraArguments=" + this.extraArguments + ", channel=" + this.channel + ", envs=" + this.envs + ")";
        }

        public int hashCode() {
            int result2 = this.linter.hashCode();
            result2 = result2 * 31 + ((Object)this.cargoProjectDirectory).hashCode();
            result2 = result2 * 31 + (this.rustcTarget == null ? 0 : this.rustcTarget.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.allTargets);
            result2 = result2 * 31 + this.extraArguments.hashCode();
            result2 = result2 * 31 + this.channel.hashCode();
            result2 = result2 * 31 + ((Object)this.envs).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FullWorkspace)) {
                return false;
            }
            FullWorkspace fullWorkspace = (FullWorkspace)other;
            if (this.linter != fullWorkspace.linter) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cargoProjectDirectory, (Object)fullWorkspace.cargoProjectDirectory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rustcTarget, (Object)fullWorkspace.rustcTarget)) {
                return false;
            }
            if (this.allTargets != fullWorkspace.allTargets) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extraArguments, (Object)fullWorkspace.extraArguments)) {
                return false;
            }
            if (this.channel != fullWorkspace.channel) {
                return false;
            }
            return Intrinsics.areEqual(this.envs, fullWorkspace.envs);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u00c6\u0003J]\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lorg/rust/cargo/toolchain/tools/CargoCheckArgs$SpecificTarget;", "Lorg/rust/cargo/toolchain/tools/CargoCheckArgs;", "linter", "Lorg/rust/cargo/toolchain/ExternalLinter;", "cargoProjectDirectory", "Ljava/nio/file/Path;", "rustcTarget", "", "target", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "extraArguments", "channel", "Lorg/rust/cargo/toolchain/RustChannel;", "envs", "", "<init>", "(Lorg/rust/cargo/toolchain/ExternalLinter;Ljava/nio/file/Path;Ljava/lang/String;Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;Ljava/lang/String;Lorg/rust/cargo/toolchain/RustChannel;Ljava/util/Map;)V", "getLinter", "()Lorg/rust/cargo/toolchain/ExternalLinter;", "getCargoProjectDirectory", "()Ljava/nio/file/Path;", "getRustcTarget", "()Ljava/lang/String;", "getTarget", "()Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "getExtraArguments", "getChannel", "()Lorg/rust/cargo/toolchain/RustChannel;", "getEnvs", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
    public static final class SpecificTarget
    extends CargoCheckArgs {
        @NotNull
        private final ExternalLinter linter;
        @NotNull
        private final Path cargoProjectDirectory;
        @Nullable
        private final String rustcTarget;
        @NotNull
        private final CargoWorkspace.Target target;
        @NotNull
        private final String extraArguments;
        @NotNull
        private final RustChannel channel;
        @NotNull
        private final Map<String, String> envs;

        public SpecificTarget(@NotNull ExternalLinter linter, @NotNull Path cargoProjectDirectory, @Nullable String rustcTarget, @NotNull CargoWorkspace.Target target, @NotNull String extraArguments, @NotNull RustChannel channel, @NotNull Map<String, String> envs) {
            Intrinsics.checkNotNullParameter((Object)((Object)linter), (String)"linter");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)extraArguments, (String)"extraArguments");
            Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            super(null);
            this.linter = linter;
            this.cargoProjectDirectory = cargoProjectDirectory;
            this.rustcTarget = rustcTarget;
            this.target = target;
            this.extraArguments = extraArguments;
            this.channel = channel;
            this.envs = envs;
        }

        @Override
        @NotNull
        public ExternalLinter getLinter() {
            return this.linter;
        }

        @Override
        @NotNull
        public Path getCargoProjectDirectory() {
            return this.cargoProjectDirectory;
        }

        @Override
        @Nullable
        public String getRustcTarget() {
            return this.rustcTarget;
        }

        @NotNull
        public final CargoWorkspace.Target getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public String getExtraArguments() {
            return this.extraArguments;
        }

        @Override
        @NotNull
        public RustChannel getChannel() {
            return this.channel;
        }

        @Override
        @NotNull
        public Map<String, String> getEnvs() {
            return this.envs;
        }

        @NotNull
        public final ExternalLinter component1() {
            return this.linter;
        }

        @NotNull
        public final Path component2() {
            return this.cargoProjectDirectory;
        }

        @Nullable
        public final String component3() {
            return this.rustcTarget;
        }

        @NotNull
        public final CargoWorkspace.Target component4() {
            return this.target;
        }

        @NotNull
        public final String component5() {
            return this.extraArguments;
        }

        @NotNull
        public final RustChannel component6() {
            return this.channel;
        }

        @NotNull
        public final Map<String, String> component7() {
            return this.envs;
        }

        @NotNull
        public final SpecificTarget copy(@NotNull ExternalLinter linter, @NotNull Path cargoProjectDirectory, @Nullable String rustcTarget, @NotNull CargoWorkspace.Target target, @NotNull String extraArguments, @NotNull RustChannel channel, @NotNull Map<String, String> envs) {
            Intrinsics.checkNotNullParameter((Object)((Object)linter), (String)"linter");
            Intrinsics.checkNotNullParameter((Object)cargoProjectDirectory, (String)"cargoProjectDirectory");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)extraArguments, (String)"extraArguments");
            Intrinsics.checkNotNullParameter((Object)((Object)channel), (String)"channel");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            return new SpecificTarget(linter, cargoProjectDirectory, rustcTarget, target, extraArguments, channel, envs);
        }

        public static /* synthetic */ SpecificTarget copy$default(SpecificTarget specificTarget, ExternalLinter externalLinter, Path path, String string, CargoWorkspace.Target target, String string2, RustChannel rustChannel, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                externalLinter = specificTarget.linter;
            }
            if ((n & 2) != 0) {
                path = specificTarget.cargoProjectDirectory;
            }
            if ((n & 4) != 0) {
                string = specificTarget.rustcTarget;
            }
            if ((n & 8) != 0) {
                target = specificTarget.target;
            }
            if ((n & 0x10) != 0) {
                string2 = specificTarget.extraArguments;
            }
            if ((n & 0x20) != 0) {
                rustChannel = specificTarget.channel;
            }
            if ((n & 0x40) != 0) {
                map2 = specificTarget.envs;
            }
            return specificTarget.copy(externalLinter, path, string, target, string2, rustChannel, map2);
        }

        @NotNull
        public String toString() {
            return "SpecificTarget(linter=" + this.linter + ", cargoProjectDirectory=" + this.cargoProjectDirectory + ", rustcTarget=" + this.rustcTarget + ", target=" + this.target + ", extraArguments=" + this.extraArguments + ", channel=" + this.channel + ", envs=" + this.envs + ")";
        }

        public int hashCode() {
            int result2 = this.linter.hashCode();
            result2 = result2 * 31 + ((Object)this.cargoProjectDirectory).hashCode();
            result2 = result2 * 31 + (this.rustcTarget == null ? 0 : this.rustcTarget.hashCode());
            result2 = result2 * 31 + this.target.hashCode();
            result2 = result2 * 31 + this.extraArguments.hashCode();
            result2 = result2 * 31 + this.channel.hashCode();
            result2 = result2 * 31 + ((Object)this.envs).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpecificTarget)) {
                return false;
            }
            SpecificTarget specificTarget = (SpecificTarget)other;
            if (this.linter != specificTarget.linter) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cargoProjectDirectory, (Object)specificTarget.cargoProjectDirectory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rustcTarget, (Object)specificTarget.rustcTarget)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.target, (Object)specificTarget.target)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extraArguments, (Object)specificTarget.extraArguments)) {
                return false;
            }
            if (this.channel != specificTarget.channel) {
                return false;
            }
            return Intrinsics.areEqual(this.envs, specificTarget.envs);
        }
    }
}

