/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain.tools;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.gson.JsonObject;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.RsBundle;
import org.rust.cargo.CargoConfig;
import org.rust.cargo.CfgOptions;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.CargoWorkspaceData;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.toolchain.BacktraceMode;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.toolchain.ExternalLinter;
import org.rust.cargo.toolchain.RsCommandLineBase;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.RustChannel;
import org.rust.cargo.toolchain.eel.RsEelToolchain;
import org.rust.cargo.toolchain.impl.BuildMessages;
import org.rust.cargo.toolchain.impl.BuildScriptMessage;
import org.rust.cargo.toolchain.impl.CargoMetadata;
import org.rust.cargo.toolchain.impl.CompilerMessage;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.Cargo;
import org.rust.cargo.toolchain.tools.CargoCallType;
import org.rust.cargo.toolchain.tools.CargoCheckArgs;
import org.rust.cargo.toolchain.tools.CargoKt;
import org.rust.cargo.toolchain.tools.ProjectDescription;
import org.rust.cargo.toolchain.tools.ProjectDescriptionStatus;
import org.rust.cargo.toolchain.tools.RsTool;
import org.rust.cargo.toolchain.tools.RustcKt;
import org.rust.cargo.toolchain.tools.Rustup;
import org.rust.cargo.toolchain.tools.RustupComponent;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.ide.actions.InstallBinaryCrateAction;
import org.rust.ide.annotator.external.RsExternalLinterResult;
import org.rust.ide.experiments.RsExperiments;
import org.rust.openapiext.CommandLineExtKt;
import org.rust.openapiext.JsonUtils;
import org.rust.openapiext.RsDeserializationException;
import org.rust.openapiext.RsPathManager;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.openapiext.RsProcessExecutionOrDeserializationException;
import org.rust.openapiext.RsProcessResultKt;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.CollectionBuilder;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 n2\u00020\u0001:\u0002mnB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\tJ\u009c\u0001\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d20\b\u0002\u0010\u001e\u001a*\u0012\b\u0012\u00060\u0019j\u0002` \u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0010j\u0002`!\u0012\u0004\u0012\u00020\u00050\u001f\u0018\u00010\u001fj\u0004\u0018\u0001`\"2\b\b\u0002\u0010#\u001a\u00020$2\u0016\b\u0002\u0010%\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010(0&J\u0018\u0010)\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0010H\u0002J^\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010,\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00192.\u0010\u001e\u001a*\u0012\b\u0012\u00060\u0019j\u0002` \u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0010j\u0002`!\u0012\u0004\u0012\u00020\u00050\u001f\u0018\u00010\u001fj\u0004\u0018\u0001`\"2\u0006\u0010#\u001a\u00020$H\u0002JP\u0010/\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010(J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000205H\u0002JV\u00108\u001a\u0018\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002090\u0014j\b\u0012\u0004\u0012\u00020\u000e`:2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u00192\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u00101\u001a\u0002022\n\b\u0002\u00103\u001a\u0004\u0018\u00010(J8\u0010<\u001a\u0018\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002090\u0014j\b\u0012\u0004\u0012\u00020=`:2\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010J\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010@\u001a\u00020AH\u0002JD\u0010B\u001a\u0002052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u00103\u001a\u0004\u0018\u00010(2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u0002J0\u0010C\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u0001050D2\u0006\u0010\u000b\u001a\u00020-2\b\u0010E\u001a\u0004\u0018\u0001052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JH\u0010F\u001a\u0018\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u0002090\u0014j\b\u0012\u0004\u0012\u00020G`:2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020\u00052\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\u0010JH\u0010M\u001a\u0018\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u0002090\u0014j\b\u0012\u0004\u0012\u00020G`:2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00102\u0006\u0010N\u001a\u00020\u00102\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\u0010J*\u0010O\u001a\u000e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020Q0\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0005J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010V\u001a\u00020WH\u0002J\u0016\u0010X\u001a\u00020Y2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010Z\u001a\u00020[J\u0016\u0010\\\u001a\u00020Y2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010Z\u001a\u00020[J \u0010\\\u001a\u00020Y2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010Z\u001a\u00020[2\u0006\u0010]\u001a\u00020\u0005H\u0002JB\u0010^\u001a\u0018\u0012\u0004\u0012\u00020_\u0012\u0004\u0012\u0002090\u0014j\b\u0012\u0004\u0012\u00020_`:*\u00020[2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010a2\n\b\u0002\u00103\u001a\u0004\u0018\u00010(H\u0002J\"\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020Q0\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020(J\u000e\u0010c\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010d\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010e\u001a\u0004\u0018\u00010fH\u0002J\u0010\u0010l\u001a\u00020\u000e2\u0006\u0010i\u001a\u00020hH\u0007R\u0010\u0010g\u001a\u0004\u0018\u00010hX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010i\u001a\u00020h8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bj\u0010k\u00a8\u0006o"}, d2={"Lorg/rust/cargo/toolchain/tools/Cargo;", "Lorg/rust/cargo/toolchain/tools/RustupComponent;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "useWrapper", "", "<init>", "(Lorg/rust/cargo/toolchain/RsToolchainBase;Z)V", "listInstalledBinaryCrates", "", "Lorg/rust/cargo/toolchain/tools/Cargo$BinaryCrate;", "project", "Lcom/intellij/openapi/project/Project;", "installBinaryCrate", "", "crateName", "", "addDependency", "features", "fullProjectDescription", "Lorg/rust/stdext/RsResult;", "Lorg/rust/cargo/toolchain/tools/ProjectDescription;", "Lorg/rust/openapiext/RsProcessExecutionOrDeserializationException;", "owner", "projectDirectory", "Ljava/nio/file/Path;", "buildTargets", "rustcTarget", "rustcVersion", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "configuredFeatures", "", "Lorg/rust/cargo/project/workspace/PackageRoot;", "Lorg/rust/cargo/project/workspace/FeatureName;", "Lorg/rust/cargo/project/workspace/UserEnabledFeatures;", "cargoConfig", "Lorg/rust/cargo/CargoConfig;", "listenerProvider", "Lkotlin/Function1;", "Lorg/rust/cargo/toolchain/tools/CargoCallType;", "Lcom/intellij/execution/process/ProcessListener;", "normalizeProjectPath", "workspaceRoot", "collectFeaturesForFetchingBuildScripts", "ijProject", "Lorg/rust/cargo/toolchain/impl/CargoMetadata$Project;", "normProjectDirectory", "fetchMetadata", "toolchainOverride", "environmentVariables", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "listener", "mergeBuildMessages", "Lorg/rust/cargo/toolchain/impl/BuildMessages;", "primary", "secondary", "vendorDependencies", "Lorg/rust/openapiext/RsProcessExecutionException;", "Lorg/rust/openapiext/RsProcessResult;", "dstPath", "getCfgOption", "Lorg/rust/cargo/CfgOptions;", "getConfig", "getBuildTargets", "tree", "Lcom/fasterxml/jackson/databind/JsonNode;", "fetchBuildScriptsInfo", "replacePathsSymlinkIfNeeded", "Lkotlin/Pair;", "buildMessages", "init", "Lorg/rust/cargo/toolchain/tools/Cargo$Companion$GeneratedFilesHolder;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "name", "createBinary", "vcs", "generate", "templateUrl", "checkProject", "Lorg/rust/ide/annotator/external/RsExternalLinterResult;", "Lorg/rust/openapiext/RsProcessExecutionException$Start;", "args", "Lorg/rust/cargo/toolchain/tools/CargoCheckArgs;", "isOnTheFly", "allEnabledFeaturesForCheck", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "toColoredCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "commandLine", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "toGeneralCommandLine", "colors", "execute", "Lcom/intellij/execution/process/ProcessOutput;", "stdIn", "", "installCargoGenerate", "checkNeedInstallCargoGenerate", "checkBinaryCrateIsNotInstalled", "minVersion", "Lcom/intellij/util/text/SemVer;", "_http", "Lcom/intellij/util/net/HttpConfigurable;", "http", "getHttp", "()Lcom/intellij/util/net/HttpConfigurable;", "setHttp", "BinaryCrate", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cargo.kt\norg/rust/cargo/toolchain/tools/Cargo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 8 Collections.kt\norg/rust/stdext/CollectionsKt\n+ 9 RsResult.kt\norg/rust/stdext/RsResult\n+ 10 utils.kt\norg/rust/openapiext/UtilsKt\n+ 11 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 12 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1108:1\n827#2:1109\n855#2,2:1110\n1617#2,9:1112\n1869#2:1121\n1870#2:1123\n1626#2:1124\n774#2:1142\n865#2,2:1143\n1193#2,2:1145\n1267#2,4:1147\n230#2,2:1151\n1634#2,3:1153\n2746#2,3:1164\n1761#2,3:1167\n1617#2,9:1194\n1869#2:1203\n1870#2:1205\n1626#2:1206\n1563#2:1207\n1634#2,3:1208\n1617#2,9:1212\n1869#2:1221\n1870#2:1223\n1626#2:1224\n1617#2,9:1226\n1869#2:1235\n1870#2:1237\n1626#2:1238\n1563#2:1239\n1634#2,3:1240\n1617#2,9:1282\n1869#2:1291\n1870#2:1293\n1626#2:1294\n774#2:1323\n865#2,2:1324\n1374#2:1326\n1460#2,2:1327\n827#2:1336\n855#2,2:1337\n1563#2:1339\n1634#2,3:1340\n1462#2,3:1343\n1761#2,3:1362\n1761#2,3:1372\n1761#2,3:1375\n1563#2:1382\n1634#2,3:1383\n1761#2,3:1388\n1#3:1122\n1#3:1139\n1#3:1204\n1#3:1211\n1#3:1222\n1#3:1225\n1#3:1236\n1#3:1256\n1#3:1292\n1#3:1306\n60#4,5:1125\n60#4,5:1134\n13#4:1392\n60#5,4:1130\n60#5,4:1156\n60#5,4:1170\n60#5,4:1190\n60#5,4:1248\n60#5,4:1274\n60#5,4:1278\n183#6,2:1140\n413#7,4:1160\n413#7,4:1252\n13#8:1174\n31#8:1175\n23#8,10:1176\n13#8:1295\n31#8:1296\n23#8:1297\n32#8:1305\n13#8:1307\n31#8:1308\n23#8,10:1309\n13#8:1346\n31#8:1347\n23#8,10:1348\n29#9,4:1186\n29#9,4:1319\n29#9,4:1358\n310#10,5:1243\n305#10,10:1264\n382#11,7:1257\n504#11,7:1298\n504#11,7:1329\n536#11:1365\n521#11,6:1366\n126#12:1378\n153#12,3:1379\n188#12,2:1386\n190#12:1391\n*S KotlinDebug\n*F\n+ 1 Cargo.kt\norg/rust/cargo/toolchain/tools/Cargo\n*L\n127#1:1109\n127#1:1110,2\n128#1:1112,9\n128#1:1121\n128#1:1123\n128#1:1124\n279#1:1142\n279#1:1143,2\n287#1:1145,2\n287#1:1147,4\n329#1:1151,2\n330#1:1153,3\n398#1:1164,3\n399#1:1167,3\n474#1:1194,9\n474#1:1203\n474#1:1205\n474#1:1206\n492#1:1207\n492#1:1208,3\n505#1:1212,9\n505#1:1221\n505#1:1223\n505#1:1224\n511#1:1226,9\n511#1:1235\n511#1:1237\n511#1:1238\n520#1:1239\n520#1:1240,3\n697#1:1282,9\n697#1:1291\n697#1:1293\n697#1:1294\n788#1:1323\n788#1:1324,2\n790#1:1326\n790#1:1327,2\n794#1:1336\n794#1:1337,2\n795#1:1339\n795#1:1340,3\n790#1:1343,3\n867#1:1362,3\n311#1:1372,3\n312#1:1375,3\n299#1:1382\n299#1:1383,3\n301#1:1388,3\n128#1:1122\n474#1:1204\n505#1:1222\n511#1:1236\n697#1:1292\n180#1:1125,5\n219#1:1134,5\n883#1:1392\n182#1:1130,4\n375#1:1156,4\n423#1:1170,4\n465#1:1190,4\n594#1:1248,4\n663#1:1274,4\n693#1:1278,4\n256#1:1140,2\n378#1:1160,4\n601#1:1252,4\n432#1:1174\n432#1:1175\n432#1:1176,10\n712#1:1295\n712#1:1296\n712#1:1297\n712#1:1305\n744#1:1307\n744#1:1308\n744#1:1309,10\n814#1:1346\n814#1:1347\n814#1:1348,10\n447#1:1186,4\n776#1:1319,4\n857#1:1358,4\n580#1:1243,5\n620#1:1264,10\n604#1:1257,7\n715#1:1298,7\n792#1:1329,7\n296#1:1365\n296#1:1366,6\n315#1:1378\n315#1:1379,3\n300#1:1386,2\n300#1:1391\n*E\n"})
public final class Cargo
extends RustupComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HttpConfigurable _http;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ObjectMapper JSON_MAPPER;
    @NotNull
    private static final TomlMapper TOML_MAPPER;
    @NotNull
    private static final RegistryValue TEST_NOCAPTURE_ENABLED_KEY;
    @NotNull
    private static final RegistryValue USE_BUILD_SCRIPT_WRAPPER;
    @NotNull
    public static final String NAME = "cargo";
    @NotNull
    public static final String WRAPPER_NAME = "xargo";
    @NotNull
    private static final List<String> FEATURES_ACCEPTING_COMMANDS;
    @NotNull
    private static final List<String> COLOR_ACCEPTING_COMMANDS;

    public Cargo(@NotNull RsToolchainBase toolchain2, boolean useWrapper) {
        Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
        super(useWrapper ? WRAPPER_NAME : NAME, toolchain2);
    }

    public /* synthetic */ Cargo(RsToolchainBase rsToolchainBase, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(rsToolchainBase, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<BinaryCrate> listInstalledBinaryCrates(Project project) {
        List list;
        List list2;
        Object object = new String[]{"install", "--list"};
        ProcessOutput processOutput = CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, object, null, null, 12, null), this.getToolchain().getExecutionTimeoutInMilliseconds(), null, 2, null);
        if (processOutput != null && (object = processOutput.getStdoutLines()) != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Iterable iterable = (Iterable)object;
            boolean $i$f$filterNot = false;
            void var6_6 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it2 = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                if (StringsKt.startsWith$default((String)it2, (String)" ", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                BinaryCrate it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it3 = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it3);
                if (BinaryCrate.Companion.from(it3) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void installBinaryCrate(@NotNull Project project, @NotNull String crateName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)crateName, (String)"crateName");
        CargoProject cargoProject = (CargoProject)CollectionsKt.firstOrNull((Iterable)CargoProjectServiceKt.getCargoProjects(project).getAllProjects());
        if (cargoProject == null) {
            return;
        }
        CargoProject cargoProject2 = cargoProject;
        Object[] objectArray = new String[]{"--force", crateName};
        CargoCommandLine commandLine = CargoCommandLine.Companion.forProject$default(CargoCommandLine.Companion, cargoProject2, "install", CollectionsKt.listOf((Object[])objectArray), false, null, null, null, 120, null);
        RsCommandLineBase.run$default(commandLine, cargoProject2, "Install " + crateName, false, null, 8, null);
    }

    public final void addDependency(@NotNull Project project, @NotNull String crateName, @NotNull List<String> features) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)crateName, (String)"crateName");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        CargoProject cargoProject = (CargoProject)CollectionsKt.firstOrNull((Iterable)CargoProjectServiceKt.getCargoProjects(project).getAllProjects());
        if (cargoProject == null) {
            return;
        }
        CargoProject cargoProject2 = cargoProject;
        Object[] objectArray = new String[]{crateName};
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!((Collection)features).isEmpty()) {
            args.add("--features");
            args.add(CollectionsKt.joinToString$default((Iterable)features, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        CargoCommandLine commandLine = CargoCommandLine.Companion.forProject$default(CargoCommandLine.Companion, cargoProject2, "add", args, false, null, null, null, 120, null);
        RsCommandLineBase.run$default(commandLine, cargoProject2, "Add dependency " + crateName, false, null, 8, null);
    }

    public static /* synthetic */ void addDependency$default(Cargo cargo, Project project, String string, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        cargo.addDependency(project, string, list);
    }

    @NotNull
    public final RsResult<ProjectDescription, RsProcessExecutionOrDeserializationException> fullProjectDescription(@NotNull Project owner, @NotNull Path projectDirectory, @NotNull List<String> buildTargets, @Nullable String rustcTarget, @Nullable RustcVersion rustcVersion, @Nullable Map<Path, ? extends Map<String, Boolean>> configuredFeatures, @NotNull CargoConfig cargoConfig, @NotNull Function1<? super CargoCallType, ? extends ProcessListener> listenerProvider) {
        BuildMessages buildMessages;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter(buildTargets, (String)"buildTargets");
        Intrinsics.checkNotNullParameter((Object)cargoConfig, (String)"cargoConfig");
        Intrinsics.checkNotNullParameter(listenerProvider, (String)"listenerProvider");
        long start1 = System.currentTimeMillis();
        RsResult rawDataResult = Cargo.fetchMetadata$default(this, owner, projectDirectory, buildTargets, null, null, (ProcessListener)listenerProvider.invoke((Object)CargoCallType.METADATA), 24, null);
        if (rawDataResult instanceof RsResult.Err) {
            LOG.warn("Cargo metadata invocation failed", (Throwable)((RsResult.Err)rawDataResult).getErr());
        }
        long start2 = System.currentTimeMillis();
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Finished cargo metadata invocation in " + (start2 - start1) + " ms", e$iv);
        }
        RsResult $this$unwrapOrElse$iv = rawDataResult;
        boolean $i$f$unwrapOrElse = false;
        RsResult bl = $this$unwrapOrElse$iv;
        if (!(bl instanceof RsResult.Ok)) {
            if (bl instanceof RsResult.Err) {
                RsProcessExecutionOrDeserializationException it2 = (RsProcessExecutionOrDeserializationException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl2 = false;
                return new RsResult.Err<RsProcessExecutionOrDeserializationException>(it2);
            }
            throw new NoWhenBranchMatchedException();
        }
        CargoMetadata.Project rawData = (CargoMetadata.Project)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        Path normProjectDirectory = this.normalizeProjectPath(projectDirectory, rawData.getWorkspace_root());
        List<String> features = this.collectFeaturesForFetchingBuildScripts(owner, rawData, normProjectDirectory, configuredFeatures, cargoConfig);
        if (RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean()) {
            BuildMessages withRustcTarget = this.fetchBuildScriptsInfo(owner, normProjectDirectory, rustcVersion, rustcTarget, (ProcessListener)listenerProvider.invoke((Object)CargoCallType.BUILD_SCRIPT_CHECK), features);
            if (!withRustcTarget.isSuccessful() && rustcTarget != null) {
                BuildMessages withoutRustcTarget = this.fetchBuildScriptsInfo(owner, normProjectDirectory, rustcVersion, null, (ProcessListener)listenerProvider.invoke((Object)CargoCallType.BUILD_SCRIPT_CHECK), features);
                buildMessages = this.mergeBuildMessages(withRustcTarget, withoutRustcTarget);
            } else {
                buildMessages = withRustcTarget;
            }
        } else {
            LOG.warn("Buildscript evaluation is disabled via registry key " + RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().getKey());
            buildMessages = BuildMessages.Companion.getDEFAULT();
        }
        BuildMessages buildScriptsInfo = buildMessages;
        Logger $this$debug_u24default$iv2 = LOG;
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl3 = false;
            logger.debug("Finished buildscript evaluation in " + (System.currentTimeMillis() - start2) + " ms", e$iv2);
        }
        Pair<CargoMetadata.Project, BuildMessages> pair = this.replacePathsSymlinkIfNeeded(rawData, buildScriptsInfo, normProjectDirectory);
        CargoMetadata.Project rawDataAdjusted = (CargoMetadata.Project)pair.component1();
        BuildMessages buildScriptsInfoAdjusted = (BuildMessages)pair.component2();
        CargoWorkspaceData workspaceData = CargoMetadata.INSTANCE.clean(owner, rawDataAdjusted, buildScriptsInfoAdjusted, normProjectDirectory, cargoConfig);
        ProjectDescriptionStatus status = buildScriptsInfo.isSuccessful() ? ProjectDescriptionStatus.OK : ProjectDescriptionStatus.BUILD_SCRIPT_EVALUATION_ERROR;
        return new RsResult.Ok<ProjectDescription>(new ProjectDescription(workspaceData, status, normProjectDirectory));
    }

    public static /* synthetic */ RsResult fullProjectDescription$default(Cargo cargo, Project project, Path path, List list, String string, RustcVersion rustcVersion, Map map2, CargoConfig cargoConfig, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            map2 = null;
        }
        if ((n & 0x40) != 0) {
            cargoConfig = CargoConfig.Companion.getDEFAULT();
        }
        if ((n & 0x80) != 0) {
            function1 = fullProjectDescription.1.INSTANCE;
        }
        return cargo.fullProjectDescription(project, path, list, string, rustcVersion, map2, cargoConfig, (Function1<? super CargoCallType, ? extends ProcessListener>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final Path normalizeProjectPath(Path projectDirectory, String workspaceRoot) {
        Path path;
        Path path2;
        try {
            path2 = projectDirectory.toAbsolutePath();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return projectDirectory;
        }
        Path absProjectDirectory = path2;
        try {
            Path it2 = path = Path.of(workspaceRoot, new String[0]);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            path = Files.exists(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
        }
        catch (InvalidPathException invalidPathException) {
            path = null;
        }
        Path workspaceRootPath = path;
        if (workspaceRootPath == null) {
            Intrinsics.checkNotNull((Object)absProjectDirectory);
            return absProjectDirectory;
        }
        try {
            Path path3;
            Object v1;
            block9: {
                void $this$firstOrNull$iv;
                Sequence bl = SequencesKt.generateSequence((Object)absProjectDirectory, Cargo::normalizeProjectPath$lambda$1);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it3 = (Path)element$iv;
                    boolean bl2 = false;
                    if (!Files.isSameFile(it3, workspaceRootPath)) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            if ((path3 = (Path)v1) == null) {
                path3 = absProjectDirectory;
            }
            path = path3;
            Intrinsics.checkNotNull((Object)path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Path path4 = absProjectDirectory;
            Intrinsics.checkNotNull((Object)path4);
            path = path4;
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private final List<String> collectFeaturesForFetchingBuildScripts(Project ijProject, CargoMetadata.Project project, Path normProjectDirectory, Map<Path, ? extends Map<String, Boolean>> configuredFeatures, CargoConfig cargoConfig) {
        block13: {
            block12: {
                if (!RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS_WITH_FEATURES().asBoolean()) {
                    return CollectionsKt.emptyList();
                }
                members = CollectionsKt.toSet((Iterable)project.getWorkspace_members());
                var8_7 = project.getPackages();
                var27_8 = project;
                var26_9 = ijProject;
                var25_10 = CargoMetadata.INSTANCE;
                $i$f$filter = false;
                var10_13 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CargoMetadata.Package)element$iv$iv;
                    $i$a$-filter-Cargo$collectFeaturesForFetchingBuildScripts$cargoData$1 = false;
                    if (!members.contains(it.getId())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var28_30 = (List)destination$iv$iv;
                cargoData = var25_10.clean(var26_9, CargoMetadata.Project.copy$default(var27_8, var28_30, null, 0, null, null, 30, null), BuildMessages.Companion.getDEFAULT(), normProjectDirectory, cargoConfig);
                v0 = normProjectDirectory.resolve("Cargo.toml");
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolve(...)");
                it = CargoWorkspace.Companion.deserialize$default(CargoWorkspace.Companion, v0, cargoData, null, null, 12, null);
                $i$a$-let-Cargo$collectFeaturesForFetchingBuildScripts$rawWorkspace$1 = false;
                v1 = configuredFeatures;
                rawWorkspace = v1 != null ? it.withEnabledFeatures(v1) : it;
                $this$associate$iv = rawWorkspace.getPackages();
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                var13_20 = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    var18_36 = destination$iv$iv;
                    it = (CargoWorkspace.Package)element$iv$iv;
                    $i$a$-associate-Cargo$collectFeaturesForFetchingBuildScripts$packagesFeaturesState$1 = false;
                    it = TuplesKt.to((Object)it.getId(), it.getFeatureState());
                    var18_36.put(it.getFirst(), it.getSecond());
                }
                packagesFeaturesState = destination$iv$iv;
                var13_20 = project.getPackages();
                destination$iv$iv = var13_20.iterator();
                while (destination$iv$iv.hasNext()) {
                    $i$f$associateTo = destination$iv$iv.next();
                    it = (CargoMetadata.Package)$i$f$associateTo;
                    $i$a$-find-Cargo$collectFeaturesForFetchingBuildScripts$allFeatures$1 = false;
                    v2 = Paths.get(it.getManifest_path(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                    v3 = v2.getParent();
                    v4 = Paths.get(project.getWorkspace_root(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
                    if (!Intrinsics.areEqual((Object)v3, (Object)v4)) continue;
                    v5 = $i$f$associateTo;
                    break block12;
                }
                v5 = null;
            }
            var11_16 = v5;
            if (var11_16 == null) ** GOTO lbl-1000
            root = var11_16;
            $i$a$-let-Cargo$collectFeaturesForFetchingBuildScripts$allFeatures$2 = false;
            features = Cargo.collectFeaturesForFetchingBuildScripts$featuresForPackage(root, packagesFeaturesState);
            $this$first$iv = rawWorkspace.getPackages();
            $i$f$first = false;
            for (E element$iv : $this$first$iv) {
                it = (CargoWorkspace.Package)element$iv;
                $i$a$-first-Cargo$collectFeaturesForFetchingBuildScripts$allFeatures$2$1 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)root.getId())) continue;
                break block13;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        if (((CargoWorkspace.Package)element$iv).getEdition().compareTo((Enum)CargoWorkspace.Edition.EDITION_2021) >= 0) {
            $this$first$iv = features;
            $i$f$first = new ArrayList<E>();
            $i$f$mapTo = false;
            for (T item$iv : $this$mapTo$iv) {
                $i$a$-first-Cargo$collectFeaturesForFetchingBuildScripts$allFeatures$2$1 = (String)item$iv;
                var23_48 = destination$iv;
                $i$a$-mapTo-Cargo$collectFeaturesForFetchingBuildScripts$allFeatures$2$2 = false;
                var23_48.add(root.getName() + "/" + (String)feature);
            }
            v6 = (List)destination$iv;
        } else {
            v6 = CollectionsKt.toMutableList((Collection)features);
        }
        if ((capacity$iv = v6) != null) {
            v7 = capacity$iv;
        } else lbl-1000:
        // 2 sources

        {
            v7 = new ArrayList<E>();
        }
        allFeatures = v7;
        for (CargoMetadata.Package pkg : project.getPackages()) {
            if (!members.contains(pkg.getId())) continue;
            v8 = Paths.get(pkg.getManifest_path(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"get(...)");
            v9 = v8.getParent();
            v10 = Paths.get(project.getWorkspace_root(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"get(...)");
            if (Intrinsics.areEqual((Object)v9, (Object)v10)) continue;
            it = var14_21 = Cargo.collectFeaturesForFetchingBuildScripts$featuresForPackage(pkg, packagesFeaturesState);
            $i$a$-takeIf-Cargo$collectFeaturesForFetchingBuildScripts$1 = false;
            if ((!((Collection)it).isEmpty() != false ? var14_21 : null) == null) continue;
            features = features;
            $i$a$-let-Cargo$collectFeaturesForFetchingBuildScripts$2 = false;
            for (String feature : features) {
                ((Collection)allFeatures).add(pkg.getName() + "/" + feature);
            }
        }
        return allFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RsResult<CargoMetadata.Project, RsProcessExecutionOrDeserializationException> fetchMetadata(@NotNull Project project, @NotNull Path projectDirectory, @NotNull List<String> buildTargets, @Nullable String toolchainOverride, @NotNull EnvironmentVariablesData environmentVariables, @Nullable ProcessListener listener2) {
        RsResult rsResult;
        String string;
        ProcessOutput output;
        block6: {
            void $this$dropWhile$iv;
            void $this$unwrapOrElse$iv;
            String it22;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
            Intrinsics.checkNotNullParameter(buildTargets, (String)"buildTargets");
            Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
            String[] stringArray = new String[]{"--verbose", "--format-version", "1", "--all-features"};
            List additionalArgs = CollectionsKt.mutableListOf((Object[])stringArray);
            for (String it22 : buildTargets) {
                additionalArgs.add("--filter-platform");
                additionalArgs.add(it22);
            }
            Map map2 = environmentVariables.getEnvs();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CARGO_TERM_PROGRESS_WHEN", (Object)"always"), TuplesKt.to((Object)"CARGO_TERM_PROGRESS_WIDTH", (Object)"80")};
            it22 = environmentVariables.with(MapsKt.plus((Map)map2, (Map)MapsKt.mapOf((Pair[])pairArray)));
            Intrinsics.checkNotNullExpressionValue((Object)it22, (String)"with(...)");
            String envs = it22;
            CargoCommandLine commandLine = new CargoCommandLine("metadata", projectDirectory, additionalArgs, null, false, null, toolchainOverride, null, (EnvironmentVariablesData)envs, false, false, false, 3768, null);
            RsResult rsResult2 = Cargo.execute$default(this, commandLine, project, null, listener2, 2, null);
            boolean $i$f$unwrapOrElse22 = false;
            void var13_14 = $this$unwrapOrElse$iv;
            if (!(var13_14 instanceof RsResult.Ok)) {
                if (var13_14 instanceof RsResult.Err) {
                    RsProcessExecutionException it3 = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                    boolean bl = false;
                    return new RsResult.Err<RsProcessExecutionException>(it3);
                }
                throw new NoWhenBranchMatchedException();
            }
            output = (ProcessOutput)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
            String string2 = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
            String $i$f$unwrapOrElse22 = string2;
            boolean $i$f$dropWhile = false;
            int n = ((CharSequence)$this$dropWhile$iv).length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it4 = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it4 != '{') continue;
                String string3 = $this$dropWhile$iv.substring(index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block6;
            }
            string = "";
        }
        String json = string;
        try {
            CargoMetadata.Project cargoMetadataProject2 = ((CargoMetadata.Project)JSON_MAPPER.readValue(json, CargoMetadata.Project.class)).convertPaths((Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this.getToolchain()){

                public final String invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((RsToolchainBase)this.receiver).toLocalPath(p0);
                }
            }));
            rsResult = new RsResult.Ok<CargoMetadata.Project>(cargoMetadataProject2);
        }
        catch (JacksonException e) {
            String message = StringsKt.trimMargin$default((String)("\n                |Failed to deserialize cargo metadata JSON output.\n                |stdout : " + output.getStdout() + "\n                |stderr : " + output.getStderr() + "\n            "), null, (int)1, null);
            rsResult = new RsResult.Err<RsDeserializationException>(new RsDeserializationException(message, e));
        }
        return rsResult;
    }

    public static /* synthetic */ RsResult fetchMetadata$default(Cargo cargo, Project project, Path path, List list, String string, EnvironmentVariablesData environmentVariablesData, ProcessListener processListener, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            EnvironmentVariablesData environmentVariablesData2 = EnvironmentVariablesData.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData2, (String)"DEFAULT");
            environmentVariablesData = environmentVariablesData2;
        }
        return cargo.fetchMetadata(project, path, list, string, environmentVariablesData, processListener);
    }

    /*
     * Unable to fully structure code
     */
    private final BuildMessages mergeBuildMessages(BuildMessages primary, BuildMessages secondary) {
        result = MapsKt.toMutableMap(primary.getMessages());
        for (Map.Entry<String, List<CompilerMessage>> var5_5 : secondary.getMessages().entrySet()) {
            block10: {
                packageId = var5_5.getKey();
                newMessages = var5_5.getValue();
                existingMessages = (List)result.get(packageId);
                if (existingMessages == null) ** GOTO lbl-1000
                $this$none$iv = existingMessages;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        it = (CompilerMessage)element$iv;
                        $i$a$-none-Cargo$mergeBuildMessages$replace$1 = false;
                        if (!(it instanceof BuildScriptMessage)) continue;
                        v0 = false;
                        break block10;
                    }
                    v0 = true;
                }
            }
            if (v0) {
                block11: {
                    $this$any$iv = newMessages;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (CompilerMessage)element$iv;
                            $i$a$-any-Cargo$mergeBuildMessages$replace$2 = false;
                            if (!(it instanceof BuildScriptMessage)) continue;
                            v1 = true;
                            break block11;
                        }
                        v1 = false;
                    }
                }
                ** if (!v1) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v2 = true;
                ** GOTO lbl39
            }
lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
lbl39:
            // 2 sources

            if (!(replace = v2)) continue;
            result.put(packageId, newMessages);
        }
        return new BuildMessages(result, secondary.isSuccessful());
    }

    @NotNull
    public final RsResult<Unit, RsProcessExecutionException> vendorDependencies(@NotNull Project project, @NotNull Path projectDirectory, @NotNull Path dstPath, @Nullable String toolchainOverride, @NotNull EnvironmentVariablesData environmentVariables, @Nullable ProcessListener listener2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)dstPath, (String)"dstPath");
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        Object[] objectArray = new String[]{"--respect-source-config", this.getToolchain().toRemotePath(((Object)dstPath).toString())};
        List additionalArgs = CollectionsKt.listOf((Object[])objectArray);
        CargoCommandLine commandLine = new CargoCommandLine("vendor", projectDirectory, additionalArgs, null, false, null, toolchainOverride, null, environmentVariables, false, false, false, 3768, null);
        RsResult $this$unwrapOrElse$iv = Cargo.execute$default(this, commandLine, project, null, listener2, 2, null);
        boolean $i$f$unwrapOrElse = false;
        RsResult rsResult = $this$unwrapOrElse$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                RsProcessExecutionException it2 = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return new RsResult.Err<RsProcessExecutionException>(it2);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        return new RsResult.Ok<Unit>(Unit.INSTANCE);
    }

    public static /* synthetic */ RsResult vendorDependencies$default(Cargo cargo, Project project, Path path, Path path2, String string, EnvironmentVariablesData environmentVariablesData, ProcessListener processListener, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            EnvironmentVariablesData environmentVariablesData2 = EnvironmentVariablesData.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData2, (String)"DEFAULT");
            environmentVariablesData = environmentVariablesData2;
        }
        if ((n & 0x20) != 0) {
            processListener = null;
        }
        return cargo.vendorDependencies(project, path, path2, string, environmentVariablesData, processListener);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RsResult<CfgOptions, RsProcessExecutionException> getCfgOption(@NotNull Project owner, @Nullable Path projectDirectory, @Nullable String rustcTarget) {
        RsResult rsResult;
        void result$iv$iv;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        boolean $i$f$buildList = false;
        Collection collection = new ArrayList();
        boolean $i$f$buildCollection = false;
        CollectionBuilder $this$getCfgOption_u24lambda_u240 = new CollectionBuilder<T>(result$iv$iv){
            final /* synthetic */ Collection<T> $result;
            {
                this.$result = $result;
            }

            public void add(T item) {
                this.$result.add(item);
            }

            public void addAll(Collection<? extends T> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                this.$result.addAll(items);
            }
        };
        boolean bl = false;
        $this$getCfgOption_u24lambda_u240.add("rustc");
        if (rustcTarget != null) {
            $this$getCfgOption_u24lambda_u240.add("--target");
            $this$getCfgOption_u24lambda_u240.add(rustcTarget);
        }
        $this$getCfgOption_u24lambda_u240.add("-Z");
        $this$getCfgOption_u24lambda_u240.add("unstable-options");
        $this$getCfgOption_u24lambda_u240.add("--print");
        $this$getCfgOption_u24lambda_u240.add("cfg");
        List parameters = (List)result$iv$iv;
        RsResult this_$iv = CommandLineExtKt.execute$default(this.createBaseCommandLine(owner, parameters, projectDirectory, (Map<String, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"RUSTC_BOOTSTRAP", (Object)"1"))), null, null, 3, null);
        boolean $i$f$map = false;
        RsResult rsResult2 = this_$iv;
        if (rsResult2 instanceof RsResult.Ok) {
            ProcessOutput output = (ProcessOutput)((RsResult.Ok)this_$iv).getOk();
            boolean bl2 = false;
            List list = output.getStdoutLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
            CfgOptions cfgOptions = CfgOptions.Companion.parse(list);
            rsResult = new RsResult.Ok<CfgOptions>(cfgOptions);
        } else if (rsResult2 instanceof RsResult.Err) {
            rsResult = new RsResult.Err(((RsResult.Err)this_$iv).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final RsResult<CargoConfig, RsProcessExecutionOrDeserializationException> getConfig(@NotNull Project owner, @NotNull Path projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        var4_3 = new String[]{"-Z", "unstable-options", "config", "get"};
        parameters = CollectionsKt.mutableListOf((Object[])var4_3);
        $this$unwrapOrElse$iv = CommandLineExtKt.execute$default(this.createBaseCommandLine(owner, parameters, projectDirectory, (Map<String, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"RUSTC_BOOTSTRAP", (Object)"1"))), null, null, 3, null);
        $i$f$unwrapOrElse = false;
        var8_9 = $this$unwrapOrElse$iv;
        if (!(var8_9 instanceof RsResult.Ok)) {
            if (var8_9 instanceof RsResult.Err) {
                it = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                $i$a$-unwrapOrElse-Cargo$getConfig$output$1 = false;
                return new RsResult.Err<RsProcessExecutionException>(it);
            }
            throw new NoWhenBranchMatchedException();
        }
        v0 = ((ProcessOutput)((RsResult.Ok)$this$unwrapOrElse$iv).getOk()).getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getStdout(...)");
        output = v0;
        try {
            $this$unwrapOrElse$iv = Cargo.TOML_MAPPER.readTree(output);
        }
        catch (JacksonException e) {
            Cargo.LOG.error((Throwable)e);
            return new RsResult.Err<RsDeserializationException>(new RsDeserializationException(e));
        }
        tree = $this$unwrapOrElse$iv;
        v1 = tree.at("/env").properties();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"properties(...)");
        $this$mapNotNull$iv = v1;
        $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_31 = $this$forEach$iv$iv$iv.iterator();
        while (var14_31.hasNext()) {
            element$iv$iv = element$iv$iv$iv /* !! */  = var14_31.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            field = (Map.Entry)element$iv$iv;
            $i$a$-mapNotNull-Cargo$getConfig$env$1 = false;
            if (((JsonNode)field.getValue()).isTextual()) {
                v2 = field.getKey();
                v3 = ((JsonNode)field.getValue()).asText();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"asText(...)");
                v4 = TuplesKt.to(v2, (Object)new CargoConfig.EnvValue(v3, false, false, 6, null));
            } else if (((JsonNode)field.getValue()).isObject()) {
                try {
                    var20_45 = (CargoConfig.EnvValue)Cargo.TOML_MAPPER.treeToValue((TreeNode)field.getValue(), CargoConfig.EnvValue.class);
                }
                catch (JacksonException e) {
                    Cargo.LOG.error((Throwable)e);
                    return new RsResult.Err<RsDeserializationException>(new RsDeserializationException(e));
                }
                valueParams = var20_45;
                v4 = TuplesKt.to(field.getKey(), (Object)new CargoConfig.EnvValue(valueParams.getValue(), valueParams.isForced(), valueParams.isRelative()));
            } else {
                v4 = null;
            }
            if (v4 == null) continue;
            it$iv$iv = v4;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        env = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)tree);
        $this$map$iv = this.getBuildTargets((JsonNode)tree);
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv$iv /* !! */  = (String)item$iv$iv;
            var28_56 = destination$iv$iv /* !! */ ;
            $i$a$-map-Cargo$getConfig$buildTargets$1 = false;
            if (StringsKt.endsWith$default((String)it, (String)".json", (boolean)false, (int)2, null)) {
                v5 = projectDirectory.resolve((String)it).toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toAbsolutePath(...)");
                v6 = PathKt.getSystemIndependentPath((Path)v5);
            } else {
                v6 = it;
            }
            var28_56.add(v6);
        }
        buildTargets = (List)destination$iv$iv /* !! */ ;
        $i$f$map = tree.at("/unstable/build-std");
        if ($i$f$map == null) ** GOTO lbl-1000
        it = destination$iv$iv /* !! */  = $i$f$map;
        $i$a$-takeIf-Cargo$getConfig$buildStd$1 = false;
        v7 /* !! */  = var10_17 /* !! */  = it.isArray() != false ? destination$iv$iv /* !! */  : null;
        if (var10_17 /* !! */  != null) {
            destination$iv$iv /* !! */  = (Iterable)var10_17 /* !! */ ;
            $i$f$mapNotNull = false;
            $i$a$-takeIf-Cargo$getConfig$buildStd$1 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            field = $this$forEach$iv$iv$iv.iterator();
            while (field.hasNext()) {
                element$iv$iv = element$iv$iv$iv = field.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (JsonNode)element$iv$iv;
                $i$a$-mapNotNull-Cargo$getConfig$buildStd$2 = false;
                if ((it.isTextual() != false ? it.asText() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v8 = (List)destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v8 = v9 = null;
        }
        if (v8 == null) {
            v9 = buildStd = CollectionsKt.emptyList();
        }
        if ((var10_17 /* !! */  = tree.at("/profile")) == null) ** GOTO lbl-1000
        it /* !! */  = var12_25 /* !! */  = var10_17 /* !! */ ;
        $i$a$-takeIf-Cargo$getConfig$profiles$1 = false;
        v10 /* !! */  = var11_20 /* !! */  = it /* !! */ .isObject() != false ? var12_25 /* !! */  : null;
        if (var11_20 /* !! */  != null && (var12_25 /* !! */  = var11_20 /* !! */ .properties()) != null) {
            it /* !! */  = (Iterable)var12_25 /* !! */ ;
            $i$f$mapNotNull = false;
            $i$f$mapNotNullTo = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var20_45 = $this$forEach$iv$iv$iv.iterator();
            while (var20_45.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var20_45.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (Map.Entry)element$iv$iv;
                $i$a$-mapNotNull-Cargo$getConfig$profiles$2 = false;
                if ((String)it.getKey() == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v11 = (List)destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v11 = v12 = null;
        }
        if (v11 == null) {
            v12 = CollectionsKt.emptyList();
        }
        profiles = v12;
        return new RsResult.Ok<CargoConfig>(new CargoConfig(buildTargets, env, buildStd, profiles));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBuildTargets(JsonNode tree) {
        JsonNode buildTargetNode = tree.at("/build/target");
        if (buildTargetNode.isTextual()) {
            return CollectionsKt.listOf((Object)buildTargetNode.asText());
        }
        if (buildTargetNode.isArray()) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNull((Object)buildTargetNode);
            Iterable $this$map$iv = (Iterable)buildTargetNode;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                JsonNode jsonNode = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.asText());
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final BuildMessages fetchBuildScriptsInfo(Project project, Path projectDirectory, RustcVersion rustcVersion, String rustcTarget, ProcessListener listener2, List<String> features) {
        void $this$unwrapOrElse$iv;
        Object[] objectArray = new String[]{"--color=always", "--message-format", "json-diagnostic-rendered-ansi", "--workspace", "--all-targets"};
        List additionalArgs = CollectionsKt.mutableListOf((Object[])objectArray);
        if (rustcTarget != null) {
            additionalArgs.add("--target");
            additionalArgs.add(rustcTarget);
        }
        if (!((Collection)features).isEmpty()) {
            additionalArgs.add("--features");
            additionalArgs.add(CollectionsKt.joinToString$default((Iterable)features, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        boolean useKeepGoing = rustcVersion != null && rustcVersion.getSemver().compareTo(CargoKt.access$getRUST_1_62$p()) >= 0;
        boolean stableKeepGoing = rustcVersion != null && rustcVersion.getSemver().compareTo(CargoKt.access$getRUST_1_74$p()) >= 0;
        Object object = new Pair[]{TuplesKt.to((Object)"CARGO_TERM_PROGRESS_WHEN", (Object)"always"), TuplesKt.to((Object)"CARGO_TERM_PROGRESS_WIDTH", (Object)"800")};
        Map envMap = MapsKt.mutableMapOf((Pair[])object);
        if (useKeepGoing && !stableKeepGoing) {
            object = additionalArgs;
            Object object2 = new String[]{"-Z", "unstable-options"};
            CollectionsKt.addAll((Collection)object, (Iterable)CollectionsKt.listOf((Object[])object2));
            String originalRustcBootstrapValue = System.getenv("RUSTC_BOOTSTRAP");
            object2 = envMap;
            Pair pair = TuplesKt.to((Object)"RUSTC_BOOTSTRAP", (Object)"1");
            object2.put(pair.getFirst(), pair.getSecond());
            object2 = envMap;
            pair = TuplesKt.to((Object)"INTELLIJ_RUST_RUSTC_BOOTSTRAP_WAS_SET_BY_RR", (Object)"");
            object2.put(pair.getFirst(), pair.getSecond());
            if (originalRustcBootstrapValue != null) {
                object2 = envMap;
                pair = TuplesKt.to((Object)"INTELLIJ_ORIGINAL_RUSTC_BOOTSTRAP", (Object)originalRustcBootstrapValue);
                object2.put(pair.getFirst(), pair.getSecond());
            }
        }
        if (useKeepGoing) {
            ((Collection)additionalArgs).add("--keep-going");
        }
        Path nativeHelper = RsPathManager.INSTANCE.nativeHelper(this.getToolchain());
        boolean $i$f$testAssert2 = false;
        if (UtilsKt.isUnitTestMode()) {
            boolean bl = false;
            if (!(nativeHelper != null)) {
                boolean bl2 = false;
                String message$iv = "Native helpers must not be null in tests";
                throw new AssertionError((Object)message$iv);
            }
        }
        if (nativeHelper != null && USE_BUILD_SCRIPT_WRAPPER.asBoolean()) {
            Map $i$f$testAssert2 = envMap;
            Pair bl2 = TuplesKt.to((Object)"RUSTC_WRAPPER", (Object)this.getToolchain().toRemotePath(((Object)nativeHelper).toString()));
            $i$f$testAssert2.put(bl2.getFirst(), bl2.getSecond());
        }
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)envMap, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
        EnvironmentVariablesData envs = environmentVariablesData;
        CargoCommandLine commandLine = new CargoCommandLine("check", projectDirectory, additionalArgs, null, false, null, null, null, envs, false, false, false, 3832, null);
        RsResult processResult = Cargo.execute$default(this, commandLine, project, null, listener2, 2, null);
        if (processResult instanceof RsResult.Err) {
            LOG.warn("Build script evaluation failed", (Throwable)((RsResult.Err)processResult).getErr());
        }
        RsResult<ProcessOutput, RsProcessExecutionException.Start> rsResult = RsProcessResultKt.ignoreExitCode(processResult);
        boolean $i$f$unwrapOrElse = false;
        void var18_26 = $this$unwrapOrElse$iv;
        if (!(var18_26 instanceof RsResult.Ok)) {
            if (var18_26 instanceof RsResult.Err) {
                RsProcessExecutionException.Start it2 = (RsProcessExecutionException.Start)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return BuildMessages.Companion.getFAILED();
            }
            throw new NoWhenBranchMatchedException();
        }
        ProcessOutput processOutput = (ProcessOutput)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        Map messages = new LinkedHashMap();
        for (String line : processOutput.getStdoutLines()) {
            Object object3;
            void $this$getOrPut$iv;
            JsonObject jsonObject;
            CompilerMessage compilerMessage;
            String string;
            JsonUtils jsonUtils;
            Object object4;
            block15: {
                void $this$dropWhile$iv;
                Intrinsics.checkNotNull((Object)line);
                object4 = line;
                jsonUtils = JsonUtils.INSTANCE;
                boolean $i$f$dropWhile = false;
                int n = ((CharSequence)$this$dropWhile$iv).length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it3 = $this$dropWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it3 != '{') continue;
                    String string2 = $this$dropWhile$iv.substring(index$iv);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    break block15;
                }
                string = "";
            }
            if (JsonUtils.tryParseJsonObject$default(jsonUtils, string, false, 2, null) == null || (compilerMessage = CompilerMessage.Companion.fromJson(jsonObject)) == null || (object4 = compilerMessage.convertPaths((Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this.getToolchain()){

                public final String invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((RsToolchainBase)this.receiver).toLocalPath(p0);
                }
            }))) == null) continue;
            Object it4 = object4;
            boolean bl = false;
            Map it3 = messages;
            String key$iv = ((CompilerMessage)it4).getPackage_id();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            ((Collection)object3).add(it4);
        }
        return new BuildMessages(messages, processOutput.getExitCode() == 0);
    }

    private final Pair<CargoMetadata.Project, BuildMessages> replacePathsSymlinkIfNeeded(CargoMetadata.Project project, BuildMessages buildMessages, Path projectDirectory) {
        boolean $i$f$testAssert = false;
        boolean $i$f$testAssert2 = false;
        if (UtilsKt.isUnitTestMode()) {
            boolean bl = false;
            if (!projectDirectory.isAbsolute()) {
                boolean bl2 = false;
                String message$iv$iv = "Assertion failed";
                throw new AssertionError((Object)message$iv$iv);
            }
        }
        String workspaceRoot = project.getWorkspace_root();
        if (Intrinsics.areEqual((Object)((Object)projectDirectory).toString(), (Object)workspaceRoot)) {
            return new Pair((Object)project, (Object)buildMessages);
        }
        Path workspaceRootPath = Paths.get(workspaceRoot, new String[0]);
        if (!Files.isSameFile(projectDirectory, workspaceRootPath)) {
            return new Pair((Object)project, (Object)buildMessages);
        }
        String normalisedWorkspace = ((Object)projectDirectory.normalize()).toString();
        Function1 replacer = arg_0 -> Cargo.replacePathsSymlinkIfNeeded$lambda$1(workspaceRoot, normalisedWorkspace, arg_0);
        BuildMessages buildMessages2 = buildMessages;
        return new Pair((Object)CargoMetadata.INSTANCE.replacePaths(project, (Function1<? super String, String>)replacer), (Object)(buildMessages2 != null ? buildMessages2.replacePaths((Function1<? super String, String>)replacer) : null));
    }

    @NotNull
    public final RsResult<Companion.GeneratedFilesHolder, RsProcessExecutionException> init(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String name2, boolean createBinary, @Nullable String vcs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Path path = UtilsKt.getPathAsPath(directory);
        String crateType = createBinary ? "--bin" : "--lib";
        Object[] objectArray = new String[]{crateType, "--name", name2};
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        String string = vcs;
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            Object[] objectArray2 = new String[]{"--vcs", vcs};
            args.addAll(CollectionsKt.listOf((Object[])objectArray2));
        }
        args.add(((Object)path).toString());
        RsResult $this$unwrapOrElse$iv = Cargo.execute$default(this, new CargoCommandLine("init", path, args, null, false, null, null, null, null, false, false, false, 4088, null), project, null, null, 6, null);
        boolean $i$f$unwrapOrElse = false;
        RsResult bl = $this$unwrapOrElse$iv;
        if (!(bl instanceof RsResult.Ok)) {
            if (bl instanceof RsResult.Err) {
                RsProcessExecutionException it3 = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl2 = false;
                return new RsResult.Err<RsProcessExecutionException>(it3);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        UtilsKt.fullyRefreshDirectory(directory);
        VirtualFile manifest = directory.findChild("Cargo.toml");
        String fileName = createBinary ? "main.rs" : "lib.rs";
        List sourceFiles = CollectionsKt.listOfNotNull((Object)directory.findFileByRelativePath("src/" + fileName));
        return new RsResult.Ok<Companion.GeneratedFilesHolder>(new Companion.GeneratedFilesHolder(manifest, sourceFiles));
    }

    public static /* synthetic */ RsResult init$default(Cargo cargo, Project project, VirtualFile virtualFile, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return cargo.init(project, virtualFile, string, bl, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RsResult<Companion.GeneratedFilesHolder, RsProcessExecutionException> generate(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String name2, @NotNull String templateUrl, @Nullable String vcs) {
        void $this$mapNotNullTo$iv$iv;
        void $this$unwrapOrElse$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)templateUrl, (String)"templateUrl");
        Path path = UtilsKt.getPathAsPath(directory);
        Object object = new String[]{"--name", name2, "--git", templateUrl, "--init", "--force"};
        List args = CollectionsKt.mutableListOf((Object[])object);
        String string = vcs;
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            Object[] objectArray = new String[]{"--vcs", vcs};
            args.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        object = Cargo.execute$default(this, new CargoCommandLine("generate", path, args, null, false, null, null, null, null, false, false, false, 4088, null), project, null, null, 6, null);
        boolean $i$f$unwrapOrElse = false;
        Object[] bl = $this$unwrapOrElse$iv;
        if (!(bl instanceof RsResult.Ok)) {
            if (bl instanceof RsResult.Err) {
                RsProcessExecutionException it3 = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl2 = false;
                return new RsResult.Err<RsProcessExecutionException>(it3);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        UtilsKt.fullyRefreshDirectory(directory);
        VirtualFile manifest = directory.findChild("Cargo.toml");
        bl = new String[]{"main", "lib"};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])bl);
        boolean $i$f$mapNotNull = false;
        Iterable bl2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            String it4 = (String)element$iv$iv;
            boolean bl4 = false;
            if (directory.findFileByRelativePath("src/" + it4 + ".rs") == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List sourceFiles = (List)destination$iv$iv;
        return new RsResult.Ok<Companion.GeneratedFilesHolder>(new Companion.GeneratedFilesHolder(manifest, sourceFiles));
    }

    public static /* synthetic */ RsResult generate$default(Cargo cargo, Project project, VirtualFile virtualFile, String string, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        return cargo.generate(project, virtualFile, string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RsResult<RsExternalLinterResult, RsProcessExecutionException.Start> checkProject(@NotNull Project project, @NotNull CargoCheckArgs args, boolean isOnTheFly) {
        RsResult rsResult;
        CargoCommandLine cargoCommandLine;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        boolean useClippy = args.getLinter() == ExternalLinter.CLIPPY && Rustup.Companion.checkClippy(project, args.getCargoProjectDirectory(), !isOnTheFly);
        String checkCommand = useClippy ? "clippy" : "check";
        CargoCheckArgs cargoCheckArgs = args;
        if (cargoCheckArgs instanceof CargoCheckArgs.SpecificTarget) {
            void result$iv$iv;
            boolean $i$f$buildList = false;
            Collection collection = new ArrayList();
            boolean $i$f$buildCollection = false;
            CollectionBuilder $this$checkProject_u24lambda_u240 = new /* invalid duplicate definition of identical inner class */;
            boolean bl = false;
            $this$checkProject_u24lambda_u240.add("--message-format=json");
            $this$checkProject_u24lambda_u240.add("--no-default-features");
            Map<String, FeatureState> $this$filterValues$iv = ((CargoCheckArgs.SpecificTarget)args).getTarget().getPkg().getFeatureState();
            boolean $i$f$filterValues = false;
            LinkedHashMap<String, FeatureState> result$iv = new LinkedHashMap<String, FeatureState>();
            for (Map.Entry<String, FeatureState> entry$iv : $this$filterValues$iv.entrySet()) {
                FeatureState it2 = entry$iv.getValue();
                boolean bl2 = false;
                if (!it2.isEnabled()) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            List enabledFeatures = CollectionsKt.toList((Iterable)((Map)result$iv).keySet());
            if (!((Collection)enabledFeatures).isEmpty()) {
                $this$checkProject_u24lambda_u240.add("--features");
                $this$checkProject_u24lambda_u240.add(CollectionsKt.joinToString$default((Iterable)enabledFeatures, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            if (!(((CargoCheckArgs.SpecificTarget)args).getTarget().getKind() instanceof CargoWorkspace.TargetKind.Test)) {
                $this$checkProject_u24lambda_u240.add("--tests");
            }
            if (((CargoCheckArgs.SpecificTarget)args).getRustcTarget() != null) {
                $this$checkProject_u24lambda_u240.add("--target=" + ((CargoCheckArgs.SpecificTarget)args).getRustcTarget());
            }
            List list = ParametersListUtil.parse((String)((CargoCheckArgs.SpecificTarget)args).getExtraArguments());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            $this$checkProject_u24lambda_u240.addAll(list);
            List arguments = (List)result$iv$iv;
            CargoWorkspace.Target target = ((CargoCheckArgs.SpecificTarget)args).getTarget();
            RustChannel rustChannel = ((CargoCheckArgs.SpecificTarget)args).getChannel();
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create(((CargoCheckArgs.SpecificTarget)args).getEnvs(), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
            cargoCommandLine = CargoCommandLine.Companion.forTarget(target, checkCommand, arguments, rustChannel, environmentVariablesData, false);
        } else if (cargoCheckArgs instanceof CargoCheckArgs.FullWorkspace) {
            void result$iv$iv;
            List<String> list;
            List<String> list2;
            Object it3;
            Object v5;
            block19: {
                Iterable $i$f$buildCollection = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
                for (Object bl : $i$f$buildCollection) {
                    CargoProject it4 = (CargoProject)bl;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it4.getRootDirPath(), (Object)((CargoCheckArgs.FullWorkspace)args).getCargoProjectDirectory())) continue;
                    v5 = bl;
                    break block19;
                }
                v5 = null;
            }
            CargoProject $i$f$buildList = v5;
            if ($i$f$buildList != null) {
                it3 = $i$f$buildList;
                boolean bl = false;
                list2 = this.allEnabledFeaturesForCheck((CargoProject)it3);
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            List<String> enabledFeatures = list;
            boolean $i$f$buildList2 = false;
            it3 = new ArrayList();
            boolean $i$f$buildCollection = false;
            CollectionBuilder $this$checkProject_u24lambda_u243 = new /* invalid duplicate definition of identical inner class */;
            boolean bl = false;
            $this$checkProject_u24lambda_u243.add("--message-format=json");
            $this$checkProject_u24lambda_u243.add("--all");
            if (((CargoCheckArgs.FullWorkspace)args).getAllTargets()) {
                $this$checkProject_u24lambda_u243.add("--all-targets");
            }
            $this$checkProject_u24lambda_u243.add("--no-default-features");
            if (!((Collection)enabledFeatures).isEmpty()) {
                $this$checkProject_u24lambda_u243.add("--features");
                $this$checkProject_u24lambda_u243.add(CollectionsKt.joinToString$default((Iterable)enabledFeatures, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            if (((CargoCheckArgs.FullWorkspace)args).getRustcTarget() != null) {
                $this$checkProject_u24lambda_u243.add("--target=" + ((CargoCheckArgs.FullWorkspace)args).getRustcTarget());
            }
            List list3 = ParametersListUtil.parse((String)((CargoCheckArgs.FullWorkspace)args).getExtraArguments());
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"parse(...)");
            $this$checkProject_u24lambda_u243.addAll(list3);
            List arguments = (List)result$iv$iv;
            Path path = ((CargoCheckArgs.FullWorkspace)args).getCargoProjectDirectory();
            RustChannel rustChannel = ((CargoCheckArgs.FullWorkspace)args).getChannel();
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create(((CargoCheckArgs.FullWorkspace)args).getEnvs(), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
            cargoCommandLine = new CargoCommandLine(checkCommand, path, arguments, null, false, null, null, rustChannel, environmentVariablesData, false, false, false, 3704, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        CargoCommandLine commandLine = CargoCommandLine.copy$default(cargoCommandLine, null, null, null, null, false, BacktraceMode.NO, null, null, null, false, false, false, 4063, null);
        GeneralCommandLine generalCommandLine = this.toGeneralCommandLine(project, CargoCommandLine.copy$default(commandLine, null, null, null, null, false, null, null, null, null, false, false, false, 4079, null));
        Instant started = Instant.now();
        RsResult<ProcessOutput, RsProcessExecutionException.Start> result2 = RsProcessResultKt.ignoreExitCode(CommandLineExtKt.execute$default(generalCommandLine, null, null, 3, null));
        Instant finish = Instant.now();
        RsResult<ProcessOutput, RsProcessExecutionException.Start> this_$iv = result2;
        boolean $i$f$map = false;
        RsResult<ProcessOutput, RsProcessExecutionException.Start> rsResult2 = this_$iv;
        if (rsResult2 instanceof RsResult.Ok) {
            ProcessOutput it5 = (ProcessOutput)((RsResult.Ok)this_$iv).getOk();
            boolean bl = false;
            List list = it5.getStdoutLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
            RsExternalLinterResult rsExternalLinterResult = new RsExternalLinterResult(list, it5.getExitCode(), Duration.between(started, finish).toMillis(), CommandLineExtKt.getSimpleSpec(generalCommandLine));
            rsResult = new RsResult.Ok<RsExternalLinterResult>(rsExternalLinterResult);
        } else if (rsResult2 instanceof RsResult.Err) {
            rsResult = new RsResult.Err(((RsResult.Err)this_$iv).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> allEnabledFeaturesForCheck(CargoProject cargoProject) {
        List list;
        List list2;
        Collection<CargoWorkspace.Package> collection;
        CargoWorkspace cargoWorkspace = cargoProject.getWorkspace();
        if (cargoWorkspace != null && (collection = cargoWorkspace.getPackages()) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            CargoWorkspace.Package pkg;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            void var7_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                pkg = (CargoWorkspace.Package)element$iv$iv;
                boolean bl = false;
                if (!(pkg.getOrigin() == PackageOrigin.WORKSPACE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String it2;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable $this$filterValues$iv;
                pkg = (CargoWorkspace.Package)element$iv$iv;
                boolean bl = false;
                Map<String, FeatureState> map2 = pkg.getFeatureState();
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                    FeatureState feature = (FeatureState)((Object)entry$iv.getValue());
                    boolean bl2 = false;
                    if (!feature.isEnabled()) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterValues$iv = ((Map)result$iv).keySet();
                boolean $i$f$filterNot = false;
                result$iv = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                    it2 = (String)element$iv$iv2;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it2, (Object)"default")) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filterNot$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void feature;
                    it2 = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    collection2.add(pkg.getEdition().compareTo((Enum)CargoWorkspace.Edition.EDITION_2021) < 0 && Intrinsics.areEqual((Object)pkg.getContentRootPath(), (Object)cargoProject.getRootDirPath()) ? feature : pkg.getName() + "/" + (String)feature);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List result2 = list;
        return result2;
    }

    @NotNull
    public final GeneralCommandLine toColoredCommandLine(@NotNull Project project, @NotNull CargoCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return this.toGeneralCommandLine(project, commandLine, true);
    }

    @NotNull
    public final GeneralCommandLine toGeneralCommandLine(@NotNull Project project, @NotNull CargoCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return this.toGeneralCommandLine(project, commandLine, false);
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine toGeneralCommandLine(Project project, CargoCommandLine commandLine, boolean colors) {
        void result$iv$iv;
        CargoCommandLine $this$toGeneralCommandLine_u24lambda_u240 = Companion.patchArgs(commandLine, project, colors);
        boolean bl = false;
        boolean $i$f$buildList = false;
        Collection collection = new ArrayList();
        boolean $i$f$buildCollection = false;
        CollectionBuilder $this$toGeneralCommandLine_u24lambda_u240_u240 = new /* invalid duplicate definition of identical inner class */;
        boolean bl2 = false;
        if ($this$toGeneralCommandLine_u24lambda_u240.getChannel() != RustChannel.DEFAULT) {
            $this$toGeneralCommandLine_u24lambda_u240_u240.add("+" + $this$toGeneralCommandLine_u24lambda_u240.getChannel());
        } else if ($this$toGeneralCommandLine_u24lambda_u240.getToolchain() != null) {
            $this$toGeneralCommandLine_u24lambda_u240_u240.add("+" + $this$toGeneralCommandLine_u24lambda_u240.getToolchain());
        }
        if (RustProjectSettingsServiceKt.getRustSettings(project).getUseOffline()) {
            $this$toGeneralCommandLine_u24lambda_u240_u240.add("--offline");
        }
        $this$toGeneralCommandLine_u24lambda_u240_u240.add($this$toGeneralCommandLine_u24lambda_u240.getCommand());
        $this$toGeneralCommandLine_u24lambda_u240_u240.addAll((Collection)$this$toGeneralCommandLine_u24lambda_u240.getAdditionalArguments());
        List parameters = (List)result$iv$iv;
        String rustcExecutable = this.getToolchain().toRemotePath(((Object)RustcKt.rustc(this.getToolchain()).getExecutable()).toString());
        GeneralCommandLine generalCommandLine = RsToolchainBase.createGeneralCommandLine$default(this.getToolchain(), project, this.getExecutable(), $this$toGeneralCommandLine_u24lambda_u240.getWorkingDirectory(), $this$toGeneralCommandLine_u24lambda_u240.getRedirectInputFrom(), $this$toGeneralCommandLine_u24lambda_u240.getBacktraceMode(), $this$toGeneralCommandLine_u24lambda_u240.getEnvironmentVariables(), parameters, $this$toGeneralCommandLine_u24lambda_u240.getEmulateTerminal(), RsExperiments.INSTANCE.getBUILD_TOOL_WINDOW().asBoolean() ? $this$toGeneralCommandLine_u24lambda_u240.getWithSudo() : false, false, this.getHttp(), 512, null).withEnvironment("RUSTC", rustcExecutable);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"with(...)");
        return generalCommandLine;
    }

    private final RsResult<ProcessOutput, RsProcessExecutionException> execute(CargoCommandLine $this$execute, Project project, byte[] stdIn, ProcessListener listener2) {
        return CommandLineExtKt.execute(this.toGeneralCommandLine(project, CargoCommandLine.copy$default($this$execute, null, null, null, null, false, null, null, null, null, false, false, false, 4079, null)), stdIn, listener2);
    }

    static /* synthetic */ RsResult execute$default(Cargo cargo, CargoCommandLine cargoCommandLine, Project project, byte[] byArray, ProcessListener processListener, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        if ((n & 4) != 0) {
            processListener = null;
        }
        return cargo.execute(cargoCommandLine, project, byArray, processListener);
    }

    @NotNull
    public final RsResult<Unit, RsProcessExecutionException.Start> installCargoGenerate(@NotNull Project project, @NotNull ProcessListener listener2) {
        RsResult rsResult;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        String[] stringArray = new String[]{"install", "cargo-generate"};
        RsResult<ProcessOutput, RsProcessExecutionException.Start> this_$iv = RsProcessResultKt.ignoreExitCode(CommandLineExtKt.execute$default(RsTool.createBaseCommandLine$default((RsTool)this, project, stringArray, null, null, 12, null), null, listener2, 1, null));
        boolean $i$f$map = false;
        RsResult<ProcessOutput, RsProcessExecutionException.Start> rsResult2 = this_$iv;
        if (rsResult2 instanceof RsResult.Ok) {
            ProcessOutput it2 = (ProcessOutput)((RsResult.Ok)this_$iv).getOk();
            boolean bl = false;
            Unit unit = Unit.INSTANCE;
            rsResult = new RsResult.Ok<Unit>(unit);
        } else if (rsResult2 instanceof RsResult.Err) {
            rsResult = new RsResult.Err(((RsResult.Err)this_$iv).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    public final boolean checkNeedInstallCargoGenerate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String crateName = "cargo-generate";
        SemVer minVersion = ToolchainUtilKt.parseSemVer("0.9.0");
        return this.checkBinaryCrateIsNotInstalled(project, crateName, minVersion);
    }

    private final boolean checkBinaryCrateIsNotInstalled(Project project, String crateName, SemVer minVersion) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.listInstalledBinaryCrates(project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BinaryCrate binaryCrate = (BinaryCrate)element$iv;
                    boolean bl2 = false;
                    String name2 = binaryCrate.component1();
                    SemVer version = binaryCrate.component2();
                    if (!(Intrinsics.areEqual((Object)name2, (Object)crateName) && (minVersion == null || version != null && version.compareTo(minVersion) >= 0))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean installed = bl;
        return !installed;
    }

    private final HttpConfigurable getHttp() {
        HttpConfigurable httpConfigurable = this._http;
        if (httpConfigurable == null) {
            HttpConfigurable httpConfigurable2 = HttpConfigurable.getInstance();
            httpConfigurable = httpConfigurable2;
            Intrinsics.checkNotNullExpressionValue((Object)httpConfigurable2, (String)"getInstance(...)");
        }
        return httpConfigurable;
    }

    @TestOnly
    public final void setHttp(@NotNull HttpConfigurable http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        this._http = http;
    }

    private static final Path normalizeProjectPath$lambda$1(Path it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getParent();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final List<String> collectFeaturesForFetchingBuildScripts$featuresForPackage(CargoMetadata.Package $this$collectFeaturesForFetchingBuildScripts_u24featuresForPackage, Map<String, ? extends Map<String, ? extends FeatureState>> packagesFeaturesState) {
        void $this$mapTo$iv$iv;
        List list;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Map enabledFeatures;
        Map.Entry it2;
        Iterator iterator2;
        Iterator $this$filterTo$iv$iv;
        Object destination$iv$iv;
        block12: {
            Map map2 = packagesFeaturesState.get($this$collectFeaturesForFetchingBuildScripts_u24featuresForPackage.getId());
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map featureStates = map2;
            Map<String, List<String>> $this$filter$iv = $this$collectFeaturesForFetchingBuildScripts_u24featuresForPackage.getFeatures();
            boolean $i$f$filter = false;
            Map<String, List<String>> map3 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                it2 = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                FeatureState featureState = (FeatureState)((Object)featureStates.get(it2.getKey()));
                boolean bl3 = featureState != null ? featureState.isEnabled() : false;
                if (!bl3) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            enabledFeatures = destination$iv$iv;
            $this$any$iv = $this$collectFeaturesForFetchingBuildScripts_u24featuresForPackage.getTargets();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CargoMetadata.Target it3 = (CargoMetadata.Target)element$iv;
                    boolean bl4 = false;
                    if (!(it3.getCleanKind() == CargoMetadata.TargetKind.CUSTOM_BUILD)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (!bl) {
            boolean bl5;
            block13: {
                $this$any$iv = $this$collectFeaturesForFetchingBuildScripts_u24featuresForPackage.getDependencies();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CargoMetadata.RawDependency it4 = (CargoMetadata.RawDependency)element$iv;
                        boolean bl6 = false;
                        if (!it4.getOptional()) continue;
                        bl5 = true;
                        break block13;
                    }
                    bl5 = false;
                }
            }
            if (!bl5 && !Cargo.collectFeaturesForFetchingBuildScripts$featuresForPackage$propagatesFeatures($this$collectFeaturesForFetchingBuildScripts_u24featuresForPackage, enabledFeatures)) {
                list = CollectionsKt.emptyList();
                return list;
            }
        }
        Map $this$map$iv = enabledFeatures;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                list = (List)destination$iv$iv;
                return list;
            }
            Map.Entry item$iv$iv = iterator2.next();
            it2 = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl7 = false;
            object.add((String)it2.getKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean collectFeaturesForFetchingBuildScripts$featuresForPackage$propagatesFeatures(CargoMetadata.Package $this_featuresForPackage, Map<String, ? extends List<String>> enabledFeatures) {
        boolean bl;
        block10: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this_featuresForPackage.getDependencies();
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                CargoMetadata.RawDependency rawDependency = (CargoMetadata.RawDependency)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.getName());
            }
            Set dependencyNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Map<String, ? extends List<String>> $this$any$iv = enabledFeatures;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.entrySet().iterator();
                while (object.hasNext()) {
                    boolean bl3;
                    block9: {
                        Map.Entry element$iv;
                        Map.Entry entry2 = element$iv = (Map.Entry)object.next();
                        boolean bl4 = false;
                        List deps = (List)entry2.getValue();
                        Iterable $this$any$iv2 = deps;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                boolean bl5;
                                String string;
                                Object object2;
                                String it3 = (String)element$iv2;
                                boolean bl6 = false;
                                Object object3 = new String[]{"/"};
                                Object it4 = object3 = StringsKt.split$default((CharSequence)it3, (String[])object3, (boolean)false, (int)2, (int)2, null);
                                boolean bl7 = false;
                                Object object4 = object2 = it4.size() == 2 ? object3 : null;
                                if (object2 != null && (object3 = (String)CollectionsKt.first((List)object2)) != null && (string = StringsKt.removeSuffix((String)object3, (CharSequence)"?")) != null) {
                                    String it5 = string;
                                    boolean bl8 = false;
                                    bl5 = dependencyNames.contains(it5);
                                } else {
                                    bl5 = false;
                                }
                                if (!bl5) continue;
                                bl3 = true;
                                break block9;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String replacePathsSymlinkIfNeeded$lambda$1(String $workspaceRoot, String $normalisedWorkspace, String it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        if (!StringsKt.startsWith$default((String)it2, (String)$workspaceRoot, (boolean)false, (int)2, null)) {
            return it2;
        }
        return $normalisedWorkspace + StringsKt.removePrefix((String)it2, (CharSequence)$workspaceRoot);
    }

    @NotNull
    public static final RegistryValue getTEST_NOCAPTURE_ENABLED_KEY() {
        return Companion.getTEST_NOCAPTURE_ENABLED_KEY();
    }

    public static final /* synthetic */ List access$getFEATURES_ACCEPTING_COMMANDS$cp() {
        return FEATURES_ACCEPTING_COMMANDS;
    }

    public static final /* synthetic */ List access$getCOLOR_ACCEPTING_COMMANDS$cp() {
        return COLOR_ACCEPTING_COMMANDS;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Cargo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"configure(...)");
        JSON_MAPPER = ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper);
        TOML_MAPPER = new TomlMapper();
        TEST_NOCAPTURE_ENABLED_KEY = Registry.Companion.get("org.rust.cargo.test.nocapture");
        USE_BUILD_SCRIPT_WRAPPER = Registry.Companion.get("org.rust.cargo.evaluate.build.scripts.wrapper");
        Object[] objectArray = new String[]{"bench", "build", "check", "doc", "fix", "run", "rustc", "rustdoc", "test", "metadata", "tree", "install", "package", "publish"};
        FEATURES_ACCEPTING_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"bench", "build", "check", "clean", "clippy", "doc", "install", "publish", "run", "rustc", "test", "update"};
        COLOR_ACCEPTING_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/cargo/toolchain/tools/Cargo$BinaryCrate;", "", "name", "", "version", "Lcom/intellij/util/text/SemVer;", "<init>", "(Ljava/lang/String;Lcom/intellij/util/text/SemVer;)V", "getName", "()Ljava/lang/String;", "getVersion", "()Lcom/intellij/util/text/SemVer;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rustrover.core"})
    public static final class BinaryCrate {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @Nullable
        private final SemVer version;
        @NotNull
        private static final Regex VERSION_LINE = new Regex("(?<name>[\\w-]+) v(?<version>\\d+\\.\\d+\\.\\d+(-[\\w.]+)?).*");

        public BinaryCrate(@NotNull String name2, @Nullable SemVer version) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.version = version;
        }

        public /* synthetic */ BinaryCrate(String string, SemVer semVer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                semVer = null;
            }
            this(string, semVer);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final SemVer getVersion() {
            return this.version;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final SemVer component2() {
            return this.version;
        }

        @NotNull
        public final BinaryCrate copy(@NotNull String name2, @Nullable SemVer version) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new BinaryCrate(name2, version);
        }

        public static /* synthetic */ BinaryCrate copy$default(BinaryCrate binaryCrate, String string, SemVer semVer, int n, Object object) {
            if ((n & 1) != 0) {
                string = binaryCrate.name;
            }
            if ((n & 2) != 0) {
                semVer = binaryCrate.version;
            }
            return binaryCrate.copy(string, semVer);
        }

        @NotNull
        public String toString() {
            return "BinaryCrate(name=" + this.name + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BinaryCrate)) {
                return false;
            }
            BinaryCrate binaryCrate = (BinaryCrate)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)binaryCrate.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)binaryCrate.version);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/rust/cargo/toolchain/tools/Cargo$BinaryCrate$Companion;", "", "<init>", "()V", "VERSION_LINE", "Lkotlin/text/Regex;", "from", "Lorg/rust/cargo/toolchain/tools/Cargo$BinaryCrate;", "line", "", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final BinaryCrate from(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                MatchResult matchResult = VERSION_LINE.matchEntire((CharSequence)line);
                if (matchResult == null) {
                    return null;
                }
                MatchResult result2 = matchResult;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result2.getGroups(), (String)"name");
                if (object == null || (object = object.getValue()) == null) {
                    return null;
                }
                Object name2 = object;
                Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result2.getGroups(), (String)"version");
                if (object2 == null || (object2 = object2.getValue()) == null) {
                    return null;
                }
                Object rawVersion = object2;
                return new BinaryCrate((String)name2, SemVer.parseFromText((String)rawVersion));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ8\u0010$\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\n\b\u0003\u0010(\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/rust/cargo/toolchain/tools/Cargo$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "JSON_MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "TOML_MAPPER", "Lcom/fasterxml/jackson/dataformat/toml/TomlMapper;", "TEST_NOCAPTURE_ENABLED_KEY", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getTEST_NOCAPTURE_ENABLED_KEY$annotations", "getTEST_NOCAPTURE_ENABLED_KEY", "()Lcom/intellij/openapi/util/registry/RegistryValue;", "USE_BUILD_SCRIPT_WRAPPER", "getUSE_BUILD_SCRIPT_WRAPPER", "NAME", "", "WRAPPER_NAME", "FEATURES_ACCEPTING_COMMANDS", "", "COLOR_ACCEPTING_COMMANDS", "getCargoCommonPatch", "Lkotlin/Function1;", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "Lorg/rust/cargo/runconfig/buildtool/CargoPatch;", "project", "Lcom/intellij/openapi/project/Project;", "patchArgs", "colors", "", "checkNeedInstallLlvmCov", "checkNeedInstallCargoExpand", "checkNeedInstallEvcxr", "checkNeedInstallWasmPack", "checkNeedInstallBinaryCrate", "crateName", "notificationType", "Lcom/intellij/notification/NotificationType;", "message", "minVersion", "Lcom/intellij/util/text/SemVer;", "GeneratedFilesHolder", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cargo.kt\norg/rust/cargo/toolchain/tools/Cargo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1108:1\n1#2:1109\n1374#3:1110\n1460#3,5:1111\n2746#3,3:1116\n*S KotlinDebug\n*F\n+ 1 Cargo.kt\norg/rust/cargo/toolchain/tools/Cargo$Companion\n*L\n940#1:1110\n940#1:1111,5\n948#1:1116,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RegistryValue getTEST_NOCAPTURE_ENABLED_KEY() {
            return TEST_NOCAPTURE_ENABLED_KEY;
        }

        @JvmStatic
        public static /* synthetic */ void getTEST_NOCAPTURE_ENABLED_KEY$annotations() {
        }

        @NotNull
        public final RegistryValue getUSE_BUILD_SCRIPT_WRAPPER() {
            return USE_BUILD_SCRIPT_WRAPPER;
        }

        @NotNull
        public final Function1<CargoCommandLine, CargoCommandLine> getCargoCommonPatch(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return arg_0 -> Companion.getCargoCommonPatch$lambda$0(project, arg_0);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final CargoCommandLine patchArgs(@NotNull CargoCommandLine $this$patchArgs, @NotNull Project project, boolean colors) {
            block18: {
                Intrinsics.checkNotNullParameter((Object)$this$patchArgs, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                var6_4 = $this$patchArgs.splitOnDoubleDash();
                $i$a$-let-Cargo$Companion$patchArgs$1 = false;
                pre = (List)var6_4.component1();
                post = (List)var6_4.component2();
                var4_12 = TuplesKt.to((Object)CollectionsKt.toMutableList((Collection)pre), (Object)CollectionsKt.toMutableList((Collection)post));
                pre = (List)var4_12.component1();
                post = (List)var4_12.component2();
                $i$a$-let-Cargo$Companion$patchArgs$1 = new String[]{"test", "bench"};
                if (CollectionsKt.listOf((Object[])$i$a$-let-Cargo$Companion$patchArgs$1).contains($this$patchArgs.getCommand())) {
                    if ($this$patchArgs.getAllFeatures() && !pre.contains("--all-features")) {
                        pre.add("--all-features");
                    }
                    if (this.getTEST_NOCAPTURE_ENABLED_KEY().asBoolean() && !post.contains("--nocapture")) {
                        post.add(0, "--nocapture");
                    }
                }
                if ($this$patchArgs.getRequiredFeatures() && Cargo.access$getFEATURES_ACCEPTING_COMMANDS$cp().contains($this$patchArgs.getCommand())) {
                    $this$patchArgs_u24lambda_u241 = $this$patchArgs;
                    $i$a$-run-Cargo$Companion$patchArgs$2 = false;
                    v0 = CargoCommandConfiguration.Companion.findCargoProject(project, $this$patchArgs_u24lambda_u241.getAdditionalArguments(), $this$patchArgs_u24lambda_u241.getWorkingDirectory());
                    if (v0 != null) {
                        cargoProject = v0;
                        v1 = CargoCommandConfiguration.Companion.findCargoPackage(cargoProject, $this$patchArgs_u24lambda_u241.getAdditionalArguments(), $this$patchArgs_u24lambda_u241.getWorkingDirectory());
                        if (v1 != null) {
                            cargoPackage = v1;
                            if (!Intrinsics.areEqual((Object)$this$patchArgs_u24lambda_u241.getWorkingDirectory(), (Object)cargoPackage.getContentRootPath())) {
                                manifestIdx = pre.indexOf("--manifest-path");
                                packageIdx = pre.indexOf("--package");
                                if (manifestIdx == -1 && packageIdx != -1) {
                                    pre.remove(packageIdx);
                                    pre.remove(packageIdx);
                                    pre.add("--manifest-path");
                                    manifest = cargoPackage.getContentRootPath().resolve("Cargo.toml").toAbsolutePath();
                                    if (RsEelToolchain.Companion.canUseEel()) {
                                        Intrinsics.checkNotNull((Object)manifest);
                                        v2 = EelNioBridgeServiceKt.asEelPath((Path)manifest).toString();
                                    } else {
                                        v2 = manifest.toString();
                                    }
                                    pre.add(v2);
                                }
                            }
                            cargoTargets = CargoCommandConfiguration.Companion.findCargoTargets(cargoPackage, $this$patchArgs_u24lambda_u241.getAdditionalArguments());
                            $this$flatMap$iv = cargoTargets;
                            $i$f$flatMap = false;
                            var16_23 = $this$flatMap$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$flatMapTo = false;
                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                it = (CargoWorkspace.Target)element$iv$iv;
                                $i$a$-flatMap-Cargo$Companion$patchArgs$2$features$1 = false;
                                list$iv$iv = it.getRequiredFeatures();
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            features = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                            if (((CharSequence)features).length() > 0) {
                                pre.add("--features=" + features);
                            }
                        }
                    }
                }
                if (!colors || !Cargo.access$getCOLOR_ACCEPTING_COMMANDS$cp().contains($this$patchArgs.getCommand())) ** GOTO lbl-1000
                $this$none$iv = $this$patchArgs.getAdditionalArguments();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v3 = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        it = (String)element$iv;
                        $i$a$-none-Cargo$Companion$patchArgs$forceColors$1 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"--color", (boolean)false, (int)2, null)) continue;
                        v3 = false;
                        break block18;
                    }
                    v3 = true;
                }
            }
            if (v3) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = forceColors = false;
            }
            if (forceColors) {
                pre.add(0, "--color=always");
            }
            return CargoCommandLine.copy$default($this$patchArgs, null, null, post.isEmpty() != false ? pre : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)pre, (Object)"--"), (Iterable)post), null, false, null, null, null, null, false, false, false, 4091, null);
        }

        public final boolean checkNeedInstallLlvmCov(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String crateName = RsBundle.INSTANCE.message("notification.content.llvm.cov", new Object[0]);
            SemVer minVersion = ToolchainUtilKt.parseSemVer("0.1.0");
            Object[] objectArray = new Object[]{crateName, minVersion};
            return this.checkNeedInstallBinaryCrate(project, crateName, NotificationType.ERROR, RsBundle.INSTANCE.message("notification.content.need.at.least", objectArray), minVersion);
        }

        public final boolean checkNeedInstallCargoExpand(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String crateName = RsBundle.INSTANCE.message("notification.content.cargo.expand", new Object[0]);
            SemVer minVersion = ToolchainUtilKt.parseSemVer("1.0.0");
            Object[] objectArray = new Object[]{crateName, minVersion};
            return this.checkNeedInstallBinaryCrate(project, crateName, NotificationType.ERROR, RsBundle.INSTANCE.message("notification.content.need.at.least", objectArray), minVersion);
        }

        public final boolean checkNeedInstallEvcxr(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String crateName = "evcxr_repl";
            SemVer minVersion = ToolchainUtilKt.parseSemVer("0.14.2");
            Object[] objectArray = new Object[]{crateName, minVersion};
            return this.checkNeedInstallBinaryCrate(project, crateName, NotificationType.ERROR, RsBundle.INSTANCE.message("notification.content.need.at.least", objectArray), minVersion);
        }

        public final boolean checkNeedInstallWasmPack(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String crateName = RsBundle.INSTANCE.message("notification.content.wasm.pack", new Object[0]);
            SemVer minVersion = ToolchainUtilKt.parseSemVer("0.9.1");
            Object[] objectArray = new Object[]{crateName, minVersion};
            return this.checkNeedInstallBinaryCrate(project, crateName, NotificationType.ERROR, RsBundle.INSTANCE.message("notification.content.need.at.least", objectArray), minVersion);
        }

        private final boolean checkNeedInstallBinaryCrate(Project project, String crateName, NotificationType notificationType, @NlsContexts.NotificationContent String message, SemVer minVersion) {
            boolean needInstall2;
            Object[] objectArray;
            Object object = RustProjectSettingsServiceKt.getToolchain(project);
            if (object == null || (object = CargoKt.cargo((RsToolchainBase)object)) == null) {
                return false;
            }
            Object cargo = object;
            Function0 isNotInstalled = () -> Companion.checkNeedInstallBinaryCrate$lambda$0((Cargo)cargo, project, crateName, minVersion);
            if (UtilsKt.isDispatchThread()) {
                objectArray = new Object[]{crateName};
                v1 = (Boolean)UtilsKt.computeWithCancelableProgress(project, RsBundle.INSTANCE.message("progress.title.checking.if.installed", objectArray), isNotInstalled);
            } else {
                v1 = needInstall2 = ((Boolean)isNotInstalled.invoke()).booleanValue();
            }
            if (needInstall2) {
                objectArray = new Object[]{crateName};
                String string = RsBundle.INSTANCE.message("notification.title.code.code.not.installed", objectArray);
                String string2 = message;
                if (string2 == null) {
                    string2 = "";
                }
                org.rust.ide.notifications.UtilsKt.showBalloon$default(project, "crate.is.not.installed", string, string2, notificationType, (AnAction)new InstallBinaryCrateAction(crateName), null, 32, null);
            }
            return needInstall2;
        }

        static /* synthetic */ boolean checkNeedInstallBinaryCrate$default(Companion companion, Project project, String string, NotificationType notificationType, String string2, SemVer semVer, int n, Object object) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                semVer = null;
            }
            return companion.checkNeedInstallBinaryCrate(project, string, notificationType, string2, semVer);
        }

        private static final CargoCommandLine getCargoCommonPatch$lambda$0(Project $project, CargoCommandLine it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return Companion.patchArgs(it2, $project, true);
        }

        private static final boolean checkNeedInstallBinaryCrate$lambda$0(Cargo $cargo, Project $project, String $crateName, SemVer $minVersion) {
            return $cargo.checkBinaryCrateIsNotInstalled($project, $crateName, $minVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/cargo/toolchain/tools/Cargo$Companion$GeneratedFilesHolder;", "", "manifest", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceFiles", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "getManifest", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getSourceFiles", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class GeneratedFilesHolder {
            @Nullable
            private final VirtualFile manifest;
            @NotNull
            private final List<VirtualFile> sourceFiles;

            public GeneratedFilesHolder(@Nullable VirtualFile manifest, @NotNull List<? extends VirtualFile> sourceFiles) {
                Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
                this.manifest = manifest;
                this.sourceFiles = sourceFiles;
            }

            @Nullable
            public final VirtualFile getManifest() {
                return this.manifest;
            }

            @NotNull
            public final List<VirtualFile> getSourceFiles() {
                return this.sourceFiles;
            }

            @Nullable
            public final VirtualFile component1() {
                return this.manifest;
            }

            @NotNull
            public final List<VirtualFile> component2() {
                return this.sourceFiles;
            }

            @NotNull
            public final GeneratedFilesHolder copy(@Nullable VirtualFile manifest, @NotNull List<? extends VirtualFile> sourceFiles) {
                Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
                return new GeneratedFilesHolder(manifest, sourceFiles);
            }

            public static /* synthetic */ GeneratedFilesHolder copy$default(GeneratedFilesHolder generatedFilesHolder, VirtualFile virtualFile, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    virtualFile = generatedFilesHolder.manifest;
                }
                if ((n & 2) != 0) {
                    list = generatedFilesHolder.sourceFiles;
                }
                return generatedFilesHolder.copy(virtualFile, list);
            }

            @NotNull
            public String toString() {
                return "GeneratedFilesHolder(manifest=" + this.manifest + ", sourceFiles=" + this.sourceFiles + ")";
            }

            public int hashCode() {
                int result2 = this.manifest == null ? 0 : this.manifest.hashCode();
                result2 = result2 * 31 + ((Object)this.sourceFiles).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GeneratedFilesHolder)) {
                    return false;
                }
                GeneratedFilesHolder generatedFilesHolder = (GeneratedFilesHolder)other;
                if (!Intrinsics.areEqual((Object)this.manifest, (Object)generatedFilesHolder.manifest)) {
                    return false;
                }
                return Intrinsics.areEqual(this.sourceFiles, generatedFilesHolder.sourceFiles);
            }
        }
    }
}

