/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.text.SemVer;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.toolchain.RustChannel;
import org.rust.cargo.toolchain.impl.RustcVersion;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007\u00a8\u0006\u0005"}, d2={"parseRustcVersion", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "lines", "", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRustcVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RustcVersion.kt\norg/rust/cargo/toolchain/impl/RustcVersionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class RustcVersionKt {
    @VisibleForTesting
    @Nullable
    public static final RustcVersion parseRustcVersion(@NotNull List<String> lines) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Regex releaseRe = new Regex("release: (\\d+\\.\\d+\\.\\d+.*)");
        Regex hostRe = new Regex("host: (.*)");
        Regex commitHashRe = new Regex("commit-hash: ([A-Fa-f0-9]{40})");
        Regex commitDateRe = new Regex("commit-date: (\\d{4}-\\d{2}-\\d{2})");
        Function1 find = arg_0 -> RustcVersionKt.parseRustcVersion$lambda$0(lines, arg_0);
        MatchResult matchResult = (MatchResult)find.invoke((Object)releaseRe);
        if (matchResult == null) {
            return null;
        }
        MatchResult releaseMatch = matchResult;
        Object object = (MatchResult)find.invoke((Object)hostRe);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            return null;
        }
        Object hostText = object;
        Object object2 = releaseMatch.getGroups().get(1);
        if (object2 == null || (object2 = object2.getValue()) == null) {
            return null;
        }
        Object versionText = object2;
        MatchResult matchResult2 = (MatchResult)find.invoke((Object)commitHashRe);
        String commitHash = matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(1)) != null ? matchResult2.getValue() : null;
        try {
            LocalDate localDate2;
            Object object3 = (MatchResult)find.invoke((Object)commitDateRe);
            if (object3 != null && (object3 = object3.getGroups()) != null && (object3 = object3.get(1)) != null && (object3 = object3.getValue()) != null) {
                CharSequence p0 = (CharSequence)object3;
                boolean bl = false;
                localDate2 = LocalDate.parse(p0);
            } else {
                localDate2 = null;
            }
            localDate = localDate2;
        }
        catch (DateTimeParseException e) {
            localDate = null;
        }
        LocalDate commitDate = localDate;
        SemVer semVer = SemVer.parseFromText((String)versionText);
        if (semVer == null) {
            return null;
        }
        SemVer semVer2 = semVer;
        String string = semVer2.getPreRelease();
        if (string == null) {
            string = "";
        }
        String preRelease = string;
        RustChannel channel = RustChannel.Companion.fromPreRelease(preRelease);
        return new RustcVersion(semVer2, (String)hostText, channel, commitHash, commitDate);
    }

    private static final MatchResult parseRustcVersion$lambda$0(List $lines, Regex re) {
        MatchResult matchResult;
        block1: {
            Intrinsics.checkNotNullParameter((Object)re, (String)"re");
            for (String it2 : (Iterable)$lines) {
                boolean bl = false;
                MatchResult matchResult2 = re.matchEntire((CharSequence)it2);
                if (matchResult2 == null) continue;
                matchResult = matchResult2;
                break block1;
            }
            matchResult = null;
        }
        return matchResult;
    }
}

