/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ContextKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.EDT;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.BacktraceMode;
import org.rust.cargo.toolchain.CommandLineKt;
import org.rust.cargo.toolchain.ProxyHelperKt;
import org.rust.cargo.toolchain.RsToolchainProvider;
import org.rust.cargo.toolchain.eel.RsEelToolchain;
import org.rust.cargo.toolchain.flavors.RsToolchainFlavor;
import org.rust.cargo.toolchain.wsl.RsWslToolchainFlavorKt;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.openapiext.CommandLineExtKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 92\u00020\u0001:\u00019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0013H&J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH&J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH&J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH&J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH&J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\tH&J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\tH&J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\tH&J\u0013\u0010%\u001a\u00020\u00132\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010'\u001a\u00020\u000fH\u0016Jl\u0010(\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t042\u0006\u00105\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\b\b\u0002\u00106\u001a\u00020\u00132\b\b\u0002\u00107\u001a\u000208R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006:"}, d2={"Lorg/rust/cargo/toolchain/RsToolchainBase;", "", "location", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getLocation", "()Ljava/nio/file/Path;", "presentableLocation", "", "getPresentableLocation", "()Ljava/lang/String;", "fileSeparator", "getFileSeparator", "executionTimeoutInMilliseconds", "", "getExecutionTimeoutInMilliseconds", "()I", "looksLikeValidToolchain", "", "patchCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "commandLine", "withSudo", "toLocalPath", "remotePath", "toRemotePath", "localPath", "expandUserHome", "getExecutableName", "toolName", "pathToExecutable", "remotePathToExecutable", "pathToCargoExecutable", "hasExecutable", "exec", "hasCargoExecutable", "equals", "other", "hashCode", "createGeneralCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "executable", "workingDirectory", "redirectInputFrom", "Ljava/io/File;", "backtraceMode", "Lorg/rust/cargo/toolchain/BacktraceMode;", "environmentVariables", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "parameters", "", "emulateTerminal", "patchToRemote", "http", "Lcom/intellij/util/net/HttpConfigurable;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsToolchainBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsToolchainBase.kt\norg/rust/cargo/toolchain/RsToolchainBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n13#2:185\n*S KotlinDebug\n*F\n+ 1 RsToolchainBase.kt\norg/rust/cargo/toolchain/RsToolchainBase\n*L\n135#1:185\n*E\n"})
public abstract class RsToolchainBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path location;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final SemVer MIN_SUPPORTED_TOOLCHAIN;
    @NotNull
    public static final String RUSTC_BOOTSTRAP = "RUSTC_BOOTSTRAP";
    @NotNull
    public static final String RUSTC_WRAPPER = "RUSTC_WRAPPER";
    @NotNull
    public static final String ORIGINAL_RUSTC_BOOTSTRAP = "INTELLIJ_ORIGINAL_RUSTC_BOOTSTRAP";
    @NotNull
    public static final String RUSTC_BOOTSTRAP_WAS_SET_BY_RR = "INTELLIJ_RUST_RUSTC_BOOTSTRAP_WAS_SET_BY_RR";

    public RsToolchainBase(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.location = location;
    }

    @NotNull
    public final Path getLocation() {
        return this.location;
    }

    @NotNull
    public final String getPresentableLocation() {
        return ((Object)this.pathToExecutable("cargo")).toString();
    }

    @NotNull
    public abstract String getFileSeparator();

    public abstract int getExecutionTimeoutInMilliseconds();

    public final boolean looksLikeValidToolchain() {
        return RsToolchainFlavor.Companion.getFlavor(this.location) != null;
    }

    @NotNull
    public abstract GeneralCommandLine patchCommandLine(@NotNull GeneralCommandLine var1, boolean var2);

    @NotNull
    public abstract String toLocalPath(@NotNull String var1);

    @NotNull
    public abstract String toRemotePath(@NotNull String var1);

    @NotNull
    public abstract String expandUserHome(@NotNull String var1);

    @NotNull
    public abstract String getExecutableName(@NotNull String var1);

    @NotNull
    public abstract Path pathToExecutable(@NotNull String var1);

    @NotNull
    public String remotePathToExecutable(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return ((Object)this.pathToExecutable(toolName)).toString();
    }

    @NotNull
    public final Path pathToCargoExecutable(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Path exePath = this.pathToExecutable(toolName);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(exePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return exePath;
        }
        String cargoBin = this.expandUserHome("~/.cargo/bin");
        String exeName = this.getExecutableName(toolName);
        String[] stringArray = new String[]{exeName};
        Path path = Paths.get(cargoBin, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    public abstract boolean hasExecutable(@NotNull String var1);

    public abstract boolean hasCargoExecutable(@NotNull String var1);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RsToolchainBase)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.location, (Object)((RsToolchainBase)other).location);
    }

    public int hashCode() {
        return ((Object)this.location).hashCode();
    }

    @NotNull
    public final GeneralCommandLine createGeneralCommandLine(@Nullable Project project, @NotNull Path executable, @NotNull Path workingDirectory, @Nullable File redirectInputFrom, @NotNull BacktraceMode backtraceMode, @NotNull EnvironmentVariablesData environmentVariables, @NotNull List<String> parameters, boolean emulateTerminal, boolean withSudo, boolean patchToRemote, @NotNull HttpConfigurable http) {
        Map map2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)backtraceMode), (String)"backtraceMode");
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        GeneralCommandLine generalCommandLine = CommandLineExtKt.withWorkDirectory(CommandLineExtKt.GeneralCommandLine(executable, withSudo, new String[0]), workingDirectory).withInput(redirectInputFrom).withEnvironment("TERM", "ansi").withParameters(parameters).withCharset(Charsets.UTF_8).withRedirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withRedirectErrorStream(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        ProxyHelperKt.withProxyIfNeeded(commandLine, http);
        switch (WhenMappings.$EnumSwitchMapping$0[backtraceMode.ordinal()]) {
            case 1: {
                GeneralCommandLine generalCommandLine2 = commandLine.withEnvironment("RUST_BACKTRACE", "short");
                Unit unit = generalCommandLine2;
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withEnvironment(...)");
                break;
            }
            case 2: {
                GeneralCommandLine generalCommandLine3 = commandLine.withEnvironment("RUST_BACKTRACE", "full");
                Unit unit = generalCommandLine3;
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withEnvironment(...)");
                break;
            }
            case 3: {
                Unit unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (((object = project) != null && (object = RustProjectSettingsServiceKt.getRustSettings((Project)object)) != null ? ((RustProjectSettingsService)((Object)object)).getEnvs() : (map2 = null)) == null) {
            map2 = MapsKt.emptyMap();
        }
        CommandLineKt.withAdded(environmentVariables, map2).configureCommandLine(commandLine, true);
        if (emulateTerminal) {
            PtyCommandLine ptyCommandLine = new PtyCommandLine(commandLine).withInitialColumns(2500).withConsoleMode(false);
            Intrinsics.checkNotNullExpressionValue((Object)ptyCommandLine, (String)"withConsoleMode(...)");
            commandLine = (GeneralCommandLine)ptyCommandLine;
        }
        if (patchToRemote) {
            commandLine = this.patchCommandLine(commandLine, withSudo);
        }
        return commandLine;
    }

    public static /* synthetic */ GeneralCommandLine createGeneralCommandLine$default(RsToolchainBase rsToolchainBase, Project project, Path path, Path path2, File file, BacktraceMode backtraceMode, EnvironmentVariablesData environmentVariablesData, List list, boolean bl, boolean bl2, boolean bl3, HttpConfigurable httpConfigurable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createGeneralCommandLine");
        }
        if ((n & 0x200) != 0) {
            bl3 = true;
        }
        if ((n & 0x400) != 0) {
            HttpConfigurable httpConfigurable2 = HttpConfigurable.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)httpConfigurable2, (String)"getInstance(...)");
            httpConfigurable = httpConfigurable2;
        }
        return rsToolchainBase.createGeneralCommandLine(project, path, path2, file, backtraceMode, environmentVariablesData, list, bl, bl2, bl3, httpConfigurable);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsToolchainBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        MIN_SUPPORTED_TOOLCHAIN = ToolchainUtilKt.parseSemVer("1.64.0");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/cargo/toolchain/RsToolchainBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MIN_SUPPORTED_TOOLCHAIN", "Lcom/intellij/util/text/SemVer;", "getMIN_SUPPORTED_TOOLCHAIN", "()Lcom/intellij/util/text/SemVer;", "RUSTC_BOOTSTRAP", "", "RUSTC_WRAPPER", "ORIGINAL_RUSTC_BOOTSTRAP", "RUSTC_BOOTSTRAP_WAS_SET_BY_RR", "suggest", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "projectDir", "Ljava/nio/file/Path;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsToolchainBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsToolchainBase.kt\norg/rust/cargo/toolchain/RsToolchainBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SemVer getMIN_SUPPORTED_TOOLCHAIN() {
            return MIN_SUPPORTED_TOOLCHAIN;
        }

        @JvmOverloads
        @Nullable
        public final RsToolchainBase suggest(@Nullable Path projectDir) {
            Sequence sequence2;
            Sequence sequence3;
            Sequence<Path> sequence4;
            RsToolchainBase toolchain2;
            WSLDistribution wSLDistribution;
            if (!(ContextKt.isInCancellableContext() || EDT.isCurrentThreadEdt())) {
                throw new IllegalStateException("Check failed.");
            }
            Path path = projectDir;
            if (path != null) {
                Path it2 = path;
                boolean bl = false;
                wSLDistribution = RsEelToolchain.Companion.canUseEel(it2) ? null : WslPath.Companion.getDistributionByWindowsUncPath(((Object)it2).toString());
            } else {
                wSLDistribution = null;
            }
            WSLDistribution distribution = wSLDistribution;
            RsToolchainBase rsToolchainBase = toolchain2 = distribution != null && (sequence4 = RsWslToolchainFlavorKt.getHomePathCandidates(distribution)) != null && (sequence3 = SequencesKt.filter(sequence4, Companion::suggest$lambda$1)) != null && (sequence2 = SequencesKt.mapNotNull((Sequence)sequence3, Companion::suggest$lambda$2)) != null ? (RsToolchainBase)SequencesKt.firstOrNull((Sequence)sequence2) : null;
            if (rsToolchainBase != null) {
                return rsToolchainBase;
            }
            return (RsToolchainBase)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatten((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)RsToolchainFlavor.Companion.getApplicableFlavors(projectDir)), arg_0 -> Companion.suggest$lambda$3(projectDir, arg_0))), Companion::suggest$lambda$4));
        }

        public static /* synthetic */ RsToolchainBase suggest$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                path = null;
            }
            return companion.suggest(path);
        }

        @JvmOverloads
        @Nullable
        public final RsToolchainBase suggest() {
            return org.rust.cargo.toolchain.RsToolchainBase$Companion.suggest$default(this, null, 1, null);
        }

        private static final boolean suggest$lambda$1(Path it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return RsToolchainFlavor.Companion.getFlavor(it2) != null;
        }

        private static final RsToolchainBase suggest$lambda$2(Path it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            Path path = it2.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            return RsToolchainProvider.Companion.getToolchain(path);
        }

        private static final Sequence suggest$lambda$3(Path $projectDir, RsToolchainFlavor it2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            Companion companion = Companion;
            try {
                Companion $this$suggest_u24lambda_u243_u240 = companion;
                boolean bl = false;
                object = Result.constructor-impl(it2.suggestHomePaths($projectDir));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            return (Sequence)LoggerKt.getOrLogException((Object)object, (Logger)LOG);
        }

        private static final RsToolchainBase suggest$lambda$4(Path it2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            Companion companion = Companion;
            try {
                Companion $this$suggest_u24lambda_u244_u240 = companion;
                boolean bl = false;
                Path path = it2.toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
                object = Result.constructor-impl((Object)RsToolchainProvider.Companion.getToolchain(path));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            return (RsToolchainBase)LoggerKt.getOrLogException((Object)object, (Logger)LOG);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BacktraceMode.values().length];
            try {
                nArray[BacktraceMode.SHORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BacktraceMode.FULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BacktraceMode.NO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

