/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.toolchain;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/rust/cargo/toolchain/RsLocalToolchain;", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "location", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "fileSeparator", "", "getFileSeparator", "()Ljava/lang/String;", "executionTimeoutInMilliseconds", "", "getExecutionTimeoutInMilliseconds", "()I", "patchCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "commandLine", "withSudo", "", "toLocalPath", "remotePath", "toRemotePath", "localPath", "expandUserHome", "getExecutableName", "toolName", "pathToExecutable", "hasExecutable", "exec", "hasCargoExecutable", "intellij.rustrover.core"})
public class RsLocalToolchain
extends RsToolchainBase {
    private final int executionTimeoutInMilliseconds;

    public RsLocalToolchain(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(location);
        this.executionTimeoutInMilliseconds = 1000;
    }

    @Override
    @NotNull
    public String getFileSeparator() {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        return string;
    }

    @Override
    public int getExecutionTimeoutInMilliseconds() {
        return this.executionTimeoutInMilliseconds;
    }

    @Override
    @NotNull
    public GeneralCommandLine patchCommandLine(@NotNull GeneralCommandLine commandLine, boolean withSudo) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return commandLine;
    }

    @Override
    @NotNull
    public String toLocalPath(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        return remotePath;
    }

    @Override
    @NotNull
    public String toRemotePath(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return localPath;
    }

    @Override
    @NotNull
    public String expandUserHome(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String string = OSAgnosticPathUtil.expandUserHome((String)remotePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandUserHome(...)");
        return string;
    }

    @Override
    @NotNull
    public String getExecutableName(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return OS.CURRENT == OS.Windows ? toolName + ".exe" : toolName;
    }

    @Override
    @NotNull
    public Path pathToExecutable(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return ToolchainUtilKt.pathToExecutable(this.getLocation(), toolName);
    }

    @Override
    public boolean hasExecutable(@NotNull String exec) {
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        return ToolchainUtilKt.hasExecutable(this.getLocation(), exec);
    }

    @Override
    public boolean hasCargoExecutable(@NotNull String exec) {
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        return UtilsKt.isExecutable(this.pathToCargoExecutable(exec));
    }
}

