/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.ui;

import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.RsCommandConfiguration;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.ui.WorkingDirectoryComponent;
import org.rust.cargo.util.RsCommandLineEditor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0004J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/rust/cargo/runconfig/ui/RsCommandConfigurationEditor;", "T", "Lorg/rust/cargo/runconfig/RsCommandConfiguration;", "Lcom/intellij/openapi/options/SettingsEditor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "command", "Lorg/rust/cargo/util/RsCommandLineEditor;", "getCommand", "()Lorg/rust/cargo/util/RsCommandLineEditor;", "emulateTerminal", "Ljavax/swing/JCheckBox;", "getEmulateTerminal", "()Ljavax/swing/JCheckBox;", "currentWorkspace", "Lorg/rust/cargo/project/workspace/CargoWorkspace;", "currentWorkingDirectory", "Ljava/nio/file/Path;", "getCurrentWorkingDirectory", "()Ljava/nio/file/Path;", "workingDirectory", "Lcom/intellij/openapi/ui/LabeledComponent;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getWorkingDirectory", "()Lcom/intellij/openapi/ui/LabeledComponent;", "resetEditorFrom", "", "configuration", "(Lorg/rust/cargo/runconfig/RsCommandConfiguration;)V", "applyEditorTo", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCommandConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCommandConfigurationEditor.kt\norg/rust/cargo/runconfig/ui/RsCommandConfigurationEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public abstract class RsCommandConfigurationEditor<T extends RsCommandConfiguration>
extends SettingsEditor<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final JCheckBox emulateTerminal;
    @NotNull
    private final LabeledComponent<TextFieldWithBrowseButton> workingDirectory;

    public RsCommandConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.emulateTerminal = ComponentsKt.CheckBox$default((String)RsBundle.INSTANCE.message("checkbox.emulate.terminal.in.output.console", new Object[0]), (boolean)RsCommandConfiguration.Companion.getEmulateTerminalDefault(), null, (int)4, null);
        this.workingDirectory = new WorkingDirectoryComponent();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract RsCommandLineEditor getCommand();

    @NotNull
    protected final JCheckBox getEmulateTerminal() {
        return this.emulateTerminal;
    }

    @Nullable
    protected final CargoWorkspace currentWorkspace() {
        CargoProject cargoProject = CargoCommandConfiguration.Companion.findCargoProject(this.project, this.getCommand().getText(), this.getCurrentWorkingDirectory());
        return cargoProject != null ? cargoProject.getWorkspace() : null;
    }

    @Nullable
    protected final Path getCurrentWorkingDirectory() {
        Path path;
        String string = StringKt.nullize$default((String)((TextFieldWithBrowseButton)this.workingDirectory.getComponent()).getText(), (boolean)false, (int)1, null);
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            path = Paths.get(it2, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    @NotNull
    protected final LabeledComponent<TextFieldWithBrowseButton> getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        RsCommandLineEditor rsCommandLineEditor = this.getCommand();
        String string = ((RsCommandConfiguration)((Object)configuration)).getProgramParameters();
        if (string == null) {
            string = "";
        }
        rsCommandLineEditor.setText(string);
        TextFieldWithBrowseButton textFieldWithBrowseButton = (TextFieldWithBrowseButton)this.workingDirectory.getComponent();
        String string2 = ((RsCommandConfiguration)((Object)configuration)).getWorkingDirectory();
        if (string2 == null) {
            string2 = "";
        }
        textFieldWithBrowseButton.setText(string2);
        this.emulateTerminal.setSelected(((RsCommandConfiguration)((Object)configuration)).getEmulateTerminal());
    }

    protected void applyEditorTo(@NotNull T configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        ((RsCommandConfiguration)((Object)configuration)).setProgramParameters(this.getCommand().getText());
        Path path = this.getCurrentWorkingDirectory();
        ((RsCommandConfiguration)((Object)configuration)).setWorkingDirectory(path != null ? ((Object)path).toString() : null);
        ((RsCommandConfiguration)((Object)configuration)).setEmulateTerminal(this.emulateTerminal.isSelected());
    }
}

