/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.ui.TargetAwareRunConfigurationEditor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.RsCommandConfiguration;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.target.BuildTarget;
import org.rust.cargo.runconfig.ui.RsCommandConfigurationEditor;
import org.rust.cargo.toolchain.BacktraceMode;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.RustChannel;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.cargo.util.CargoCommandCompletionProvider;
import org.rust.cargo.util.RsCommandLineEditor;
import org.rust.ide.experiments.RsExperiments;
import org.rust.openapiext.UiKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0002H\u0014J\u0010\u0010,\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0002H\u0014J\b\u0010-\u001a\u00020\tH\u0014J\u0012\u0010.\u001a\u00020#2\b\u0010/\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u00100\u001a\u00020#H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/rust/cargo/runconfig/ui/CargoCommandConfigurationEditor;", "Lorg/rust/cargo/runconfig/ui/RsCommandConfigurationEditor;", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "Lcom/intellij/execution/ui/TargetAwareRunConfigurationEditor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Ljavax/swing/JComponent;", "isRemoteTarget", "", "()Z", "command", "Lorg/rust/cargo/util/RsCommandLineEditor;", "getCommand", "()Lorg/rust/cargo/util/RsCommandLineEditor;", "allCargoProjects", "", "Lorg/rust/cargo/project/model/CargoProject;", "backtraceMode", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/rust/cargo/toolchain/BacktraceMode;", "channel", "Lorg/rust/cargo/toolchain/RustChannel;", "cargoProject", "redirectInput", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "redirectInputPath", "", "getRedirectInputPath", "()Ljava/lang/String;", "isRedirectInput", "Ljavax/swing/JCheckBox;", "setWorkingDirectoryFromSelectedProject", "", "environmentVariables", "Lcom/intellij/execution/configuration/EnvironmentVariablesComponent;", "requiredFeatures", "allFeatures", "withSudo", "buildOnRemoteTarget", "resetEditorFrom", "configuration", "applyEditorTo", "createEditor", "targetChanged", "targetName", "hideUnsupportedFieldsIfNeeded", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoCommandConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoCommandConfigurationEditor.kt\norg/rust/cargo/runconfig/ui/CargoCommandConfigurationEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1056#2:212\n1056#2:213\n1869#2,2:214\n1056#2:216\n1869#2,2:217\n1869#2,2:219\n1#3:221\n*S KotlinDebug\n*F\n+ 1 CargoCommandConfigurationEditor.kt\norg/rust/cargo/runconfig/ui/CargoCommandConfigurationEditor\n*L\n58#1:212\n62#1:213\n63#1:214,2\n67#1:216\n68#1:217,2\n73#1:219,2\n*E\n"})
public final class CargoCommandConfigurationEditor
extends RsCommandConfigurationEditor<CargoCommandConfiguration>
implements TargetAwareRunConfigurationEditor {
    @Nullable
    private JComponent panel;
    @NotNull
    private final RsCommandLineEditor command;
    @NotNull
    private final List<CargoProject> allCargoProjects;
    @NotNull
    private final ComboBox<BacktraceMode> backtraceMode;
    @NotNull
    private final ComboBox<RustChannel> channel;
    @NotNull
    private final ComboBox<CargoProject> cargoProject;
    @NotNull
    private final TextFieldWithBrowseButton redirectInput;
    @NotNull
    private final JCheckBox isRedirectInput;
    @NotNull
    private final EnvironmentVariablesComponent environmentVariables;
    @NotNull
    private final JCheckBox requiredFeatures;
    @NotNull
    private final JCheckBox allFeatures;
    @NotNull
    private final JCheckBox withSudo;
    @NotNull
    private final JCheckBox buildOnRemoteTarget;

    /*
     * WARNING - void declaration
     */
    public CargoCommandConfigurationEditor(@NotNull Project project) {
        void $this$withSudo_u24lambda_u240;
        Object $this$isRedirectInput_u24lambda_u240;
        Object $this$redirectInput_u24lambda_u240;
        ComboBox $this$cargoProject_u24lambda_u240;
        ComboBox $this$channel_u24lambda_u240;
        ComboBox $this$backtraceMode_u24lambda_u240;
        Object it2;
        Iterable $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.command = new RsCommandLineEditor(project, new CargoCommandCompletionProvider(CargoProjectServiceKt.getCargoProjects(project), (Function0<? extends CargoWorkspace>)((Function0)() -> CargoCommandConfigurationEditor.command$lambda$0(this))));
        Iterable $this$sortedBy$iv2 = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
        boolean $i$f$sortedBy22 = false;
        this.allCargoProjects = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CargoProject it2 = (CargoProject)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it2.getPresentableName());
                it2 = (CargoProject)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it2.getPresentableName())));
            }
        });
        ComboBox $i$f$sortedBy22 = object = new ComboBox();
        CargoCommandConfigurationEditor cargoCommandConfigurationEditor = this;
        boolean bl = false;
        Iterable iterable = (Iterable)BacktraceMode.getEntries();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BacktraceMode it2 = (BacktraceMode)((Object)a);
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it2.getIndex());
                it2 = (BacktraceMode)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it2.getIndex()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (BacktraceMode)((Object)element$iv);
            boolean bl2 = false;
            $this$backtraceMode_u24lambda_u240.addItem(it2);
        }
        cargoCommandConfigurationEditor.backtraceMode = object;
        $this$backtraceMode_u24lambda_u240 = object = new ComboBox();
        cargoCommandConfigurationEditor = this;
        boolean bl3 = false;
        $this$forEach$iv = (Iterable)RustChannel.getEntries();
        $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RustChannel it2 = (RustChannel)((Object)a);
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it2.getIndex());
                it2 = (RustChannel)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it2.getIndex()));
            }
        });
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (RustChannel)((Object)element$iv);
            boolean bl4 = false;
            $this$channel_u24lambda_u240.addItem(it2);
        }
        cargoCommandConfigurationEditor.channel = object;
        $this$channel_u24lambda_u240 = object = new ComboBox();
        cargoCommandConfigurationEditor = this;
        boolean bl5 = false;
        $this$cargoProject_u24lambda_u240.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> CargoCommandConfigurationEditor.cargoProject$lambda$0$1(CargoCommandConfigurationEditor::cargoProject$lambda$0$0, arg_0)));
        $this$forEach$iv = this.allCargoProjects;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (CargoProject)element$iv;
            boolean bl6 = false;
            $this$cargoProject_u24lambda_u240.addItem(it2);
        }
        $this$cargoProject_u24lambda_u240.addItemListener(arg_0 -> CargoCommandConfigurationEditor.cargoProject$lambda$0$3(this, arg_0));
        cargoCommandConfigurationEditor.cargoProject = object;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFileDescriptor(...)");
        $this$cargoProject_u24lambda_u240 = object = UiKt.pathTextField$default(fileChooserDescriptor, (Disposable)this, "", null, 8, null);
        cargoCommandConfigurationEditor = this;
        boolean bl7 = false;
        $this$redirectInput_u24lambda_u240.setEnabled(false);
        cargoCommandConfigurationEditor.redirectInput = object;
        String string = ExecutionBundle.message((String)"redirect.input.from", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$redirectInput_u24lambda_u240 = object = ComponentsKt.CheckBox$default((String)string, (boolean)false, null, (int)4, null);
        cargoCommandConfigurationEditor = this;
        boolean bl8 = false;
        $this$isRedirectInput_u24lambda_u240.addChangeListener(arg_0 -> CargoCommandConfigurationEditor.isRedirectInput$lambda$0$0(this, (JCheckBox)$this$isRedirectInput_u24lambda_u240, arg_0));
        cargoCommandConfigurationEditor.isRedirectInput = object;
        this.environmentVariables = new EnvironmentVariablesComponent();
        this.requiredFeatures = ComponentsKt.CheckBox$default((String)RsBundle.INSTANCE.message("checkbox.implicitly.add.required.features.if.possible", new Object[0]), (boolean)true, null, (int)4, null);
        this.allFeatures = ComponentsKt.CheckBox$default((String)RsBundle.INSTANCE.message("checkbox.use.all.features.in.tests", new Object[0]), (boolean)false, null, (int)4, null);
        $this$isRedirectInput_u24lambda_u240 = object = ComponentsKt.CheckBox$default((String)(SystemInfo.isWindows ? RsBundle.INSTANCE.message("checkbox.run.with.administrator.privileges", new Object[0]) : RsBundle.INSTANCE.message("checkbox.run.with.root.privileges", new Object[0])), (boolean)false, null, (int)4, null);
        cargoCommandConfigurationEditor = this;
        boolean bl9 = false;
        $this$withSudo_u24lambda_u240.setEnabled(RsExperiments.INSTANCE.getBUILD_TOOL_WINDOW().asBoolean());
        cargoCommandConfigurationEditor.withSudo = object;
        this.buildOnRemoteTarget = ComponentsKt.CheckBox$default((String)RsBundle.INSTANCE.message("checkbox.build.on.remote.target", new Object[0]), (boolean)true, null, (int)4, null);
    }

    private final boolean isRemoteTarget() {
        return DataManager.getInstance().getDataContext((Component)this.panel).getData(SingleConfigurationConfigurable.RUN_ON_TARGET_NAME_KEY) != null;
    }

    @Override
    @NotNull
    public RsCommandLineEditor getCommand() {
        return this.command;
    }

    private final String getRedirectInputPath() {
        String string;
        String string2 = StringKt.nullize$default((String)this.redirectInput.getText(), (boolean)false, (int)1, null);
        if (string2 != null) {
            String it2 = string2;
            boolean bl = false;
            string = FileUtil.toSystemIndependentName((String)it2);
        } else {
            string = null;
        }
        return string;
    }

    private final void setWorkingDirectoryFromSelectedProject() {
        CargoCommandConfigurationEditor $this$setWorkingDirectoryFromSelectedProject_u24lambda_u240 = this;
        boolean bl = false;
        int idx = $this$setWorkingDirectoryFromSelectedProject_u24lambda_u240.cargoProject.getSelectedIndex();
        if (idx == -1) {
            return;
        }
        CargoProject selectedProject = (CargoProject)$this$setWorkingDirectoryFromSelectedProject_u24lambda_u240.cargoProject.getItemAt(idx);
        ((TextFieldWithBrowseButton)this.getWorkingDirectory().getComponent()).setText(((Object)selectedProject.getRootDirPath()).toString());
    }

    @Override
    protected void resetEditorFrom(@NotNull CargoCommandConfiguration configuration) {
        VirtualFile vFile;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        super.resetEditorFrom((RsCommandConfiguration)configuration);
        this.channel.setSelectedIndex(configuration.getChannel().getIndex());
        this.requiredFeatures.setSelected(configuration.getRequiredFeatures());
        this.allFeatures.setSelected(configuration.getAllFeatures());
        this.withSudo.setSelected(configuration.getWithSudo());
        this.buildOnRemoteTarget.setSelected(configuration.getBuildTarget().isRemote());
        this.backtraceMode.setSelectedIndex(configuration.getBacktrace().getIndex());
        this.environmentVariables.setEnvData(EnvironmentVariablesData.create(configuration.getEnvs(), (boolean)configuration.isPassParentEnvs()));
        Path path = this.getCurrentWorkingDirectory();
        if (path != null) {
            Path it2 = path;
            boolean bl = false;
            v1 = LocalFileSystem.getInstance().findFileByIoFile(it2.toFile());
        } else {
            v1 = vFile = null;
        }
        if (vFile == null) {
            this.cargoProject.setSelectedIndex(-1);
        } else {
            CargoProject projectForWd = CargoProjectServiceKt.getCargoProjects(this.getProject()).findProjectForFile(vFile);
            this.cargoProject.setSelectedIndex(CollectionsKt.indexOf(this.allCargoProjects, (Object)projectForWd));
        }
        this.isRedirectInput.setSelected(configuration.isRedirectInput());
        String string = configuration.getRedirectInputPath();
        if (string == null) {
            string = "";
        }
        this.redirectInput.setText(string);
        this.hideUnsupportedFieldsIfNeeded();
    }

    @Override
    protected void applyEditorTo(@NotNull CargoCommandConfiguration configuration) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        super.applyEditorTo((RsCommandConfiguration)configuration);
        RustChannel configChannel = RustChannel.Companion.fromIndex(this.channel.getSelectedIndex());
        configuration.setChannel(configChannel);
        configuration.setRequiredFeatures(this.requiredFeatures.isSelected());
        configuration.setAllFeatures(this.allFeatures.isSelected());
        configuration.setWithSudo(this.withSudo.isSelected());
        configuration.setBuildTarget(this.buildOnRemoteTarget.isSelected() ? BuildTarget.REMOTE : BuildTarget.LOCAL);
        configuration.setBacktrace(BacktraceMode.Companion.fromIndex(this.backtraceMode.getSelectedIndex()));
        Map map2 = this.environmentVariables.getEnvData().getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
        configuration.setEnvs(map2);
        configuration.setPassParentEnvs(this.environmentVariables.getEnvData().isPassParentEnvs());
        RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(this.getProject());
        if (toolchain2 instanceof RsWslToolchain && this.isRemoteTarget()) {
            throw new ConfigurationException(RsBundle.INSTANCE.message("dialog.message.run.targets.cannot.be.used.alongside.with.wsl.toolchain", new Object[0]));
        }
        RsToolchainBase rsToolchainBase = toolchain2;
        boolean rustupAvailable = rsToolchainBase != null ? RustupKt.isRustupAvailable(rsToolchainBase) : false;
        this.channel.setEnabled(rustupAvailable || configChannel != RustChannel.DEFAULT);
        if (!rustupAvailable && configChannel != RustChannel.DEFAULT) {
            throw new ConfigurationException(RsBundle.INSTANCE.message("dialog.message.channel.cannot.be.set.explicitly.because.rustup.not.available", new Object[0]));
        }
        configuration.setRedirectInput(this.isRedirectInput.isSelected());
        configuration.setRedirectInputPath(this.getRedirectInputPath());
        this.hideUnsupportedFieldsIfNeeded();
    }

    @NotNull
    protected JComponent createEditor() {
        DialogPanel dialogPanel;
        DialogPanel it2 = dialogPanel = BuilderKt.panel(arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0(this, arg_0));
        boolean bl = false;
        this.panel = (JComponent)it2;
        return (JComponent)dialogPanel;
    }

    public void targetChanged(@Nullable String targetName) {
        this.hideUnsupportedFieldsIfNeeded();
    }

    private final void hideUnsupportedFieldsIfNeeded() {
        UIUtil.invokeLaterIfNeeded(() -> CargoCommandConfigurationEditor.hideUnsupportedFieldsIfNeeded$lambda$0(this));
    }

    private static final CargoWorkspace command$lambda$0(CargoCommandConfigurationEditor this$0) {
        return this$0.currentWorkspace();
    }

    private static final String cargoProject$lambda$0$0(CargoProject it2) {
        return it2.getPresentableName();
    }

    private static final String cargoProject$lambda$0$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void cargoProject$lambda$0$3(CargoCommandConfigurationEditor this$0, ItemEvent it2) {
        this$0.setWorkingDirectoryFromSelectedProject();
    }

    private static final void isRedirectInput$lambda$0$0(CargoCommandConfigurationEditor this$0, JCheckBox $this_apply, ChangeEvent it2) {
        this$0.redirectInput.setEnabled($this_apply.isSelected());
    }

    private static final Unit createEditor$lambda$0(CargoCommandConfigurationEditor this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(RsBundle.INSTANCE.message("command", new Object[0]), arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$0(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$3(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$4(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$5(this$0, arg_0), (int)1, null);
        $this$panel.row((JLabel)this$0.environmentVariables.getLabel(), arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$6(this$0, arg_0));
        $this$panel.row((JLabel)this$0.getWorkingDirectory().getLabel(), arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$7(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$8(this$0, arg_0), (int)1, null);
        $this$panel.row(RsBundle.INSTANCE.message("backtrace", new Object[0]), arg_0 -> CargoCommandConfigurationEditor.createEditor$lambda$0$9(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$0(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        UiKt.fullWidthCell($this$row, (JComponent)this$0.getCommand()).resizableColumn();
        Cell.label$default((Cell)$this$row.cell((JComponent)this$0.channel), (String)RsBundle.INSTANCE.message("label.channel", new Object[0]), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$1(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.requiredFeatures);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$2(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.allFeatures);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$3(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getEmulateTerminal());
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$4(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.withSudo);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$5(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.buildOnRemoteTarget);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$6(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        UiKt.fullWidthCell($this$row, (JComponent)this$0.environmentVariables);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$7(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        UiKt.fullWidthCell($this$row, (JComponent)this$0.getWorkingDirectory()).resizableColumn();
        if (CargoProjectServiceKt.getCargoProjects(this$0.getProject()).getAllProjects().size() > 1) {
            $this$row.cell((JComponent)this$0.cargoProject);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$8(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.layout(RowLayout.LABEL_ALIGNED);
        $this$row.cell((JComponent)this$0.isRedirectInput);
        UiKt.fullWidthCell($this$row, (JComponent)this$0.redirectInput);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$9(CargoCommandConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.backtraceMode);
        return Unit.INSTANCE;
    }

    private static final void hideUnsupportedFieldsIfNeeded$lambda$0(CargoCommandConfigurationEditor this$0) {
        this$0.buildOnRemoteTarget.setVisible(this$0.isRemoteTarget());
    }
}

