/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.test;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.test.TestConfig;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/rust/cargo/runconfig/test/DirectoryTestConfig;", "Lorg/rust/cargo/runconfig/test/TestConfig;", "commandName", "", "targets", "", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "sourceElement", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/psi/PsiDirectory;)V", "getCommandName", "()Ljava/lang/String;", "getTargets", "()Ljava/util/List;", "getSourceElement", "()Lcom/intellij/psi/PsiDirectory;", "paths", "getPaths", "exact", "", "getExact", "()Z", "configurationName", "getConfigurationName", "intellij.rustrover.core"})
final class DirectoryTestConfig
implements TestConfig {
    @NotNull
    private final String commandName;
    @NotNull
    private final List<CargoWorkspace.Target> targets;
    @NotNull
    private final PsiDirectory sourceElement;
    @NotNull
    private final List<String> paths;
    private final boolean exact;

    public DirectoryTestConfig(@NotNull String commandName, @NotNull List<? extends CargoWorkspace.Target> targets, @NotNull PsiDirectory sourceElement) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        this.commandName = commandName;
        this.targets = targets;
        this.sourceElement = sourceElement;
        this.paths = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public List<CargoWorkspace.Target> getTargets() {
        return this.targets;
    }

    @NotNull
    public PsiDirectory getSourceElement() {
        return this.sourceElement;
    }

    @Override
    @NotNull
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public boolean getExact() {
        return this.exact;
    }

    @Override
    @NotNull
    public String getConfigurationName() {
        String string = StringUtil.pluralize((String)this.getCommandName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
        return UtilsKt.capitalized(string) + " in '" + this.getSourceElement().getName() + "'";
    }
}

