/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.test;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.runconfig.test.CargoTestLocator;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.openapiext.UtilsKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/rust/cargo/runconfig/test/CargoTestFailedLineManager;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "testStorage", "Lcom/intellij/execution/TestStateStorage;", "cache", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/rust/cargo/runconfig/test/CargoTestFailedLineManager$TestInfo;", "fileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "getTestInfo", "element", "Lcom/intellij/psi/PsiElement;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "getCallName", "parent", "TestInfo", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoTestFailedLineManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTestFailedLineManager.kt\norg/rust/cargo/runconfig/test/CargoTestFailedLineManager\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,124:1\n15#2:125\n382#3,7:126\n*S KotlinDebug\n*F\n+ 1 CargoTestFailedLineManager.kt\norg/rust/cargo/runconfig/test/CargoTestFailedLineManager\n*L\n47#1:125\n93#1:126,7\n*E\n"})
public final class CargoTestFailedLineManager
implements FileEditorManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestStateStorage testStorage;
    @NotNull
    private final Map<VirtualFile, Map<String, TestInfo>> cache;
    @NotNull
    private static final List<Class<? extends PsiElement>> SEARCH_CLASSES;

    public CargoTestFailedLineManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TestStateStorage testStateStorage = TestStateStorage.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)testStateStorage, (String)"getInstance(...)");
        this.testStorage = testStateStorage;
        this.cache = new ConcurrentHashMap();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map map2 = this.cache.remove(file);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        for (Map.Entry<String, TestInfo> entry2 : map2.entrySet()) {
            String url = entry2.getKey();
            TestInfo info = entry2.getValue();
            this.testStorage.writeState(url, info.getRecord());
        }
    }

    @Nullable
    public final TestInfo getTestInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SmartPsiElementPointer<PsiElement> $this$ancestorOrSelf$iv = element;
        boolean $i$f$ancestorOrSelf = false;
        RsFunction rsFunction = (RsFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsFunction.class, (boolean)false);
        if (rsFunction == null) {
            return null;
        }
        RsFunction function = rsFunction;
        TestInfo testInfo = this.getTestInfo(function);
        if (testInfo == null) {
            return null;
        }
        TestInfo info = testInfo;
        if (info.getFailedLine() == -1) {
            return null;
        }
        if (info.getMagnitude() < TestStateInfo.Magnitude.FAILED_INDEX.getValue()) {
            return null;
        }
        $this$ancestorOrSelf$iv = info.getPointer();
        if ($this$ancestorOrSelf$iv != null && ($i$f$ancestorOrSelf = $this$ancestorOrSelf$iv.getElement()) != null) {
            PsiElement it2 = $i$f$ancestorOrSelf;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2, element)) {
                return null;
            }
            CharSequence charSequence = info.getFailedMethod();
            if (!(charSequence == null || charSequence.length() == 0) && !Intrinsics.areEqual((Object)this.getCallName(it2), (Object)info.getFailedMethod())) {
                return null;
            }
            return info;
        }
        PsiFile file = element.getContainingFile();
        Intrinsics.checkNotNull((Object)file);
        Document document = UtilsKt.getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int line = info.getFailedLine() / 1000 - 1;
        int column = info.getFailedLine() % 1000 - 1;
        if (line >= document2.getLineCount()) {
            return null;
        }
        int offset = document2.getLineStartOffset(line) + column;
        RsBlock rsBlock = RsFunctionKt.getBlock(function);
        if (rsBlock == null) {
            return null;
        }
        RsBlock block = rsBlock;
        if (!block.getTextRange().contains(offset)) {
            return null;
        }
        PsiElement psiElement2 = file.findElementAt(offset);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement candidate = psiElement2;
        for (Class<? extends PsiElement> klass : SEARCH_CLASSES) {
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)candidate, klass, (boolean)false, (int)offset);
            if (psiElement3 == null) continue;
            PsiElement parent2 = psiElement3;
            String callName = this.getCallName(parent2);
            CharSequence charSequence = info.getFailedMethod();
            if (charSequence == null || charSequence.length() == 0) {
                info.getRecord().failedMethod = callName;
            } else if (!Intrinsics.areEqual((Object)callName, (Object)info.getFailedMethod())) {
                return null;
            }
            info.setPointer((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)parent2.getProject()).createSmartPsiElementPointer(parent2, file));
            if (!Intrinsics.areEqual((Object)parent2, element)) {
                return null;
            }
            return info;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final TestInfo getTestInfo(RsFunction function) {
        Map infoInFile;
        TestInfo info;
        Object object;
        void $this$getOrPut$iv;
        if (!RsFunctionKt.isTest(function)) {
            return null;
        }
        String url = CargoTestLocator.INSTANCE.getTestUrl(function);
        TestStateStorage.Record record = this.testStorage.getState(url);
        if (record == null) {
            return null;
        }
        TestStateStorage.Record state = record;
        PsiFile psiFile = function.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        PsiFile vFile = psiFile;
        Map<VirtualFile, Map<String, TestInfo>> map2 = this.cache;
        PsiFile key$iv = vFile;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new ConcurrentHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((info = (TestInfo)(infoInFile = (Map)object).get(url)) == null || !Intrinsics.areEqual((Object)state.date, (Object)info.getDate())) {
            info = new TestInfo(state, null, 2, null);
            infoInFile.put(url, info);
        }
        return info;
    }

    private final String getCallName(PsiElement parent2) {
        PsiElement psiElement2 = parent2;
        return psiElement2 instanceof RsCallExpr ? ((RsCallExpr)parent2).getExpr().getText() : (psiElement2 instanceof RsMethodCallExpr ? ((RsMethodCallExpr)parent2).getMethodCall().getIdentifier().getText() : (psiElement2 instanceof RsMacroCall ? ((RsMacroCall)parent2).getPath().getText() : null));
    }

    static {
        Object[] objectArray = new Class[]{RsCallExpr.class, RsDotExpr.class, RsMacroCall.class};
        SEARCH_CLASSES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/runconfig/test/CargoTestFailedLineManager$Companion;", "", "<init>", "()V", "SEARCH_CLASSES", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/rust/cargo/runconfig/test/CargoTestFailedLineManager$TestInfo;", "", "record", "Lcom/intellij/execution/TestStateStorage$Record;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/execution/TestStateStorage$Record;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getRecord", "()Lcom/intellij/execution/TestStateStorage$Record;", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "setPointer", "(Lcom/intellij/psi/SmartPsiElementPointer;)V", "magnitude", "", "getMagnitude", "()I", "failedLine", "getFailedLine", "failedMethod", "", "getFailedMethod", "()Ljava/lang/String;", "errorMessage", "getErrorMessage", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "intellij.rustrover.core"})
    public static final class TestInfo {
        @NotNull
        private final TestStateStorage.Record record;
        @Nullable
        private SmartPsiElementPointer<PsiElement> pointer;

        public TestInfo(@NotNull TestStateStorage.Record record, @Nullable SmartPsiElementPointer<PsiElement> pointer) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.record = record;
            this.pointer = pointer;
        }

        public /* synthetic */ TestInfo(TestStateStorage.Record record, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                smartPsiElementPointer = null;
            }
            this(record, (SmartPsiElementPointer<PsiElement>)smartPsiElementPointer);
        }

        @NotNull
        public final TestStateStorage.Record getRecord() {
            return this.record;
        }

        @Nullable
        public final SmartPsiElementPointer<PsiElement> getPointer() {
            return this.pointer;
        }

        public final void setPointer(@Nullable SmartPsiElementPointer<PsiElement> smartPsiElementPointer) {
            this.pointer = smartPsiElementPointer;
        }

        public final int getMagnitude() {
            return this.record.magnitude;
        }

        public final int getFailedLine() {
            return this.record.failedLine;
        }

        @Nullable
        public final String getFailedMethod() {
            return this.record.failedMethod;
        }

        @NotNull
        public final String getErrorMessage() {
            String string = this.record.errorMessage;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorMessage");
            return string;
        }

        @NotNull
        public final Date getDate() {
            Date date = this.record.date;
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
            return date;
        }
    }
}

