/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.test;

import com.google.gson.JsonObject;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.impl.CargoProjectImplKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.runconfig.test.CargoTestEventsConverterKt;
import org.rust.cargo.runconfig.test.CargoTestLocator;
import org.rust.cargo.runconfig.test.DiffResult;
import org.rust.cargo.runconfig.test.ErrorMessage;
import org.rust.cargo.runconfig.test.FailedTestOutput;
import org.rust.cargo.runconfig.test.LibtestBenchMessage;
import org.rust.cargo.runconfig.test.LibtestSuiteMessage;
import org.rust.cargo.runconfig.test.LibtestTestMessage;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.openapiext.JsonUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010#\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u0000 @2\u00020\u0001:\u0002@AB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020\u0003H\u0002J$\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$H\u0002J$\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u00100\u001a\u000201H\u0002J\u0018\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\u0006\u00102\u001a\u000203H\u0002J\u0014\u00104\u001a\u00020&2\n\u00105\u001a\u00060\u0003j\u0002`\u0010H\u0002J\u0014\u00106\u001a\u00020&2\n\u00107\u001a\u00060\u0003j\u0002`\u0010H\u0002J\u0014\u00108\u001a\u00020&2\n\u00107\u001a\u00060\u0003j\u0002`\u0010H\u0002J\u0014\u00109\u001a\u00020\u00032\n\u00105\u001a\u00060\u0003j\u0002`\u0010H\u0002J\u0016\u0010:\u001a\u00020&2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020-0\u000fH\u0002J\u001e\u0010<\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00100=2\n\u0010>\u001a\u00060\u0003j\u0002`\u0010H\u0002J\"\u0010?\u001a\u00020&2\n\u00107\u001a\u00060\u0003j\u0002`\u00102\f\u0010;\u001a\b\u0012\u0004\u0012\u00020-0\u000fH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\u0003j\u0002`\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\u0003j\u0002`\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R(\u0010\u0016\u001a\u001c\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0003j\u0002`\u00100\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\u0004\u0012\u00020\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00100\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/rust/cargo/runconfig/test/CargoTestEventsConverter;", "Lcom/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter;", "testFrameworkName", "", "consoleProperties", "Lcom/intellij/execution/testframework/TestConsoleProperties;", "rustcVersion", "Lcom/intellij/util/text/SemVer;", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/testframework/TestConsoleProperties;Lcom/intellij/util/text/SemVer;)V", "project", "Lcom/intellij/openapi/project/Project;", "converterState", "Lorg/rust/cargo/runconfig/test/CargoTestEventsConverter$State;", "suitesStack", "", "Lorg/rust/cargo/runconfig/test/NodeId;", "target", "getTarget", "()Ljava/lang/String;", "currentSuite", "getCurrentSuite", "suitesToNotFinishedChildren", "", "", "testsStartTimes", "", "pendingFinishedSuites", "doctestPackageCounter", "", "processServiceMessages", "", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "visitor", "Ljetbrains/buildServer/messages/serviceMessages/ServiceMessageVisitor;", "handleStartMessage", "", "handleTestMessage", "jsonObject", "Lcom/google/gson/JsonObject;", "handleSuiteMessage", "createServiceMessagesFor", "", "Lcom/intellij/execution/testframework/sm/ServiceMessageBuilder;", "testMessage", "Lorg/rust/cargo/runconfig/test/LibtestTestMessage;", "benchMessage", "Lorg/rust/cargo/runconfig/test/LibtestBenchMessage;", "suiteMessage", "Lorg/rust/cargo/runconfig/test/LibtestSuiteMessage;", "recordTestStartTime", "test", "recordSuiteChildStarted", "node", "recordSuiteChildFinished", "getTestDuration", "processFinishedSuites", "messages", "getNotFinishedChildren", "", "suite", "recursivelyInitContainingSuite", "Companion", "State", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoTestEventsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTestEventsConverter.kt\norg/rust/cargo/runconfig/test/CargoTestEventsConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,472:1\n1#2:473\n1634#3,3:474\n1634#3,3:477\n382#4,7:480\n*S KotlinDebug\n*F\n+ 1 CargoTestEventsConverter.kt\norg/rust/cargo/runconfig/test/CargoTestEventsConverter\n*L\n205#1:474,3\n207#1:477,3\n221#1:480,7\n*E\n"})
public final class CargoTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SemVer rustcVersion;
    @NotNull
    private final Project project;
    @NotNull
    private State converterState;
    @NotNull
    private final List<String> suitesStack;
    @NotNull
    private final Map<String, Set<String>> suitesToNotFinishedChildren;
    @NotNull
    private final Map<String, Long> testsStartTimes;
    @NotNull
    private final Set<String> pendingFinishedSuites;
    private int doctestPackageCounter;
    @NotNull
    private static final SemVer RUSTC_1_73_BETA = ToolchainUtilKt.parseSemVer("1.73.0-beta");
    @NotNull
    private static final String TARGET_PATH_PART = "/target/";
    @NotNull
    private static final String ROOT_SUITE = "0";
    @NotNull
    private static final String NAME_SEPARATOR = "::";
    @NotNull
    private static final String DOCTESTS_SUFFIX = "doctests";
    @NotNull
    private static final Regex NAME_RE = new Regex("\"name\":\\s*\"(?<name>[^\"]+)\"");
    @NotNull
    private static final Regex LINE_NUMBER_RE = new Regex("\\s+\\(line\\s+(?<line>\\d+)\\)\\s*");
    @NotNull
    private static final Regex ERROR_MESSAGE_RE_OLD;
    @NotNull
    private static final Regex ERROR_MESSAGE_RE;

    public CargoTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @Nullable SemVer rustcVersion) {
        Intrinsics.checkNotNullParameter((Object)testFrameworkName, (String)"testFrameworkName");
        Intrinsics.checkNotNullParameter((Object)consoleProperties, (String)"consoleProperties");
        super(testFrameworkName, consoleProperties);
        this.rustcVersion = rustcVersion;
        Project project = consoleProperties.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.converterState = State.START_MESSAGE;
        this.suitesStack = new ArrayList();
        this.suitesToNotFinishedChildren = new HashMap();
        this.testsStartTimes = new HashMap();
        this.pendingFinishedSuites = new LinkedHashSet();
    }

    private final String getTarget() {
        String string = (String)CollectionsKt.firstOrNull(this.suitesStack);
        if (string == null) {
            string = ROOT_SUITE;
        }
        return string;
    }

    private final String getCurrentSuite() {
        String string = (String)CollectionsKt.lastOrNull(this.suitesStack);
        if (string == null) {
            string = ROOT_SUITE;
        }
        return string;
    }

    protected boolean processServiceMessages(@NotNull String text, @NotNull Key<?> outputType, @NotNull ServiceMessageVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.handleStartMessage(text);
        CharSequence charSequence = text;
        Regex regex = NAME_RE;
        Function1 function1 = CargoTestEventsConverter::processServiceMessages$lambda$0;
        String escapedText = regex.replace(charSequence, function1);
        JsonObject jsonObject = JsonUtils.tryParseJsonObject$default(JsonUtils.INSTANCE, escapedText, false, 2, null);
        return jsonObject == null ? false : (this.handleTestMessage(jsonObject, outputType, visitor2) ? true : (this.handleSuiteMessage(jsonObject, outputType, visitor2) ? true : true));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleStartMessage(String text) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.converterState.ordinal()]) {
            case 1: {
                State state;
                String string = ((Object)StringsKt.trim((CharSequence)text)).toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String clean = string;
                CargoTestEventsConverter cargoTestEventsConverter = this;
                if (Intrinsics.areEqual((Object)clean, (Object)"running")) {
                    state = State.EXECUTABLE_NAME;
                } else if (Intrinsics.areEqual((Object)clean, (Object)"doc-tests")) {
                    state = State.DOCTESTS_PACKAGE_NAME;
                } else {
                    String string2;
                    void it2;
                    String string3;
                    String string4;
                    String string5;
                    if (!StringsKt.contains$default((CharSequence)text, (CharSequence)TARGET_PATH_PART, (boolean)false, (int)2, null)) return;
                    List list = ParametersListUtil.parse((String)text);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
                    String string6 = (String)CollectionsKt.firstOrNull((List)list);
                    if (string6 == null || (string5 = StringsKt.substringAfterLast$default((String)string6, (String)"/", null, (int)2, null)) == null || (string4 = StringsKt.substringBeforeLast$default((String)string5, (String)".", null, (int)2, null)) == null) throw new IllegalStateException("Can't parse the executable name".toString());
                    String string7 = string3 = string4;
                    CargoTestEventsConverter cargoTestEventsConverter2 = cargoTestEventsConverter;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it2).length() > 0;
                    cargoTestEventsConverter = cargoTestEventsConverter2;
                    String string8 = string2 = bl2 ? string3 : null;
                    if (string2 == null) {
                        throw new IllegalStateException("Can't parse the executable name".toString());
                    }
                    String executableName = string2;
                    this.suitesStack.add(executableName);
                    state = State.START_MESSAGE;
                }
                cargoTestEventsConverter.converterState = state;
                return;
            }
            case 2: {
                String string = ((Object)StringsKt.trim((CharSequence)text)).toString();
                Object object = RustProjectSettingsServiceKt.getToolchain(this.project);
                if (object == null || (object = ((RsToolchainBase)object).getFileSeparator()) == null) {
                    object = File.separator;
                }
                Object object2 = object;
                Intrinsics.checkNotNull((Object)object2);
                Object it3 = object2 = StringsKt.removeSuffix((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)string, (String)object2, null, (int)2, null), (String)".", null, (int)2, null), (CharSequence)")");
                boolean bl = false;
                Object object3 = ((CharSequence)it3).length() > 0 ? object2 : null;
                if (object3 == null) {
                    throw new IllegalStateException("Can't parse the executable name".toString());
                }
                Object executableName = object3;
                this.suitesStack.add((String)executableName);
                this.converterState = State.START_MESSAGE;
                return;
            }
            case 3: {
                String packageName = ((Object)StringsKt.trim((CharSequence)text)).toString();
                CargoWorkspace.Target target = CargoTestEventsConverter.Companion.findLibTargetForPackageName(this.project, packageName);
                String libTargetName = target != null ? target.getNormName() : null;
                String string = libTargetName;
                if (string == null) {
                    string = packageName;
                }
                int n = this.doctestPackageCounter;
                this.doctestPackageCounter = n + 1;
                String targetNameWithSuffix = string + "-" + n + DOCTESTS_SUFFIX;
                this.suitesStack.add(targetNameWithSuffix);
                this.converterState = State.START_MESSAGE;
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean handleTestMessage(JsonObject jsonObject, Key<?> outputType, ServiceMessageVisitor visitor2) {
        List<ServiceMessageBuilder> list;
        Object object = LibtestTestMessage.Companion.fromJson(jsonObject);
        if (object == null) {
            object = LibtestBenchMessage.Companion.fromJson(jsonObject);
        }
        LibtestTestMessage libtestMessage = object;
        if (libtestMessage instanceof LibtestTestMessage) {
            String qualifiedName = StringsKt.substringAfter$default((String)libtestMessage.getName(), (String)" - ", null, (int)2, null);
            LibtestTestMessage fixedMessage = LibtestTestMessage.copy$default(libtestMessage, null, null, this.getTarget() + NAME_SEPARATOR + qualifiedName, null, 11, null);
            list = this.createServiceMessagesFor(fixedMessage);
            if (list == null) {
                return false;
            }
        } else if (libtestMessage instanceof LibtestBenchMessage) {
            LibtestBenchMessage fixedMessage = LibtestBenchMessage.copy$default((LibtestBenchMessage)((Object)libtestMessage), null, this.getTarget() + NAME_SEPARATOR + ((LibtestBenchMessage)((Object)libtestMessage)).getName(), null, null, 13, null);
            list = this.createServiceMessagesFor(fixedMessage);
        } else {
            return false;
        }
        List<ServiceMessageBuilder> serviceMessages = list;
        for (ServiceMessageBuilder message : serviceMessages) {
            super.processServiceMessages(message.toString(), outputType, visitor2);
        }
        return true;
    }

    private final boolean handleSuiteMessage(JsonObject jsonObject, Key<?> outputType, ServiceMessageVisitor visitor2) {
        LibtestSuiteMessage libtestSuiteMessage = LibtestSuiteMessage.Companion.fromJson(jsonObject);
        if (libtestSuiteMessage == null) {
            return false;
        }
        LibtestSuiteMessage suiteMessage = libtestSuiteMessage;
        List<ServiceMessageBuilder> list = this.createServiceMessagesFor(suiteMessage);
        if (list == null) {
            return false;
        }
        List<ServiceMessageBuilder> messages = list;
        for (ServiceMessageBuilder message : messages) {
            super.processServiceMessages(message.toString(), outputType, visitor2);
        }
        return true;
    }

    private final List<ServiceMessageBuilder> createServiceMessagesFor(LibtestTestMessage testMessage) {
        List messages = new ArrayList();
        switch (testMessage.getEvent()) {
            case "started": {
                this.recordTestStartTime(testMessage.getName());
                this.recursivelyInitContainingSuite(testMessage.getName(), messages);
                this.recordSuiteChildStarted(testMessage.getName());
                messages.add(CargoTestEventsConverter.Companion.createTestStartedMessage(testMessage.getName()));
                break;
            }
            case "ok": {
                String duration = this.getTestDuration(testMessage.getName());
                CharSequence charSequence = testMessage.getStdout();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    messages.add(CargoTestEventsConverter.Companion.createTestStdOutMessage(testMessage.getName(), testMessage.getStdout()));
                }
                messages.add(CargoTestEventsConverter.Companion.createTestFinishedMessage(testMessage.getName(), duration));
                this.recordSuiteChildFinished(testMessage.getName());
                this.processFinishedSuites(messages);
                break;
            }
            case "failed": {
                String duration = this.getTestDuration(testMessage.getName());
                String string = testMessage.getStdout();
                if (string == null) {
                    string = "";
                }
                FailedTestOutput failedTestOutput = CargoTestEventsConverter.Companion.parseFailedTestOutput(string);
                String stdout = failedTestOutput.component1();
                String failedMessage = failedTestOutput.component2();
                if (((CharSequence)stdout).length() > 0) {
                    messages.add(CargoTestEventsConverter.Companion.createTestStdOutMessage(testMessage.getName(), stdout + "\n"));
                }
                messages.add(CargoTestEventsConverter.Companion.createTestFailedMessage(testMessage.getName(), failedMessage, this.rustcVersion));
                messages.add(CargoTestEventsConverter.Companion.createTestFinishedMessage(testMessage.getName(), duration));
                this.recordSuiteChildFinished(testMessage.getName());
                this.processFinishedSuites(messages);
                break;
            }
            case "ignored": {
                messages.add(CargoTestEventsConverter.Companion.createTestIgnoredMessage(testMessage.getName()));
                break;
            }
            default: {
                return null;
            }
        }
        return messages;
    }

    private final List<ServiceMessageBuilder> createServiceMessagesFor(LibtestBenchMessage benchMessage) {
        List messages = new ArrayList();
        String result2 = benchMessage.getMedian() + " ns/iter (+/- " + benchMessage.getDeviation() + ")\n";
        messages.add(CargoTestEventsConverter.Companion.createTestStdOutMessage(benchMessage.getName(), result2));
        String duration = this.getTestDuration(benchMessage.getName());
        messages.add(CargoTestEventsConverter.Companion.createTestFinishedMessage(benchMessage.getName(), duration));
        this.recordSuiteChildFinished(benchMessage.getName());
        this.processFinishedSuites(messages);
        return messages;
    }

    private final List<ServiceMessageBuilder> createServiceMessagesFor(LibtestSuiteMessage suiteMessage) {
        List messages = new ArrayList();
        switch (suiteMessage.getEvent()) {
            case "started": {
                this.getProcessor().onTestsReporterAttached();
                if (Integer.parseInt(suiteMessage.getTest_count()) == 0) {
                    return CollectionsKt.emptyList();
                }
                messages.add(CargoTestEventsConverter.Companion.createTestSuiteStartedMessage(this.getTarget()));
                messages.add(CargoTestEventsConverter.Companion.createTestCountMessage(suiteMessage.getTest_count()));
                break;
            }
            case "failed": 
            case "ok": {
                String it2;
                Collection collection;
                Iterable $this$mapTo$iv;
                Iterable iterable = this.pendingFinishedSuites;
                Collection destination$iv = messages;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    String string = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    collection.add(CargoTestEventsConverter.Companion.createTestSuiteFinishedMessage(it2));
                }
                this.pendingFinishedSuites.clear();
                $this$mapTo$iv = CollectionsKt.reversed((Iterable)this.suitesStack);
                destination$iv = messages;
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    it2 = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    collection.add(CargoTestEventsConverter.Companion.createTestSuiteFinishedMessage(it2));
                }
                this.suitesStack.clear();
                this.testsStartTimes.clear();
                break;
            }
            default: {
                return null;
            }
        }
        return messages;
    }

    private final void recordTestStartTime(String test) {
        this.testsStartTimes.put(test, System.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    private final void recordSuiteChildStarted(String node) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, Set<String>> map2 = this.suitesToNotFinishedChildren;
        String key$iv = CargoTestEventsConverter.Companion.getParent(node);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(node);
    }

    private final void recordSuiteChildFinished(String node) {
        block0: {
            Set<String> set = this.suitesToNotFinishedChildren.get(CargoTestEventsConverter.Companion.getParent(node));
            if (set == null) break block0;
            set.remove(node);
        }
    }

    private final String getTestDuration(String test) {
        Long l = this.testsStartTimes.get(test);
        if (l == null) {
            return ROOT_SUITE;
        }
        long startTime = l;
        long endTime = System.currentTimeMillis();
        return String.valueOf(endTime - startTime);
    }

    private final void processFinishedSuites(List<ServiceMessageBuilder> messages) {
        Iterator<String> iterator2 = this.pendingFinishedSuites.iterator();
        while (iterator2.hasNext()) {
            String suite = iterator2.next();
            if (!this.getNotFinishedChildren(suite).isEmpty()) continue;
            messages.add(CargoTestEventsConverter.Companion.createTestSuiteFinishedMessage(suite));
            iterator2.remove();
        }
    }

    private final Set<String> getNotFinishedChildren(String suite) {
        Set set = this.suitesToNotFinishedChildren.get(suite);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void recursivelyInitContainingSuite(String node, List<ServiceMessageBuilder> messages) {
        String suite = CargoTestEventsConverter.Companion.getParent(node);
        if (Intrinsics.areEqual((Object)suite, (Object)this.getTarget())) {
            return;
        }
        while (!Intrinsics.areEqual((Object)suite, (Object)this.getCurrentSuite()) && !StringsKt.startsWith$default((String)suite, (String)(this.getCurrentSuite() + NAME_SEPARATOR), (boolean)false, (int)2, null)) {
            String lastSuite;
            Intrinsics.checkNotNullExpressionValue((Object)this.suitesStack.removeLast(), (String)"removeLast(...)");
            this.pendingFinishedSuites.add(lastSuite);
        }
        this.processFinishedSuites(messages);
        if (Intrinsics.areEqual((Object)suite, (Object)this.getCurrentSuite())) {
            return;
        }
        this.recursivelyInitContainingSuite(suite, messages);
        messages.add(CargoTestEventsConverter.Companion.createTestSuiteStartedMessage(suite));
        this.recordSuiteChildStarted(suite);
        this.suitesStack.add(suite);
    }

    private static final CharSequence processServiceMessages$lambda$0(MatchResult it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return StringsKt.replace$default((String)it2.getValue(), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
    }

    static {
        String string = "thread '.*' panicked at '(?<fullMessage>(assertion failed: `\\(left (?<sign>.*) right\\)`\\s*left: `(?<left>.*?)`,\\s*right: `(?<right>.*?)`(: )?)?(?<message>.*))',";
        Object object = new RegexOption[]{RegexOption.MULTILINE, RegexOption.DOT_MATCHES_ALL};
        object = SetsKt.setOf((Object[])object);
        ERROR_MESSAGE_RE_OLD = new Regex(string, (Set)object);
        string = "thread '.*' panicked at ([^\\n]*)\\n(?<fullMessage>(assertion `left (?<sign>.*) right` failed(: )?)?(?<message>.*?)\\n\\s*(left: (?<left>.*?)\\n\\s*right: (?<right>.*?)\\n)?)(note|stack backtrace):";
        object = new RegexOption[]{RegexOption.MULTILINE, RegexOption.DOT_MATCHES_ALL};
        object = SetsKt.setOf((Object[])object);
        ERROR_MESSAGE_RE = new Regex(string, (Set)object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0007j\u0002`\u0011H\u0002J\u0014\u0010\u0019\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0007j\u0002`\u0011H\u0002J\u0014\u0010\u001a\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0007j\u0002`\u0011H\u0002J&\u0010\u001c\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0007j\u0002`\u00112\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u0002J\u001c\u0010\u001f\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0007j\u0002`\u00112\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0014\u0010!\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0007j\u0002`\u0011H\u0002J\u001c\u0010\"\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0007j\u0002`\u00112\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u001c\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u0007*\u00060\u0007j\u0002`\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u00060\u0007j\u0002`\u0011*\u00060\u0007j\u0002`\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u00060"}, d2={"Lorg/rust/cargo/runconfig/test/CargoTestEventsConverter$Companion;", "", "<init>", "()V", "RUSTC_1_73_BETA", "Lcom/intellij/util/text/SemVer;", "TARGET_PATH_PART", "", "ROOT_SUITE", "NAME_SEPARATOR", "DOCTESTS_SUFFIX", "NAME_RE", "Lkotlin/text/Regex;", "LINE_NUMBER_RE", "ERROR_MESSAGE_RE_OLD", "ERROR_MESSAGE_RE", "name", "Lorg/rust/cargo/runconfig/test/NodeId;", "getName", "(Ljava/lang/String;)Ljava/lang/String;", "parent", "getParent", "createTestSuiteStartedMessage", "Lcom/intellij/execution/testframework/sm/ServiceMessageBuilder;", "suite", "createTestSuiteFinishedMessage", "createTestStartedMessage", "test", "createTestFailedMessage", "failedMessage", "rustcVersion", "createTestFinishedMessage", "duration", "createTestIgnoredMessage", "createTestStdOutMessage", "stdout", "createTestCountMessage", "testCount", "parseFailedTestOutput", "Lorg/rust/cargo/runconfig/test/FailedTestOutput;", "output", "parseErrorMessage", "Lorg/rust/cargo/runconfig/test/ErrorMessage;", "findLibTargetForPackageName", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "project", "Lcom/intellij/openapi/project/Project;", "packageName", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargoTestEventsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTestEventsConverter.kt\norg/rust/cargo/runconfig/test/CargoTestEventsConverter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,472:1\n1#2:473\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getName(String $this$name) {
            Object object;
            if (StringsKt.contains$default((CharSequence)$this$name, (CharSequence)CargoTestEventsConverter.NAME_SEPARATOR, (boolean)false, (int)2, null)) {
                object = StringsKt.substringAfterLast$default((String)$this$name, (String)CargoTestEventsConverter.NAME_SEPARATOR, null, (int)2, null);
            } else {
                void var2_2;
                String targetName = StringsKt.substringBeforeLast$default((String)$this$name, (String)"-", null, (int)2, null);
                object = StringsKt.endsWith$default((String)$this$name, (String)CargoTestEventsConverter.DOCTESTS_SUFFIX, (boolean)false, (int)2, null) ? targetName + " (doc-tests)" : var2_2;
            }
            return object;
        }

        private final String getParent(String $this$parent) {
            String parent2 = StringsKt.substringBeforeLast$default((String)$this$parent, (String)CargoTestEventsConverter.NAME_SEPARATOR, null, (int)2, null);
            return Intrinsics.areEqual((Object)$this$parent, (Object)parent2) ? CargoTestEventsConverter.ROOT_SUITE : parent2;
        }

        private final ServiceMessageBuilder createTestSuiteStartedMessage(String suite) {
            ServiceMessageBuilder serviceMessageBuilder = ServiceMessageBuilder.testSuiteStarted((String)this.getName(suite)).addAttribute("nodeId", suite).addAttribute("parentNodeId", this.getParent(suite)).addAttribute("locationHint", CargoTestLocator.INSTANCE.getTestUrl(suite));
            Intrinsics.checkNotNullExpressionValue((Object)serviceMessageBuilder, (String)"addAttribute(...)");
            return serviceMessageBuilder;
        }

        private final ServiceMessageBuilder createTestSuiteFinishedMessage(String suite) {
            ServiceMessageBuilder serviceMessageBuilder = ServiceMessageBuilder.testSuiteFinished((String)this.getName(suite)).addAttribute("nodeId", suite);
            Intrinsics.checkNotNullExpressionValue((Object)serviceMessageBuilder, (String)"addAttribute(...)");
            return serviceMessageBuilder;
        }

        private final ServiceMessageBuilder createTestStartedMessage(String test) {
            CharSequence charSequence = test;
            Regex regex = LINE_NUMBER_RE;
            Function1 function1 = Companion::createTestStartedMessage$lambda$0;
            String name2 = regex.replace(charSequence, function1);
            ServiceMessageBuilder serviceMessageBuilder = ServiceMessageBuilder.testStarted((String)this.getName(test)).addAttribute("nodeId", test).addAttribute("parentNodeId", this.getParent(test)).addAttribute("locationHint", CargoTestLocator.INSTANCE.getTestUrl(name2));
            Intrinsics.checkNotNullExpressionValue((Object)serviceMessageBuilder, (String)"addAttribute(...)");
            return serviceMessageBuilder;
        }

        private final ServiceMessageBuilder createTestFailedMessage(String test, String failedMessage, SemVer rustcVersion) {
            ServiceMessageBuilder builder = ServiceMessageBuilder.testFailed((String)this.getName(test)).addAttribute("nodeId", test).addAttribute("details", failedMessage);
            ErrorMessage parseResult = this.parseErrorMessage(failedMessage, rustcVersion);
            if (parseResult == null) {
                builder.addAttribute("message", "");
            } else {
                ErrorMessage errorMessage = parseResult;
                String message = errorMessage.component1();
                DiffResult diff = errorMessage.component2();
                builder.addAttribute("message", message);
                if (diff != null) {
                    builder.addAttribute("actual", diff.getLeft()).addAttribute("expected", diff.getRight());
                }
            }
            Intrinsics.checkNotNull((Object)builder);
            return builder;
        }

        private final ServiceMessageBuilder createTestFinishedMessage(String test, String duration) {
            ServiceMessageBuilder serviceMessageBuilder = ServiceMessageBuilder.testFinished((String)this.getName(test)).addAttribute("nodeId", test).addAttribute("duration", duration);
            Intrinsics.checkNotNullExpressionValue((Object)serviceMessageBuilder, (String)"addAttribute(...)");
            return serviceMessageBuilder;
        }

        private final ServiceMessageBuilder createTestIgnoredMessage(String test) {
            ServiceMessageBuilder serviceMessageBuilder = ServiceMessageBuilder.testIgnored((String)this.getName(test)).addAttribute("nodeId", test);
            Intrinsics.checkNotNullExpressionValue((Object)serviceMessageBuilder, (String)"addAttribute(...)");
            return serviceMessageBuilder;
        }

        private final ServiceMessageBuilder createTestStdOutMessage(String test, String stdout) {
            ServiceMessageBuilder serviceMessageBuilder = ServiceMessageBuilder.testStdOut((String)this.getName(test)).addAttribute("nodeId", test).addAttribute("out", stdout);
            Intrinsics.checkNotNullExpressionValue((Object)serviceMessageBuilder, (String)"addAttribute(...)");
            return serviceMessageBuilder;
        }

        private final ServiceMessageBuilder createTestCountMessage(String testCount) {
            ServiceMessageBuilder serviceMessageBuilder = new ServiceMessageBuilder("testCount").addAttribute("count", testCount);
            Intrinsics.checkNotNullExpressionValue((Object)serviceMessageBuilder, (String)"addAttribute(...)");
            return serviceMessageBuilder;
        }

        private final FailedTestOutput parseFailedTestOutput(String output) {
            Function1 partitionPredicate = Companion::parseFailedTestOutput$lambda$0;
            String stdout = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)StringsKt.lineSequence((CharSequence)output), (Function1)partitionPredicate), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            String failedMessage = SequencesKt.joinToString$default((Sequence)SequencesKt.dropWhile((Sequence)StringsKt.lineSequence((CharSequence)output), (Function1)partitionPredicate), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            return new FailedTestOutput(stdout, failedMessage);
        }

        private final ErrorMessage parseErrorMessage(String failedMessage, SemVer rustcVersion) {
            DiffResult diffResult;
            Regex regex = rustcVersion == null || rustcVersion.compareTo(RUSTC_1_73_BETA) < 0 ? ERROR_MESSAGE_RE_OLD : ERROR_MESSAGE_RE;
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)failedMessage, (int)0, (int)2, null);
            if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
                return null;
            }
            MatchResult groups = matchResult;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"message");
            String string = StringKt.nullize$default((String)(matchGroup2 != null ? matchGroup2.getValue() : null), (boolean)false, (int)1, null);
            if (string == null) {
                MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"fullMessage");
                string = matchGroup3 != null ? matchGroup3.getValue() : null;
                if (string == null) {
                    throw new IllegalStateException("Failed to find `message` or `fullMessage` capturing group".toString());
                }
            }
            String message = string;
            MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"sign");
            if (Intrinsics.areEqual((Object)(matchGroup4 != null ? matchGroup4.getValue() : null), (Object)"==")) {
                String right;
                Object object;
                String left;
                Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"left");
                if (object2 != null && (object2 = object2.getValue()) != null) {
                    Object p0 = object2;
                    boolean bl = false;
                    v6 = CargoTestEventsConverterKt.access$unescape((String)p0);
                } else {
                    v6 = left = null;
                }
                if ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"right")) != null && (object = object.getValue()) != null) {
                    Object p0 = object;
                    boolean bl = false;
                    v8 = CargoTestEventsConverterKt.access$unescape((String)p0);
                } else {
                    v8 = right = null;
                }
                diffResult = left != null && right != null ? new DiffResult(left, right) : null;
            } else {
                diffResult = null;
            }
            DiffResult diff = diffResult;
            return new ErrorMessage(message, diff, null);
        }

        private final CargoWorkspace.Target findLibTargetForPackageName(Project project, String packageName) {
            return (CargoWorkspace.Target)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(CargoProjectImplKt.getAllPackages(CargoProjectServiceKt.getCargoProjects(project)), Companion::findLibTargetForPackageName$lambda$0), Companion::findLibTargetForPackageName$lambda$1), arg_0 -> Companion.findLibTargetForPackageName$lambda$2(packageName, arg_0)));
        }

        private static final CharSequence createTestStartedMessage$lambda$0(MatchResult it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it2.getGroups(), (String)"line");
            if (object == null || (object = object.getValue()) == null) {
                throw new IllegalStateException("Failed to find `line` capturing group".toString());
            }
            Object line = object;
            return "#" + Integer.parseInt((String)line);
        }

        private static final boolean parseFailedTestOutput$lambda$0(String it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return !StringsKt.startsWith((String)((Object)StringsKt.trimStart((CharSequence)it2)).toString(), (String)"thread", (boolean)true);
        }

        private static final boolean findLibTargetForPackageName$lambda$0(CargoWorkspace.Package it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return it2.getOrigin() == PackageOrigin.WORKSPACE;
        }

        private static final CargoWorkspace.Target findLibTargetForPackageName$lambda$1(CargoWorkspace.Package it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return it2.getLibTarget();
        }

        private static final boolean findLibTargetForPackageName$lambda$2(String $packageName, CargoWorkspace.Target it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return Intrinsics.areEqual((Object)it2.getPkg().getName(), (Object)$packageName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/cargo/runconfig/test/CargoTestEventsConverter$State;", "", "<init>", "(Ljava/lang/String;I)V", "START_MESSAGE", "EXECUTABLE_NAME", "DOCTESTS_PACKAGE_NAME", "intellij.rustrover.core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State START_MESSAGE = new State();
        public static final /* enum */ State EXECUTABLE_NAME = new State();
        public static final /* enum */ State DOCTESTS_PACKAGE_NAME = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.START_MESSAGE, State.EXECUTABLE_NAME, State.DOCTESTS_PACKAGE_NAME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.START_MESSAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.EXECUTABLE_NAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.DOCTESTS_PACKAGE_NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

