/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.test;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.test.TestConfig;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/rust/cargo/runconfig/test/CargoProjectTestConfig;", "Lorg/rust/cargo/runconfig/test/TestConfig;", "commandName", "", "sourceElement", "Lcom/intellij/psi/PsiDirectory;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;Lorg/rust/cargo/project/model/CargoProject;)V", "getCommandName", "()Ljava/lang/String;", "getSourceElement", "()Lcom/intellij/psi/PsiDirectory;", "getCargoProject", "()Lorg/rust/cargo/project/model/CargoProject;", "targets", "", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "getTargets", "()Ljava/util/List;", "paths", "getPaths", "exact", "", "getExact", "()Z", "configurationName", "getConfigurationName", "cargoCommandLine", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "intellij.rustrover.core"})
final class CargoProjectTestConfig
implements TestConfig {
    @NotNull
    private final String commandName;
    @NotNull
    private final PsiDirectory sourceElement;
    @NotNull
    private final CargoProject cargoProject;
    @NotNull
    private final List<CargoWorkspace.Target> targets;
    @NotNull
    private final List<String> paths;
    private final boolean exact;

    public CargoProjectTestConfig(@NotNull String commandName, @NotNull PsiDirectory sourceElement, @NotNull CargoProject cargoProject) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        this.commandName = commandName;
        this.sourceElement = sourceElement;
        this.cargoProject = cargoProject;
        this.targets = CollectionsKt.emptyList();
        this.paths = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    @NotNull
    public PsiDirectory getSourceElement() {
        return this.sourceElement;
    }

    @NotNull
    public final CargoProject getCargoProject() {
        return this.cargoProject;
    }

    @Override
    @NotNull
    public List<CargoWorkspace.Target> getTargets() {
        return this.targets;
    }

    @Override
    @NotNull
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public boolean getExact() {
        return this.exact;
    }

    @Override
    @NotNull
    public String getConfigurationName() {
        String string = StringUtil.pluralize((String)this.getCommandName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
        return "All " + UtilsKt.capitalized(string);
    }

    @Override
    @NotNull
    public CargoCommandLine cargoCommandLine() {
        return CargoCommandLine.Companion.forProject$default(CargoCommandLine.Companion, this.cargoProject, this.getCommandName(), null, false, null, null, null, 124, null);
    }
}

