/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.RsCommandConfigurationKt;
import org.rust.cargo.runconfig.RsProcessHandler;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.target.RsCommandLineSetup;
import org.rust.cargo.runconfig.target.RsLanguageRuntimeConfiguration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u001a\u001c\u0010\u0019\u001a\u00020\u001a*\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u001a\u001c\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0017\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "getTargetEnvironment", "(Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;)Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "localBuildArgsForRemoteRun", "", "", "getLocalBuildArgsForRemoteRun", "(Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;)Ljava/util/List;", "languageRuntime", "Lorg/rust/cargo/runconfig/target/RsLanguageRuntimeConfiguration;", "getLanguageRuntime", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)Lorg/rust/cargo/runconfig/target/RsLanguageRuntimeConfiguration;", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "config", "processColors", "", "uploadExecutable", "toTargeted", "Lcom/intellij/execution/target/TargetedCommandLine;", "setup", "Lorg/rust/cargo/runconfig/target/RsCommandLineSetup;", "prepareEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/rust/cargo/runconfig/target/UtilsKt\n+ 2 ContributedConfigurationsList.kt\ncom/intellij/execution/target/ContributedConfigurationsList\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n44#2:146\n808#3,11:147\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/rust/cargo/runconfig/target/UtilsKt\n*L\n55#1:146\n55#1:147,11\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final TargetEnvironmentConfiguration getTargetEnvironment(@NotNull CargoCommandConfiguration $this$targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$targetEnvironment), (String)"<this>");
        if (!RunTargetsEnabled.get()) {
            return null;
        }
        RunProfile runProfile = (RunProfile)$this$targetEnvironment;
        Project project = $this$targetEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return TargetEnvironmentConfigurations.getEffectiveConfiguration((RunProfile)runProfile, (Project)project);
    }

    @NotNull
    public static final List<String> getLocalBuildArgsForRemoteRun(@NotNull CargoCommandConfiguration $this$localBuildArgsForRemoteRun) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$localBuildArgsForRemoteRun), (String)"<this>");
        if (RsCommandConfigurationKt.getHasRemoteTarget($this$localBuildArgsForRemoteRun) && $this$localBuildArgsForRemoteRun.getBuildTarget().isLocal()) {
            String string;
            Object object = UtilsKt.getTargetEnvironment($this$localBuildArgsForRemoteRun);
            if ((object != null && (object = UtilsKt.getLanguageRuntime((TargetEnvironmentConfiguration)object)) != null ? ((RsLanguageRuntimeConfiguration)((Object)object)).getLocalBuildArgs() : (string = null)) == null) {
                string = "";
            }
            List list2 = ParametersListUtil.parse((String)string);
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RsLanguageRuntimeConfiguration getLanguageRuntime(@NotNull TargetEnvironmentConfiguration $this$languageRuntime) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$languageRuntime, (String)"<this>");
        ContributedConfigurationsList this_$iv = $this$languageRuntime.getRuntimes();
        boolean $i$f$findByType = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.resolvedConfigs();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof RsLanguageRuntimeConfiguration)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (RsLanguageRuntimeConfiguration)((ContributedConfigurationBase)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv)));
    }

    @NotNull
    public static final ProcessHandler startProcess(@NotNull GeneralCommandLine $this$startProcess, @NotNull Project project, @Nullable TargetEnvironmentConfiguration config, boolean processColors, boolean uploadExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$startProcess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (config == null) {
            RsProcessHandler handler = new RsProcessHandler($this$startProcess, false, 2, null);
            ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)handler));
            return (ProcessHandler)handler;
        }
        TargetEnvironmentRequest request = config.createEnvironmentRequest(project);
        RsCommandLineSetup setup = new RsCommandLineSetup(request);
        TargetedCommandLine targetCommandLine = UtilsKt.toTargeted($this$startProcess, setup, uploadExecutable);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator progressIndicator2 = progressIndicator;
        TargetEnvironment environment = (TargetEnvironment)org.rust.openapiext.UtilsKt.computeWithCancelableProgress(project, RsBundle.INSTANCE.message("progress.title.preparing.remote.environment", new Object[0]), () -> UtilsKt.startProcess$lambda$0(request, setup, progressIndicator2));
        Process process2 = environment.createProcess(targetCommandLine, progressIndicator2);
        String commandRepresentation = targetCommandLine.getCommandPresentation(environment);
        LOG.debug("Executing command: `" + commandRepresentation + "`");
        RsProcessHandler handler = new RsProcessHandler(process2, commandRepresentation, targetCommandLine.getCharset(), processColors);
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)handler));
        return (ProcessHandler)handler;
    }

    private static final TargetedCommandLine toTargeted(GeneralCommandLine $this$toTargeted, RsCommandLineSetup setup, boolean uploadExecutable) {
        File inputFile;
        TargetValue<String> targetValue;
        TargetedCommandLineBuilder commandLineBuilder = new TargetedCommandLineBuilder(setup.getRequest());
        Charset charset = $this$toTargeted.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
        commandLineBuilder.setCharset(charset);
        if (uploadExecutable) {
            String string = $this$toTargeted.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
            targetValue = setup.requestUploadIntoTarget(string);
        } else {
            targetValue = TargetValue.fixed((Object)$this$toTargeted.getExePath());
        }
        TargetValue<String> targetedExePath = targetValue;
        Intrinsics.checkNotNull(targetedExePath);
        commandLineBuilder.setExePath(targetedExePath);
        File workDirectory = $this$toTargeted.getWorkDirectory();
        if (workDirectory != null) {
            String string = workDirectory.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            TargetValue<String> targetWorkingDirectory = setup.requestUploadIntoTarget(string);
            commandLineBuilder.setWorkingDirectory(targetWorkingDirectory);
        }
        if ((inputFile = $this$toTargeted.getInputFile()) != null) {
            String string = inputFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            TargetValue<String> targetInput = setup.requestUploadIntoTarget(string);
            commandLineBuilder.setInputFile(targetInput);
        }
        List list = $this$toTargeted.getParametersList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        commandLineBuilder.addParameters(list);
        for (Map.Entry entry2 : $this$toTargeted.getEnvironment().entrySet()) {
            String key = (String)entry2.getKey();
            String value = (String)entry2.getValue();
            Intrinsics.checkNotNull((Object)key);
            commandLineBuilder.addEnvironmentVariable(key, value);
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = setup.getRequest().getConfiguration();
        RsLanguageRuntimeConfiguration runtime = targetEnvironmentConfiguration != null ? UtilsKt.getLanguageRuntime(targetEnvironmentConfiguration) : null;
        Object object = runtime;
        commandLineBuilder.addEnvironmentVariable("RUSTC", object != null && (object = object.getRustcPath()) != null ? StringKt.nullize((String)object, (boolean)true) : null);
        Object object2 = runtime;
        commandLineBuilder.addEnvironmentVariable("CARGO", object2 != null && (object2 = object2.getCargoPath()) != null ? StringKt.nullize((String)object2, (boolean)true) : null);
        return commandLineBuilder.build();
    }

    private static final TargetEnvironment prepareEnvironment(TargetEnvironmentRequest $this$prepareEnvironment, RsCommandLineSetup setup, ProgressIndicator progressIndicator) {
        TargetEnvironment targetEnvironment;
        TargetProgressIndicator targetProgressIndicator2 = new TargetProgressIndicator(progressIndicator){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            {
                this.$progressIndicator = $progressIndicator;
            }

            public boolean isCanceled() {
                return this.$progressIndicator.isCanceled();
            }

            public void stop() {
                this.$progressIndicator.cancel();
            }

            public boolean isStopped() {
                return this.isCanceled();
            }

            public void addText(String text, Key<?> key) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter(key, (String)"key");
                this.$progressIndicator.setText2(((Object)StringsKt.trim((CharSequence)text)).toString());
            }
        };
        try {
            TargetEnvironment environment = $this$prepareEnvironment.prepareEnvironment(targetProgressIndicator2);
            setup.provideEnvironment(environment, targetProgressIndicator2);
            targetEnvironment = environment;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)e.getLocalizedMessage(), (String)"getLocalizedMessage(...)");
            throw new ExecutionException(RsBundle.INSTANCE.message("dialog.message.failed.to.prepare.remote.environment", objectArray), (Throwable)e);
        }
        return targetEnvironment;
    }

    private static final TargetEnvironment startProcess$lambda$0(TargetEnvironmentRequest $request, RsCommandLineSetup $setup, ProgressIndicator $progressIndicator) {
        return UtilsKt.prepareEnvironment($request, $setup, $progressIndicator);
    }

    static {
        Logger logger = Logger.getInstance((String)"org.rust.cargo.runconfig.target.Utils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

