/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.target;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.lang.LangCoreBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.rust.cargo.runconfig.target.RsLanguageRuntimeConfiguration;
import org.rust.cargo.runconfig.target.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0019J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J!\u0010 \u001a\u00020\u00192\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\"\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/rust/cargo/runconfig/target/RsCommandLineSetup;", "", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "<init>", "(Lcom/intellij/execution/target/TargetEnvironmentRequest;)V", "getRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "languageRuntime", "Lorg/rust/cargo/runconfig/target/RsLanguageRuntimeConfiguration;", "environmentPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "dependingOnEnvironmentPromise", "", "Lorg/jetbrains/concurrency/Promise;", "", "uploads", "Lorg/rust/cargo/runconfig/target/RsCommandLineSetup$Upload;", "projectHomeOnTarget", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "requestUploadIntoTarget", "Lcom/intellij/execution/target/value/TargetValue;", "", "uploadPathString", "createUploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "volumeDescriptor", "localRootPath", "Ljava/nio/file/Path;", "joinPath", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "provideEnvironment", "environment", "targetProgressIndicator", "Upload", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCommandLineSetup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCommandLineSetup.kt\norg/rust/cargo/runconfig/target/RsCommandLineSetup\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n608#2:121\n1011#2:122\n1045#2,3:123\n1048#2,3:133\n382#3,7:126\n216#4,2:136\n1#5:138\n13#6:139\n*S KotlinDebug\n*F\n+ 1 RsCommandLineSetup.kt\norg/rust/cargo/runconfig/target/RsCommandLineSetup\n*L\n104#1:121\n105#1:122\n105#1:123,3\n105#1:133,3\n105#1:126,7\n106#1:136,2\n117#1:139\n*E\n"})
public final class RsCommandLineSetup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TargetEnvironmentRequest request;
    @Nullable
    private final RsLanguageRuntimeConfiguration languageRuntime;
    @NotNull
    private final AsyncPromise<Pair<TargetEnvironment, TargetProgressIndicator>> environmentPromise;
    @NotNull
    private final List<Promise<Unit>> dependingOnEnvironmentPromise;
    @NotNull
    private final List<Upload> uploads;
    @NotNull
    private final LanguageRuntimeType.VolumeDescriptor projectHomeOnTarget;
    @NotNull
    private static final Logger LOG;

    public RsCommandLineSetup(@NotNull TargetEnvironmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
        this.languageRuntime = targetEnvironmentConfiguration != null ? UtilsKt.getLanguageRuntime(targetEnvironmentConfiguration) : null;
        this.environmentPromise = new AsyncPromise();
        this.dependingOnEnvironmentPromise = new ArrayList();
        this.uploads = new ArrayList();
        this.projectHomeOnTarget = new LanguageRuntimeType.VolumeDescriptor(RsCommandLineSetup.class.getSimpleName() + ":projectHomeOnTarget", "", "", "", this.request.getProjectPathOnTarget(), null, 32, null);
    }

    @NotNull
    public final TargetEnvironmentRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final TargetValue<String> requestUploadIntoTarget(@NotNull String uploadPathString) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)uploadPathString, (String)"uploadPathString");
        String string = FileUtil.toSystemDependentName((String)uploadPathString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        Path uploadPath = org.rust.stdext.UtilsKt.toPath(string);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean isDir = Files.isDirectory(uploadPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (isDir) {
            path = uploadPath;
        } else {
            path = uploadPath.getParent();
            if (path == null) {
                path = Paths.get(".", new String[0]);
            }
        }
        Path localRootPath = path;
        Intrinsics.checkNotNull((Object)localRootPath);
        Pair pair = TargetEnvironmentFunctions.getUploadRootForLocalPath((TargetEnvironmentRequest)this.request, (Path)localRootPath);
        if (pair == null) {
            TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(this.projectHomeOnTarget, localRootPath);
            boolean bl = false;
            ((Collection)this.request.getUploadVolumes()).add(uploadRoot);
            pair = TuplesKt.to((Object)uploadRoot, (Object)".");
        }
        Pair pair2 = pair;
        TargetEnvironment.UploadRoot uploadRoot = (TargetEnvironment.UploadRoot)pair2.component1();
        String pathToRoot = (String)pair2.component2();
        DeferredTargetValue result2 = new DeferredTargetValue((Object)uploadPathString);
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> RsCommandLineSetup.requestUploadIntoTarget$lambda$2(arg_0 -> RsCommandLineSetup.requestUploadIntoTarget$lambda$1(result2, uploadRoot, isDir, pathToRoot, uploadPath, this, arg_0), arg_0)));
        return (TargetValue)result2;
    }

    private final TargetEnvironment.UploadRoot createUploadRoot(LanguageRuntimeType.VolumeDescriptor volumeDescriptor, Path localRootPath) {
        RsLanguageRuntimeConfiguration rsLanguageRuntimeConfiguration = this.languageRuntime;
        if (rsLanguageRuntimeConfiguration == null || (rsLanguageRuntimeConfiguration = rsLanguageRuntimeConfiguration.createUploadRoot(volumeDescriptor, localRootPath)) == null) {
            rsLanguageRuntimeConfiguration = new TargetEnvironment.UploadRoot(localRootPath, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
        }
        return rsLanguageRuntimeConfiguration;
    }

    private final String joinPath(String ... segments) {
        return ArraysKt.joinToString$default((Object[])segments, (CharSequence)String.valueOf(this.request.getTargetPlatform().getPlatform().fileSeparator), null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void provideEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator2) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Sequence $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator2, (String)"targetProgressIndicator");
        Application application = ApplicationManager.getApplication();
        LOG.assertTrue(environment instanceof LocalTargetEnvironment || this.uploads.isEmpty() || !application.isDispatchThread() || application.isUnitTestMode(), (Object)"Preparation of environment shouldn't be performed on EDT.");
        this.environmentPromise.setResult((Object)TuplesKt.to((Object)environment, (Object)targetProgressIndicator2));
        Sequence sequence2 = CollectionsKt.asSequence((Iterable)this.uploads);
        boolean bl = false;
        $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Upload it2 = (Upload)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it2.getRelativePath().length());
                it2 = (Upload)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it2.getRelativePath().length()));
            }
        });
        boolean bl2 = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it2;
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Upload it3 = (Upload)element$iv$iv;
            boolean $i$a$-groupBy-RsCommandLineSetup$provideEnvironment$432 = false;
            TargetEnvironment.UploadableVolume key$iv$iv = it3.getVolume();
            Map map2 = destination$iv$iv;
            TargetEnvironment.UploadableVolume key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Upload $i$a$-groupBy-RsCommandLineSetup$provideEnvironment$432 = (Upload)element$iv$iv;
            List list = list$iv$iv;
            boolean bl4 = false;
            list.add(it2.getRelativePath());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean bl5 = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = iterator2.next();
            boolean bl6 = false;
            TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)entry2.getKey();
            List relativePaths = (List)entry2.getValue();
            volume.upload((String)CollectionsKt.first((List)relativePaths), targetProgressIndicator2);
        }
        for (Promise promise : this.dependingOnEnvironmentPromise) {
            promise.blockingGet(0);
        }
    }

    private static final Unit requestUploadIntoTarget$lambda$1(DeferredTargetValue $result, TargetEnvironment.UploadRoot $uploadRoot, boolean $isDir, String $pathToRoot, Path $uploadPath, RsCommandLineSetup this$0, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        TargetProgressIndicator targetProgressIndicator2 = (TargetProgressIndicator)pair.component2();
        if (targetProgressIndicator2.isCanceled() || targetProgressIndicator2.isStopped()) {
            $result.stopProceeding();
            return Unit.INSTANCE;
        }
        TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)$uploadRoot);
        try {
            String string;
            if ($isDir) {
                string = $pathToRoot;
            } else {
                String it2 = ((Object)$uploadPath.getFileName()).toString();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)$pathToRoot, (Object)".")) {
                    string = it2;
                } else {
                    String[] stringArray = new String[]{$pathToRoot, it2};
                    string = this$0.joinPath(stringArray);
                }
            }
            String relativePath = string;
            String resolvedTargetPath = volume.resolveTargetPath(relativePath);
            this$0.uploads.add(new Upload(volume, relativePath));
            $result.resolve((Object)resolvedTargetPath);
        }
        catch (Throwable t) {
            LOG.warn(t);
            Object[] objectArray = new Object[]{volume.getLocalRoot(), t.getLocalizedMessage()};
            targetProgressIndicator2.stopWithErrorMessage(LangCoreBundle.message((String)"progress.message.failed.to.resolve.0.1", (Object[])objectArray));
            $result.resolveFailure(t);
        }
        return Unit.INSTANCE;
    }

    private static final Unit requestUploadIntoTarget$lambda$2(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsCommandLineSetup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/target/RsCommandLineSetup$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/cargo/runconfig/target/RsCommandLineSetup$Upload;", "", "volume", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "relativePath", "", "<init>", "(Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;Ljava/lang/String;)V", "getVolume", "()Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "getRelativePath", "()Ljava/lang/String;", "intellij.rustrover.core"})
    private static final class Upload {
        @NotNull
        private final TargetEnvironment.UploadableVolume volume;
        @NotNull
        private final String relativePath;

        public Upload(@NotNull TargetEnvironment.UploadableVolume volume, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.volume = volume;
            this.relativePath = relativePath;
        }

        @NotNull
        public final TargetEnvironment.UploadableVolume getVolume() {
            return this.volume;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }
    }
}

