/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.profiles;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.profiles.CargoBuildProfile;
import org.rust.cargo.runconfig.profiles.RsDefaultProfileExecutionTarget;
import org.rust.ide.statistics.CargoCommandProfilesCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/rust/cargo/runconfig/profiles/RsProfileExecutionTargetListener;", "Lcom/intellij/execution/ExecutionTargetListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "activeTargetChanged", "", "newTarget", "Lcom/intellij/execution/ExecutionTarget;", "intellij.rustrover.core"})
public final class RsProfileExecutionTargetListener
implements ExecutionTargetListener {
    @NotNull
    private final Project project;

    public RsProfileExecutionTargetListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
        Intrinsics.checkNotNullParameter((Object)newTarget, (String)"newTarget");
        if (newTarget instanceof RsDefaultProfileExecutionTarget) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(this.project).getSelectedConfiguration();
            RunConfiguration runConfiguration = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
            CargoCommandConfiguration cargoCommandConfiguration = runConfiguration instanceof CargoCommandConfiguration ? (CargoCommandConfiguration)runConfiguration : null;
            if (cargoCommandConfiguration == null) {
                return;
            }
            CargoCommandConfiguration selectedConfiguration = cargoCommandConfiguration;
            CargoBuildProfile oldProfile = selectedConfiguration.getBuildProfile();
            if (!Intrinsics.areEqual((Object)oldProfile, (Object)((RsDefaultProfileExecutionTarget)newTarget).getBuildProfile())) {
                CargoCommandProfilesCollector.INSTANCE.logBuildProfileChanged(this.project, selectedConfiguration.getBuildProfile(), ((RsDefaultProfileExecutionTarget)newTarget).getBuildProfile());
            }
            selectedConfiguration.setBuildProfile(((RsDefaultProfileExecutionTarget)newTarget).getBuildProfile());
        }
    }
}

