/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.runconfig.filters.FilterUtils;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.resolve.NameResolutionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/rust/cargo/runconfig/filters/RsBacktraceItemFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "workspace", "Lorg/rust/cargo/project/workspace/CargoWorkspace;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/project/workspace/CargoWorkspace;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getWorkspace", "()Lorg/rust/cargo/project/workspace/CargoWorkspace;", "docManager", "Lcom/intellij/psi/PsiDocumentManager;", "kotlin.jvm.PlatformType", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "extractFnHyperlink", "Lcom/intellij/execution/filters/Filter$ResultItem;", "funcName", "start", "end", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsBacktraceFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsBacktraceFilter.kt\norg/rust/cargo/runconfig/filters/RsBacktraceItemFilter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n19985#2,2:140\n1#3:142\n*S KotlinDebug\n*F\n+ 1 RsBacktraceFilter.kt\norg/rust/cargo/runconfig/filters/RsBacktraceItemFilter\n*L\n94#1:140,2\n*E\n"})
public final class RsBacktraceItemFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final CargoWorkspace workspace;
    private final PsiDocumentManager docManager;
    @NotNull
    private static final TextAttributes DIMMED_TEXT;
    @NotNull
    private static final String[] SKIP_PREFIXES;
    @NotNull
    private static final Pattern FUNCTION_PATTERN;

    public RsBacktraceItemFilter(@NotNull Project project, @Nullable CargoWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.workspace = workspace;
        this.docManager = PsiDocumentManager.getInstance((Project)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final CargoWorkspace getWorkspace() {
        return this.workspace;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        boolean bl;
        int funcEnd;
        int funcStart;
        ArrayList<Filter.ResultItem> resultItems;
        String normFuncName;
        String funcHash;
        block5: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Companion.BacktraceRecord backtraceRecord = Companion.parseBacktraceRecord(line);
            if (backtraceRecord == null) {
                return null;
            }
            Companion.BacktraceRecord backtraceRecord2 = backtraceRecord;
            String header = backtraceRecord2.component1();
            String funcName = backtraceRecord2.component2();
            funcHash = backtraceRecord2.component3();
            normFuncName = FilterUtils.INSTANCE.normalizeFunctionPath(funcName);
            resultItems = new ArrayList<Filter.ResultItem>(2);
            funcStart = entireLength - line.length() + header.length();
            funcEnd = funcStart + funcName.length();
            String[] $this$none$iv = SKIP_PREFIXES;
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it2 = element$iv = $this$none$iv[j];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)normFuncName, (String)it2, (boolean)false, (int)2, null)) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (bl) {
            Filter.ResultItem resultItem = this.extractFnHyperlink(normFuncName, funcStart, funcEnd);
            if (resultItem != null) {
                Filter.ResultItem it3 = resultItem;
                boolean bl3 = false;
                resultItems.add(it3);
            }
        }
        if (funcHash != null) {
            resultItems.add(new Filter.ResultItem(funcEnd, funcEnd + funcHash.length(), null, DIMMED_TEXT));
        }
        return new Filter.Result((List)resultItems);
    }

    private final Filter.ResultItem extractFnHyperlink(String funcName, int start2, int end) {
        CargoWorkspace cargoWorkspace = this.workspace;
        if (cargoWorkspace == null) {
            return null;
        }
        CargoWorkspace workspace = cargoWorkspace;
        Pair pair = (Pair)SequencesKt.firstOrNull((Sequence)NameResolutionKt.resolveStringPath$default(funcName, workspace, this.project, null, 8, null));
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        RsNamedElement element = (RsNamedElement)pair2.component1();
        CargoWorkspace.Package pkg = (CargoWorkspace.Package)pair2.component2();
        PsiFile funcFile = element.getContainingFile();
        Document document = this.docManager.getDocument(funcFile);
        if (document == null) {
            return null;
        }
        Document doc = document;
        OpenFileHyperlinkInfo link = new OpenFileHyperlinkInfo(this.project, funcFile.getVirtualFile(), doc.getLineNumber(element.getTextOffset()));
        return new Filter.ResultItem(start2, end, (HyperlinkInfo)link, pkg.getOrigin() != PackageOrigin.WORKSPACE);
    }

    static {
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(TextAttributesKey.createTextAttributesKey((String)"org.rust.DIMMED_TEXT"));
        Intrinsics.checkNotNull((Object)textAttributes);
        DIMMED_TEXT = textAttributes;
        String[] stringArray = new String[]{"std::rt::lang_start", "std::panicking", "std::sys::backtrace", "std::sys::imp::backtrace", "core::panicking"};
        SKIP_PREFIXES = stringArray;
        Pattern pattern2 = Pattern.compile("^(\\s*\\d+:\\s+(?:0x[a-f0-9]+ - )?)(.+?)(::h[0-9a-f]+)?$");
        Intrinsics.checkNotNull((Object)pattern2);
        FUNCTION_PATTERN = pattern2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/cargo/runconfig/filters/RsBacktraceItemFilter$Companion;", "", "<init>", "()V", "DIMMED_TEXT", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getDIMMED_TEXT", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "SKIP_PREFIXES", "", "", "getSKIP_PREFIXES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "FUNCTION_PATTERN", "Ljava/util/regex/Pattern;", "parseBacktraceRecord", "Lorg/rust/cargo/runconfig/filters/RsBacktraceItemFilter$Companion$BacktraceRecord;", "line", "BacktraceRecord", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextAttributes getDIMMED_TEXT() {
            return DIMMED_TEXT;
        }

        @NotNull
        public final String[] getSKIP_PREFIXES() {
            return SKIP_PREFIXES;
        }

        @Nullable
        public final BacktraceRecord parseBacktraceRecord(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Matcher matcher = FUNCTION_PATTERN.matcher(line);
            if (!matcher.find()) {
                return null;
            }
            String header = matcher.group(1);
            String funcName = matcher.group(2);
            String funcHash = matcher.group(3);
            Intrinsics.checkNotNull((Object)header);
            Intrinsics.checkNotNull((Object)funcName);
            return new BacktraceRecord(header, funcName, funcHash);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/rust/cargo/runconfig/filters/RsBacktraceItemFilter$Companion$BacktraceRecord;", "", "header", "", "functionName", "functionHash", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHeader", "()Ljava/lang/String;", "getFunctionName", "getFunctionHash", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
        public static final class BacktraceRecord {
            @NotNull
            private final String header;
            @NotNull
            private final String functionName;
            @Nullable
            private final String functionHash;

            public BacktraceRecord(@NotNull String header, @NotNull String functionName, @Nullable String functionHash) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
                this.header = header;
                this.functionName = functionName;
                this.functionHash = functionHash;
            }

            @NotNull
            public final String getHeader() {
                return this.header;
            }

            @NotNull
            public final String getFunctionName() {
                return this.functionName;
            }

            @Nullable
            public final String getFunctionHash() {
                return this.functionHash;
            }

            @NotNull
            public final String component1() {
                return this.header;
            }

            @NotNull
            public final String component2() {
                return this.functionName;
            }

            @Nullable
            public final String component3() {
                return this.functionHash;
            }

            @NotNull
            public final BacktraceRecord copy(@NotNull String header, @NotNull String functionName, @Nullable String functionHash) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
                return new BacktraceRecord(header, functionName, functionHash);
            }

            public static /* synthetic */ BacktraceRecord copy$default(BacktraceRecord backtraceRecord, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = backtraceRecord.header;
                }
                if ((n & 2) != 0) {
                    string2 = backtraceRecord.functionName;
                }
                if ((n & 4) != 0) {
                    string3 = backtraceRecord.functionHash;
                }
                return backtraceRecord.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "BacktraceRecord(header=" + this.header + ", functionName=" + this.functionName + ", functionHash=" + this.functionHash + ")";
            }

            public int hashCode() {
                int result2 = this.header.hashCode();
                result2 = result2 * 31 + this.functionName.hashCode();
                result2 = result2 * 31 + (this.functionHash == null ? 0 : this.functionHash.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BacktraceRecord)) {
                    return false;
                }
                BacktraceRecord backtraceRecord = (BacktraceRecord)other;
                if (!Intrinsics.areEqual((Object)this.header, (Object)backtraceRecord.header)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.functionName, (Object)backtraceRecord.functionName)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.functionHash, (Object)backtraceRecord.functionHash);
            }
        }
    }
}

