/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.filters.RegexpFileLinkFilter;
import org.rust.cargo.runconfig.filters.RsBacktraceItemFilter;
import org.rust.cargo.runconfig.filters.RsBacktraceLineRegexpFileLinkFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/rust/cargo/runconfig/filters/RsBacktraceFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "cargoProjectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "workspace", "Lorg/rust/cargo/project/workspace/CargoWorkspace;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/rust/cargo/project/workspace/CargoWorkspace;)V", "(Lcom/intellij/openapi/project/Project;)V", "backtraceItemFilters", "", "Lorg/rust/cargo/runconfig/filters/RsBacktraceItemFilter;", "getBacktraceItemFilters", "()Ljava/util/List;", "sourceLinkFilters", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter;", "getSourceLinkFilters", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsBacktraceFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsBacktraceFilter.kt\norg/rust/cargo/runconfig/filters/RsBacktraceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1617#2,9:140\n1869#2:149\n1870#2:151\n1626#2:152\n1563#2:153\n1634#2,3:154\n1617#2,9:157\n1869#2:166\n1870#2:168\n1626#2:169\n1563#2:170\n1634#2,3:171\n1#3:150\n1#3:167\n*S KotlinDebug\n*F\n+ 1 RsBacktraceFilter.kt\norg/rust/cargo/runconfig/filters/RsBacktraceFilter\n*L\n39#1:140,9\n39#1:149\n39#1:151\n39#1:152\n40#1:153\n40#1:154,3\n50#1:157,9\n50#1:166\n50#1:168\n50#1:169\n51#1:170\n51#1:171,3\n39#1:150\n50#1:167\n*E\n"})
public final class RsBacktraceFilter
implements Filter {
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile cargoProjectDir;
    @Nullable
    private final CargoWorkspace workspace;

    @NonInjectable
    public RsBacktraceFilter(@NotNull Project project, @Nullable VirtualFile cargoProjectDir, @Nullable CargoWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cargoProjectDir = cargoProjectDir;
        this.workspace = workspace;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RsBacktraceItemFilter> getBacktraceItemFilters() {
        if (this.workspace == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = CargoProjectServiceKt.getCargoProjects(this.project).getAllProjects();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                CargoWorkspace it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                CargoProject it2 = (CargoProject)element$iv$iv;
                boolean bl2 = false;
                if (it2.getWorkspace() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                object = (CargoWorkspace)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new RsBacktraceItemFilter(this.project, (CargoWorkspace)it3));
            }
            List filters2 = (List)destination$iv$iv;
            if (!((Collection)filters2).isEmpty()) {
                return filters2;
            }
        }
        return CollectionsKt.listOf((Object)new RsBacktraceItemFilter(this.project, this.workspace));
    }

    /*
     * WARNING - void declaration
     */
    private final List<RegexpFileLinkFilter> getSourceLinkFilters() {
        if (this.cargoProjectDir == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = CargoProjectServiceKt.getCargoProjects(this.project).getAllProjects();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            VirtualFile virtualFile = $this$forEach$iv$iv$iv.iterator();
            while (virtualFile.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = virtualFile.next();
                boolean bl = false;
                CargoProject it2 = (CargoProject)element$iv$iv;
                boolean bl2 = false;
                if (it2.getRootDir() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new RsBacktraceLineRegexpFileLinkFilter(this.project, (VirtualFile)it3));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)new RsBacktraceLineRegexpFileLinkFilter(this.project, this.cargoProjectDir));
    }

    public RsBacktraceFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, null, null);
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return (Filter.Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.getBacktraceItemFilters()), (Sequence)CollectionsKt.asSequence((Iterable)this.getSourceLinkFilters())), arg_0 -> RsBacktraceFilter.applyFilter$lambda$0(line, entireLength, arg_0)));
    }

    private static final Filter.Result applyFilter$lambda$0(String $line, int $entireLength, Filter it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.applyFilter($line, $entireLength);
    }
}

