/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.runconfig.filters.OpenFileHyperlinkInfoWithOnClick;
import org.rust.cargo.toolchain.RsToolchainBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0003%&'B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0015H\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010$\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "lineRegExp", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$RegexpFileLinkFilterPattern;", "onClick", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$RegexpFileLinkFilterPattern;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cargoProjectDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCargoProjectDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "matchLine", "Lkotlin/text/MatchResult;", "zeroBasedNumber", "number", "resolveFilePath", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath;", "fileName", "resolveCargoPath", "path", "resolveStdlibPath", "normalizeStdLibPath", "getSysroot", "getCargoRoot", "Companion", "ResolvedPath", "RegexpFileLinkFilterPattern", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRegexpFileLinkFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexpFileLinkFilter.kt\norg/rust/cargo/runconfig/filters/RegexpFileLinkFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public abstract class RegexpFileLinkFilter
implements Filter,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RegexpFileLinkFilterPattern lineRegExp;
    @NotNull
    private final Function0<Unit> onClick;
    @Language(value="RegExp")
    @NotNull
    private static final Regex RUSTC_ABSOLUTE_PATH_RE = new Regex("/rustc/\\w+/(.*)");

    public RegexpFileLinkFilter(@NotNull Project project, @NotNull RegexpFileLinkFilterPattern lineRegExp, @NotNull Function0<Unit> onClick) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lineRegExp, (String)"lineRegExp");
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        this.project = project;
        this.lineRegExp = lineRegExp;
        this.onClick = onClick;
    }

    public /* synthetic */ RegexpFileLinkFilter(Project project, RegexpFileLinkFilterPattern regexpFileLinkFilterPattern, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = RegexpFileLinkFilter::_init_$lambda$0;
        }
        this(project, regexpFileLinkFilterPattern, (Function0<Unit>)function0);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    public abstract VirtualFile getCargoProjectDirectory();

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        MatchGroup matchGroup2;
        boolean grayedOut;
        OpenFileHyperlinkInfoWithOnClick link;
        ResolvedPath file;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        MatchResult matchResult = this.matchLine(line);
        if (matchResult == null) {
            return null;
        }
        MatchResult match2 = matchResult;
        MatchGroup matchGroup3 = match2.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup3);
        MatchGroup fileGroup = matchGroup3;
        MatchGroup matchGroup4 = match2.getGroups().get(2);
        if (matchGroup4 != null) {
            MatchGroup it2 = matchGroup4;
            boolean bl = false;
            n2 = this.zeroBasedNumber(it2.getValue());
        } else {
            n2 = 0;
        }
        int lineNumber = n2;
        MatchGroup matchGroup5 = match2.getGroups().get(3);
        if (matchGroup5 != null) {
            MatchGroup it3 = matchGroup5;
            boolean bl = false;
            n = this.zeroBasedNumber(it3.getValue());
        } else {
            n = 0;
        }
        int columnNumber = n;
        int lineStart = entireLength - line.length();
        ResolvedPath resolvedPath = file = this.resolveFilePath(fileGroup.getValue());
        if (resolvedPath != null) {
            ResolvedPath it4 = resolvedPath;
            boolean bl = false;
            v7 = new OpenFileHyperlinkInfoWithOnClick(this.project, file.getFile(), lineNumber, columnNumber, this.onClick);
        } else {
            v7 = link = null;
        }
        boolean bl = grayedOut = file == null ? false : !(file instanceof ResolvedPath.Workspace);
        MatchGroup matchGroup6 = match2.getGroups().get(3);
        int end = matchGroup6 != null && (matchGroup6 = matchGroup6.getRange()) != null ? matchGroup6.getLast() : ((matchGroup2 = match2.getGroups().get(2)) != null && (matchGroup2 = matchGroup2.getRange()) != null ? matchGroup2.getLast() : fileGroup.getRange().getLast());
        return new Filter.Result(lineStart + fileGroup.getRange().getFirst(), lineStart + end + 1, (HyperlinkInfo)link, grayedOut);
    }

    @Nullable
    public final MatchResult matchLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.lineRegExp.getLinePattern().matchEntire((CharSequence)line);
    }

    public final int zeroBasedNumber(@NotNull String number) {
        int n;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        try {
            n = Math.max(0, Integer.parseInt(number) - 1);
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        return n;
    }

    private final ResolvedPath resolveFilePath(String fileName) {
        ResolvedPath.Unknown unknown;
        ResolvedPath externalPath;
        ResolvedPath resolvedPath;
        String string = FileUtil.toSystemIndependentName((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String path = string;
        VirtualFile virtualFile = this.getCargoProjectDirectory();
        boolean bl = virtualFile != null ? virtualFile.isValid() : false;
        if (bl) {
            VirtualFile file;
            VirtualFile virtualFile2 = this.getCargoProjectDirectory();
            Object object = file = virtualFile2 != null ? virtualFile2.findFileByRelativePath(path) : null;
            if (file != null) {
                return new ResolvedPath.Workspace(file);
            }
        }
        if ((resolvedPath = this.resolveStdlibPath(fileName)) == null) {
            resolvedPath = this.resolveCargoPath(fileName);
        }
        ResolvedPath resolvedPath2 = externalPath = resolvedPath;
        if (resolvedPath2 != null) {
            return resolvedPath2;
        }
        VirtualFile virtualFile3 = this.getCargoProjectDirectory();
        if (virtualFile3 != null && (virtualFile3 = virtualFile3.getFileSystem()) != null && (virtualFile3 = virtualFile3.findFileByPath(path)) != null) {
            VirtualFile it2 = virtualFile3;
            boolean bl2 = false;
            unknown = new ResolvedPath.Unknown(it2);
        } else {
            unknown = null;
        }
        return unknown;
    }

    private final ResolvedPath resolveCargoPath(String path) {
        ResolvedPath.CargoDependency cargoDependency;
        if (!StringsKt.startsWith$default((String)path, (String)"/cargo", (boolean)false, (int)2, null)) {
            return null;
        }
        String[] stringArray = new String[]{StringsKt.removePrefix((String)path, (CharSequence)"/cargo")};
        String fullPath = ((Object)Paths.get(this.getCargoRoot(), stringArray)).toString();
        VirtualFile virtualFile = this.getCargoProjectDirectory();
        if (virtualFile != null && (virtualFile = virtualFile.getFileSystem()) != null && (virtualFile = virtualFile.findFileByPath(fullPath)) != null) {
            VirtualFile it2 = virtualFile;
            boolean bl = false;
            cargoDependency = new ResolvedPath.CargoDependency(it2);
        } else {
            cargoDependency = null;
        }
        return cargoDependency;
    }

    private final ResolvedPath resolveStdlibPath(String path) {
        ResolvedPath.Stdlib stdlib;
        String string = this.getSysroot();
        if (string == null) {
            return null;
        }
        String sysroot = string;
        String normalizedPath = this.normalizeStdLibPath(path);
        String fullPath = sysroot + "/lib/rustlib/src/rust/" + normalizedPath;
        VirtualFile virtualFile = this.getCargoProjectDirectory();
        if (virtualFile != null && (virtualFile = virtualFile.getFileSystem()) != null && (virtualFile = virtualFile.findFileByPath(fullPath)) != null) {
            VirtualFile it2 = virtualFile;
            boolean bl = false;
            stdlib = new ResolvedPath.Stdlib(it2);
        } else {
            stdlib = null;
        }
        return stdlib;
    }

    private final String normalizeStdLibPath(String path) {
        MatchResult matchResult = RUSTC_ABSOLUTE_PATH_RE.matchEntire((CharSequence)path);
        if (matchResult == null) {
            return path;
        }
        MatchResult match2 = matchResult;
        return (String)match2.getGroupValues().get(1);
    }

    private final String getSysroot() {
        Object object = (CargoProject)CollectionsKt.firstOrNull((Iterable)CargoProjectServiceKt.getCargoProjects(this.project).getAllProjects());
        return object != null && (object = object.getRustcInfo()) != null ? ((RustcInfo)object).getSysroot() : null;
    }

    private final String getCargoRoot() {
        Object object = RustProjectSettingsServiceKt.getRustSettings(this.project).getToolchain();
        return String.valueOf(object != null && (object = ((RsToolchainBase)object).getLocation()) != null ? object.getParent() : null);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$Companion;", "", "<init>", "()V", "RUSTC_ABSOLUTE_PATH_RE", "Lkotlin/text/Regex;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$RegexpFileLinkFilterPattern;", "", "lineRegExp", "", "<init>", "(Ljava/lang/String;)V", "linePattern", "Lkotlin/text/Regex;", "getLinePattern", "()Lkotlin/text/Regex;", "Companion", "intellij.rustrover.core"})
    public static abstract class RegexpFileLinkFilterPattern {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Regex linePattern;
        @Language(value="RegExp")
        @NotNull
        public static final String FILE_POSITION_RE = "(?<path>(?:\\p{Alpha}:)?[0-9 a-z_A-Z\\-\\\\./]+):(?<line>[0-9]+)(?::(?<column>[0-9]+))?";

        public RegexpFileLinkFilterPattern(@Language(value="RegExp") @NotNull String lineRegExp) {
            Intrinsics.checkNotNullParameter((Object)lineRegExp, (String)"lineRegExp");
            if (!StringsKt.contains$default((CharSequence)lineRegExp, (CharSequence)FILE_POSITION_RE, (boolean)false, (int)2, null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)lineRegExp, (char)'^', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)lineRegExp, (char)'$', (boolean)false, (int)2, null))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.linePattern = new Regex("^" + lineRegExp + "\\R?$");
        }

        @NotNull
        public final Regex getLinePattern() {
            return this.linePattern;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$RegexpFileLinkFilterPattern$Companion;", "", "<init>", "()V", "FILE_POSITION_RE", "", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\b\t\n\u000bB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "Workspace", "Stdlib", "CargoDependency", "Unknown", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$CargoDependency;", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$Stdlib;", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$Unknown;", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$Workspace;", "intellij.rustrover.core"})
    public static abstract sealed class ResolvedPath {
        @NotNull
        private final VirtualFile file;

        private ResolvedPath(VirtualFile file) {
            this.file = file;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public /* synthetic */ ResolvedPath(VirtualFile file, DefaultConstructorMarker $constructor_marker) {
            this(file);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$CargoDependency;", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.rustrover.core"})
        public static final class CargoDependency
        extends ResolvedPath {
            public CargoDependency(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                super(file, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$Stdlib;", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.rustrover.core"})
        public static final class Stdlib
        extends ResolvedPath {
            public Stdlib(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                super(file, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$Unknown;", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.rustrover.core"})
        public static final class Unknown
        extends ResolvedPath {
            public Unknown(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                super(file, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath$Workspace;", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter$ResolvedPath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.rustrover.core"})
        public static final class Workspace
        extends ResolvedPath {
            public Workspace(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                super(file, null);
            }
        }
    }
}

