/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.filters;

import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewDiffResult;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.LazyKt;
import com.intellij.util.LocalTimeCounter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.buildtool.FixApply;
import org.rust.lang.RsFileType;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0002J\u0006\u0010\u001d\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0011\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0013\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lorg/rust/cargo/runconfig/filters/FixDiffContainer;", "", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "applies", "", "Lorg/rust/cargo/runconfig/buildtool/FixApply;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;)V", "originalFile", "Lcom/intellij/psi/PsiFile;", "getOriginalFile", "()Lcom/intellij/psi/PsiFile;", "originalFile$delegate", "Lkotlin/Lazy;", "modifiedFile", "Lorg/jetbrains/annotations/NotNull;", "getModifiedFile", "modifiedFile$delegate", "diffFileRequested", "", "diffs", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewDiffResult;", "getDiffs", "()Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewDiffResult;", "diffs$delegate", "createPreviewDiffs", "isDiffFileAvailable", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBuildOutputFixesFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOutputFixesFilter.kt\norg/rust/cargo/runconfig/filters/FixDiffContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,498:1\n1761#2,3:499\n*S KotlinDebug\n*F\n+ 1 BuildOutputFixesFilter.kt\norg/rust/cargo/runconfig/filters/FixDiffContainer\n*L\n368#1:499,3\n*E\n"})
final class FixDiffContainer {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy originalFile$delegate;
    @NotNull
    private final Lazy modifiedFile$delegate;
    private boolean diffFileRequested;
    @NotNull
    private final Lazy diffs$delegate;

    public FixDiffContainer(@NotNull Project project, @NotNull String fileName, @NotNull List<? extends FixApply> applies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(applies, (String)"applies");
        this.project = project;
        this.originalFile$delegate = LazyKt.lazyPub(() -> FixDiffContainer.originalFile_delegate$lambda$0(this, fileName));
        this.modifiedFile$delegate = LazyKt.lazyPub(() -> FixDiffContainer.modifiedFile_delegate$lambda$0(this, applies));
        this.diffs$delegate = LazyKt.lazyPub(() -> FixDiffContainer.diffs_delegate$lambda$0(this));
    }

    private final PsiFile getOriginalFile() {
        Lazy lazy = this.originalFile$delegate;
        return (PsiFile)lazy.getValue();
    }

    private final PsiFile getModifiedFile() {
        Lazy lazy = this.modifiedFile$delegate;
        return (PsiFile)lazy.getValue();
    }

    @Nullable
    public final IntentionPreviewDiffResult getDiffs() {
        Lazy lazy = this.diffs$delegate;
        return (IntentionPreviewDiffResult)lazy.getValue();
    }

    private final IntentionPreviewDiffResult createPreviewDiffs() {
        PsiFile psiFile = this.getOriginalFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile originalFile = psiFile;
        PsiFile psiFile2 = this.getModifiedFile();
        if (psiFile2 == null) {
            return null;
        }
        PsiFile modifiedFile = psiFile2;
        Document document = UtilsKt.getDocument(modifiedFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        FileType fileType = (FileType)RsFileType.INSTANCE;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = originalFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return IntentionPreviewDiffResult.Companion.create$default((IntentionPreviewDiffResult.Companion)IntentionPreviewDiffResult.Companion, (FileType)fileType, (String)string, (String)string2, (ComparisonPolicy)ComparisonPolicy.TRIM_WHITESPACES, (boolean)false, null, (int)48, null);
    }

    public final boolean isDiffFileAvailable() {
        if (!this.diffFileRequested) {
            CommandProcessor.getInstance().executeCommand(this.project, () -> FixDiffContainer.isDiffFileAvailable$lambda$0(this), RsBundle.INSTANCE.message("apply.compiler.fix.command.name", new Object[0]), (Object)RsBundle.INSTANCE.message("apply.compiler.fix.command.name", new Object[0]));
            return this.getModifiedFile() != null;
        }
        return this.getModifiedFile() != null;
    }

    private static final PsiFile originalFile_delegate$lambda$0(FixDiffContainer this$0, String $fileName) {
        PsiFile psiFile;
        String string = this$0.project.getBasePath();
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            Path filePath = Path.of($fileName, new String[0]);
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(Path.of(it2, new String[0]).resolve(filePath));
            psiFile = virtualFile != null ? UtilsKt.toPsiFile(virtualFile, this$0.project) : null;
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    private static final PsiFile modifiedFile_delegate$lambda$0(FixDiffContainer this$0, List $applies) {
        PsiFile psiFile;
        this$0.diffFileRequested = true;
        PsiFile psiFile2 = this$0.getOriginalFile();
        if (psiFile2 != null) {
            boolean bl;
            PsiFile originalFile;
            block8: {
                originalFile = psiFile2;
                boolean bl2 = false;
                Iterable $this$any$iv = $applies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FixApply it2 = (FixApply)element$iv;
                        boolean bl3 = false;
                        if (!(it2.getRange().getRange() == null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                psiFile = null;
            } else {
                PsiFile psiFile3 = PsiFileFactory.getInstance((Project)this$0.project).createFileFromText(originalFile.getName(), originalFile.getFileType(), (CharSequence)InjectedLanguageManager.getInstance((Project)this$0.project).getUnescapedText((PsiElement)originalFile), LocalTimeCounter.currentTime(), true);
                Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"createFileFromText(...)");
                PsiFile copyFile = psiFile3;
                for (FixApply fixApply : $applies) {
                    Project project = this$0.project;
                    Document document = copyFile.getViewProvider().getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                    fixApply.apply(project, document, true);
                }
                psiFile = copyFile;
            }
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    private static final IntentionPreviewDiffResult diffs_delegate$lambda$0(FixDiffContainer this$0) {
        return this$0.createPreviewDiffs();
    }

    private static final void isDiffFileAvailable$lambda$0(FixDiffContainer this$0) {
        this$0.getModifiedFile();
    }
}

