/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.runconfig.buildtool.BuildOutputFixesDataStore;
import org.rust.cargo.runconfig.filters.ApplyFixButtonItem;
import org.rust.cargo.runconfig.filters.ApplyFixData;
import org.rust.cargo.runconfig.filters.CompilerFixMessageContext;
import org.rust.cargo.runconfig.filters.CompilerFixWatchersContainer;
import org.rust.cargo.runconfig.filters.RegexpFileLinkFilter;
import org.rust.cargo.runconfig.filters.RsSourceCodeLinkFilter;
import org.rust.ide.statistics.CargoFixesFromBuildOutputCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/rust/cargo/runconfig/filters/BuildOutputFixesFilter;", "Lcom/intellij/execution/filters/Filter;", "buildOutputFixesDataStore", "Lorg/rust/cargo/runconfig/buildtool/BuildOutputFixesDataStore;", "project", "Lcom/intellij/openapi/project/Project;", "cargoProjectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lorg/rust/cargo/runconfig/buildtool/BuildOutputFixesDataStore;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "compilerFixWatchersContainer", "Lorg/rust/cargo/runconfig/filters/CompilerFixWatchersContainer;", "sourceLinkFilters", "", "Lorg/rust/cargo/runconfig/filters/RegexpFileLinkFilter;", "getSourceLinkFilters", "()Ljava/util/List;", "fileLinkResult", "Lcom/intellij/execution/filters/Filter$Result;", "currentFixContext", "Lorg/rust/cargo/runconfig/filters/CompilerFixMessageContext;", "lastLineWasNote", "", "lastLine", "", "applyFilter", "line", "entireLength", "", "tryRememberContext", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBuildOutputFixesFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOutputFixesFilter.kt\norg/rust/cargo/runconfig/filters/BuildOutputFixesFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,498:1\n1617#2,9:499\n1869#2:508\n1870#2:510\n1626#2:511\n1563#2:512\n1634#2,3:513\n1#3:509\n*S KotlinDebug\n*F\n+ 1 BuildOutputFixesFilter.kt\norg/rust/cargo/runconfig/filters/BuildOutputFixesFilter\n*L\n86#1:499,9\n86#1:508\n86#1:510\n86#1:511\n87#1:512\n87#1:513,3\n86#1:509\n*E\n"})
public final class BuildOutputFixesFilter
implements Filter {
    @NotNull
    private final BuildOutputFixesDataStore buildOutputFixesDataStore;
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile cargoProjectDir;
    @NotNull
    private final CompilerFixWatchersContainer compilerFixWatchersContainer;
    @Nullable
    private Filter.Result fileLinkResult;
    @Nullable
    private CompilerFixMessageContext currentFixContext;
    private boolean lastLineWasNote;
    @NotNull
    private String lastLine;

    public BuildOutputFixesFilter(@NotNull BuildOutputFixesDataStore buildOutputFixesDataStore, @NotNull Project project, @Nullable VirtualFile cargoProjectDir) {
        Intrinsics.checkNotNullParameter((Object)buildOutputFixesDataStore, (String)"buildOutputFixesDataStore");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.buildOutputFixesDataStore = buildOutputFixesDataStore;
        this.project = project;
        this.cargoProjectDir = cargoProjectDir;
        this.compilerFixWatchersContainer = new CompilerFixWatchersContainer();
        this.lastLine = "";
    }

    /*
     * WARNING - void declaration
     */
    private final List<RegexpFileLinkFilter> getSourceLinkFilters() {
        if (this.cargoProjectDir == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = CargoProjectServiceKt.getCargoProjects(this.project).getAllProjects();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            VirtualFile virtualFile = $this$forEach$iv$iv$iv.iterator();
            while (virtualFile.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = virtualFile.next();
                boolean bl = false;
                CargoProject it2 = (CargoProject)element$iv$iv;
                boolean bl2 = false;
                if (it2.getRootDir() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new RsSourceCodeLinkFilter(this.project, (VirtualFile)it3, null, 4, null));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)new RsSourceCodeLinkFilter(this.project, this.cargoProjectDir, null, 4, null));
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Filter.Result result2;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.tryRememberContext(line, entireLength);
        this.lastLineWasNote = StringsKt.startsWith$default((String)line, (String)"note:", (boolean)false, (int)2, null);
        CompilerFixMessageContext compilerFixMessageContext = this.currentFixContext;
        if (compilerFixMessageContext != null) {
            HyperlinkInfo fileHyperLink;
            Pair<Integer, ApplyFixData> pair;
            CompilerFixMessageContext context = compilerFixMessageContext;
            boolean bl = false;
            if (Path.of(context.getFileName(), new String[0]).isAbsolute()) {
                return null;
            }
            Pair<Integer, ApplyFixData> it2 = pair = this.buildOutputFixesDataStore.findFix(line, context, this.lastLine);
            boolean bl2 = false;
            this.lastLine = line;
            Pair<Integer, ApplyFixData> pair2 = pair;
            if (pair2 == null) {
                return null;
            }
            Pair<Integer, ApplyFixData> pair3 = pair2;
            int fixIndex = ((Number)pair3.component1()).intValue();
            ApplyFixData errorFix = (ApplyFixData)pair3.component2();
            int inlayPosition = Math.max(entireLength - 1, 0);
            Filter.Result result3 = this.fileLinkResult;
            Object object = fileHyperLink = result3 != null ? result3.getFirstHyperlinkInfo() : null;
            if (this.compilerFixWatchersContainer.fixWasNotCreated(fixIndex)) {
                CargoFixesFromBuildOutputCollector.INSTANCE.logFixCreatedForError(this.project, errorFix.getErrorCode());
            }
            Object[] objectArray = new Filter.ResultItem[]{new ApplyFixButtonItem(inlayPosition, errorFix, context.getFileName(), this.project, fileHyperLink, this.compilerFixWatchersContainer.createOrGetWatcher(fixIndex), line), new Filter.ResultItem(0, 0, null)};
            Filter.Result result4 = new Filter.Result(CollectionsKt.listOf((Object[])objectArray));
            result2 = result4;
        } else {
            result2 = null;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryRememberContext(String line, int entireLength) {
        CompilerFixMessageContext compilerFixMessageContext;
        Filter.Result fileLink;
        Pair pair;
        MatchResult matchResult;
        block13: {
            if (this.lastLineWasNote) {
                return;
            }
            for (RegexpFileLinkFilter it2 : (Iterable)this.getSourceLinkFilters()) {
                Pair pair2;
                Pair pair3;
                boolean bl = false;
                Filter.Result result2 = it2.applyFilter(line, entireLength);
                if (result2 == null) {
                    matchResult = null;
                    pair3 = matchResult;
                } else {
                    pair3 = TuplesKt.to((Object)it2, (Object)result2);
                }
                if ((pair2 = pair3) == null) continue;
                pair = pair2;
                break block13;
            }
            pair = null;
        }
        if (pair == null) {
            return;
        }
        Pair pair4 = pair;
        RegexpFileLinkFilter linkFilter = (RegexpFileLinkFilter)pair4.component1();
        this.fileLinkResult = fileLink = (Filter.Result)pair4.component2();
        BuildOutputFixesFilter buildOutputFixesFilter = this;
        MatchResult matchResult2 = linkFilter.matchLine(line);
        if (matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null) {
            CompilerFixMessageContext compilerFixMessageContext2;
            void it3;
            matchResult = matchResult2;
            BuildOutputFixesFilter buildOutputFixesFilter2 = buildOutputFixesFilter;
            boolean bl = false;
            Object object = it3.get(1);
            if (object == null || (object = object.getValue()) == null) {
                compilerFixMessageContext2 = null;
            } else {
                Object object2 = it3.get(2);
                if (object2 == null || (object2 = object2.getValue()) == null) {
                    CompilerFixMessageContext compilerFixMessageContext3;
                    compilerFixMessageContext2 = compilerFixMessageContext3 = null;
                } else {
                    Object object3 = it3.get(3);
                    if (object3 == null || (object3 = object3.getValue()) == null) {
                        CompilerFixMessageContext compilerFixMessageContext4;
                        compilerFixMessageContext2 = compilerFixMessageContext4 = null;
                    } else {
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n = 24;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = linkFilter.zeroBasedNumber((String)object3);
                        int n5 = linkFilter.zeroBasedNumber((String)object2);
                        Object object4 = object;
                        compilerFixMessageContext2 = new CompilerFixMessageContext((String)object4, n5, n4, n3, n2, n, defaultConstructorMarker);
                    }
                }
            }
            compilerFixMessageContext = compilerFixMessageContext2;
            buildOutputFixesFilter = buildOutputFixesFilter2;
        } else {
            compilerFixMessageContext = null;
        }
        buildOutputFixesFilter.currentFixContext = compilerFixMessageContext;
    }
}

