/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.filters;

import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.ChangeOnHoverPresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.codeInsight.hints.presentation.SpacePresentation;
import com.intellij.codeInsight.hints.presentation.WithCursorOnHoverPresentation;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.buildtool.FixApply;
import org.rust.cargo.runconfig.filters.ApplyFixData;
import org.rust.cargo.runconfig.filters.CompilerFixWatcher;
import org.rust.cargo.runconfig.filters.FixInlayHoverListener;
import org.rust.cargo.runconfig.filters.WithStateWatcherPresentation;
import org.rust.ide.statistics.CargoFixesFromBuildOutputCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/rust/cargo/runconfig/filters/ApplyFixButtonItem;", "Lcom/intellij/execution/filters/Filter$ResultItem;", "Lcom/intellij/execution/impl/InlayProvider;", "offset", "", "fix", "Lorg/rust/cargo/runconfig/filters/ApplyFixData;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "fileHyperLink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "compilerFixWatcher", "Lorg/rust/cargo/runconfig/filters/CompilerFixWatcher;", "line", "<init>", "(ILorg/rust/cargo/runconfig/filters/ApplyFixData;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/filters/HyperlinkInfo;Lorg/rust/cargo/runconfig/filters/CompilerFixWatcher;Ljava/lang/String;)V", "consoleButtonText", "createPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "createInlay", "Lcom/intellij/openapi/editor/Inlay;", "hoverInlay", "inlayButton", "clickButton", "", "applyFix", "document", "Lcom/intellij/openapi/editor/Document;", "doUndoableAction", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBuildOutputFixesFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOutputFixesFilter.kt\norg/rust/cargo/runconfig/filters/ApplyFixButtonItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,498:1\n1740#2,3:499\n*S KotlinDebug\n*F\n+ 1 BuildOutputFixesFilter.kt\norg/rust/cargo/runconfig/filters/ApplyFixButtonItem\n*L\n264#1:499,3\n*E\n"})
final class ApplyFixButtonItem
extends Filter.ResultItem
implements InlayProvider {
    @NotNull
    private final ApplyFixData fix;
    @NotNull
    private final String fileName;
    @NotNull
    private final Project project;
    @Nullable
    private final HyperlinkInfo fileHyperLink;
    @NotNull
    private final CompilerFixWatcher compilerFixWatcher;
    @NotNull
    private final String line;
    @NotNull
    private final String consoleButtonText;

    public ApplyFixButtonItem(int offset, @NotNull ApplyFixData fix, @NotNull String fileName, @NotNull Project project, @Nullable HyperlinkInfo fileHyperLink, @NotNull CompilerFixWatcher compilerFixWatcher, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerFixWatcher, (String)"compilerFixWatcher");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        super(offset, offset, null);
        this.fix = fix;
        this.fileName = fileName;
        this.project = project;
        this.fileHyperLink = fileHyperLink;
        this.compilerFixWatcher = compilerFixWatcher;
        this.line = line;
        this.consoleButtonText = RsBundle.INSTANCE.message("apply.compiler.fix.tooltip", new Object[0]);
    }

    private final InlayPresentation createPresentation(Editor editor2) {
        this.compilerFixWatcher.rememberEditor(editor2);
        PresentationFactory factory2 = new PresentationFactory(editor2);
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
        Icon icon = AllIcons.Actions.QuickfixBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"QuickfixBulb");
        inlayPresentationArray[0] = factory2.smallScaledIcon(icon);
        inlayPresentationArray[1] = factory2.smallText(" " + this.consoleButtonText);
        InlayPresentation inlayButton = factory2.roundWithBackground(factory2.seq(inlayPresentationArray));
        InlayPresentation basePresentation = this.hoverInlay(editor2, inlayButton);
        InlayPresentation inlayPresentation = (InlayPresentation)new SpacePresentation(1, 0);
        Cursor cursor = Cursor.getPredefinedCursor(2);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
        return (InlayPresentation)new WithStateWatcherPresentation(basePresentation, factory2.withCursorOnHover(inlayPresentation, cursor), this.compilerFixWatcher.getStateWatcher());
    }

    @NotNull
    public EditorCustomElementRenderer createInlayRenderer(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return (EditorCustomElementRenderer)new PresentationRenderer(this.createPresentation(editor2));
    }

    @Nullable
    public Inlay<?> createInlay(@NotNull Editor editor2, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        boolean inlayForEditorAlreadyCreated = this.compilerFixWatcher.hasEditor(editor2);
        InlayPresentation button2 = this.createPresentation(editor2);
        FontMetrics fontMetrics = editor2.getComponent().getFontMetrics(EditorUtil.getEditorFont());
        int lineWidth = fontMetrics.stringWidth(this.line) + button2.getWidth();
        return editor2.getComponent().getWidth() < lineWidth ? (!inlayForEditorAlreadyCreated ? editor2.getInlayModel().addBlockElement(offset, new InlayProperties(), (EditorCustomElementRenderer)new PresentationRenderer(button2)) : null) : super.createInlay(editor2, offset);
    }

    private final InlayPresentation hoverInlay(Editor editor2, InlayPresentation inlayButton) {
        PresentationFactory factory2 = new PresentationFactory(editor2);
        FixInlayHoverListener hoveringListener = new FixInlayHoverListener(this.project, editor2, this.fileName, this.fix.getApplies());
        InlayPresentation onHover = factory2.onHover(inlayButton, (InlayPresentationFactory.HoverListener)hoveringListener);
        ChangeOnHoverPresentation change = new ChangeOnHoverPresentation(onHover, () -> ApplyFixButtonItem.hoverInlay$lambda$0(factory2, onHover), null, 4, null);
        InlayPresentation inlayPresentation = (InlayPresentation)change;
        EnumSet<Enum> enumSet = EnumSet.of((Enum)MouseButton.Left, (Enum)MouseButton.Middle);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        InlayPresentation basePresentation = factory2.onClick(inlayPresentation, enumSet, (arg_0, arg_1) -> ApplyFixButtonItem.hoverInlay$lambda$1(editor2, this, change, arg_0, arg_1));
        Cursor cursor = Cursor.getPredefinedCursor(12);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
        return (InlayPresentation)new WithCursorOnHoverPresentation(basePresentation, cursor, editor2);
    }

    @VisibleForTesting
    public final void clickButton(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.compilerFixWatcher.getCurrentState()) {
            boolean bl;
            block7: {
                Iterable $this$all$iv = this.fix.getApplies();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FixApply it2 = (FixApply)element$iv;
                        boolean bl2 = false;
                        if (it2.getRange().getRange() != null) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (bl) {
                HyperlinkInfo hyperlinkInfo = this.fileHyperLink;
                if (hyperlinkInfo != null) {
                    hyperlinkInfo.navigate(project);
                }
                FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if (textEditor == null || (textEditor = textEditor.getEditor()) == null) {
                    return;
                }
                TextEditor fileToEditEditor = textEditor;
                CommandProcessor.getInstance().executeCommand(project, () -> ApplyFixButtonItem.clickButton$lambda$1(this, (Editor)fileToEditEditor), RsBundle.INSTANCE.message("apply.compiler.fix.command.name", new Object[0]), (Object)RsBundle.INSTANCE.message("apply.compiler.fix.command.name", new Object[0]));
                CargoFixesFromBuildOutputCollector.INSTANCE.logFixAppliedForError(project, this.fix.getErrorCode());
            }
        }
    }

    private final void applyFix(Document document) {
        for (FixApply apply : this.fix.getApplies()) {
            apply.apply(this.project, document, false);
        }
    }

    private final void doUndoableAction(Editor editor2) {
        UndoManager undoManager = UndoManager.getInstance((Project)this.project);
        VirtualFile[] virtualFileArray = new VirtualFile[1];
        Intrinsics.checkNotNull((Object)editor2.getVirtualFile());
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        undoManager.undoableActionPerformed((UndoableAction)new BasicUndoableAction(this, virtualFileArray2){
            final /* synthetic */ ApplyFixButtonItem this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void undo() {
                ApplyFixButtonItem.access$getCompilerFixWatcher$p(this.this$0).changeState(true);
            }

            public void redo() {
                ApplyFixButtonItem.access$getCompilerFixWatcher$p(this.this$0).changeState(false);
            }
        });
        this.compilerFixWatcher.changeState(false);
    }

    private static final InlayPresentation hoverInlay$lambda$0(PresentationFactory $factory, InlayPresentation $onHover) {
        return (InlayPresentation)$factory.withReferenceAttributes($onHover);
    }

    private static final Unit hoverInlay$lambda$1(Editor $editor, ApplyFixButtonItem this$0, ChangeOnHoverPresentation $change, MouseEvent mouseEvent, Point point) {
        block0: {
            Project project = $editor.getProject();
            if (project == null) break block0;
            Project it2 = project;
            boolean bl = false;
            this$0.clickButton(it2);
            $change.mouseExited();
        }
        return Unit.INSTANCE;
    }

    private static final void clickButton$lambda$1(ApplyFixButtonItem this$0, Editor $fileToEditEditor) {
        this$0.doUndoableAction($fileToEditEditor);
        Document document = $fileToEditEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this$0.applyFix(document);
    }

    public static final /* synthetic */ CompilerFixWatcher access$getCompilerFixWatcher$p(ApplyFixButtonItem $this) {
        return $this.compilerFixWatcher;
    }
}

