/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.console;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.runconfig.RsCommandConfiguration;
import org.rust.cargo.runconfig.RsCommandConfigurationKt;
import org.rust.cargo.runconfig.console.CargoConsoleView;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/rust/cargo/runconfig/console/RsConsoleBuilder;", "Lcom/intellij/execution/filters/TextConsoleBuilderImpl;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lorg/rust/cargo/runconfig/RsCommandConfiguration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/runconfig/RsCommandConfiguration;)V", "getConfig", "()Lorg/rust/cargo/runconfig/RsCommandConfiguration;", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "intellij.rustrover.core"})
public class RsConsoleBuilder
extends TextConsoleBuilderImpl {
    @NotNull
    private final RsCommandConfiguration config;

    public RsConsoleBuilder(@NotNull Project project, @NotNull RsCommandConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super(project, ExecutionSearchScopes.executionScope((Project)project, (RunProfile)((RunProfile)config)));
        this.config = config;
    }

    @NotNull
    public final RsCommandConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    protected ConsoleView createConsole() {
        ConsoleView consoleView;
        if (this.config.getEmulateTerminal() && !RsCommandConfigurationKt.getHasRemoteTarget(this.config)) {
            consoleView = (ConsoleView)new TerminalExecutionConsole(this.getProject(), null);
        } else {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GlobalSearchScope globalSearchScope = this.getScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScope(...)");
            consoleView = (ConsoleView)new CargoConsoleView(project, globalSearchScope, this.isViewer(), true);
        }
        return consoleView;
    }
}

