/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.console;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.runconfig.console.CargoConsoleViewKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/runconfig/console/CargoConsoleView;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "viewer", "", "usePredefinedMessageFilter", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;ZZ)V", "hasErrors", "doCreateConsoleEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "scrollToEnd", "", "intellij.rustrover.core"})
public final class CargoConsoleView
extends ConsoleViewImpl {
    private boolean hasErrors;

    public CargoConsoleView(@NotNull Project project, @NotNull GlobalSearchScope searchScope, boolean viewer, boolean usePredefinedMessageFilter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        super(project, searchScope, viewer, usePredefinedMessageFilter);
    }

    @NotNull
    protected EditorEx doCreateConsoleEditor() {
        EditorEx editor2 = super.doCreateConsoleEditor();
        editor2.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ CargoConsoleView this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CharSequence charSequence = e.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)"error", (boolean)false, (int)2, null)) {
                    return;
                }
                Document document = e.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                int startLine = document2.getLineNumber(e.getOffset());
                int endLine = document2.getLineNumber(e.getOffset() + e.getNewLength());
                int lineNumber = startLine;
                if (lineNumber <= endLine) {
                    while (true) {
                        int lineStart = document2.getLineStartOffset(lineNumber);
                        int lineEnd = document2.getLineEndOffset(lineNumber);
                        this.processLine(lineNumber, document2.getImmutableCharSequence().subSequence(lineStart, lineEnd));
                        if (lineNumber == endLine) break;
                        ++lineNumber;
                    }
                }
            }

            private final void processLine(int lineNumber, CharSequence line) {
                if (CargoConsoleViewKt.access$getERROR_RE$p().matches(line)) {
                    if (!CargoConsoleView.access$getHasErrors$p(this.this$0)) {
                        Editor editor2;
                        Editor editor3 = this.this$0.getEditor();
                        if (editor3 != null && (editor3 = editor3.getCaretModel()) != null) {
                            editor3.moveToLogicalPosition(new LogicalPosition(lineNumber - 1, 0));
                        }
                        if ((editor2 = this.this$0.getEditor()) != null && (editor2 = editor2.getScrollingModel()) != null) {
                            editor2.scrollToCaret(ScrollType.CENTER);
                        }
                    }
                    CargoConsoleView.access$setHasErrors$p(this.this$0, true);
                }
            }
        });
        return editor2;
    }

    public void scrollToEnd() {
        if (this.hasErrors) {
            return;
        }
        super.scrollToEnd();
    }

    public static final /* synthetic */ boolean access$getHasErrors$p(CargoConsoleView $this) {
        return $this.hasErrors;
    }

    public static final /* synthetic */ void access$setHasErrors$p(CargoConsoleView $this, boolean bl) {
        $this.hasErrors = bl;
    }
}

