/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.command;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.command.CargoExecutableRunConfigurationProducer;
import org.rust.cargo.runconfig.command.CargoRunConfigurationProducer;
import org.rust.cargo.runconfig.command.CompositeCargoRunConfigurationProducer;
import org.rust.cargo.runconfig.test.CargoBenchRunConfigurationProducer;
import org.rust.cargo.runconfig.test.CargoTestRunConfigurationProducer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0018\u001a\u00020\r*\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/rust/cargo/runconfig/command/CompositeCargoRunConfigurationProducer;", "Lorg/rust/cargo/runconfig/command/CargoRunConfigurationProducer;", "<init>", "()V", "producers", "", "findExistingConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "findOrCreateConfigurationFromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "isConfigurationFromContext", "", "configuration", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "createLightConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "createPreferredConfigurationFromContext", "getPreferredProducerForContext", "isSame", "other", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCompositeCargoRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeCargoRunConfigurationProducer.kt\norg/rust/cargo/runconfig/command/CompositeCargoRunConfigurationProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1761#2,3:121\n1761#2,3:124\n1617#2,9:127\n1869#2:136\n1870#2:138\n1626#2:139\n1#3:137\n1#3:140\n*S KotlinDebug\n*F\n+ 1 CompositeCargoRunConfigurationProducer.kt\norg/rust/cargo/runconfig/command/CompositeCargoRunConfigurationProducer\n*L\n67#1:121,3\n73#1:124,3\n92#1:127,9\n92#1:136\n92#1:138\n92#1:139\n92#1:137\n*E\n"})
public final class CompositeCargoRunConfigurationProducer
extends CargoRunConfigurationProducer {
    @NotNull
    private final List<CargoRunConfigurationProducer> producers;

    public CompositeCargoRunConfigurationProducer() {
        CargoRunConfigurationProducer[] cargoRunConfigurationProducerArray = new CargoRunConfigurationProducer[]{new CargoExecutableRunConfigurationProducer(), new CargoTestRunConfigurationProducer(), new CargoBenchRunConfigurationProducer()};
        this.producers = CollectionsKt.listOf((Object[])cargoRunConfigurationProducerArray);
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConfigurationFromContext configurationFromContext = this.createPreferredConfigurationFromContext(context);
        if (configurationFromContext == null) {
            return null;
        }
        ConfigurationFromContext preferredConfig = configurationFromContext;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunManager runManager = RunManager.Companion.getInstance(project);
        List list = this.getConfigurationSettingsList(runManager);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationSettingsList(...)");
        List configurations = list;
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            RunConfiguration runConfiguration = preferredConfig.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            if (!this.isSame(runConfiguration, configurationSettings.getConfiguration())) continue;
            return configurationSettings;
        }
        return null;
    }

    @Nullable
    public ConfigurationFromContext findOrCreateConfigurationFromContext(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConfigurationFromContext configurationFromContext = this.createPreferredConfigurationFromContext(context);
        if (configurationFromContext == null) {
            return null;
        }
        ConfigurationFromContext preferredConfig = configurationFromContext;
        PsiElement psiElement2 = preferredConfig.getSourceElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getSourceElement(...)");
        PsiElement psiElement3 = psiElement2;
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        Location locationFromContext = location;
        Location locationFromElement = PsiLocation.fromPsiElement((PsiElement)psiElement3, (Module)locationFromContext.getModule());
        if (locationFromElement != null) {
            RunnerAndConfigurationSettings settings = this.findExistingConfiguration(context);
            RunConfiguration runConfiguration = preferredConfig.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
            if (this.isSame(runConfiguration, (RunConfiguration)(runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null))) {
                preferredConfig.setConfigurationSettings(settings);
            } else {
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                RunManager runManager = RunManager.Companion.getInstance(project);
                RunConfiguration runConfiguration2 = preferredConfig.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)runConfiguration2, (String)"getConfiguration(...)");
                runManager.setUniqueNameIfNeeded(runConfiguration2);
            }
        }
        return preferredConfig;
    }

    public boolean isConfigurationFromContext(@NotNull CargoCommandConfiguration configuration, @NotNull ConfigurationContext context) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$any$iv = this.producers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CargoRunConfigurationProducer it2 = (CargoRunConfigurationProducer)((Object)element$iv);
                    boolean bl2 = false;
                    if (!it2.isConfigurationFromContext((RunConfiguration)configuration, context)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean setupConfigurationFromContext(@NotNull CargoCommandConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
            Iterable $this$any$iv = this.producers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CargoRunConfigurationProducer it2 = (CargoRunConfigurationProducer)((Object)element$iv);
                    boolean bl2 = false;
                    if (!it2.setupConfigurationFromContext(configuration, context, sourceElement)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public RunConfiguration createLightConfiguration(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CargoRunConfigurationProducer cargoRunConfigurationProducer = this.getPreferredProducerForContext(context);
        if (cargoRunConfigurationProducer == null) {
            return null;
        }
        CargoRunConfigurationProducer producer = cargoRunConfigurationProducer;
        RunConfiguration runConfiguration = this.getConfigurationFactory().createTemplateConfiguration(context.getProject());
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type org.rust.cargo.runconfig.command.CargoCommandConfiguration");
        CargoCommandConfiguration configuration = (CargoCommandConfiguration)runConfiguration;
        Ref ref = new Ref((Object)context.getPsiLocation());
        try {
            if (!producer.setupConfigurationFromContext(configuration, context, (Ref<PsiElement>)ref)) {
                return null;
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return (RunConfiguration)configuration;
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigurationFromContext createPreferredConfigurationFromContext(ConfigurationContext context) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.producers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConfigurationFromContext it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CargoRunConfigurationProducer it2 = (CargoRunConfigurationProducer)((Object)element$iv$iv);
            boolean bl2 = false;
            if (it2.createConfigurationFromContext(context) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Comparator comparator = ConfigurationFromContext.COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"COMPARATOR");
        return (ConfigurationFromContext)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator));
    }

    private final CargoRunConfigurationProducer getPreferredProducerForContext(ConfigurationContext context) {
        Sequence sequence2 = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.producers), arg_0 -> CompositeCargoRunConfigurationProducer.getPreferredProducerForContext$lambda$0(context, arg_0));
        Comparator<Pair> comparator = Comparator.comparing(arg_0 -> ((KProperty1)((KProperty1)getPreferredProducerForContext.3.INSTANCE)).get(arg_0), ConfigurationFromContext.COMPARATOR);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        return (CargoRunConfigurationProducer)((Object)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)sequence2, comparator), CompositeCargoRunConfigurationProducer::getPreferredProducerForContext$lambda$1)));
    }

    private final boolean isSame(RunConfiguration $this$isSame, RunConfiguration other) {
        return $this$isSame == other ? true : (!($this$isSame instanceof CargoCommandConfiguration) || !(other instanceof CargoCommandConfiguration) ? $this$isSame.equals(other) : (((CargoCommandConfiguration)$this$isSame).getChannel() != ((CargoCommandConfiguration)other).getChannel() ? false : (!Intrinsics.areEqual((Object)((CargoCommandConfiguration)$this$isSame).getProgramParameters(), (Object)((CargoCommandConfiguration)other).getProgramParameters()) ? false : (!Intrinsics.areEqual((Object)((CargoCommandConfiguration)$this$isSame).getBuildProfile(), (Object)((CargoCommandConfiguration)other).getBuildProfile()) ? false : (((CargoCommandConfiguration)$this$isSame).getBacktrace() != ((CargoCommandConfiguration)other).getBacktrace() ? false : Intrinsics.areEqual((Object)((CargoCommandConfiguration)$this$isSame).getWorkingDirectory(), (Object)((CargoCommandConfiguration)other).getWorkingDirectory()))))));
    }

    private static final Pair getPreferredProducerForContext$lambda$0(ConfigurationContext $context, CargoRunConfigurationProducer it2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
        ConfigurationFromContext configurationFromContext = it2.createConfigurationFromContext($context);
        if (configurationFromContext != null) {
            ConfigurationFromContext key = configurationFromContext;
            boolean bl = false;
            pair = new Pair((Object)key, (Object)it2);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final CargoRunConfigurationProducer getPreferredProducerForContext$lambda$1(Pair it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return (CargoRunConfigurationProducer)((Object)it2.getSecond());
    }
}

