/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.command;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.UtilsKt;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.command.CargoRunConfigurationProducer;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsUseSpeckKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/runconfig/command/CargoExecutableRunConfigurationProducer;", "Lorg/rust/cargo/runconfig/command/CargoRunConfigurationProducer;", "<init>", "()V", "isConfigurationFromContext", "", "configuration", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "ExecutableTarget", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoExecutableRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoExecutableRunConfigurationProducer.kt\norg/rust/cargo/runconfig/command/CargoExecutableRunConfigurationProducer\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,88:1\n9#2:89\n*S KotlinDebug\n*F\n+ 1 CargoExecutableRunConfigurationProducer.kt\norg/rust/cargo/runconfig/command/CargoExecutableRunConfigurationProducer\n*L\n43#1:89\n*E\n"})
public final class CargoExecutableRunConfigurationProducer
extends CargoRunConfigurationProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isConfigurationFromContext(@NotNull CargoCommandConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        ExecutableTarget executableTarget = CargoExecutableRunConfigurationProducer.Companion.findBinaryTarget(location2);
        if (executableTarget == null) {
            return false;
        }
        ExecutableTarget target = executableTarget;
        return configuration.canBeFrom(target.getCargoCommandLine());
    }

    @Override
    public boolean setupConfigurationFromContext(@NotNull CargoCommandConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        ExecutableTarget executableTarget = CargoExecutableRunConfigurationProducer.Companion.findBinaryTarget(location2);
        if (executableTarget == null) {
            return false;
        }
        ExecutableTarget target = executableTarget;
        PsiElement psiElement3 = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getPsiElement(...)");
        PsiElement $this$ancestorStrict$iv = psiElement3;
        boolean $i$f$ancestorStrict = false;
        RsFunction fn = (RsFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsFunction.class, (boolean)true);
        if (fn != null && Companion.isMainFunction(fn)) {
            psiElement2 = fn;
        } else {
            PsiElement psiElement4 = context.getPsiLocation();
            psiElement2 = (PsiElement)(psiElement4 != null ? psiElement4.getContainingFile() : null);
        }
        PsiElement source = psiElement2;
        sourceElement.set((Object)source);
        configuration.setName(target.getConfigurationName());
        CargoCommandLine cmd = UtilsKt.mergeWithDefault(target.getCargoCommandLine(), configuration);
        configuration.setFromCmd(cmd);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/rust/cargo/runconfig/command/CargoExecutableRunConfigurationProducer$Companion;", "", "<init>", "()V", "isMainFunction", "", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "isMainFunctionImport", "useSpeck", "Lorg/rust/lang/core/psi/RsUseSpeck;", "hasValidTarget", "element", "Lorg/rust/lang/core/psi/ext/RsElement;", "findBinaryTarget", "Lorg/rust/cargo/runconfig/command/CargoExecutableRunConfigurationProducer$ExecutableTarget;", "location", "Lcom/intellij/execution/Location;", "ws", "Lorg/rust/cargo/project/workspace/CargoWorkspace;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMainFunction(@NotNull RsFunction fn) {
            Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
            if (!RsFunctionKt.isMain(fn)) {
                return false;
            }
            return this.hasValidTarget(fn);
        }

        public final boolean isMainFunctionImport(@NotNull RsUseSpeck useSpeck) {
            Intrinsics.checkNotNullParameter((Object)useSpeck, (String)"useSpeck");
            if (!RsUseSpeckKt.isImportedMain(useSpeck)) {
                return false;
            }
            return this.hasValidTarget(useSpeck);
        }

        private final boolean hasValidTarget(RsElement element) {
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile file = virtualFile;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object object = CargoProjectServiceKt.getCargoProjects(project).findProjectForFile(file);
            if (object == null || (object = object.getWorkspace()) == null) {
                return false;
            }
            Object ws = object;
            return this.findBinaryTarget((CargoWorkspace)ws, file) != null;
        }

        private final ExecutableTarget findBinaryTarget(Location<?> location) {
            VirtualFile virtualFile = location.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            Project project = location.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object object = CargoProjectServiceKt.getCargoProjects(project).findProjectForFile(file);
            if (object == null || (object = object.getWorkspace()) == null) {
                return null;
            }
            Object ws = object;
            return this.findBinaryTarget((CargoWorkspace)ws, file);
        }

        private final ExecutableTarget findBinaryTarget(CargoWorkspace ws, VirtualFile file) {
            CargoWorkspace.Target target = ws.findTargetByCrateRoot(file);
            if (target == null) {
                return null;
            }
            CargoWorkspace.Target target2 = target;
            if (!target2.getKind().isBin() && !target2.getKind().isExampleBin()) {
                return null;
            }
            return new ExecutableTarget(target2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/cargo/runconfig/command/CargoExecutableRunConfigurationProducer$ExecutableTarget;", "", "target", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;", "<init>", "(Lorg/rust/cargo/project/workspace/CargoWorkspace$Target;)V", "configurationName", "", "getConfigurationName", "()Ljava/lang/String;", "cargoCommandLine", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "getCargoCommandLine", "()Lorg/rust/cargo/toolchain/CargoCommandLine;", "intellij.rustrover.core"})
    private static final class ExecutableTarget {
        @NotNull
        private final String configurationName;
        @NotNull
        private final CargoCommandLine cargoCommandLine;

        public ExecutableTarget(@NotNull CargoWorkspace.Target target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.configurationName = "Run " + target.getName();
            this.cargoCommandLine = CargoCommandLine.Companion.forTarget$default(CargoCommandLine.Companion, target, "run", null, null, null, false, 60, null);
        }

        @NotNull
        public final String getConfigurationName() {
            return this.configurationName;
        }

        @NotNull
        public final CargoCommandLine getCargoCommandLine() {
            return this.cargoCommandLine;
        }
    }
}

