/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.buildtool;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.buildtool.CargoBuildTaskRunnerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/rust/cargo/runconfig/buildtool/WaitingTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "waitingIndicator", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "executionStarted", "Ljava/util/concurrent/Future;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Future;)V", "getWaitingIndicator", "()Ljava/util/concurrent/CompletableFuture;", "getExecutionStarted", "()Ljava/util/concurrent/Future;", "run", "", "indicator", "intellij.rustrover.core"})
final class WaitingTask
extends Task.Backgroundable {
    @NotNull
    private final CompletableFuture<ProgressIndicator> waitingIndicator;
    @NotNull
    private final Future<Boolean> executionStarted;

    public WaitingTask(@NotNull Project project, @NotNull CompletableFuture<ProgressIndicator> waitingIndicator, @NotNull Future<Boolean> executionStarted) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(waitingIndicator, (String)"waitingIndicator");
        Intrinsics.checkNotNullParameter(executionStarted, (String)"executionStarted");
        super(project, RsBundle.INSTANCE.message("progress.text.waiting.for.current.build.to.finish", new Object[0]), true);
        this.waitingIndicator = waitingIndicator;
        this.executionStarted = executionStarted;
    }

    @NotNull
    public final CompletableFuture<ProgressIndicator> getWaitingIndicator() {
        return this.waitingIndicator;
    }

    @NotNull
    public final Future<Boolean> getExecutionStarted() {
        return this.executionStarted;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.waitingIndicator.complete(indicator);
        try {
            while (true) {
                indicator.checkCanceled();
                try {
                    this.executionStarted.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    continue;
                }
                break;
            }
        }
        catch (CancellationException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (ExecutionException e) {
            CargoBuildTaskRunnerKt.access$getLOG$p().error((Throwable)e);
            throw new ProcessCanceledException((Throwable)e);
        }
    }
}

