/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.buildtool;

import com.google.gson.JsonObject;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.RsAnsiEscapeDecoder;
import org.rust.cargo.runconfig.RsAnsiEscapeDecoderKt;
import org.rust.cargo.runconfig.buildtool.CargoBuildContextBase;
import org.rust.cargo.toolchain.impl.CargoMetadata;
import org.rust.cargo.toolchain.impl.CargoTopMessage;
import org.rust.cargo.toolchain.impl.CompilerArtifactMessage;
import org.rust.cargo.toolchain.impl.RustcMessage;
import org.rust.cargo.toolchain.impl.RustcSpan;
import org.rust.openapiext.JsonUtils;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0016J \u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0002J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00142\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0002J \u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00162\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0002J\"\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0002J(\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020\u00162\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0002J(\u0010,\u001a\u00020\"*\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001a2\b\u0010-\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010.\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/rust/cargo/runconfig/buildtool/RsBuildEventsConverter;", "Lcom/intellij/build/output/BuildOutputParser;", "context", "Lorg/rust/cargo/runconfig/buildtool/CargoBuildContextBase;", "<init>", "(Lorg/rust/cargo/runconfig/buildtool/CargoBuildContextBase;)V", "decoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "startEvents", "", "Lcom/intellij/build/events/StartEvent;", "messageEvents", "", "Lcom/intellij/build/events/MessageEvent;", "jsonBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "currentProblemEventId", "", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "tryHandleRustcMessage", "jsonObject", "Lcom/google/gson/JsonObject;", "tryHandleRustcArtifact", "tryHandleCargoMessage", "handleCompilingMessage", "", "originalMessage", "isUpToDate", "handleProgressMessage", "message", "handleFinishedMessage", "failedTaskName", "handleProblemMessage", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "acceptUnclassifiedCargoText", "parentId", "text", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsBuildEventsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsBuildEventsConverter.kt\norg/rust/cargo/runconfig/buildtool/RsBuildEventsConverter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,414:1\n413#2,4:415\n401#2,4:419\n1#3:423\n2746#4,3:424\n1563#4:432\n1634#4,3:433\n60#5,5:427\n60#5,5:436\n60#5,5:441\n13#5:446\n*S KotlinDebug\n*F\n+ 1 RsBuildEventsConverter.kt\norg/rust/cargo/runconfig/buildtool/RsBuildEventsConverter\n*L\n110#1:415,4\n119#1:419,4\n158#1:424,3\n287#1:432\n287#1:433,3\n167#1:427,5\n313#1:436,5\n359#1:441,5\n365#1:446\n*E\n"})
public final class RsBuildEventsConverter
implements BuildOutputParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CargoBuildContextBase context;
    @NotNull
    private final AnsiEscapeDecoder decoder;
    @NotNull
    private final List<StartEvent> startEvents;
    @NotNull
    private final Set<MessageEvent> messageEvents;
    @NotNull
    private final StringBuilder jsonBuffer;
    @Nullable
    private volatile Object currentProblemEventId;
    @NotNull
    private static final Logger BUILD_PROBLEMS_LOG;
    @NotNull
    private static final List<String> MESSAGES_TO_IGNORE;
    @NotNull
    private static final String FAILED_TO_RUN_CUSTOM_BUILD_COMMAND_MESSAGE = "Failed to run custom build command for `";
    @NotNull
    private static final List<MessageEvent.Kind> ERROR_OR_WARNING;

    public RsBuildEventsConverter(@NotNull CargoBuildContextBase context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.decoder = new AnsiEscapeDecoder();
        this.startEvents = new ArrayList();
        this.messageEvents = new HashSet();
        this.jsonBuffer = new StringBuilder();
    }

    /*
     * WARNING - void declaration
     */
    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        CharSequence charSequence;
        block7: {
            String string;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
            if (((CharSequence)this.jsonBuffer).length() == 0 && !StringsKt.contains$default((CharSequence)line, (CharSequence)"{\"reason\"", (boolean)false, (int)2, null)) {
                return this.tryHandleCargoMessage(RsAnsiEscapeDecoder.Companion.quantizeAnsiColors(line), messageConsumer);
            }
            if (StringsKt.startsWith$default((String)line, (String)"\u001b[24;", (boolean)false, (int)2, null) && ((CharSequence)this.jsonBuffer).length() > 0) {
                String string2;
                block6: {
                    void $this$dropWhile$iv;
                    String string3 = StringsKt.removePrefix((String)line, (CharSequence)"\u001b[24;");
                    boolean $i$f$dropWhile = false;
                    int n = ((CharSequence)$this$dropWhile$iv).length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it2 = $this$dropWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (it2 != 'H') continue;
                        String string4 = $this$dropWhile$iv.substring(index$iv);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        break block6;
                    }
                    string2 = "";
                }
                string = StringsKt.drop((String)string2, (int)1);
            } else {
                string = line;
            }
            String cleanLine = string;
            this.jsonBuffer.append(cleanLine);
            CharSequence $this$dropWhile$iv = this.jsonBuffer;
            boolean $i$f$dropWhile = false;
            int n = $this$dropWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it3 = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it3 != '{') continue;
                charSequence = $this$dropWhile$iv.subSequence(index$iv, $this$dropWhile$iv.length());
                break block7;
            }
            charSequence = "";
        }
        String message = ((Object)charSequence).toString();
        JsonObject jsonObject = JsonUtils.tryParseJsonObject$default(JsonUtils.INSTANCE, message, false, 2, null);
        if (jsonObject == null) {
            return false;
        }
        JsonObject jsonObject2 = jsonObject;
        StringsKt.clear((StringBuilder)this.jsonBuffer);
        return this.tryHandleRustcMessage(jsonObject2, messageConsumer) || this.tryHandleRustcArtifact(jsonObject2);
    }

    private final boolean tryHandleRustcMessage(JsonObject jsonObject, Consumer<? super BuildEvent> messageConsumer) {
        String detailedMessage;
        CargoTopMessage cargoTopMessage = CargoTopMessage.Companion.fromJson(jsonObject);
        if (cargoTopMessage == null) {
            return false;
        }
        CargoTopMessage topMessage = cargoTopMessage;
        RustcMessage rustcMessage = topMessage.getMessage();
        this.currentProblemEventId = null;
        this.context.getBuildOutputFixesDataStore().saveLatestBuildFixes(this.context.getWorkingDirectory(), topMessage, this.context.getProject());
        String string = rustcMessage.getRendered();
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            v2 = RsAnsiEscapeDecoder.Companion.quantizeAnsiColors(it2);
        } else {
            v2 = detailedMessage = null;
        }
        if (detailedMessage != null) {
            RsBuildEventsConverter.Companion.acceptText(messageConsumer, this.context.getParentId(), RsBuildEventsConverter.Companion.withNewLine(detailedMessage));
        }
        char[] cArray = new char[]{'.'};
        String message = StringsKt.trimEnd((String)UtilsKt.capitalized(((Object)StringsKt.trim((CharSequence)rustcMessage.getMessage())).toString()), (char[])cArray);
        if (StringsKt.startsWith$default((String)message, (String)"Aborting due", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)message, (String)"emitted", (boolean)false, (int)2, null)) {
            return true;
        }
        String packageId = topMessage.getPackage_id();
        int lastIndexOfHash = StringsKt.lastIndexOf$default((CharSequence)packageId, (char)'#', (int)0, (boolean)false, (int)6, null);
        boolean isNewPkgId1 = lastIndexOfHash != -1 && StringsKt.lastIndexOf$default((CharSequence)packageId, (char)'@', (int)0, (boolean)false, (int)6, null) > lastIndexOfHash;
        boolean isNewPkgId2 = lastIndexOfHash != -1 && lastIndexOfHash > StringsKt.lastIndexOf$default((CharSequence)packageId, (char)'/', (int)0, (boolean)false, (int)6, null);
        String parentEventId = isNewPkgId1 ? StringsKt.replace$default((String)StringsKt.substringAfterLast$default((String)packageId, (String)"#", null, (int)2, null), (String)"@", (String)" ", (boolean)false, (int)4, null) : (isNewPkgId2 ? StringsKt.replace$default((String)StringsKt.substringAfterLast$default((String)packageId, (String)"/", null, (int)2, null), (String)"#", (String)" ", (boolean)false, (int)4, null) : ((Object)StringsKt.trimEnd((CharSequence)StringsKt.substringBefore$default((String)packageId, (String)"(", null, (int)2, null))).toString());
        MessageEvent.Kind kind2 = RsBuildEventsConverter.Companion.getMessageKind(rustcMessage.getLevel());
        if (kind2 == MessageEvent.Kind.SIMPLE) {
            return true;
        }
        RustcSpan rustcSpan = rustcMessage.getMainSpan();
        FilePosition filePosition = rustcSpan != null ? rustcSpan.toFilePosition(this.context.getWorkingDirectory()) : null;
        MessageEvent messageEvent = RsBuildEventsConverter.Companion.createMessageEvent(this.context.getWorkingDirectory(), parentEventId, kind2, message, "", filePosition);
        if (this.messageEvents.add(messageEvent)) {
            boolean bl;
            block15: {
                Iterable $this$none$iv = this.startEvents;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        StartEvent it3 = (StartEvent)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it3.getId(), (Object)parentEventId)) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.handleCompilingMessage("Compiling " + parentEventId, false, messageConsumer);
            }
            messageConsumer.accept((BuildEvent)messageEvent);
            Object object = messageEvent.getId();
            String string2 = detailedMessage;
            if (string2 == null) {
                string2 = "";
            }
            RsBuildEventsConverter.Companion.acceptText(messageConsumer, object, string2);
            if (kind2 == MessageEvent.Kind.ERROR) {
                this.context.getErrors().incrementAndGet();
                Logger $this$debug_u24default$iv = BUILD_PROBLEMS_LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl3 = false;
                    logger.debug("Rustc error: " + rustcMessage, e$iv);
                }
                RustcMessage rustcMessage2 = rustcMessage;
                ConcurrentHashMap.KeySetView<RustcMessage, Boolean> keySetView = this.context.getRustcErrorMessages();
                RustcMessage p0 = rustcMessage2;
                boolean bl4 = false;
                keySetView.add(p0);
            } else {
                this.context.getWarnings().incrementAndGet();
            }
        }
        return true;
    }

    private final boolean tryHandleRustcArtifact(JsonObject jsonObject) {
        boolean isSuitableTarget;
        CompilerArtifactMessage compilerArtifactMessage = CompilerArtifactMessage.Companion.fromJson(jsonObject);
        if (compilerArtifactMessage == null) {
            return false;
        }
        CompilerArtifactMessage rustcArtifact = compilerArtifactMessage;
        switch (WhenMappings.$EnumSwitchMapping$0[rustcArtifact.getTarget().getCleanKind().ordinal()]) {
            case 1: {
                boolean bl = true;
                break;
            }
            case 2: {
                boolean bl;
                if (CollectionsKt.singleOrNull(rustcArtifact.getTarget().getCleanCrateTypes()) == CargoMetadata.CrateType.BIN) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: 
            case 4: {
                boolean bl = true;
                break;
            }
            case 5: {
                boolean bl = rustcArtifact.getProfile().getTest();
                break;
            }
            default: {
                boolean bl = isSuitableTarget = false;
            }
        }
        if (!isSuitableTarget || this.context.isTestBuild() && !rustcArtifact.getProfile().getTest()) {
            return true;
        }
        CargoBuildContextBase cargoBuildContextBase = this.context;
        cargoBuildContextBase.setArtifacts(CollectionsKt.plus((Collection)cargoBuildContextBase.getArtifacts(), (Object)rustcArtifact));
        return true;
    }

    private final boolean tryHandleCargoMessage(String line, Consumer<? super BuildEvent> messageConsumer) {
        String cleanLine = RsAnsiEscapeDecoderKt.removeEscapeSequences(this.decoder, line);
        if (((CharSequence)cleanLine).length() == 0) {
            return true;
        }
        MessageEvent.Kind kind2 = RsBuildEventsConverter.Companion.getMessageKind(StringsKt.substringBefore$default((String)cleanLine, (String)":", null, (int)2, null));
        String it2 = cleanLine;
        boolean bl = false;
        char[] cArray = new char[]{'.'};
        String message = StringsKt.trimEnd((String)UtilsKt.capitalized(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)(ERROR_OR_WARNING.contains(kind2) ? StringsKt.substringAfter$default((String)it2, (String)":", null, (int)2, null) : it2), (CharSequence)" internal compiler error:"))).toString()), (char[])cArray);
        if (StringsKt.startsWith$default((String)message, (String)"Compiling", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)message, (String)"Checking", (boolean)false, (int)2, null)) {
            this.handleCompilingMessage(message, false, messageConsumer);
        } else if (StringsKt.startsWith$default((String)message, (String)"Fresh", (boolean)false, (int)2, null)) {
            this.handleCompilingMessage(message, true, messageConsumer);
        } else {
            if (StringsKt.startsWith$default((String)message, (String)"Building", (boolean)false, (int)2, null)) {
                this.handleProgressMessage(cleanLine, messageConsumer);
                return true;
            }
            if (StringsKt.startsWith$default((String)message, (String)"Downloading", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)message, (String)"Checkout", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)message, (String)"Fetch", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)message, (String)"Finished", (boolean)false, (int)2, null)) {
                this.handleFinishedMessage(null, messageConsumer);
            } else if (StringsKt.startsWith$default((String)message, (String)"Could not compile", (boolean)false, (int)2, null)) {
                String taskName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)message, (String)"`", null, (int)2, null), (String)"`", null, (int)2, null);
                this.handleFinishedMessage(taskName, messageConsumer);
            } else if (ERROR_OR_WARNING.contains(kind2)) {
                this.handleProblemMessage(kind2, message, messageConsumer);
            }
        }
        this.acceptUnclassifiedCargoText(messageConsumer, this.context.getParentId(), RsBuildEventsConverter.Companion.withNewLine(line));
        return true;
    }

    private final void handleCompilingMessage(String originalMessage, boolean isUpToDate, Consumer<? super BuildEvent> messageConsumer) {
        this.currentProblemEventId = null;
        String message = ((Object)StringsKt.trimEnd((CharSequence)StringsKt.substringBefore$default((String)StringsKt.replace$default((String)originalMessage, (String)"Fresh", (String)"Compiling", (boolean)false, (int)4, null), (String)"(", null, (int)2, null))).toString();
        String eventId = StringsKt.replace$default((String)StringsKt.substringAfter$default((String)message, (String)" ", null, (int)2, null), (String)" v", (String)" ", (boolean)false, (int)4, null);
        StartEventImpl startEvent = new StartEventImpl((Object)eventId, this.context.getParentId(), System.currentTimeMillis(), message);
        messageConsumer.accept((BuildEvent)startEvent);
        if (isUpToDate) {
            FinishEventImpl finishEvent = new FinishEventImpl((Object)eventId, this.context.getParentId(), System.currentTimeMillis(), message, (EventResult)new SuccessResultImpl(isUpToDate));
            messageConsumer.accept((BuildEvent)finishEvent);
        } else {
            this.startEvents.add((StartEvent)startEvent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleProgressMessage(String message, Consumer<? super BuildEvent> messageConsumer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new String[]{","};
        object = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)message, (String)":", null, (int)2, null), (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)it2, (String)"(", null, (int)2, null))).toString());
        }
        List activeTaskNames = (List)destination$iv$iv;
        RsBuildEventsConverter.handleProgressMessage$finishNonActiveTasks(this, messageConsumer, activeTaskNames);
    }

    private final void handleFinishedMessage(String failedTaskName, Consumer<? super BuildEvent> messageConsumer) {
        for (StartEvent startEvent : this.startEvents) {
            String string;
            FinishEventImpl finishEvent = new FinishEventImpl(startEvent.getId(), this.context.getParentId(), System.currentTimeMillis(), startEvent.getMessage(), Intrinsics.areEqual((Object)(string = failedTaskName), (Object)RsBuildEventsConverter.Companion.getTaskName(startEvent)) ? (EventResult)new FailureResultImpl(null) : (string == null ? (EventResult)new SuccessResultImpl() : (EventResult)new SkippedResultImpl()));
            messageConsumer.accept((BuildEvent)finishEvent);
        }
    }

    private final void handleProblemMessage(MessageEvent.Kind kind2, String message, Consumer<? super BuildEvent> messageConsumer) {
        MessageEvent messageEvent;
        Logger $this$debug_u24default$iv = BUILD_PROBLEMS_LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Problem: " + message, e$iv);
        }
        this.currentProblemEventId = null;
        if (MESSAGES_TO_IGNORE.contains(message)) {
            return;
        }
        Object parentEventIde = this.context.getParentId();
        if (StringsKt.startsWith$default((String)message, (String)FAILED_TO_RUN_CUSTOM_BUILD_COMMAND_MESSAGE, (boolean)false, (int)2, null)) {
            Object v0;
            String packageEventId;
            block6: {
                packageEventId = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)message, (CharSequence)FAILED_TO_RUN_CUSTOM_BUILD_COMMAND_MESSAGE), (String)"`", null, (int)2, null), (String)"(", null, (int)2, null))).toString(), (String)" v", (String)" ", (boolean)false, (int)4, null);
                Iterable iterable = this.startEvents;
                for (Object t : iterable) {
                    StartEvent it2 = (StartEvent)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)packageEventId)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            StartEvent startEvent = v0;
            if (startEvent != null) {
                messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)packageEventId, this.context.getParentId(), System.currentTimeMillis(), startEvent.getMessage(), (EventResult)new FailureResultImpl(null)));
                parentEventIde = packageEventId;
            }
        }
        if (this.messageEvents.add(messageEvent = org.rust.cargo.runconfig.buildtool.RsBuildEventsConverter$Companion.createMessageEvent$default(Companion, this.context.getWorkingDirectory(), parentEventIde, kind2, message, "", null, 32, null))) {
            this.currentProblemEventId = messageEvent.getId();
            messageConsumer.accept((BuildEvent)messageEvent);
            int n = kind2 == MessageEvent.Kind.ERROR ? this.context.getErrors().incrementAndGet() : this.context.getWarnings().incrementAndGet();
        }
    }

    private final void acceptUnclassifiedCargoText(Consumer<? super BuildEvent> $this$acceptUnclassifiedCargoText, Object parentId, @BuildEventsNls.Message String text) {
        block1: {
            RsBuildEventsConverter.Companion.acceptText($this$acceptUnclassifiedCargoText, parentId, text);
            Object object = this.currentProblemEventId;
            if (object == null) break block1;
            Object it2 = object;
            boolean bl = false;
            Logger $this$debug_u24default$iv = BUILD_PROBLEMS_LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug(RsAnsiEscapeDecoderKt.removeEscapeSequences(this.decoder, ((Object)StringsKt.trim((CharSequence)text)).toString()), e$iv);
            }
            RsBuildEventsConverter.Companion.acceptText($this$acceptUnclassifiedCargoText, it2, text);
        }
    }

    private static final void handleProgressMessage$finishNonActiveTasks(RsBuildEventsConverter this$0, Consumer<? super BuildEvent> $messageConsumer, List<String> activeTaskNames) {
        Iterator<StartEvent> startEventsIterator = this$0.startEvents.iterator();
        while (startEventsIterator.hasNext()) {
            StartEvent startEvent = startEventsIterator.next();
            String taskName = RsBuildEventsConverter.Companion.getTaskName(startEvent);
            if (CollectionsKt.contains((Iterable)activeTaskNames, (Object)taskName)) continue;
            startEventsIterator.remove();
            FinishEventImpl finishEvent = new FinishEventImpl(startEvent.getId(), this$0.context.getParentId(), System.currentTimeMillis(), startEvent.getMessage(), (EventResult)new SuccessResultImpl());
            $messageConsumer.accept((BuildEvent)finishEvent);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsBuildEventsConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BUILD_PROBLEMS_LOG = logger;
        Object[] objectArray = new String[]{"Build failed, waiting for other jobs to finish", "Build failed"};
        MESSAGES_TO_IGNORE = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new MessageEvent.Kind[]{MessageEvent.Kind.ERROR, MessageEvent.Kind.WARNING};
        ERROR_OR_WARNING = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0010\u001a\u00020\b*\u00020\bH\u0003J(\u0010\u0011\u001a\u00020\u0012*\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\bH\u0002JB\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000b2\b\b\u0001\u0010\u001e\u001a\u00020\b2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/rust/cargo/runconfig/buildtool/RsBuildEventsConverter$Companion;", "", "<init>", "()V", "BUILD_PROBLEMS_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MESSAGES_TO_IGNORE", "", "", "FAILED_TO_RUN_CUSTOM_BUILD_COMMAND_MESSAGE", "ERROR_OR_WARNING", "Lcom/intellij/build/events/MessageEvent$Kind;", "taskName", "Lcom/intellij/build/events/StartEvent;", "getTaskName", "(Lcom/intellij/build/events/StartEvent;)Ljava/lang/String;", "withNewLine", "acceptText", "", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parentId", "text", "getMessageKind", "kind", "createMessageEvent", "Lcom/intellij/build/events/MessageEvent;", "workingDirectory", "Ljava/nio/file/Path;", "parentEventId", "message", "detailedMessage", "filePosition", "Lcom/intellij/build/FilePosition;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getTaskName(StartEvent $this$taskName) {
            Object object = $this$taskName.getId();
            String string = object instanceof String ? (String)object : null;
            return string != null && (string = StringsKt.substringBefore$default((String)string, (String)" ", null, (int)2, null)) != null && (string = StringsKt.substringBefore$default((String)string, (String)"(", null, (int)2, null)) != null ? ((Object)StringsKt.trimEnd((CharSequence)string)).toString() : null;
        }

        @NlsSafe
        private final String withNewLine(String $this$withNewLine) {
            return StringUtil.endsWithLineBreak((CharSequence)$this$withNewLine) ? $this$withNewLine : $this$withNewLine + "\n";
        }

        private final void acceptText(Consumer<? super BuildEvent> $this$acceptText, Object parentId, @BuildEventsNls.Message String text) {
            $this$acceptText.accept((BuildEvent)new OutputBuildEventImpl(parentId, text, true));
        }

        /*
         * Unable to fully structure code
         */
        private final MessageEvent.Kind getMessageKind(String kind) {
            block6: {
                var2_2 = kind;
                switch (var2_2.hashCode()) {
                    case 280265756: {
                        if (!var2_2.equals("error: internal compiler error")) {
                            ** break;
                        }
                        ** GOTO lbl12
                    }
                    case 1124446108: {
                        if (var2_2.equals("warning")) break;
                        ** break;
                    }
                    case 96784904: {
                        if (!var2_2.equals("error")) ** break;
lbl12:
                        // 2 sources

                        v0 = MessageEvent.Kind.ERROR;
                        break block6;
                    }
                }
                v0 = MessageEvent.Kind.WARNING;
                break block6;
lbl16:
                // 4 sources

                v0 = MessageEvent.Kind.SIMPLE;
            }
            return v0;
        }

        private final MessageEvent createMessageEvent(Path workingDirectory, Object parentEventId, MessageEvent.Kind kind2, @BuildEventsNls.Message String message, @Nls String detailedMessage, FilePosition filePosition) {
            String string = RsBundle.INSTANCE.message("rust.compiler", new Object[0]);
            FilePosition filePosition2 = filePosition;
            if (filePosition2 == null) {
                filePosition2 = new FilePosition(workingDirectory.toFile(), 0, 0);
            }
            return (MessageEvent)new FileMessageEventImpl(parentEventId, kind2, string, message, detailedMessage, filePosition2);
        }

        static /* synthetic */ MessageEvent createMessageEvent$default(Companion companion, Path path, Object object, MessageEvent.Kind kind2, String string, String string2, FilePosition filePosition, int n, Object object2) {
            if ((n & 0x20) != 0) {
                filePosition = null;
            }
            return companion.createMessageEvent(path, object, kind2, string, string2, filePosition);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CargoMetadata.TargetKind.values().length];
            try {
                nArray[CargoMetadata.TargetKind.BIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CargoMetadata.TargetKind.EXAMPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CargoMetadata.TargetKind.TEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CargoMetadata.TargetKind.BENCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CargoMetadata.TargetKind.LIB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

