/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.buildtool;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.refactoring.RefactoringFactory;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.runconfig.buildtool.BuildOutputFixesDataStoreKt;
import org.rust.cargo.toolchain.impl.RustcSpan;
import org.rust.ide.fixes.RenameFix;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00162\u00020\u0001:\u0003\u0014\u0015\u0016B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/rust/cargo/runconfig/buildtool/FixApply;", "", "range", "Lcom/intellij/psi/SmartPsiFileRange;", "suggestedReplacement", "", "<init>", "(Lcom/intellij/psi/SmartPsiFileRange;Ljava/lang/String;)V", "getRange", "()Lcom/intellij/psi/SmartPsiFileRange;", "getSuggestedReplacement", "()Ljava/lang/String;", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "preview", "", "SimpleReplaceApply", "RenameElementApply", "Companion", "Lorg/rust/cargo/runconfig/buildtool/FixApply$RenameElementApply;", "Lorg/rust/cargo/runconfig/buildtool/FixApply$SimpleReplaceApply;", "intellij.rustrover.core"})
public abstract sealed class FixApply {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartPsiFileRange range;
    @NotNull
    private final String suggestedReplacement;

    private FixApply(SmartPsiFileRange range, String suggestedReplacement) {
        this.range = range;
        this.suggestedReplacement = suggestedReplacement;
    }

    @NotNull
    public final SmartPsiFileRange getRange() {
        return this.range;
    }

    @NotNull
    public final String getSuggestedReplacement() {
        return this.suggestedReplacement;
    }

    public abstract void apply(@NotNull Project var1, @NotNull Document var2, boolean var3);

    public /* synthetic */ FixApply(SmartPsiFileRange range, String suggestedReplacement, DefaultConstructorMarker $constructor_marker) {
        this(range, suggestedReplacement);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/rust/cargo/runconfig/buildtool/FixApply$Companion;", "", "<init>", "()V", "isIdentifierReplace", "", "psi", "Lcom/intellij/psi/PsiFile;", "rangePointer", "Lcom/intellij/psi/SmartPsiFileRange;", "tryFrom", "Lorg/rust/cargo/runconfig/buildtool/FixApply;", "applySpan", "Lorg/rust/cargo/toolchain/impl/RustcSpan;", "workingDirectory", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isIdentifierReplace(PsiFile psi, SmartPsiFileRange rangePointer) {
            Segment segment = rangePointer.getRange();
            if (segment == null) {
                return false;
            }
            Segment range = segment;
            PsiElement psiElement2 = psi.findElementAt(range.getStartOffset());
            if (psiElement2 == null) {
                return false;
            }
            PsiElement element = psiElement2;
            return Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(element), (Object)RsElementTypes.IDENTIFIER) && Intrinsics.areEqual((Object)element.getTextRange(), (Object)range);
        }

        @Nullable
        public final FixApply tryFrom(@NotNull RustcSpan applySpan, @NotNull Path workingDirectory, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)applySpan, (String)"applySpan");
            Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = applySpan.getFile_name();
            if (string == null) {
                return null;
            }
            String fileName = string;
            Document document = BuildOutputFixesDataStoreKt.access$findDocument(workingDirectory, fileName);
            if (document == null) {
                return null;
            }
            Document document2 = document;
            PsiFile psiFile = UtilsKt.toPsiFile(document2, project);
            if (psiFile == null) {
                return null;
            }
            PsiFile psi = psiFile;
            SmartPsiFileRange smartPsiFileRange = applySpan.toRangePointer(psi, document2);
            if (smartPsiFileRange == null) {
                return null;
            }
            SmartPsiFileRange rangePointer = smartPsiFileRange;
            String string2 = applySpan.getSuggested_replacement();
            if (string2 == null) {
                return null;
            }
            String replacement = string2;
            return this.isIdentifierReplace(psi, rangePointer) ? (FixApply)new RenameElementApply(rangePointer, replacement) : (FixApply)new SimpleReplaceApply(rangePointer, replacement);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/runconfig/buildtool/FixApply$RenameElementApply;", "Lorg/rust/cargo/runconfig/buildtool/FixApply;", "range", "Lcom/intellij/psi/SmartPsiFileRange;", "suggestedReplacement", "", "<init>", "(Lcom/intellij/psi/SmartPsiFileRange;Ljava/lang/String;)V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "preview", "", "intellij.rustrover.core"})
    public static final class RenameElementApply
    extends FixApply {
        public RenameElementApply(@NotNull SmartPsiFileRange range, @NotNull String suggestedReplacement) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)suggestedReplacement, (String)"suggestedReplacement");
            super(range, suggestedReplacement, null);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull Document document, boolean preview) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Segment segment = this.getRange().getRange();
            if (segment == null) {
                return;
            }
            Segment textRange = segment;
            PsiFile psiFile = UtilsKt.toPsiFile(document, project);
            if (psiFile == null || (psiFile = psiFile.findElementAt(textRange.getStartOffset())) == null || (psiFile = psiFile.getParent()) == null) {
                return;
            }
            PsiFile element = psiFile;
            if (element instanceof PsiNamedElement) {
                if (preview) {
                    ActionsKt.runWriteAction(() -> RenameElementApply.apply$lambda$0((PsiElement)element, this));
                } else {
                    RefactoringFactory.getInstance((Project)project).createRename(RenameFix.Companion.findElementToRename((PsiNamedElement)element), this.getSuggestedReplacement()).run();
                }
            } else {
                ActionsKt.runWriteAction(() -> RenameElementApply.apply$lambda$1(document, textRange, this));
            }
        }

        private static final PsiElement apply$lambda$0(PsiElement $element, RenameElementApply this$0) {
            return ((PsiNamedElement)$element).setName(this$0.getSuggestedReplacement());
        }

        private static final Unit apply$lambda$1(Document $document, Segment $textRange, RenameElementApply this$0) {
            $document.replaceString($textRange.getStartOffset(), $textRange.getEndOffset(), (CharSequence)this$0.getSuggestedReplacement());
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/cargo/runconfig/buildtool/FixApply$SimpleReplaceApply;", "Lorg/rust/cargo/runconfig/buildtool/FixApply;", "range", "Lcom/intellij/psi/SmartPsiFileRange;", "suggestedReplacement", "", "<init>", "(Lcom/intellij/psi/SmartPsiFileRange;Ljava/lang/String;)V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "preview", "", "intellij.rustrover.core"})
    public static final class SimpleReplaceApply
    extends FixApply {
        public SimpleReplaceApply(@NotNull SmartPsiFileRange range, @NotNull String suggestedReplacement) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)suggestedReplacement, (String)"suggestedReplacement");
            super(range, suggestedReplacement, null);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull Document document, boolean preview) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Segment segment = this.getRange().getRange();
            if (segment == null) {
                return;
            }
            Segment textRange = segment;
            ActionsKt.runWriteAction(() -> SimpleReplaceApply.apply$lambda$0(document, textRange, this));
        }

        private static final Unit apply$lambda$0(Document $document, Segment $textRange, SimpleReplaceApply this$0) {
            $document.replaceString($textRange.getStartOffset(), $textRange.getEndOffset(), (CharSequence)this$0.getSuggestedReplacement());
            return Unit.INSTANCE;
        }
    }
}

