/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.buildtool;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.runconfig.RsCommandConfigurationKt;
import org.rust.cargo.runconfig.UtilsKt;
import org.rust.cargo.runconfig.buildtool.BackgroundableProjectTaskRunner;
import org.rust.cargo.runconfig.buildtool.CargoBuildConfiguration;
import org.rust.cargo.runconfig.buildtool.CargoBuildManager;
import org.rust.cargo.runconfig.buildtool.CargoBuildResult;
import org.rust.cargo.runconfig.buildtool.CargoBuildSessionsQueueManager;
import org.rust.cargo.runconfig.buildtool.WaitingTask;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.util.RustCrateUtilKt;
import org.rust.ide.experiments.RsExperiments;
import org.rust.stdext.CollectionBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0014\u001a\u00020\r\u00a8\u0006\u0016"}, d2={"Lorg/rust/cargo/runconfig/buildtool/CargoBuildTaskRunner;", "Lcom/intellij/task/ProjectTaskRunner;", "<init>", "()V", "run", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/task/ProjectTaskContext;", "tasks", "", "Lcom/intellij/task/ProjectTask;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/task/ProjectTaskContext;[Lcom/intellij/task/ProjectTask;)Lorg/jetbrains/concurrency/Promise;", "canRun", "", "projectTask", "expandTask", "", "task", "executeTask", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoBuildTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoBuildTaskRunner.kt\norg/rust/cargo/runconfig/buildtool/CargoBuildTaskRunner\n+ 2 Collections.kt\norg/rust/stdext/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n13#2:307\n31#2:308\n23#2,10:309\n1617#3,9:319\n1869#3:328\n1870#3:330\n1626#3:331\n1#4:329\n*S KotlinDebug\n*F\n+ 1 CargoBuildTaskRunner.kt\norg/rust/cargo/runconfig/buildtool/CargoBuildTaskRunner\n*L\n134#1:307\n134#1:308\n134#1:309,10\n142#1:319,9\n142#1:328\n142#1:330\n142#1:331\n142#1:329\n*E\n"})
public final class CargoBuildTaskRunner
extends ProjectTaskRunner {
    @NotNull
    public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
        CargoCommandConfiguration configuration;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        if (project.isDisposed()) {
            return Promises.rejectedPromise((String)"Project is already disposed");
        }
        boolean confirmed = (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> CargoBuildTaskRunner.run$lambda$0(project), (int)1, null);
        if (!confirmed) {
            return Promises.rejectedPromise((String)RsBundle.INSTANCE.message("untrusted.project.notification.execution.error", new Object[0]));
        }
        RunConfiguration runConfiguration = context.getRunConfiguration();
        CargoCommandConfiguration cargoCommandConfiguration = configuration = runConfiguration instanceof CargoCommandConfiguration ? (CargoCommandConfiguration)runConfiguration : null;
        boolean bl = cargoCommandConfiguration != null ? RsCommandConfigurationKt.getHasRemoteTarget(cargoCommandConfiguration) : false;
        if (bl || !RsExperiments.INSTANCE.getBUILD_TOOL_WINDOW().asBoolean()) {
            ActionsKt.invokeLater$default(null, () -> CargoBuildTaskRunner.run$lambda$1(project), (int)1, null);
            return Promises.rejectedPromise();
        }
        AsyncPromise resultPromise = new AsyncPromise();
        CompletableFuture<ProgressIndicator> waitingIndicator = new CompletableFuture<ProgressIndicator>();
        BackgroundableProjectTaskRunner queuedTask = new BackgroundableProjectTaskRunner(project, tasks, this, (AsyncPromise<ProjectTaskRunner.Result>)resultPromise, (Future<ProgressIndicator>)waitingIndicator);
        if (!org.rust.openapiext.UtilsKt.isHeadlessEnvironment()) {
            new WaitingTask(project, waitingIndicator, (Future<Boolean>)queuedTask.getExecutionStarted()).queue();
        }
        CargoBuildSessionsQueueManager.Companion.getInstance(project).getBuildSessionsQueue().run((Task.Backgroundable)queuedTask, ModalityState.defaultModalityState(), (ProgressIndicator)new EmptyProgressIndicator());
        return (Promise)resultPromise;
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
        ProjectTask projectTask2 = projectTask;
        if (projectTask2 instanceof ModuleFilesBuildTask) {
            bl = false;
        } else if (projectTask2 instanceof ModuleBuildTask) {
            RunConfiguration buildableElement;
            Module module = ((ModuleBuildTask)projectTask).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            if (RustCrateUtilKt.getCargoProjectRoot(module) != null) {
                return true;
            }
            Project project = ((ModuleBuildTask)projectTask).getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RunManager runManager = RunManager.Companion.getInstance(project);
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.getSelectedConfiguration();
            Object object = buildableElement = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
            bl = buildableElement instanceof CargoCommandConfiguration && CargoBuildManager.INSTANCE.isBuildToolWindowAvailable((CargoCommandConfiguration)buildableElement);
        } else {
            ProjectModelBuildableElement buildableElement;
            bl = projectTask2 instanceof ProjectModelBuildTask ? (buildableElement = ((ProjectModelBuildTask)projectTask).getBuildableElement()) instanceof CargoBuildConfiguration && ((CargoBuildConfiguration)buildableElement).getEnabled() : false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProjectTask> expandTask(@NotNull ProjectTask task2) {
        void $this$mapNotNullTo$iv$iv;
        void result$iv$iv;
        CargoCommandConfiguration oldConfiguration;
        RunnerAndConfigurationSettings oldSettings;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (!(task2 instanceof ModuleBuildTask)) {
            return CollectionsKt.listOf((Object)task2);
        }
        Project project = ((ModuleBuildTask)task2).getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        RunManager runManager = RunManager.Companion.getInstance(project2);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = oldSettings = runManager.getSelectedConfiguration();
        RunConfiguration runConfiguration = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        CargoCommandConfiguration cargoCommandConfiguration = oldConfiguration = runConfiguration instanceof CargoCommandConfiguration ? (CargoCommandConfiguration)runConfiguration : null;
        if (oldConfiguration != null) {
            CargoCommandConfiguration cargoCommandConfiguration2 = CargoBuildManager.INSTANCE.getBuildConfiguration(oldConfiguration);
            if (cargoCommandConfiguration2 == null) {
                return CollectionsKt.emptyList();
            }
            CargoCommandConfiguration buildConfiguration = cargoCommandConfiguration2;
            ExecutionEnvironment executionEnvironment = CargoBuildManager.createBuildEnvironment$default(CargoBuildManager.INSTANCE, buildConfiguration, oldSettings, null, 4, null);
            if (executionEnvironment == null) {
                return CollectionsKt.emptyList();
            }
            ExecutionEnvironment environment = executionEnvironment;
            CargoBuildConfiguration buildableElement = new CargoBuildConfiguration(buildConfiguration, environment);
            return CollectionsKt.listOf((Object)new ProjectModelBuildTaskImpl((ProjectModelBuildableElement)buildableElement, ((ModuleBuildTask)task2).isIncrementalBuild()));
        }
        Collection<CargoProject> cargoProjects = CargoProjectServiceKt.getCargoProjects(project2).getAllProjects();
        if (cargoProjects.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Run");
        if (executor == null) {
            return CollectionsKt.emptyList();
        }
        Executor executor2 = executor;
        ProgramRunner programRunner = ProgramRunner.findRunnerById((String)"CargoCommandRunner");
        if (programRunner == null) {
            return CollectionsKt.emptyList();
        }
        ProgramRunner runner = programRunner;
        boolean $i$f$buildList = false;
        Collection collection = new ArrayList();
        boolean $i$f$buildCollection22 = false;
        CollectionBuilder $this$expandTask_u24lambda_u240 = new CollectionBuilder<T>(result$iv$iv){
            final /* synthetic */ Collection<T> $result;
            {
                this.$result = $result;
            }

            public void add(T item) {
                this.$result.add(item);
            }

            public void addAll(Collection<? extends T> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                this.$result.addAll(items);
            }
        };
        boolean bl = false;
        RustProjectSettingsService settings = RustProjectSettingsServiceKt.getRustSettings(project2);
        $this$expandTask_u24lambda_u240.add("--all");
        if (settings.getCompileAllTargets()) {
            $this$expandTask_u24lambda_u240.add("--all-targets");
        }
        List additionalArguments = (List)result$iv$iv;
        Iterable $this$mapNotNull$iv = cargoProjects;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$buildCollection22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ProjectModelBuildTaskImpl projectModelBuildTaskImpl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            CargoProject cargoProject = (CargoProject)element$iv$iv;
            boolean bl3 = false;
            CargoCommandLine commandLine = CargoCommandLine.Companion.forProject$default(CargoCommandLine.Companion, cargoProject, "build", additionalArguments, false, null, null, null, 120, null);
            RunnerAndConfigurationSettings newSettings = UtilsKt.createCargoCommandRunConfiguration$default(runManager, commandLine, null, 2, null);
            ExecutionEnvironment environment = new ExecutionEnvironment(executor2, runner, newSettings, project2);
            RunConfiguration runConfiguration2 = newSettings.getConfiguration();
            if ((runConfiguration2 instanceof CargoCommandConfiguration ? (CargoCommandConfiguration)runConfiguration2 : null) == null) {
                projectModelBuildTaskImpl = null;
            } else {
                CargoCommandConfiguration newConfiguration;
                newConfiguration = newConfiguration;
                newConfiguration.setEmulateTerminal(false);
                CargoBuildConfiguration buildableElement = new CargoBuildConfiguration(newConfiguration, environment);
                projectModelBuildTaskImpl = new ProjectModelBuildTaskImpl((ProjectModelBuildableElement)buildableElement, ((ModuleBuildTask)task2).isIncrementalBuild());
            }
            if (projectModelBuildTaskImpl == null) continue;
            ProjectModelBuildTaskImpl it$iv$iv = projectModelBuildTaskImpl;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Promise<ProjectTaskRunner.Result> executeTask(@NotNull ProjectTask task2) {
        Object buildFuture;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (!(task2 instanceof ProjectModelBuildTask)) {
            return Promises.resolvedPromise((Object)TaskRunnerResults.ABORTED);
        }
        ProjectModelBuildableElement projectModelBuildableElement = ((ProjectModelBuildTask)task2).getBuildableElement();
        Intrinsics.checkNotNull((Object)projectModelBuildableElement, (String)"null cannot be cast to non-null type org.rust.cargo.runconfig.buildtool.CargoBuildConfiguration");
        CargoBuildConfiguration buildConfiguration = (CargoBuildConfiguration)projectModelBuildableElement;
        if (!((ProjectModelBuildTask)task2).isIncrementalBuild()) {
            CargoCommandConfiguration $this$executeTask_u24lambda_u240 = buildConfiguration.getConfiguration();
            boolean bl = false;
            Project project = $this$executeTask_u24lambda_u240.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = $this$executeTask_u24lambda_u240.getProgramParameters();
            if (string == null) {
                string = "";
            }
            String string2 = $this$executeTask_u24lambda_u240.getWorkingDirectory();
            CargoProject cargoProject = CargoCommandConfiguration.Companion.findCargoProject(project, string, string2 != null ? org.rust.stdext.UtilsKt.toPathOrNull(string2) : null);
            if (cargoProject != null) {
                Object cleanFuture;
                try {
                    cleanFuture = CargoBuildManager.INSTANCE.clean(cargoProject);
                    cleanFuture = (Boolean)cleanFuture.get() != false ? TaskRunnerResults.SUCCESS : TaskRunnerResults.FAILURE;
                }
                catch (ExecutionException e) {
                    cleanFuture = TaskRunnerResults.FAILURE;
                }
                Object result2 = cleanFuture;
                if (result2.hasErrors()) {
                    Promises.resolvedPromise((Object)result2);
                }
            }
        }
        try {
            buildFuture = CargoBuildManager.INSTANCE.build(buildConfiguration);
            CargoBuildResult buildResult = (CargoBuildResult)buildFuture.get();
            buildFuture = buildResult.getCanceled() ? TaskRunnerResults.ABORTED : (buildResult.getSucceeded() ? TaskRunnerResults.SUCCESS : TaskRunnerResults.FAILURE);
        }
        catch (ExecutionException e) {
            buildFuture = TaskRunnerResults.FAILURE;
        }
        Object result3 = buildFuture;
        AsyncPromise promise = new AsyncPromise();
        promise.setResult(result3);
        return (Promise)promise;
    }

    private static final boolean run$lambda$0(Project $project) {
        return org.rust.ide.notifications.UtilsKt.confirmLoadingUntrustedProject($project);
    }

    private static final Unit run$lambda$1(Project $project) {
        UtilsKt.buildProject($project);
        return Unit.INSTANCE;
    }
}

