/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.buildtool;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.runconfig.buildtool.BuildOutputFixesDataStore;
import org.rust.cargo.toolchain.impl.CompilerArtifactMessage;
import org.rust.cargo.toolchain.impl.RustcMessage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0001\u0012\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00070'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010%R \u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u00068"}, d2={"Lorg/rust/cargo/runconfig/buildtool/CargoBuildContextBase;", "", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "progressTitle", "", "isTestBuild", "", "buildId", "parentId", "<init>", "(Lorg/rust/cargo/project/model/CargoProject;Ljava/lang/String;ZLjava/lang/Object;Ljava/lang/Object;)V", "getCargoProject", "()Lorg/rust/cargo/project/model/CargoProject;", "getProgressTitle", "()Ljava/lang/String;", "()Z", "getBuildId", "()Ljava/lang/Object;", "getParentId", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "workingDirectory", "Ljava/nio/file/Path;", "getWorkingDirectory", "()Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "errors", "Ljava/util/concurrent/atomic/AtomicInteger;", "getErrors", "()Ljava/util/concurrent/atomic/AtomicInteger;", "rustcErrorMessages", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lorg/rust/cargo/toolchain/impl/RustcMessage;", "getRustcErrorMessages", "()Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "warnings", "getWarnings", "artifacts", "", "Lorg/rust/cargo/toolchain/impl/CompilerArtifactMessage;", "getArtifacts", "()Ljava/util/List;", "setArtifacts", "(Ljava/util/List;)V", "buildOutputFixesDataStore", "Lorg/rust/cargo/runconfig/buildtool/BuildOutputFixesDataStore;", "getBuildOutputFixesDataStore", "()Lorg/rust/cargo/runconfig/buildtool/BuildOutputFixesDataStore;", "intellij.rustrover.core"})
public abstract class CargoBuildContextBase {
    @NotNull
    private final CargoProject cargoProject;
    @NotNull
    private final String progressTitle;
    private final boolean isTestBuild;
    @NotNull
    private final Object buildId;
    @NotNull
    private final Object parentId;
    @Nullable
    private volatile ProgressIndicator indicator;
    @NotNull
    private final AtomicInteger errors;
    @NotNull
    private final ConcurrentHashMap.KeySetView<RustcMessage, Boolean> rustcErrorMessages;
    @NotNull
    private final AtomicInteger warnings;
    @NotNull
    private volatile List<CompilerArtifactMessage> artifacts;
    @NotNull
    private final BuildOutputFixesDataStore buildOutputFixesDataStore;

    public CargoBuildContextBase(@NotNull CargoProject cargoProject, @NlsContexts.ProgressText @NotNull String progressTitle, boolean isTestBuild, @NotNull Object buildId, @NotNull Object parentId) {
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        this.cargoProject = cargoProject;
        this.progressTitle = progressTitle;
        this.isTestBuild = isTestBuild;
        this.buildId = buildId;
        this.parentId = parentId;
        this.errors = new AtomicInteger();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.rustcErrorMessages = keySetView;
        this.warnings = new AtomicInteger();
        this.artifacts = CollectionsKt.emptyList();
        this.buildOutputFixesDataStore = new BuildOutputFixesDataStore();
    }

    @NotNull
    public final CargoProject getCargoProject() {
        return this.cargoProject;
    }

    @NotNull
    public final String getProgressTitle() {
        return this.progressTitle;
    }

    public final boolean isTestBuild() {
        return this.isTestBuild;
    }

    @NotNull
    public final Object getBuildId() {
        return this.buildId;
    }

    @NotNull
    public final Object getParentId() {
        return this.parentId;
    }

    @NotNull
    public final Project getProject() {
        return this.cargoProject.getProject();
    }

    @NotNull
    public final Path getWorkingDirectory() {
        return this.cargoProject.getRootDirPath();
    }

    @Nullable
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public final void setIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.indicator = progressIndicator;
    }

    @NotNull
    public final AtomicInteger getErrors() {
        return this.errors;
    }

    @NotNull
    public final ConcurrentHashMap.KeySetView<RustcMessage, Boolean> getRustcErrorMessages() {
        return this.rustcErrorMessages;
    }

    @NotNull
    public final AtomicInteger getWarnings() {
        return this.warnings;
    }

    @NotNull
    public final List<CompilerArtifactMessage> getArtifacts() {
        return this.artifacts;
    }

    public final void setArtifacts(@NotNull List<CompilerArtifactMessage> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.artifacts = list;
    }

    @NotNull
    public final BuildOutputFixesDataStore getBuildOutputFixesDataStore() {
        return this.buildOutputFixesDataStore;
    }
}

