/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.buildtool;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.runconfig.buildtool.CargoBuildAdapterBaseKt;
import org.rust.cargo.runconfig.buildtool.CargoBuildContextBase;
import org.rust.cargo.runconfig.buildtool.CargoProgressParser;
import org.rust.cargo.runconfig.buildtool.IndicatorData;
import org.rust.cargo.runconfig.buildtool.RsBuildEventsConverter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/rust/cargo/runconfig/buildtool/CargoBuildAdapterBase;", "Lcom/intellij/execution/process/ProcessAdapter;", "context", "Lorg/rust/cargo/runconfig/buildtool/CargoBuildContextBase;", "buildProgressListener", "Lcom/intellij/build/BuildProgressListener;", "<init>", "(Lorg/rust/cargo/runconfig/buildtool/CargoBuildContextBase;Lcom/intellij/build/BuildProgressListener;)V", "getBuildProgressListener", "()Lcom/intellij/build/BuildProgressListener;", "instantReader", "Lcom/intellij/build/output/BuildOutputInstantReaderImpl;", "isTerminated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "processTerminated", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "onBuildOutputReaderFinish", "isSuccess", "", "isCanceled", "error", "", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "intellij.rustrover.core"})
public abstract class CargoBuildAdapterBase
extends ProcessAdapter {
    @NotNull
    private final CargoBuildContextBase context;
    @NotNull
    private final BuildProgressListener buildProgressListener;
    @NotNull
    private final BuildOutputInstantReaderImpl instantReader;
    @NotNull
    private final AtomicBoolean isTerminated;

    public CargoBuildAdapterBase(@NotNull CargoBuildContextBase context, @NotNull BuildProgressListener buildProgressListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)buildProgressListener, (String)"buildProgressListener");
        this.context = context;
        this.buildProgressListener = buildProgressListener;
        this.instantReader = new BuildOutputInstantReaderImpl(this.context.getBuildId(), this.context.getParentId(), this.buildProgressListener, CollectionsKt.listOf((Object)new RsBuildEventsConverter(this.context)), 0, 0, 48, null);
        this.isTerminated = new AtomicBoolean(false);
    }

    @NotNull
    protected final BuildProgressListener getBuildProgressListener() {
        return this.buildProgressListener;
    }

    public synchronized void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isTerminated.compareAndSet(false, true) || this.context.getProject().isDisposed()) {
            return;
        }
        this.instantReader.closeAndGetFuture().whenComplete((arg_0, arg_1) -> CargoBuildAdapterBase.processTerminated$lambda$1((arg_0, arg_1) -> CargoBuildAdapterBase.processTerminated$lambda$0(this, event, arg_0, arg_1), arg_0, arg_1));
    }

    public void onBuildOutputReaderFinish(@NotNull ProcessEvent event, boolean isSuccess, boolean isCanceled, @Nullable Throwable error) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public synchronized void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (this.isTerminated.get()) {
            return;
        }
        String string = StringUtil.convertLineSeparators((String)event.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String text = string;
        this.instantReader.append((CharSequence)text);
        String trimmed = ((Object)StringsKt.trim((CharSequence)text)).toString();
        if (StringsKt.contains$default((CharSequence)trimmed, (CharSequence)"Building", (boolean)false, (int)2, null)) {
            CargoProgressParser.INSTANCE.processBuildingProgress(trimmed, (Function1<? super IndicatorData, Unit>)((Function1)arg_0 -> CargoBuildAdapterBase.onTextAvailable$lambda$0(this, arg_0)));
        }
    }

    private static final Unit processTerminated$lambda$0(CargoBuildAdapterBase this$0, ProcessEvent $event, Unit unit, Throwable error) {
        if (this$0.context.getProject().isDisposed()) {
            return Unit.INSTANCE;
        }
        boolean isSuccess = $event.getExitCode() == 0 && this$0.context.getErrors().get() == 0;
        ProgressIndicator progressIndicator = this$0.context.getIndicator();
        boolean isCanceled = progressIndicator != null ? progressIndicator.isCanceled() : false;
        this$0.onBuildOutputReaderFinish($event, isSuccess, isCanceled, error);
        return Unit.INSTANCE;
    }

    private static final void processTerminated$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit onTextAvailable$lambda$0(CargoBuildAdapterBase this$0, IndicatorData it2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            ProgressIndicator progressIndicator = this$0.context.getIndicator();
            if (progressIndicator == null) break block0;
            CargoBuildAdapterBaseKt.access$update(progressIndicator, it2.getText(), it2.getText2(), it2.getProgress());
        }
        return Unit.INSTANCE;
    }
}

