/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig.buildtool;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.buildtool.CargoBuildTaskRunner;
import org.rust.cargo.runconfig.buildtool.CargoBuildTaskRunnerKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0002J#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/rust/cargo/runconfig/buildtool/BackgroundableProjectTaskRunner;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "tasks", "", "Lcom/intellij/task/ProjectTask;", "parentRunner", "Lorg/rust/cargo/runconfig/buildtool/CargoBuildTaskRunner;", "totalPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "waitingIndicator", "Ljava/util/concurrent/Future;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/task/ProjectTask;Lorg/rust/cargo/runconfig/buildtool/CargoBuildTaskRunner;Lorg/jetbrains/concurrency/AsyncPromise;Ljava/util/concurrent/Future;)V", "[Lcom/intellij/task/ProjectTask;", "executionStarted", "Ljava/util/concurrent/CompletableFuture;", "", "getExecutionStarted", "()Ljava/util/concurrent/CompletableFuture;", "run", "", "indicator", "waitForStart", "collectTasks", "", "([Lcom/intellij/task/ProjectTask;)Ljava/util/Collection;", "runTask", "Lorg/jetbrains/concurrency/Promise;", "task", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoBuildTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoBuildTaskRunner.kt\norg/rust/cargo/runconfig/buildtool/BackgroundableProjectTaskRunner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n3919#2:307\n4434#2,2:308\n1563#3:310\n1634#3,3:311\n1761#3,3:314\n*S KotlinDebug\n*F\n+ 1 CargoBuildTaskRunner.kt\norg/rust/cargo/runconfig/buildtool/BackgroundableProjectTaskRunner\n*L\n271#1:307\n271#1:308,2\n271#1:310\n271#1:311,3\n272#1:314,3\n*E\n"})
final class BackgroundableProjectTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final ProjectTask[] tasks;
    @NotNull
    private final CargoBuildTaskRunner parentRunner;
    @NotNull
    private final AsyncPromise<ProjectTaskRunner.Result> totalPromise;
    @NotNull
    private final Future<ProgressIndicator> waitingIndicator;
    @NotNull
    private final CompletableFuture<Boolean> executionStarted;

    public BackgroundableProjectTaskRunner(@NotNull Project project, @NotNull ProjectTask[] tasks, @NotNull CargoBuildTaskRunner parentRunner, @NotNull AsyncPromise<ProjectTaskRunner.Result> totalPromise, @NotNull Future<ProgressIndicator> waitingIndicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)((Object)parentRunner), (String)"parentRunner");
        Intrinsics.checkNotNullParameter(totalPromise, (String)"totalPromise");
        Intrinsics.checkNotNullParameter(waitingIndicator, (String)"waitingIndicator");
        super(project, RsBundle.INSTANCE.message("progress.title.building", new Object[0]), true);
        this.tasks = tasks;
        this.parentRunner = parentRunner;
        this.totalPromise = totalPromise;
        this.waitingIndicator = waitingIndicator;
        this.executionStarted = new CompletableFuture();
    }

    @NotNull
    public final CompletableFuture<Boolean> getExecutionStarted() {
        return this.executionStarted;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!this.waitForStart()) {
            if (this.totalPromise.getState() == Promise.State.PENDING) {
                this.totalPromise.cancel();
            }
            return;
        }
        Collection<ProjectTask> allTasks = this.collectTasks(this.tasks);
        if (allTasks.isEmpty()) {
            this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
            return;
        }
        try {
            for (ProjectTask task2 : allTasks) {
                Promise<ProjectTaskRunner.Result> promise = this.runTask(task2);
                if (promise.blockingGet(Integer.MAX_VALUE) == TaskRunnerResults.SUCCESS) continue;
                this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
                break;
            }
            if (Promises.isPending((Promise)((Promise)this.totalPromise))) {
                this.totalPromise.setResult((Object)TaskRunnerResults.SUCCESS);
            }
        }
        catch (InterruptedException e) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (CancellationException e) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (Throwable e) {
            CargoBuildTaskRunnerKt.access$getLOG$p().error(e);
            this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
        }
    }

    private final boolean waitForStart() {
        if (UtilsKt.isHeadlessEnvironment()) {
            return true;
        }
        try {
            boolean cancelled = this.waitingIndicator.get().isCanceled();
            this.executionStarted.complete(true);
            return !cancelled;
        }
        catch (InterruptedException e) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (CancellationException e) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (Throwable e) {
            CargoBuildTaskRunnerKt.access$getLOG$p().error(e);
            this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
            throw new ProcessCanceledException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ProjectTask> collectTasks(ProjectTask[] tasks) {
        boolean bl;
        List expandedTasks;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            ProjectTask[] $this$filter$iv = tasks;
            boolean $i$f$filter = false;
            ProjectTask[] projectTaskArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (ProjectTask element$iv$iv : $this$filterTo$iv$iv) {
                void it2 = element$iv$iv;
                boolean bl2 = false;
                if (!this.parentRunner.canRun((ProjectTask)it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                ProjectTask element$iv$iv;
                element$iv$iv = (ProjectTask)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(this.parentRunner.expandTask((ProjectTask)it3));
            }
            expandedTasks = (List)destination$iv$iv;
            Iterable $this$any$iv = expandedTasks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it4 = (List)element$iv;
                    boolean bl4 = false;
                    if (!it4.isEmpty()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.flatten((Iterable)expandedTasks);
    }

    private final Promise<ProjectTaskRunner.Result> runTask(ProjectTask task2) {
        return this.parentRunner.executeTask(task2);
    }
}

