/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.toolwindow.CargoToolWindow;
import org.rust.cargo.runconfig.CargoRunStateBase;
import org.rust.cargo.runconfig.ConfigurationExtensionContext;
import org.rust.cargo.runconfig.RsRunConfigurationExtensionManager;
import org.rust.cargo.runconfig.buildtool.BuildOutputFixesDataStore;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.command.CargoCommandConfigurationTypeKt;
import org.rust.cargo.runconfig.filters.BuildOutputFixesFilter;
import org.rust.cargo.runconfig.filters.RsBacktraceFilter;
import org.rust.cargo.runconfig.filters.RsDbgFilter;
import org.rust.cargo.runconfig.filters.RsExplainFilter;
import org.rust.cargo.runconfig.filters.RsPanicFilter;
import org.rust.cargo.runconfig.filters.RsSourceCodeLinkFilter;
import org.rust.cargo.toolchain.BacktraceMode;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.toolchain.RsCommandLineBase;
import org.rust.cargo.toolchain.RustChannel;
import org.rust.stdext.CollectionBuilder;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\f\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\f\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a$\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t\u001a\u001a\u0010!\u001a\u00020\u0010*\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t\u001a\u0014\u0010$\u001a\u0004\u0018\u00010\t*\u00020\"2\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010%\u001a\u00020\u0010*\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u000b\u001a\u0019\u0010&\u001a\u0004\u0018\u00010\u000b*\u00020\"2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010'\u001a-\u0010(\u001a\u00020\u0010\"\f\b\u0000\u0010)*\u0006\u0012\u0002\b\u00030**\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u0002H)\u00a2\u0006\u0002\u0010+\u001a.\u0010,\u001a\u0004\u0018\u0001H)\"\u0010\b\u0000\u0010)\u0018\u0001*\b\u0012\u0004\u0012\u0002H)0**\u00020\"2\u0006\u0010\b\u001a\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010-\u001a\u001c\u0010.\u001a\u00020\u0010*\u00020\"2\u0006\u0010\b\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010/\u001a\u0014\u00100\u001a\u0004\u0018\u00010/*\u00020\"2\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u00101\u001a\u000202*\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00068"}, d2={"mergeWithDefault", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "default", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "createCargoCommandRunConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "Lcom/intellij/execution/RunManager;", "cargoCommandLine", "name", "", "hasCargoProject", "", "Lcom/intellij/openapi/project/Project;", "getHasCargoProject", "(Lcom/intellij/openapi/project/Project;)Z", "buildProject", "", "cleanProject", "getAppropriateCargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createFilters", "", "Lcom/intellij/execution/filters/Filter;", "cargoProject", "buildOutputFixesManager", "Lorg/rust/cargo/runconfig/buildtool/BuildOutputFixesDataStore;", "addFormatJsonOption", "additionalArguments", "", "formatOption", "format", "writeString", "Lorg/jdom/Element;", "value", "readString", "writeBool", "readBool", "(Lorg/jdom/Element;Ljava/lang/String;)Ljava/lang/Boolean;", "writeEnum", "E", "", "(Lorg/jdom/Element;Ljava/lang/String;Ljava/lang/Enum;)V", "readEnum", "(Lorg/jdom/Element;Ljava/lang/String;)Ljava/lang/Enum;", "writePath", "Ljava/nio/file/Path;", "readPath", "executeCommandLine", "Lcom/intellij/execution/DefaultExecutionResult;", "Lorg/rust/cargo/runconfig/CargoRunStateBase;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/rust/cargo/runconfig/UtilsKt\n+ 2 Collections.kt\norg/rust/stdext/CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n13#2:222\n31#2:223\n23#2,10:224\n13#2:235\n31#2:236\n23#2,10:237\n1#3:234\n360#4,7:247\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/rust/cargo/runconfig/UtilsKt\n*L\n64#1:222\n64#1:223\n64#1:224,10\n107#1:235\n107#1:236\n107#1:237,10\n124#1:247,7\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final CargoCommandLine mergeWithDefault(@NotNull CargoCommandLine $this$mergeWithDefault, @NotNull CargoCommandConfiguration cargoCommandConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$mergeWithDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)cargoCommandConfiguration), (String)"default");
        BacktraceMode backtraceMode = cargoCommandConfiguration.getBacktrace();
        RustChannel rustChannel = cargoCommandConfiguration.getChannel();
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create(cargoCommandConfiguration.getEnvs(), (boolean)cargoCommandConfiguration.isPassParentEnvs());
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
        EnvironmentVariablesData environmentVariablesData2 = environmentVariablesData;
        boolean bl = cargoCommandConfiguration.getRequiredFeatures();
        boolean bl2 = cargoCommandConfiguration.getAllFeatures();
        boolean bl3 = cargoCommandConfiguration.getEmulateTerminal();
        boolean bl4 = cargoCommandConfiguration.getWithSudo();
        return CargoCommandLine.copy$default($this$mergeWithDefault, null, null, null, null, bl3, backtraceMode, null, rustChannel, environmentVariablesData2, bl, bl2, bl4, 79, null);
    }

    @NotNull
    public static final RunnerAndConfigurationSettings createCargoCommandRunConfiguration(@NotNull RunManager $this$createCargoCommandRunConfiguration, @NotNull CargoCommandLine cargoCommandLine, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$createCargoCommandRunConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cargoCommandLine, (String)"cargoCommandLine");
        String string = name2;
        if (string == null) {
            string = cargoCommandLine.getCommand();
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = $this$createCargoCommandRunConfiguration.createConfiguration(string, CargoCommandConfigurationTypeKt.cargoCommandConfigurationType().getFactory());
        RunConfiguration runConfiguration = runnerAndConfigurationSettings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type org.rust.cargo.runconfig.command.CargoCommandConfiguration");
        CargoCommandConfiguration configuration = (CargoCommandConfiguration)runConfiguration;
        configuration.setFromCmd(cargoCommandLine);
        return runnerAndConfigurationSettings;
    }

    public static /* synthetic */ RunnerAndConfigurationSettings createCargoCommandRunConfiguration$default(RunManager runManager, CargoCommandLine cargoCommandLine, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return UtilsKt.createCargoCommandRunConfiguration(runManager, cargoCommandLine, string);
    }

    public static final boolean getHasCargoProject(@NotNull Project $this$hasCargoProject) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCargoProject, (String)"<this>");
        return !CargoProjectServiceKt.getCargoProjects($this$hasCargoProject).getAllProjects().isEmpty();
    }

    public static final void buildProject(@NotNull Project $this$buildProject) {
        Intrinsics.checkNotNullParameter((Object)$this$buildProject, (String)"<this>");
        org.rust.openapiext.UtilsKt.checkIsDispatchThread();
        boolean $i$f$buildList = false;
        Collection result$iv$iv = new ArrayList();
        boolean $i$f$buildCollection = false;
        CollectionBuilder $this$buildProject_u24lambda_u240 = new CollectionBuilder<T>(result$iv$iv){
            final /* synthetic */ Collection<T> $result;
            {
                this.$result = $result;
            }

            public void add(T item) {
                this.$result.add(item);
            }

            public void addAll(Collection<? extends T> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                this.$result.addAll(items);
            }
        };
        boolean bl = false;
        RustProjectSettingsService settings = RustProjectSettingsServiceKt.getRustSettings($this$buildProject);
        $this$buildProject_u24lambda_u240.add("--all");
        if (settings.getCompileAllTargets()) {
            $this$buildProject_u24lambda_u240.add("--all-targets");
        }
        List arguments = (List)result$iv$iv;
        RunContentManager.getInstance((Project)$this$buildProject);
        for (CargoProject cargoProject : CargoProjectServiceKt.getCargoProjects($this$buildProject).getAllProjects()) {
            RsCommandLineBase.run$default(CargoCommandLine.Companion.forProject$default(CargoCommandLine.Companion, cargoProject, "build", arguments, false, null, null, null, 120, null), cargoProject, null, false, null, 10, null);
        }
    }

    public static final void cleanProject(@NotNull Project $this$cleanProject) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanProject, (String)"<this>");
        org.rust.openapiext.UtilsKt.checkIsDispatchThread();
        RunContentManager.getInstance((Project)$this$cleanProject);
        for (CargoProject cargoProject : CargoProjectServiceKt.getCargoProjects($this$cleanProject).getAllProjects()) {
            RsCommandLineBase.run$default(CargoCommandLine.Companion.forProject$default(CargoCommandLine.Companion, cargoProject, "clean", null, false, null, null, null, 116, null), cargoProject, null, false, null, 10, null);
        }
    }

    @Nullable
    public static final CargoProject getAppropriateCargoProject(@NotNull DataContext dataContext) {
        CargoProject cargoProject;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (object == null || (object = CargoProjectServiceKt.getCargoProjects((Project)object)) == null) {
            return null;
        }
        Object cargoProjects = object;
        CargoProject cargoProject2 = (CargoProject)CollectionsKt.singleOrNull((Iterable)cargoProjects.getAllProjects());
        if (cargoProject2 != null) {
            CargoProject it2 = cargoProject2;
            boolean bl = false;
            return it2;
        }
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile != null) {
            Object it3 = virtualFile;
            boolean bl = false;
            CargoProject cargoProject3 = cargoProjects.findProjectForFile((VirtualFile)it3);
            if (cargoProject3 != null) {
                it3 = cargoProject3;
                boolean bl2 = false;
                return it3;
            }
        }
        if ((cargoProject = (CargoProject)dataContext.getData(CargoToolWindow.Companion.getSELECTED_CARGO_PROJECT())) == null) {
            cargoProject = (CargoProject)CollectionsKt.firstOrNull((Iterable)cargoProjects.getAllProjects());
        }
        return cargoProject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Filter> createFilters(@Nullable CargoProject cargoProject, @Nullable BuildOutputFixesDataStore buildOutputFixesManager) {
        void var3_3;
        CargoProject dir;
        boolean $i$f$buildList = false;
        Collection result$iv$iv = new ArrayList();
        boolean $i$f$buildCollection = false;
        CollectionBuilder $this$createFilters_u24lambda_u240 = new /* invalid duplicate definition of identical inner class */;
        boolean bl = false;
        $this$createFilters_u24lambda_u240.add(new RsExplainFilter());
        CargoProject cargoProject2 = cargoProject;
        if (cargoProject2 == null || (cargoProject2 = cargoProject2.getWorkspaceRootDir()) == null) {
            CargoProject cargoProject3 = cargoProject;
            cargoProject2 = dir = cargoProject3 != null ? cargoProject3.getRootDir() : null;
        }
        if (cargoProject != null && dir != null) {
            $this$createFilters_u24lambda_u240.add(new RsSourceCodeLinkFilter(cargoProject.getProject(), (VirtualFile)dir, null, 4, null));
            $this$createFilters_u24lambda_u240.add(new RsDbgFilter(cargoProject.getProject(), (VirtualFile)dir));
            $this$createFilters_u24lambda_u240.add(new RsPanicFilter(cargoProject.getProject(), (VirtualFile)dir, null, 4, null));
            $this$createFilters_u24lambda_u240.add(new RsBacktraceFilter(cargoProject.getProject(), (VirtualFile)dir, cargoProject.getWorkspace()));
            if (buildOutputFixesManager != null) {
                $this$createFilters_u24lambda_u240.add(new BuildOutputFixesFilter(buildOutputFixesManager, cargoProject.getProject(), (VirtualFile)dir));
            }
        }
        return (List)var3_3;
    }

    public static /* synthetic */ Collection createFilters$default(CargoProject cargoProject, BuildOutputFixesDataStore buildOutputFixesDataStore, int n, Object object) {
        if ((n & 2) != 0) {
            buildOutputFixesDataStore = null;
        }
        return UtilsKt.createFilters(cargoProject, buildOutputFixesDataStore);
    }

    public static final void addFormatJsonOption(@NotNull List<String> additionalArguments, @NotNull String formatOption, @NotNull String format) {
        int indexArgWithValue;
        int idx;
        String formatJsonOption;
        block10: {
            int n;
            Intrinsics.checkNotNullParameter(additionalArguments, (String)"additionalArguments");
            Intrinsics.checkNotNullParameter((Object)formatOption, (String)"formatOption");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            formatJsonOption = formatOption + "=" + format;
            idx = additionalArguments.indexOf(formatOption);
            List<String> $this$indexOfFirst$iv = additionalArguments;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                String item$iv;
                String it2 = item$iv = iterator2.next();
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it2, (String)formatOption, (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = indexArgWithValue = -1;
        }
        if (idx != -1) {
            if (idx < additionalArguments.size() - 1) {
                if (!StringsKt.startsWith$default((String)additionalArguments.get(idx + 1), (String)"-", (boolean)false, (int)2, null)) {
                    additionalArguments.set(idx + 1, format);
                } else {
                    additionalArguments.add(idx + 1, format);
                }
            } else {
                additionalArguments.add(format);
            }
        } else if (indexArgWithValue != -1) {
            additionalArguments.set(indexArgWithValue, formatJsonOption);
        } else {
            additionalArguments.add(0, formatJsonOption);
        }
    }

    public static final void writeString(@NotNull Element $this$writeString, @NotNull String name2, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Element opt = new Element("option");
        opt.setAttribute("name", name2);
        opt.setAttribute("value", value);
        $this$writeString.addContent(opt);
    }

    @Nullable
    public static final String readString(@NotNull Element $this$readString, @NotNull String name2) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            List list = $this$readString.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Element it2 = (Element)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it2.getName(), (Object)"option") && Intrinsics.areEqual((Object)it2.getAttributeValue("name"), (Object)name2))) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        Element element = v1;
        return element != null ? element.getAttributeValue("value") : null;
    }

    public static final void writeBool(@NotNull Element $this$writeBool, @NotNull String name2, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBool, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        UtilsKt.writeString($this$writeBool, name2, String.valueOf(value));
    }

    @Nullable
    public static final Boolean readBool(@NotNull Element $this$readBool, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$readBool, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string = UtilsKt.readString($this$readBool, name2);
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    public static final <E extends Enum<?>> void writeEnum(@NotNull Element $this$writeEnum, @NotNull String name2, @NotNull E value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeEnum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        UtilsKt.writeString($this$writeEnum, name2, value.name());
    }

    public static final /* synthetic */ <E extends Enum<E>> E readEnum(Element $this$readEnum, String name2) {
        Enum enum_;
        Intrinsics.checkNotNullParameter((Object)$this$readEnum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        boolean $i$f$readEnum = false;
        String string = UtilsKt.readString($this$readEnum, name2);
        if (string == null) {
            return null;
        }
        String variantName = string;
        try {
            Intrinsics.reifiedOperationMarker((int)4, (String)"E");
            enum_ = Enum.valueOf(Enum.class, variantName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            enum_ = null;
        }
        return (E)enum_;
    }

    public static final void writePath(@NotNull Element $this$writePath, @NotNull String name2, @Nullable Path value) {
        Intrinsics.checkNotNullParameter((Object)$this$writePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (value != null) {
            String s = ExternalizablePath.urlValue((String)((Object)value).toString());
            Intrinsics.checkNotNull((Object)s);
            UtilsKt.writeString($this$writePath, name2, s);
        }
    }

    @Nullable
    public static final Path readPath(@NotNull Element $this$readPath, @NotNull String name2) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$readPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string = UtilsKt.readString($this$readPath, name2);
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            path = Paths.get(ExternalizablePath.localPathValue((String)it2), new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    @NotNull
    public static final DefaultExecutionResult executeCommandLine(@NotNull CargoRunStateBase $this$executeCommandLine, @NotNull GeneralCommandLine commandLine, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$executeCommandLine), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        CargoCommandConfiguration runConfiguration = $this$executeCommandLine.getRunConfiguration();
        TargetEnvironmentConfiguration targetEnvironment = org.rust.cargo.runconfig.target.UtilsKt.getTargetEnvironment(runConfiguration);
        ConfigurationExtensionContext context = new ConfigurationExtensionContext();
        RsRunConfigurationExtensionManager extensionManager = RsRunConfigurationExtensionManager.Companion.getInstance();
        extensionManager.patchCommandLine(runConfiguration, environment, commandLine, context);
        extensionManager.patchCommandLineState(runConfiguration, environment, $this$executeCommandLine, context);
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ProcessHandler handler = org.rust.cargo.runconfig.target.UtilsKt.startProcess(commandLine, project, targetEnvironment, true, true);
        extensionManager.attachExtensionsToProcess(runConfiguration, handler, environment, context);
        ConsoleView consoleView = $this$executeCommandLine.getConsoleBuilder().getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView console = consoleView;
        console.attachToProcess(handler);
        return new DefaultExecutionResult((ExecutionConsole)console, handler);
    }
}

