/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.runconfig.UtilsKt;
import org.rust.ide.experiments.RsExperiments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001(B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u001e\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lorg/rust/cargo/runconfig/RsCommandConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/execution/configurations/RunProfileState;", "Lcom/intellij/execution/configurations/RunConfigurationWithSuppressedDefaultDebugAction;", "Lcom/intellij/execution/CommonProgramRunConfigurationParameters;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "programParameters", "workingDirectory", "envs", "", "passParentEnvs", "", "emulateTerminal", "getEmulateTerminal", "()Z", "setEmulateTerminal", "(Z)V", "setProgramParameters", "", "value", "getProgramParameters", "setWorkingDirectory", "getWorkingDirectory", "setEnvs", "getEnvs", "setPassParentEnvs", "isPassParentEnvs", "checkConfiguration", "suggestedName", "writeExternal", "element", "Lorg/jdom/Element;", "readExternal", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCommandConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCommandConfiguration.kt\norg/rust/cargo/runconfig/RsCommandConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public abstract class RsCommandConfiguration
extends LocatableConfigurationBase<RunProfileState>
implements RunConfigurationWithSuppressedDefaultDebugAction,
CommonProgramRunConfigurationParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String programParameters;
    @Nullable
    private String workingDirectory;
    @NotNull
    private Map<String, String> envs;
    private boolean passParentEnvs;
    private boolean emulateTerminal;

    public RsCommandConfiguration(@NotNull Project project, @NotNull String name2, @NotNull ConfigurationFactory factory2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        super(project, factory2, name2);
        this.workingDirectory = !project.isDefault() ? ((object = (CargoProject)CollectionsKt.firstOrNull((Iterable)CargoProjectServiceKt.getCargoProjects(project).getAllProjects())) != null && (object = object.getRootDirPath()) != null ? object.toString() : null) : null;
        Map map2 = EnvironmentVariablesData.DEFAULT.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
        this.envs = map2;
        this.passParentEnvs = EnvironmentVariablesData.DEFAULT.isPassParentEnvs();
        this.emulateTerminal = Companion.getEmulateTerminalDefault();
    }

    public final boolean getEmulateTerminal() {
        return this.emulateTerminal;
    }

    public final void setEmulateTerminal(boolean bl) {
        this.emulateTerminal = bl;
    }

    public void setProgramParameters(@Nullable String value) {
        this.programParameters = value;
    }

    @Nullable
    public String getProgramParameters() {
        return this.programParameters;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.workingDirectory = value;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setEnvs(@NotNull Map<String, String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.envs = value;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return this.envs;
    }

    public void setPassParentEnvs(boolean value) {
        this.passParentEnvs = value;
    }

    public boolean isPassParentEnvs() {
        return this.passParentEnvs;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), null);
    }

    @Nullable
    public String suggestedName() {
        String string = this.getProgramParameters();
        return string != null && (string = StringsKt.substringBefore$default((String)string, (char)' ', null, (int)2, null)) != null ? org.rust.stdext.UtilsKt.capitalized(string) : null;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        String string = this.getProgramParameters();
        if (string == null) {
            string = "";
        }
        UtilsKt.writeString(element, "command", string);
        String string2 = this.workingDirectory;
        UtilsKt.writePath(element, "workingDirectory", string2 != null ? org.rust.stdext.UtilsKt.toPathOrNull(string2) : null);
        EnvironmentVariablesData.create(this.envs, (boolean)this.isPassParentEnvs()).writeExternal(element);
        UtilsKt.writeBool(element, "emulateTerminal", this.emulateTerminal);
    }

    public void readExternal(@NotNull Element element) {
        block2: {
            Object it2;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super.readExternal(element);
            String string = UtilsKt.readString(element, "command");
            if (string != null) {
                it2 = string;
                boolean bl = false;
                this.setProgramParameters((String)it2);
            }
            Path path = UtilsKt.readPath(element, "workingDirectory");
            if (path != null) {
                it2 = path;
                boolean bl = false;
                this.workingDirectory = it2.toString();
            }
            EnvironmentVariablesData it3 = EnvironmentVariablesData.readExternal((Element)element);
            boolean bl = false;
            Map map2 = it3.getEnvs();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
            this.envs = map2;
            this.setPassParentEnvs(it3.isPassParentEnvs());
            Boolean bl2 = UtilsKt.readBool(element, "emulateTerminal");
            if (bl2 == null) break block2;
            boolean it4 = bl2;
            boolean bl3 = false;
            this.emulateTerminal = it4;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/runconfig/RsCommandConfiguration$Companion;", "", "<init>", "()V", "emulateTerminalDefault", "", "getEmulateTerminalDefault", "()Z", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getEmulateTerminalDefault() {
            return RsExperiments.INSTANCE.getEMULATE_TERMINAL().asBoolean() && !org.rust.openapiext.UtilsKt.isUnitTestMode();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

