/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/cargo/runconfig/RsAnsiEscapeDecoder;", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "<init>", "()V", "escapeText", "", "text", "", "outputType", "Lcom/intellij/openapi/util/Key;", "textAcceptor", "Lcom/intellij/execution/process/AnsiEscapeDecoder$ColoredTextAcceptor;", "Companion", "intellij.rustrover.core"})
public final class RsAnsiEscapeDecoder
extends AnsiEscapeDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CSI = "\u001b[";
    @JvmField
    @NotNull
    public static final Regex ANSI_SGR_RE = new Regex(StringUtil.escapeToRegexp((String)"\u001b[") + "(\\d+(;\\d+)*)m");
    private static final int ANSI_SET_FOREGROUND_ATTR = 38;
    private static final int ANSI_SET_BACKGROUND_ATTR = 48;
    public static final int ANSI_24_BIT_COLOR_FORMAT = 2;
    public static final int ANSI_8_BIT_COLOR_FORMAT = 5;

    public void escapeText(@NotNull String text, @NotNull Key<?> outputType, @NotNull AnsiEscapeDecoder.ColoredTextAcceptor textAcceptor) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Intrinsics.checkNotNullParameter((Object)textAcceptor, (String)"textAcceptor");
        super.escapeText(Companion.quantizeAnsiColors(text), outputType, textAcceptor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0019\u0010\u000f\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/rust/cargo/runconfig/RsAnsiEscapeDecoder$Companion;", "", "<init>", "()V", "CSI", "", "ANSI_SGR_RE", "Lkotlin/text/Regex;", "ANSI_SET_FOREGROUND_ATTR", "", "ANSI_SET_BACKGROUND_ATTR", "ANSI_24_BIT_COLOR_FORMAT", "ANSI_8_BIT_COLOR_FORMAT", "quantizeAnsiColors", "text", "parseAttribute", "", "(Ljava/util/Iterator;)Ljava/lang/Integer;", "parseColor", "Ljava/awt/Color;", "rawAttributes", "parse24BitColor", "parse8BitColor", "getNearestAnsiColor", "Lorg/rust/cargo/runconfig/RsAnsiEscapeDecoder$Companion$Ansi4BitColor;", "color", "calcEuclideanDistance", "from", "to", "getColorAttribute", "realAnsiColor", "isForeground", "", "Ansi4BitColor", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsAnsiEscapeDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsAnsiEscapeDecoder.kt\norg/rust/cargo/runconfig/RsAnsiEscapeDecoder$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,177:1\n17456#2,14:178\n*S KotlinDebug\n*F\n+ 1 RsAnsiEscapeDecoder.kt\norg/rust/cargo/runconfig/RsAnsiEscapeDecoder$Companion\n*L\n119#1:178,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NlsSafe
        @NotNull
        public final String quantizeAnsiColors(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            CharSequence charSequence = text;
            Regex regex = ANSI_SGR_RE;
            Function1 function1 = Companion::quantizeAnsiColors$lambda$0;
            return regex.replace(charSequence, function1);
        }

        private final Integer parseAttribute(Iterator<String> $this$parseAttribute) {
            String string = org.rust.stdext.CollectionsKt.nextOrNull($this$parseAttribute);
            return string != null ? StringsKt.toIntOrNull((String)string) : null;
        }

        private final Color parseColor(Iterator<String> rawAttributes) {
            Integer n = this.parseAttribute(rawAttributes);
            if (n == null) {
                return null;
            }
            int format = n;
            return switch (format) {
                case 2 -> this.parse24BitColor(rawAttributes);
                case 5 -> this.parse8BitColor(rawAttributes);
                default -> null;
            };
        }

        private final Color parse24BitColor(Iterator<String> rawAttributes) {
            Integer n = this.parseAttribute(rawAttributes);
            if (n == null) {
                return null;
            }
            int red = n;
            Integer n2 = this.parseAttribute(rawAttributes);
            if (n2 == null) {
                return null;
            }
            int green = n2;
            Integer n3 = this.parseAttribute(rawAttributes);
            if (n3 == null) {
                return null;
            }
            int blue = n3;
            return new Color(red, green, blue);
        }

        private final Color parse8BitColor(Iterator<String> rawAttributes) {
            Color color;
            int attribute;
            Integer n = this.parseAttribute(rawAttributes);
            if (n == null) {
                return null;
            }
            int n2 = attribute = n.intValue();
            boolean bl = 0 <= n2 ? n2 < 16 : false;
            if (bl) {
                Ansi4BitColor ansi4BitColor = Ansi4BitColor.Companion.get(attribute);
                color = ansi4BitColor != null ? ansi4BitColor.getValue() : null;
            } else {
                boolean bl2 = 16 <= n2 ? n2 < 232 : false;
                if (bl2) {
                    int red = (attribute - 16) / 36 * 51;
                    int green = (attribute - 16) % 36 / 6 * 51;
                    int blue = (attribute - 16) % 6 * 51;
                    color = new Color(red, green, blue);
                } else {
                    boolean bl3 = 232 <= n2 ? n2 < 256 : false;
                    if (bl3) {
                        int value = (attribute - 232) * 10 + 8;
                        color = new Color(value, value, value);
                    } else {
                        color = null;
                    }
                }
            }
            return color;
        }

        private final Ansi4BitColor getNearestAnsiColor(Color color) {
            Ansi4BitColor ansi4BitColor;
            Ansi4BitColor[] $this$minByOrNull$iv = Ansi4BitColor.values();
            boolean $i$f$minByOrNull = false;
            if ($this$minByOrNull$iv.length == 0) {
                ansi4BitColor = null;
            } else {
                Ansi4BitColor minElem$iv = $this$minByOrNull$iv[0];
                int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$minByOrNull$iv);
                if (lastIndex$iv == 0) {
                    ansi4BitColor = minElem$iv;
                } else {
                    Ansi4BitColor it2 = minElem$iv;
                    boolean bl = false;
                    int minValue$iv = Companion.calcEuclideanDistance(it2.getValue(), color);
                    int i$iv = 1;
                    if (i$iv <= lastIndex$iv) {
                        while (true) {
                            Ansi4BitColor e$iv;
                            Ansi4BitColor it3 = e$iv = $this$minByOrNull$iv[i$iv];
                            $i$a$-minByOrNull-RsAnsiEscapeDecoder$Companion$getNearestAnsiColor$1 = false;
                            int v$iv = Companion.calcEuclideanDistance(it3.getValue(), color);
                            if (minValue$iv > v$iv) {
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            }
                            if (i$iv == lastIndex$iv) break;
                            ++i$iv;
                        }
                    }
                    ansi4BitColor = minElem$iv;
                }
            }
            return ansi4BitColor;
        }

        private final int calcEuclideanDistance(Color from, Color to) {
            double redDiff = (double)from.getRed() - (double)to.getRed();
            double greenDiff = (double)from.getGreen() - (double)to.getGreen();
            double blueDiff = (double)from.getBlue() - (double)to.getBlue();
            return MathKt.roundToInt((double)Math.sqrt(redDiff * redDiff + greenDiff * greenDiff + blueDiff * blueDiff));
        }

        private final int getColorAttribute(Ansi4BitColor realAnsiColor, boolean isForeground) {
            int n;
            boolean isForcedWhiteFontUnderLightTheme = realAnsiColor == Ansi4BitColor.BRIGHT_WHITE && isForeground && SystemInfo.isWindows && !UtilsKt.isUnderDarkTheme();
            Ansi4BitColor ansiColor = isForcedWhiteFontUnderLightTheme ? Ansi4BitColor.BLACK : realAnsiColor;
            int colorIndex = ansiColor.getIndex();
            boolean bl = 0 <= colorIndex ? colorIndex < 8 : false;
            if (bl && isForeground) {
                n = colorIndex + 30;
            } else {
                boolean bl2 = 0 <= colorIndex ? colorIndex < 8 : false;
                if (bl2 && !isForeground) {
                    n = colorIndex + 40;
                } else {
                    boolean bl3 = 8 <= colorIndex ? colorIndex < 16 : false;
                    if (bl3 && isForeground) {
                        n = colorIndex + 82;
                    } else {
                        boolean bl4 = 8 <= colorIndex ? colorIndex < 16 : false;
                        if (bl4 && !isForeground) {
                            n = colorIndex + 92;
                        } else {
                            throw new IllegalStateException("impossible".toString());
                        }
                    }
                }
            }
            return n;
        }

        private static final CharSequence quantizeAnsiColors$lambda$0(MatchResult it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            String[] stringArray = new String[]{";"};
            Iterator<String> rawAttributes = StringsKt.split$default((CharSequence)((String)it2.getDestructured().getMatch().getGroupValues().get(1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null).iterator();
            List result2 = new ArrayList();
            while (rawAttributes.hasNext()) {
                Ansi4BitColor ansiColor;
                Color color;
                Integer n = Companion.parseAttribute(rawAttributes);
                if (n == null) {
                    continue;
                }
                int attribute = n;
                Object[] objectArray = new Integer[]{38, 48};
                if (!CollectionsKt.listOf((Object[])objectArray).contains(attribute)) {
                    result2.add(attribute);
                    continue;
                }
                if (Companion.parseColor(rawAttributes) == null || Companion.getNearestAnsiColor(color) == null) continue;
                int colorAttribute = Companion.getColorAttribute(ansiColor, attribute == 38);
                result2.add(colorAttribute);
            }
            return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)";", (CharSequence)RsAnsiEscapeDecoder.CSI, (CharSequence)"m", (int)0, null, Companion::quantizeAnsiColors$lambda$0$0, (int)24, null);
        }

        private static final CharSequence quantizeAnsiColors$lambda$0$0(int attr) {
            return String.valueOf(attr);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bj\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u001d"}, d2={"Lorg/rust/cargo/runconfig/RsAnsiEscapeDecoder$Companion$Ansi4BitColor;", "", "value", "Ljava/awt/Color;", "<init>", "(Ljava/lang/String;ILjava/awt/Color;)V", "getValue", "()Ljava/awt/Color;", "BLACK", "RED", "GREEN", "YELLOW", "BLUE", "MAGENTA", "CYAN", "WHITE", "BRIGHT_BLACK", "BRIGHT_RED", "BRIGHT_GREEN", "BRIGHT_YELLOW", "BRIGHT_BLUE", "BRIGHT_MAGENTA", "BRIGHT_CYAN", "BRIGHT_WHITE", "index", "", "getIndex", "()I", "Companion", "intellij.rustrover.core"})
        private static final class Ansi4BitColor
        extends Enum<Ansi4BitColor> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final Color value;
            public static final /* enum */ Ansi4BitColor BLACK;
            public static final /* enum */ Ansi4BitColor RED;
            public static final /* enum */ Ansi4BitColor GREEN;
            public static final /* enum */ Ansi4BitColor YELLOW;
            public static final /* enum */ Ansi4BitColor BLUE;
            public static final /* enum */ Ansi4BitColor MAGENTA;
            public static final /* enum */ Ansi4BitColor CYAN;
            public static final /* enum */ Ansi4BitColor WHITE;
            public static final /* enum */ Ansi4BitColor BRIGHT_BLACK;
            public static final /* enum */ Ansi4BitColor BRIGHT_RED;
            public static final /* enum */ Ansi4BitColor BRIGHT_GREEN;
            public static final /* enum */ Ansi4BitColor BRIGHT_YELLOW;
            public static final /* enum */ Ansi4BitColor BRIGHT_BLUE;
            public static final /* enum */ Ansi4BitColor BRIGHT_MAGENTA;
            public static final /* enum */ Ansi4BitColor BRIGHT_CYAN;
            public static final /* enum */ Ansi4BitColor BRIGHT_WHITE;
            private static final /* synthetic */ Ansi4BitColor[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Ansi4BitColor(Color value) {
                this.value = value;
            }

            @NotNull
            public final Color getValue() {
                return this.value;
            }

            public final int getIndex() {
                return ArraysKt.indexOf((Object[])Ansi4BitColor.values(), (Object)((Object)this));
            }

            public static Ansi4BitColor[] values() {
                return (Ansi4BitColor[])$VALUES.clone();
            }

            public static Ansi4BitColor valueOf(String value) {
                return Enum.valueOf(Ansi4BitColor.class, value);
            }

            @NotNull
            public static EnumEntries<Ansi4BitColor> getEntries() {
                return $ENTRIES;
            }

            static {
                BLACK = new Ansi4BitColor(new Color(0, 0, 0));
                RED = new Ansi4BitColor(new Color(128, 0, 0));
                GREEN = new Ansi4BitColor(new Color(0, 128, 0));
                YELLOW = new Ansi4BitColor(new Color(128, 128, 0));
                BLUE = new Ansi4BitColor(new Color(0, 0, 128));
                MAGENTA = new Ansi4BitColor(new Color(128, 0, 128));
                CYAN = new Ansi4BitColor(new Color(0, 128, 128));
                WHITE = new Ansi4BitColor(new Color(192, 192, 192));
                BRIGHT_BLACK = new Ansi4BitColor(new Color(128, 128, 128));
                BRIGHT_RED = new Ansi4BitColor(new Color(255, 0, 0));
                BRIGHT_GREEN = new Ansi4BitColor(new Color(0, 255, 0));
                BRIGHT_YELLOW = new Ansi4BitColor(new Color(255, 255, 0));
                BRIGHT_BLUE = new Ansi4BitColor(new Color(0, 0, 255));
                BRIGHT_MAGENTA = new Ansi4BitColor(new Color(255, 0, 255));
                BRIGHT_CYAN = new Ansi4BitColor(new Color(0, 255, 255));
                BRIGHT_WHITE = new Ansi4BitColor(new Color(255, 255, 255));
                $VALUES = ansi4BitColorArray = new Ansi4BitColor[]{Ansi4BitColor.BLACK, Ansi4BitColor.RED, Ansi4BitColor.GREEN, Ansi4BitColor.YELLOW, Ansi4BitColor.BLUE, Ansi4BitColor.MAGENTA, Ansi4BitColor.CYAN, Ansi4BitColor.WHITE, Ansi4BitColor.BRIGHT_BLACK, Ansi4BitColor.BRIGHT_RED, Ansi4BitColor.BRIGHT_GREEN, Ansi4BitColor.BRIGHT_YELLOW, Ansi4BitColor.BRIGHT_BLUE, Ansi4BitColor.BRIGHT_MAGENTA, Ansi4BitColor.BRIGHT_CYAN, Ansi4BitColor.BRIGHT_WHITE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/runconfig/RsAnsiEscapeDecoder$Companion$Ansi4BitColor$Companion;", "", "<init>", "()V", "get", "Lorg/rust/cargo/runconfig/RsAnsiEscapeDecoder$Companion$Ansi4BitColor;", "index", "", "intellij.rustrover.core"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final Ansi4BitColor get(int index) {
                    Ansi4BitColor[] values = Ansi4BitColor.values();
                    return index >= 0 && index < values.length ? values[index] : null;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

