/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.actions.ConsolePropertiesProvider;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.SemVer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.runconfig.CargoRunStateBase;
import org.rust.cargo.runconfig.UtilsKt;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.console.CargoTestConsoleBuilder;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.RustChannel;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.openapiext.RsPathManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/rust/cargo/runconfig/CargoTestRunState;", "Lorg/rust/cargo/runconfig/CargoRunStateBase;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "runConfiguration", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "config", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration$CleanConfiguration$Ok;", "<init>", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration$CleanConfiguration$Ok;)V", "cargoTestPatch", "Lkotlin/Function1;", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "Lorg/rust/cargo/runconfig/buildtool/CargoPatch;", "requiresRustcBootstrap", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode;", "getRequiresRustcBootstrap", "()Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode;", "needRustcBootstrapForDebug", "", "getNeedRustcBootstrapForDebug", "()Z", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "RustBootstrapMode", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoTestRunState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTestRunState.kt\norg/rust/cargo/runconfig/CargoTestRunState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,171:1\n1869#2,2:172\n1#3:174\n37#4,2:175\n*S KotlinDebug\n*F\n+ 1 CargoTestRunState.kt\norg/rust/cargo/runconfig/CargoTestRunState\n*L\n103#1:172,2\n114#1:175,2\n*E\n"})
public final class CargoTestRunState
extends CargoRunStateBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<CargoCommandLine, CargoCommandLine> cargoTestPatch;
    @NotNull
    private static final SemVer RUSTC_1_70_BETA = ToolchainUtilKt.parseSemVer("1.70.0-beta");
    @NotNull
    private static final SemVer RUSTC_1_86_0 = ToolchainUtilKt.parseSemVer("1.86.0");

    public CargoTestRunState(@NotNull ExecutionEnvironment environment, @NotNull CargoCommandConfiguration runConfiguration, @NotNull CargoCommandConfiguration.CleanConfiguration.Ok config) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(environment, runConfiguration, config);
        this.cargoTestPatch = arg_0 -> CargoTestRunState.cargoTestPatch$lambda$0(this, arg_0);
        RunProfile runProfile = WrappingRunConfiguration.unwrapRunProfile((RunProfile)environment.getRunProfile());
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"unwrapRunProfile(...)");
        RunProfile runProfile2 = runProfile;
        ConsolePropertiesProvider consolePropertiesProvider = (CargoCommandConfiguration)runProfile2;
        Executor executor = environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        this.setConsoleBuilder(new CargoTestConsoleBuilder(consolePropertiesProvider, executor));
        this.getCommandLinePatches().add(this.cargoTestPatch);
        Iterable $this$forEach$iv = UtilsKt.createFilters$default(this.getCargoProject(), null, 2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Filter it2 = (Filter)element$iv;
            boolean bl = false;
            this.getConsoleBuilder().addFilter(it2);
        }
    }

    private final RustBootstrapMode getRequiresRustcBootstrap() {
        RustBootstrapMode rustBootstrapMode;
        boolean requiresRustcBootstrap;
        CargoProject cargoProject = this.getCargoProject();
        RustcInfo it2 = cargoProject != null ? cargoProject.getRustcInfo() : null;
        boolean bl = false;
        RustcInfo rustcInfo = it2;
        Pair pair = TuplesKt.to((Object)it2, (Object)(rustcInfo != null ? rustcInfo.getVersion() : null));
        RustcInfo rustcInfo2 = (RustcInfo)pair.component1();
        RustcVersion rustcVersion = (RustcVersion)pair.component2();
        boolean bl2 = requiresRustcBootstrap = rustcVersion == null || rustcVersion.getChannel() != RustChannel.NIGHTLY && rustcVersion.getChannel() != RustChannel.DEV && rustcVersion.getSemver().compareTo(RUSTC_1_70_BETA) >= 0;
        if (requiresRustcBootstrap) {
            if (rustcInfo2 != null && rustcVersion != null && rustcVersion.getSemver().compareTo(RUSTC_1_86_0) >= 0) {
                RsToolchainBase toolchain2 = rustcInfo2.getToolchain();
                Path nativeHelper = RsPathManager.INSTANCE.nativeHelper(toolchain2);
                if (nativeHelper != null) {
                    String rustdoc = toolchain2.hasExecutable("rustdoc") ? toolchain2.remotePathToExecutable("rustdoc") : null;
                    rustBootstrapMode = new RustBootstrapMode.TargetRunner(rustcVersion.getHost(), toolchain2.toRemotePath(((Object)nativeHelper).toString()), rustdoc);
                } else {
                    rustBootstrapMode = RustBootstrapMode.NotNeeded.INSTANCE;
                }
            } else {
                rustBootstrapMode = RustBootstrapMode.ConfigEnv.INSTANCE;
            }
        } else {
            rustBootstrapMode = RustBootstrapMode.NotNeeded.INSTANCE;
        }
        return rustBootstrapMode;
    }

    public final boolean getNeedRustcBootstrapForDebug() {
        return !Intrinsics.areEqual((Object)this.getRequiresRustcBootstrap(), (Object)RustBootstrapMode.NotNeeded.INSTANCE);
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) {
        AbstractRerunFailedTestsAction rerunAction;
        SMTRunnerConsoleProperties consoleProperties;
        SMTRunnerConsoleView consoleView;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        ExecutionResult executionResult = super.execute(executor, runner);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"execute(...)");
        ExecutionResult executionResult2 = executionResult;
        if (!(executionResult2 instanceof DefaultExecutionResult)) {
            return executionResult2;
        }
        ExecutionConsole executionConsole = ((DefaultExecutionResult)executionResult2).getExecutionConsole();
        SMTRunnerConsoleView sMTRunnerConsoleView = consoleView = executionConsole instanceof SMTRunnerConsoleView ? (SMTRunnerConsoleView)executionConsole : null;
        TestConsoleProperties testConsoleProperties = sMTRunnerConsoleView != null ? sMTRunnerConsoleView.getProperties() : null;
        SMTRunnerConsoleProperties sMTRunnerConsoleProperties = consoleProperties = testConsoleProperties instanceof SMTRunnerConsoleProperties ? (SMTRunnerConsoleProperties)testConsoleProperties : null;
        AbstractRerunFailedTestsAction abstractRerunFailedTestsAction = rerunAction = sMTRunnerConsoleProperties != null ? sMTRunnerConsoleProperties.createRerunFailedTestsAction((ConsoleView)consoleView) : null;
        if (abstractRerunFailedTestsAction != null) {
            abstractRerunFailedTestsAction.setModelProvider(() -> CargoTestRunState.execute$lambda$0(consoleView));
        }
        Object[] objectArray = new AnAction[]{rerunAction, new ToggleAutoTestAction()};
        List restartActions = CollectionsKt.listOfNotNull((Object[])objectArray);
        Collection $this$toTypedArray$iv = restartActions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new AnAction[0]);
        ((DefaultExecutionResult)executionResult2).setRestartActions((AnAction[])Arrays.copyOf(objectArray, objectArray.length));
        return executionResult2;
    }

    private static final CargoCommandLine cargoTestPatch$lambda$0(CargoTestRunState this$0, CargoCommandLine commandLine) {
        Map map2;
        EnvironmentVariablesData environmentVariablesData;
        RustBootstrapMode r;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (commandLine.getWithSudo()) {
            String message = SystemInfo.isWindows ? RsBundle.INSTANCE.message("notification.run.tests.as.root.windows", new Object[0]) : RsBundle.INSTANCE.message("notification.run.tests.as.root.unix", new Object[0]);
            org.rust.ide.notifications.UtilsKt.showBalloon$default(this$0.getProject(), "running.tests.with.sudo", message, NotificationType.WARNING, null, 8, null);
        }
        if ((r = this$0.getRequiresRustcBootstrap()) instanceof RustBootstrapMode.TargetRunner) {
            if (((RustBootstrapMode.TargetRunner)r).getRustdoc() != null) {
                environmentVariablesData = new EnvironmentVariablesData[]{TuplesKt.to((Object)"RR_REAL_RUSTDOC", (Object)((RustBootstrapMode.TargetRunner)r).getRustdoc()), TuplesKt.to((Object)"RUSTDOC", (Object)((RustBootstrapMode.TargetRunner)r).getNativeHelper())};
                map2 = MapsKt.mapOf((Pair[])environmentVariablesData);
            } else {
                map2 = null;
            }
        } else {
            map2 = null;
        }
        Map env = map2;
        List<String> list = Companion.patchArgs(commandLine, this$0.getRequiresRustcBootstrap());
        Map map3 = commandLine.getEnvironmentVariables().getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getEnvs(...)");
        Map map4 = env;
        if (map4 == null) {
            map4 = MapsKt.emptyMap();
        }
        EnvironmentVariablesData environmentVariablesData2 = EnvironmentVariablesData.create((Map)MapsKt.plus((Map)map3, map4), (boolean)commandLine.getEnvironmentVariables().isPassParentEnvs());
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData2, (String)"create(...)");
        environmentVariablesData = environmentVariablesData2;
        return CargoCommandLine.copy$default(commandLine, null, null, list, null, false, null, null, null, environmentVariablesData, false, false, false, 1771, null);
    }

    private static final TestFrameworkRunningModel execute$lambda$0(SMTRunnerConsoleView $consoleView) {
        Object object;
        SMTestRunnerResultsForm sMTestRunnerResultsForm = $consoleView.getResultsViewer();
        if (sMTestRunnerResultsForm != null) {
            SMTestRunnerResultsForm sMTestRunnerResultsForm2;
            SMTestRunnerResultsForm it2 = sMTestRunnerResultsForm2 = sMTestRunnerResultsForm;
            boolean bl = false;
            object = it2.getFailedTestCount() > 0 ? sMTestRunnerResultsForm2 : null;
        } else {
            object = null;
        }
        return (TestFrameworkRunningModel)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/rust/cargo/runconfig/CargoTestRunState$Companion;", "", "<init>", "()V", "RUSTC_1_70_BETA", "Lcom/intellij/util/text/SemVer;", "RUSTC_1_86_0", "patchArgs", "", "", "commandLine", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "rustBootstrapMode", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCargoTestRunState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTestRunState.kt\norg/rust/cargo/runconfig/CargoTestRunState$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final List<String> patchArgs(@NotNull CargoCommandLine commandLine, @NotNull RustBootstrapMode rustBootstrapMode) {
            String unstableOption;
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)rustBootstrapMode, (String)"rustBootstrapMode");
            Pair<List<String>, List<String>> pair = commandLine.splitOnDoubleDash();
            boolean bl = false;
            Object pre = (List)pair.component1();
            List post = (List)pair.component2();
            Pair pair2 = TuplesKt.to((Object)CollectionsKt.toMutableList((Collection)((Collection)pre)), (Object)CollectionsKt.toMutableList((Collection)post));
            List pre2 = (List)pair2.component1();
            List post2 = (List)pair2.component2();
            String noFailFastOption = "--no-fail-fast";
            if (!pre2.contains(noFailFastOption)) {
                pre2.add(noFailFastOption);
            }
            if (!Intrinsics.areEqual((Object)(pre = rustBootstrapMode), (Object)RustBootstrapMode.NotNeeded.INSTANCE)) {
                if (Intrinsics.areEqual((Object)pre, (Object)RustBootstrapMode.ConfigEnv.INSTANCE)) {
                    pre2.add("--config");
                    pre2.add("env.RUSTC_BOOTSTRAP=\"1\"");
                } else if (pre instanceof RustBootstrapMode.TargetRunner) {
                    pre2.add("--config");
                    pre2.add("target." + ((RustBootstrapMode.TargetRunner)rustBootstrapMode).getTarget() + ".runner=['" + ((RustBootstrapMode.TargetRunner)rustBootstrapMode).getNativeHelper() + "']");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (!post2.contains(unstableOption = "-Z")) {
                post2.add(unstableOption);
                post2.add("unstable-options");
            }
            UtilsKt.addFormatJsonOption(post2, "--format", "json");
            post2.add("--show-output");
            return post2.isEmpty() ? pre2 : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)pre2, (Object)"--"), (Iterable)post2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode;", "", "<init>", "()V", "NotNeeded", "ConfigEnv", "TargetRunner", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode$ConfigEnv;", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode$NotNeeded;", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode$TargetRunner;", "intellij.rustrover.core"})
    public static abstract sealed class RustBootstrapMode {
        private RustBootstrapMode() {
        }

        public /* synthetic */ RustBootstrapMode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode$ConfigEnv;", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class ConfigEnv
        extends RustBootstrapMode {
            @NotNull
            public static final ConfigEnv INSTANCE = new ConfigEnv();

            private ConfigEnv() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "ConfigEnv";
            }

            public int hashCode() {
                return -195298499;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConfigEnv)) {
                    return false;
                }
                ConfigEnv cfr_ignored_0 = (ConfigEnv)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode$NotNeeded;", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class NotNeeded
        extends RustBootstrapMode {
            @NotNull
            public static final NotNeeded INSTANCE = new NotNeeded();

            private NotNeeded() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "NotNeeded";
            }

            public int hashCode() {
                return 1736769882;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotNeeded)) {
                    return false;
                }
                NotNeeded cfr_ignored_0 = (NotNeeded)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode$TargetRunner;", "Lorg/rust/cargo/runconfig/CargoTestRunState$RustBootstrapMode;", "target", "", "nativeHelper", "rustdoc", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTarget", "()Ljava/lang/String;", "getNativeHelper", "getRustdoc", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
        public static final class TargetRunner
        extends RustBootstrapMode {
            @NotNull
            private final String target;
            @NotNull
            private final String nativeHelper;
            @Nullable
            private final String rustdoc;

            public TargetRunner(@NotNull String target, @NotNull String nativeHelper, @Nullable String rustdoc) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)nativeHelper, (String)"nativeHelper");
                super(null);
                this.target = target;
                this.nativeHelper = nativeHelper;
                this.rustdoc = rustdoc;
            }

            @NotNull
            public final String getTarget() {
                return this.target;
            }

            @NotNull
            public final String getNativeHelper() {
                return this.nativeHelper;
            }

            @Nullable
            public final String getRustdoc() {
                return this.rustdoc;
            }

            @NotNull
            public final String component1() {
                return this.target;
            }

            @NotNull
            public final String component2() {
                return this.nativeHelper;
            }

            @Nullable
            public final String component3() {
                return this.rustdoc;
            }

            @NotNull
            public final TargetRunner copy(@NotNull String target, @NotNull String nativeHelper, @Nullable String rustdoc) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)nativeHelper, (String)"nativeHelper");
                return new TargetRunner(target, nativeHelper, rustdoc);
            }

            public static /* synthetic */ TargetRunner copy$default(TargetRunner targetRunner, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = targetRunner.target;
                }
                if ((n & 2) != 0) {
                    string2 = targetRunner.nativeHelper;
                }
                if ((n & 4) != 0) {
                    string3 = targetRunner.rustdoc;
                }
                return targetRunner.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "TargetRunner(target=" + this.target + ", nativeHelper=" + this.nativeHelper + ", rustdoc=" + this.rustdoc + ")";
            }

            public int hashCode() {
                int result2 = this.target.hashCode();
                result2 = result2 * 31 + this.nativeHelper.hashCode();
                result2 = result2 * 31 + (this.rustdoc == null ? 0 : this.rustdoc.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TargetRunner)) {
                    return false;
                }
                TargetRunner targetRunner = (TargetRunner)other;
                if (!Intrinsics.areEqual((Object)this.target, (Object)targetRunner.target)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.nativeHelper, (Object)targetRunner.nativeHelper)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.rustdoc, (Object)targetRunner.rustdoc);
            }
        }
    }
}

