/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig;

import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.runconfig.RsProcessHandler;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.target.RsLanguageRuntimeConfiguration;
import org.rust.cargo.runconfig.target.UtilsKt;
import org.rust.cargo.toolchain.CargoCommandLine;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.Cargo;
import org.rust.cargo.toolchain.tools.CargoKt;
import org.rust.cargo.toolchain.tools.RustcKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 42\u00020\u0001:\u00014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u0004\u0018\u00010+J?\u0010,\u001a\u00020\u001722\u0010-\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170$j\u0002`%0.\"\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170$j\u0002`%\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0014J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R*\u0010\"\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170$j\u0002`%0#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00065"}, d2={"Lorg/rust/cargo/runconfig/CargoRunStateBase;", "Lcom/intellij/execution/configurations/CommandLineState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "runConfiguration", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "config", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration$CleanConfiguration$Ok;", "<init>", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration$CleanConfiguration$Ok;)V", "getRunConfiguration", "()Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "getConfig", "()Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration$CleanConfiguration$Ok;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "getToolchain", "()Lorg/rust/cargo/toolchain/RsToolchainBase;", "commandLine", "Lorg/rust/cargo/toolchain/CargoCommandLine;", "getCommandLine", "()Lorg/rust/cargo/toolchain/CargoCommandLine;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "getCargoProject", "()Lorg/rust/cargo/project/model/CargoProject;", "workingDirectory", "Ljava/nio/file/Path;", "getWorkingDirectory", "()Ljava/nio/file/Path;", "commandLinePatches", "", "Lkotlin/Function1;", "Lorg/rust/cargo/runconfig/buildtool/CargoPatch;", "getCommandLinePatches", "()Ljava/util/List;", "cargo", "Lorg/rust/cargo/toolchain/tools/Cargo;", "rustVersion", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "prepareCommandLine", "additionalPatches", "", "([Lkotlin/jvm/functions/Function1;)Lorg/rust/cargo/toolchain/CargoCommandLine;", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "processColors", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoRunStateBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoRunStateBase.kt\norg/rust/cargo/runconfig/CargoRunStateBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n13#2:103\n*S KotlinDebug\n*F\n+ 1 CargoRunStateBase.kt\norg/rust/cargo/runconfig/CargoRunStateBase\n*L\n97#1:103\n*E\n"})
public abstract class CargoRunStateBase
extends CommandLineState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CargoCommandConfiguration runConfiguration;
    @NotNull
    private final CargoCommandConfiguration.CleanConfiguration.Ok config;
    @NotNull
    private final Project project;
    @NotNull
    private final RsToolchainBase toolchain;
    @NotNull
    private final CargoCommandLine commandLine;
    @Nullable
    private final CargoProject cargoProject;
    @NotNull
    private final List<Function1<CargoCommandLine, CargoCommandLine>> commandLinePatches;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SSH_TARGET_TYPE_ID = "ssh/sftp";

    public CargoRunStateBase(@NotNull ExecutionEnvironment environment, @NotNull CargoCommandConfiguration runConfiguration, @NotNull CargoCommandConfiguration.CleanConfiguration.Ok config) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(environment);
        this.runConfiguration = runConfiguration;
        this.config = config;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.toolchain = this.config.getToolchain();
        this.commandLine = this.config.getCmd();
        this.cargoProject = CargoCommandConfiguration.Companion.findCargoProject(this.project, this.commandLine.getAdditionalArguments(), this.commandLine.getWorkingDirectory());
        this.commandLinePatches = new ArrayList();
        this.commandLinePatches.addAll((Collection<Function1<CargoCommandLine, CargoCommandLine>>)org.rust.cargo.runconfig.buildtool.UtilsKt.getCargoPatches(environment));
    }

    @NotNull
    public final CargoCommandConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    @NotNull
    public final CargoCommandConfiguration.CleanConfiguration.Ok getConfig() {
        return this.config;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RsToolchainBase getToolchain() {
        return this.toolchain;
    }

    @NotNull
    public final CargoCommandLine getCommandLine() {
        return this.commandLine;
    }

    @Nullable
    public final CargoProject getCargoProject() {
        return this.cargoProject;
    }

    private final Path getWorkingDirectory() {
        CargoProject cargoProject = this.cargoProject;
        return cargoProject != null ? cargoProject.getRootDirPath() : null;
    }

    @NotNull
    protected final List<Function1<CargoCommandLine, CargoCommandLine>> getCommandLinePatches() {
        return this.commandLinePatches;
    }

    @NotNull
    public final Cargo cargo() {
        return CargoKt.cargoOrWrapper(this.toolchain, this.getWorkingDirectory());
    }

    @Nullable
    public final RustcVersion rustVersion() {
        return RustcKt.rustc(this.toolchain).queryVersion(this.project, this.getWorkingDirectory());
    }

    @NotNull
    public final CargoCommandLine prepareCommandLine(Function1<? super CargoCommandLine, CargoCommandLine> ... additionalPatches) {
        Intrinsics.checkNotNullParameter(additionalPatches, (String)"additionalPatches");
        CargoCommandLine commandLine = this.commandLine;
        for (Function1<CargoCommandLine, CargoCommandLine> patch : this.commandLinePatches) {
            commandLine = (CargoCommandLine)patch.invoke((Object)commandLine);
        }
        for (Function1<? super CargoCommandLine, CargoCommandLine> patch : additionalPatches) {
            commandLine = (CargoCommandLine)patch.invoke((Object)commandLine);
        }
        return commandLine;
    }

    @NotNull
    protected ProcessHandler startProcess() {
        return this.startProcess(true);
    }

    @NotNull
    public final ProcessHandler startProcess(boolean processColors) {
        TargetEnvironmentConfiguration targetEnvironment = UtilsKt.getTargetEnvironment(this.runConfiguration);
        if (targetEnvironment == null) {
            Cargo cargo = this.cargo();
            Project project = this.getEnvironment().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GeneralCommandLine commandLine = cargo.toColoredCommandLine(project, this.prepareCommandLine(new Function1[0]));
            LOG.debug("Executing Cargo command: `" + commandLine.getCommandLineString() + "`");
            RsProcessHandler handler = new RsProcessHandler(commandLine, processColors);
            ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)handler));
            return (ProcessHandler)handler;
        }
        Function1 remoteRunPatch = arg_0 -> CargoRunStateBase.startProcess$lambda$0(this, targetEnvironment, arg_0);
        Function1[] function1Array = new Function1[]{remoteRunPatch};
        GeneralCommandLine commandLine = this.cargo().toColoredCommandLine(this.project, this.prepareCommandLine(function1Array));
        RsLanguageRuntimeConfiguration rsLanguageRuntimeConfiguration = UtilsKt.getLanguageRuntime(targetEnvironment);
        String string = StringKt.nullize((String)(rsLanguageRuntimeConfiguration != null ? rsLanguageRuntimeConfiguration.getCargoPath() : null), (boolean)true);
        if (string == null) {
            string = "cargo";
        }
        commandLine.setExePath(string);
        return UtilsKt.startProcess(commandLine, this.project, targetEnvironment, processColors, false);
    }

    private static final CargoCommandLine startProcess$lambda$0(CargoRunStateBase this$0, TargetEnvironmentConfiguration $targetEnvironment, CargoCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return CargoCommandLine.copy$default(this$0.runConfiguration.getBuildTarget().isRemote() && Intrinsics.areEqual((Object)$targetEnvironment.getTypeId(), (Object)SSH_TARGET_TYPE_ID) ? commandLine.prependArgument("--target-dir=" + $targetEnvironment.getProjectRootOnTarget() + "/target") : commandLine, null, null, null, null, false, null, null, null, null, false, false, false, 4079, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CargoRunStateBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/cargo/runconfig/CargoRunStateBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SSH_TARGET_TYPE_ID", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

