/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.runconfig;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.runconfig.RsCommandConfiguration;
import org.rust.cargo.runconfig.RsCommandConfigurationKt;
import org.rust.cargo.runconfig.RsDefaultProgramRunnerBase;
import org.rust.cargo.runconfig.buildtool.CargoBuildManager;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/rust/cargo/runconfig/CargoCommandRunner;", "Lorg/rust/cargo/runconfig/RsDefaultProgramRunnerBase;", "<init>", "()V", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "doExecute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "intellij.rustrover.core"})
public class CargoCommandRunner
extends RsDefaultProgramRunnerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RUNNER_ID = "CargoCommandRunner";

    @NotNull
    public String getRunnerId() {
        return RUNNER_ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Object[] objectArray;
        boolean isLocalRun;
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (!Intrinsics.areEqual((Object)executorId, (Object)"Run") || !(profile instanceof CargoCommandConfiguration)) {
            return false;
        }
        CargoCommandConfiguration.CleanConfiguration.Ok ok = ((CargoCommandConfiguration)profile).clean().getOk();
        if (ok == null) {
            return false;
        }
        CargoCommandConfiguration.CleanConfiguration.Ok cleaned = ok;
        boolean bl = isLocalRun = !RsCommandConfigurationKt.getHasRemoteTarget((RsCommandConfiguration)profile) || ((CargoCommandConfiguration)profile).getBuildTarget().isRemote();
        boolean isLegacyTestRun = !CargoBuildManager.INSTANCE.isBuildToolWindowAvailable((CargoCommandConfiguration)profile) && CollectionsKt.listOf((Object[])(objectArray = new String[]{"test", "bench"})).contains(cleaned.getCmd().getCommand()) && CargoBuildManager.INSTANCE.getBuildConfiguration((CargoCommandConfiguration)profile) != null;
        return isLocalRun && !isLegacyTestRun;
    }

    @Override
    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        RunContentDescriptor runContentDescriptor;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfile runProfile = WrappingRunConfiguration.unwrapRunProfile((RunProfile)environment.getRunProfile());
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"unwrapRunProfile(...)");
        RunProfile configuration = runProfile;
        if (!(!(configuration instanceof CargoCommandConfiguration) || CargoBuildManager.INSTANCE.isBuildConfiguration((CargoCommandConfiguration)configuration) && CargoBuildManager.INSTANCE.isBuildToolWindowAvailable((CargoCommandConfiguration)configuration))) {
            runContentDescriptor = super.doExecute(state, environment);
        } else {
            environment.putUserData(ExecutionManagerImpl.EXECUTION_SKIP_RUN, (Object)true);
            runContentDescriptor = null;
        }
        return runContentDescriptor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/cargo/runconfig/CargoCommandRunner$Companion;", "", "<init>", "()V", "RUNNER_ID", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

