/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.workspace;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.ProcessProgressListener;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspaceData;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.project.workspace.StandardLibrary;
import org.rust.cargo.project.workspace.StandardLibraryKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.CargoMetadata;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.Cargo;
import org.rust.cargo.toolchain.tools.CargoKt;
import org.rust.cargo.util.AutoInjectedCrates;
import org.rust.cargo.util.StdLibInfo;
import org.rust.cargo.util.StdLibType;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.openapiext.RsPathManager;
import org.rust.openapiext.RsProcessExecutionException;
import org.rust.openapiext.RsProcessExecutionOrDeserializationException;
import org.rust.stdext.RsResult;
import org.rust.stdext.UtilsKt;
import org.rust.util.ZipKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B[\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010 \u001a\u00020\u000f*\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000fH\u0002J \u0010\"\u001a\u00020#*\u00020$2\n\u0010%\u001a\u00060\u000fj\u0002`\u00172\u0006\u0010&\u001a\u00020'H\u0002J\f\u0010(\u001a\u00020#*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00170\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/rust/cargo/project/workspace/StdlibDataFetcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "cargo", "Lorg/rust/cargo/toolchain/tools/Cargo;", "srcDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "testPackageSrcDir", "stdlibDependenciesDir", "Ljava/nio/file/Path;", "buildTargets", "", "", "activeToolchain", "listener", "Lorg/rust/cargo/project/model/ProcessProgressListener;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/toolchain/tools/Cargo;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/rust/cargo/toolchain/impl/RustcVersion;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/nio/file/Path;Ljava/util/List;Ljava/lang/String;Lorg/rust/cargo/project/model/ProcessProgressListener;)V", "workspaceMembers", "", "Lorg/rust/cargo/project/workspace/PackageId;", "visitedPackages", "", "allPackages", "Lorg/rust/cargo/toolchain/impl/CargoMetadata$Package;", "allNodes", "Lorg/rust/cargo/toolchain/impl/CargoMetadata$ResolveNode;", "fetchStdlibData", "Lorg/rust/cargo/project/workspace/StandardLibrary;", "remapPath", "libName", "walk", "", "Lorg/rust/cargo/toolchain/impl/CargoMetadata$Project;", "id", "root", "", "collectPackageMetadata", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nStandardLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StdlibDataFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,522:1\n774#2:523\n865#2,2:524\n1563#2:527\n1634#2,3:528\n230#2,2:531\n230#2,2:533\n774#2:535\n865#2,2:536\n1563#2:538\n1634#2,3:539\n774#2:542\n865#2,2:543\n1#3:526\n60#4,4:545\n13#5:549\n*S KotlinDebug\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StdlibDataFetcher\n*L\n236#1:523\n236#1:524,2\n258#1:527\n258#1:528,3\n288#1:531,2\n290#1:533,2\n295#1:535\n295#1:536,2\n306#1:538\n306#1:539,3\n316#1:542\n316#1:543,2\n337#1:545,4\n348#1:549\n*E\n"})
public final class StdlibDataFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cargo cargo;
    @NotNull
    private final VirtualFile srcDir;
    @NotNull
    private final RustcVersion version;
    @NotNull
    private final VirtualFile testPackageSrcDir;
    @NotNull
    private final Path stdlibDependenciesDir;
    @NotNull
    private final List<String> buildTargets;
    @Nullable
    private final String activeToolchain;
    @Nullable
    private final ProcessProgressListener listener;
    @NotNull
    private final List<String> workspaceMembers;
    @NotNull
    private final Set<String> visitedPackages;
    @NotNull
    private final List<CargoMetadata.Package> allPackages;
    @NotNull
    private final List<CargoMetadata.ResolveNode> allNodes;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final SemVer RUSTC_1_72_BETA;

    private StdlibDataFetcher(Project project, Cargo cargo, VirtualFile srcDir, RustcVersion version, VirtualFile testPackageSrcDir, Path stdlibDependenciesDir, List<String> buildTargets, String activeToolchain, ProcessProgressListener listener2) {
        this.project = project;
        this.cargo = cargo;
        this.srcDir = srcDir;
        this.version = version;
        this.testPackageSrcDir = testPackageSrcDir;
        this.stdlibDependenciesDir = stdlibDependenciesDir;
        this.buildTargets = buildTargets;
        this.activeToolchain = activeToolchain;
        this.listener = listener2;
        this.workspaceMembers = new ArrayList();
        this.visitedPackages = new LinkedHashSet();
        this.allPackages = new ArrayList();
        this.allNodes = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StandardLibrary fetchStdlibData() {
        void $this$mapTo$iv$iv;
        Object pkg;
        Object it2;
        Object it3;
        void $this$filterTo$iv$iv;
        this.collectPackageMetadata(this.testPackageSrcDir);
        Iterable $this$filter$iv = AutoInjectedCrates.INSTANCE.getStdlibCrates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it3 = (StdLibInfo)element$iv$iv;
            boolean bl = false;
            if (!(((StdLibInfo)it3).getType() != StdLibType.DEPENDENCY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rootStdlibCrates = (List)destination$iv$iv;
        for (StdLibInfo libInfo : rootStdlibCrates) {
            Object v1;
            VirtualFile packageSrcDir;
            block5: {
                destination$iv$iv = new String[]{libInfo.getName(), "lib" + libInfo.getName()};
                List packageSrcPaths = CollectionsKt.listOf((Object[])destination$iv$iv);
                VirtualFile virtualFile = StandardLibraryKt.access$findFirstFileByRelativePaths(this.srcDir, packageSrcPaths);
                if (virtualFile == null || (virtualFile = virtualFile.getCanonicalFile()) == null) continue;
                packageSrcDir = virtualFile;
                String packageManifestPath = ((Object)org.rust.openapiext.UtilsKt.getPathAsPath(packageSrcDir).resolve("Cargo.toml")).toString();
                it3 = this.allPackages;
                Iterator iterator2 = it3.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    it2 = (CargoMetadata.Package)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((CargoMetadata.Package)it2).getManifest_path(), (Object)packageManifestPath)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            pkg = v1;
            if (pkg == null) {
                this.collectPackageMetadata(packageSrcDir);
                continue;
            }
            ((Collection)this.workspaceMembers).add(((CargoMetadata.Package)pkg).getId());
        }
        CargoMetadata.Resolve resolve = new CargoMetadata.Resolve(this.allNodes);
        String string = this.srcDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        CargoMetadata.Project stdlibMetadataProject = new CargoMetadata.Project(this.allPackages, resolve, 1, this.workspaceMembers, string);
        CargoWorkspaceData stdlibWorkspaceData = CargoMetadata.clean$default(CargoMetadata.INSTANCE, this.project, stdlibMetadataProject, null, null, null, 28, null);
        Iterable $this$map$iv = stdlibWorkspaceData.getPackages();
        boolean $i$f$map = false;
        pkg = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (CargoWorkspaceData.Package)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            PackageOrigin newOrigin = ((CargoWorkspaceData.Package)it2).getSource() == null ? PackageOrigin.STDLIB : PackageOrigin.STDLIB_DEPENDENCY;
            collection.add(CargoWorkspaceData.Package.copy$default((CargoWorkspaceData.Package)it2, null, null, null, null, null, null, newOrigin, null, null, null, null, null, null, null, null, 32703, null));
        }
        List stdlibPackages = (List)destination$iv$iv2;
        return new StandardLibrary(CargoWorkspaceData.copy$default(stdlibWorkspaceData, stdlibPackages, null, null, null, 14, null), false, false, 4, null);
    }

    private final String remapPath(String $this$remapPath, String libName, String version) {
        Path path = UtilsKt.toPath($this$remapPath);
        for (int i2 = path.getNameCount() - 1; -1 < i2; --i2) {
            String fileName = ((Object)path.getName(i2).getFileName()).toString();
            if (!StringsKt.startsWith$default((String)fileName, (String)libName, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)fileName, (String)version, (boolean)false, (int)2, null)) continue;
            Path subpath = path.subpath(i2 + 1, path.getNameCount());
            return ((Object)this.stdlibDependenciesDir.resolve(libName).resolve(subpath)).toString();
        }
        throw new IllegalStateException(("Failed to remap `" + $this$remapPath + "`").toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void walk(CargoMetadata.Project $this$walk, String id, boolean root) {
        void $this$filterTo$iv$iv;
        Pair pair;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Object it2;
        Object destination$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv3;
        CargoMetadata.Package pkg;
        String stdlibId;
        block15: {
            Object element$iv22;
            block14: {
                if (this.visitedPackages.contains(id)) {
                    return;
                }
                stdlibId = StandardLibraryKt.access$toStdlibId(id);
                if (root) {
                    ((Collection)this.workspaceMembers).add(stdlibId);
                }
                ((Collection)this.visitedPackages).add(id);
                Iterable $this$first$iv = $this$walk.getPackages();
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    CargoMetadata.Package it3 = (CargoMetadata.Package)element$iv22;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it3.getId(), (Object)id)) continue;
                    break block14;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            pkg = (CargoMetadata.Package)element$iv22;
            Iterable $this$first$iv = $this$walk.getResolve().getNodes();
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                CargoMetadata.ResolveNode it4 = (CargoMetadata.ResolveNode)element$iv3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it4.getId(), (Object)id)) continue;
                break block15;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        CargoMetadata.ResolveNode pkgNode = (CargoMetadata.ResolveNode)element$iv3;
        List nodeDeps = new ArrayList();
        List nodeDependencies = new ArrayList();
        List list = pkgNode.getDeps();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (CargoMetadata.Dep dep : list) {
            List depKinds;
            List list2;
            List list3;
            List<CargoMetadata.DepKindInfo> list4 = dep.getDep_kinds();
            if (list4 != null) {
                void $this$filterTo$iv$iv2;
                $this$filter$iv = list4;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it2 = (CargoMetadata.DepKindInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(((CargoMetadata.DepKindInfo)it2).getKind() == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if (!(!((Collection)(depKinds = list2)).isEmpty())) continue;
            ((Collection)nodeDependencies).add(StandardLibraryKt.access$toStdlibId(dep.getPkg()));
            ((Collection)nodeDeps).add(CargoMetadata.Dep.copy$default(dep, StandardLibraryKt.access$toStdlibId(dep.getPkg()), null, depKinds, 2, null));
            this.walk($this$walk, dep.getPkg(), false);
        }
        ((Collection)this.allNodes).add(CargoMetadata.ResolveNode.copy$default(pkgNode, stdlibId, nodeDependencies, nodeDeps, null, 8, null));
        if (pkg.getSource() != null) {
            Iterable $this$map$iv = pkg.getTargets();
            boolean $i$f$map = false;
            $this$filter$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                Iterator iterator2 = (CargoMetadata.Target)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(CargoMetadata.Target.copy$default((CargoMetadata.Target)it5, null, null, this.remapPath(it5.getSrc_path(), pkg.getName(), pkg.getVersion()), null, null, null, null, 123, null));
            }
            List newTargets = (List)destination$iv$iv2;
            pair = TuplesKt.to((Object)this.remapPath(pkg.getManifest_path(), pkg.getName(), pkg.getVersion()), (Object)newTargets);
        } else {
            pair = TuplesKt.to((Object)pkg.getManifest_path(), pkg.getTargets());
        }
        Iterator<Object> iterator3 = pair;
        String newManifestPath = (String)iterator3.component1();
        List newTargets = (List)iterator3.component2();
        $this$mapTo$iv$iv = pkg.getDependencies();
        Map map2 = null;
        String string = null;
        List list5 = newTargets;
        String string2 = newManifestPath;
        String string3 = stdlibId;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        List list6 = null;
        String string9 = null;
        String string10 = null;
        object = pkg;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (CargoMetadata.RawDependency)element$iv$iv;
            boolean bl = false;
            if (!(((CargoMetadata.RawDependency)it2).getKind() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list7 = (List)destination$iv$iv;
        CargoMetadata.Package newPkg = CargoMetadata.Package.copy$default((CargoMetadata.Package)object, string10, string9, list6, string8, string7, string6, string5, string4, string3, string2, list5, string, map2, list7, null, 22783, null);
        ((Collection)this.allPackages).add(newPkg);
    }

    /*
     * WARNING - void declaration
     */
    private final void collectPackageMetadata(VirtualFile $this$collectPackageMetadata) {
        String string;
        Object v3;
        CargoMetadata.Project metadataProject;
        block7: {
            void $this$unwrapOrElse$iv;
            VirtualFile manifest = $this$collectPackageMetadata.findChild("Cargo.toml");
            if (manifest == null) {
                LOG.warn("There isn't `Cargo.toml` in `" + $this$collectPackageMetadata.getPath() + "` directory");
                return;
            }
            RsResult<CargoMetadata.Project, RsProcessExecutionOrDeserializationException> rsResult = this.cargo.fetchMetadata(this.project, org.rust.openapiext.UtilsKt.getPathAsPath($this$collectPackageMetadata), this.buildTargets, this.activeToolchain, StdlibDataFetcher.Companion.additionalEnvVariables(this.version), this.listener);
            boolean $i$f$unwrapOrElse = false;
            void var6_5 = $this$unwrapOrElse$iv;
            if (!(var6_5 instanceof RsResult.Ok)) {
                if (var6_5 instanceof RsResult.Err) {
                    RsProcessExecutionOrDeserializationException it2 = (RsProcessExecutionOrDeserializationException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                    boolean bl = false;
                    ProcessProgressListener processProgressListener = this.listener;
                    if (processProgressListener != null) {
                        String string2 = RsBundle.INSTANCE.message("build.event.title.failed.to.fetch.stdlib.package.info", new Object[0]);
                        String string3 = it2.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        processProgressListener.error(string2, string3);
                    }
                    throw it2;
                }
                throw new NoWhenBranchMatchedException();
            }
            metadataProject = (CargoMetadata.Project)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
            Iterable iterable = metadataProject.getWorkspace_members();
            for (Object t : iterable) {
                String it3 = (String)t;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it3, (CharSequence)"sysroot", (boolean)false, (int)2, null)) continue;
                v3 = t;
                break block7;
            }
            v3 = null;
        }
        if ((string = (String)v3) == null) {
            string = (String)CollectionsKt.first(metadataProject.getWorkspace_members());
        }
        String rootPackageId = string;
        this.walk(metadataProject, rootPackageId, true);
    }

    public /* synthetic */ StdlibDataFetcher(Project project, Cargo cargo, VirtualFile srcDir, RustcVersion version, VirtualFile testPackageSrcDir, Path stdlibDependenciesDir, List buildTargets, String activeToolchain, ProcessProgressListener listener2, DefaultConstructorMarker $constructor_marker) {
        this(project, cargo, srcDir, version, testPackageSrcDir, stdlibDependenciesDir, buildTargets, activeToolchain, listener2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StdlibDataFetcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        RUSTC_1_72_BETA = ToolchainUtilKt.parseSemVer("1.72.0-beta");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017JN\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/rust/cargo/project/workspace/StdlibDataFetcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RUSTC_1_72_BETA", "Lcom/intellij/util/text/SemVer;", "create", "Lorg/rust/cargo/project/workspace/StdlibDataFetcher;", "project", "Lcom/intellij/openapi/project/Project;", "srcDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "buildTargets", "", "", "activeToolchain", "listener", "Lorg/rust/cargo/project/model/ProcessProgressListener;", "cleanVendorDir", "", "findStdlibDependencyDirectory", "Ljava/nio/file/Path;", "cargo", "Lorg/rust/cargo/toolchain/tools/Cargo;", "testPackageSrcDir", "tryGetBundledStdlibVendor", "stdlibVendor", "additionalEnvVariables", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nStandardLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StdlibDataFetcher$Companion\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n*L\n1#1,522:1\n60#2,4:523\n*S KotlinDebug\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StdlibDataFetcher$Companion\n*L\n434#1:523,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final StdlibDataFetcher create(@NotNull Project project, @NotNull VirtualFile srcDir, @NotNull RustcVersion version, @NotNull List<String> buildTargets, @Nullable String activeToolchain, @Nullable ProcessProgressListener listener2, boolean cleanVendorDir) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)srcDir, (String)"srcDir");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(buildTargets, (String)"buildTargets");
            Object object = RustProjectSettingsServiceKt.getToolchain(project);
            if (object == null || (object = CargoKt.cargo((RsToolchainBase)object)) == null) {
                return null;
            }
            Object cargo = object;
            Object[] objectArray = new String[]{"sysroot", "test", "libtest"};
            List testPackageSrcPaths = CollectionsKt.listOf((Object[])objectArray);
            VirtualFile virtualFile = StandardLibraryKt.access$findFirstFileByRelativePaths(srcDir, testPackageSrcPaths);
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 == null || (virtualFile2 = virtualFile2.getCanonicalFile()) == null) {
                return null;
            }
            VirtualFile testPackageSrcDir = virtualFile2;
            try {
                if (VirtualFileUtil.findFile((VirtualFile)srcDir, (String)"Cargo.lock") == null) {
                    Path cargoLock;
                    VirtualFile virtualFile3 = srcDir.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
                    VirtualFile virtualFile4 = VirtualFileUtil.findFile((VirtualFile)virtualFile3, (String)"Cargo.lock");
                    Path path = cargoLock = virtualFile4 != null ? org.rust.openapiext.UtilsKt.getPathAsPath(virtualFile4) : null;
                    if (cargoLock != null) {
                        Path newCargoLock = org.rust.openapiext.UtilsKt.getPathAsPath(testPackageSrcDir).resolve("Cargo.lock");
                        Intrinsics.checkNotNull((Object)newCargoLock);
                        PathKt.copy((Path)cargoLock, (Path)newCargoLock);
                    }
                }
            }
            catch (IOException cargoLock) {
                // empty catch block
            }
            Path path = this.findStdlibDependencyDirectory(project, (Cargo)cargo, srcDir, testPackageSrcDir, version, activeToolchain, listener2, cleanVendorDir);
            if (path == null) {
                return null;
            }
            Path stdlibDependenciesDir = path;
            return new StdlibDataFetcher(project, (Cargo)cargo, srcDir, version, testPackageSrcDir, stdlibDependenciesDir, buildTargets, activeToolchain, listener2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Path findStdlibDependencyDirectory(Project project, Cargo cargo, VirtualFile srcDir, VirtualFile testPackageSrcDir, RustcVersion version, String activeToolchain, ProcessProgressListener listener2, boolean cleanVendorDir) {
            Path stdlibVendor = RsPathManager.INSTANCE.stdlibVendorDir(org.rust.openapiext.UtilsKt.getPathAsPath(srcDir), version);
            LOG.info("Stdlib vendor dir is " + stdlibVendor);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean stdlibVendorExists = Files.exists(stdlibVendor, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            if (stdlibVendorExists && cleanVendorDir) {
                try {
                    PathKt.delete((Path)stdlibVendor, (boolean)true);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
                stdlibVendorExists = false;
            } else if (!stdlibVendorExists && !cleanVendorDir) {
                stdlibVendorExists = this.tryGetBundledStdlibVendor(stdlibVendor, version);
            }
            if (!stdlibVendorExists) {
                void $this$unwrapOrElse$iv;
                RsResult<Unit, RsProcessExecutionException> e = cargo.vendorDependencies(project, org.rust.openapiext.UtilsKt.getPathAsPath(testPackageSrcDir), stdlibVendor, activeToolchain, this.additionalEnvVariables(version), listener2);
                boolean $i$f$unwrapOrElse = false;
                void var13_14 = $this$unwrapOrElse$iv;
                if (var13_14 instanceof RsResult.Ok) {
                    ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
                } else {
                    if (var13_14 instanceof RsResult.Err) {
                        RsProcessExecutionException it2 = (RsProcessExecutionException)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                        boolean bl = false;
                        ProcessProgressListener processProgressListener = listener2;
                        if (processProgressListener != null) {
                            String string = RsBundle.INSTANCE.message("build.event.title.failed.to.load.stdlib.dependencies", new Object[0]);
                            String string2 = it2.getMessage();
                            if (string2 == null) {
                                string2 = "";
                            }
                            processProgressListener.error(string, string2);
                        }
                        LOG.warn((Throwable)it2);
                        return null;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
            return stdlibVendor;
        }

        private final boolean tryGetBundledStdlibVendor(Path stdlibVendor, RustcVersion version) {
            Path bundledStdlibVendor = RsPathManager.INSTANCE.bundledCachesDir().resolve("rust-stdlib-vendor-" + version.getSemver() + ".zip");
            Intrinsics.checkNotNull((Object)bundledStdlibVendor);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(bundledStdlibVendor, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return false;
            }
            try {
                stdlibVendor.toFile().mkdirs();
                ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(bundledStdlibVendor, new OpenOption[0]));
                ZipKt.unzipTo(zipStream, stdlibVendor);
                LOG.info("Using bundled stdlib dependencies from " + bundledStdlibVendor);
                return true;
            }
            catch (Exception e) {
                PathKt.delete((Path)stdlibVendor, (boolean)true);
                LOG.warn("Failed to get bundled stdlib dependencies from " + bundledStdlibVendor, (Throwable)e);
                return false;
            }
        }

        private final EnvironmentVariablesData additionalEnvVariables(RustcVersion version) {
            EnvironmentVariablesData environmentVariablesData;
            boolean addRustcBootstrap;
            boolean bl = addRustcBootstrap = version.getSemver().compareTo(RUSTC_1_72_BETA) >= 0;
            if (addRustcBootstrap) {
                EnvironmentVariablesData environmentVariablesData2 = EnvironmentVariablesData.create((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"RUSTC_BOOTSTRAP", (Object)"1")), (boolean)true);
                Intrinsics.checkNotNull((Object)environmentVariablesData2);
                environmentVariablesData = environmentVariablesData2;
            } else {
                EnvironmentVariablesData environmentVariablesData3 = EnvironmentVariablesData.DEFAULT;
                Intrinsics.checkNotNull((Object)environmentVariablesData3);
                environmentVariablesData = environmentVariablesData3;
            }
            return environmentVariablesData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

