/*
 * Decompiled with CFR 0.152.
 */
package org.rust.cargo.project.workspace;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.CargoConfig;
import org.rust.cargo.CfgOptions;
import org.rust.cargo.project.model.ProcessProgressListener;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.CargoWorkspaceData;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.project.workspace.StandardLibraryKt;
import org.rust.cargo.project.workspace.StdlibDataFetcher;
import org.rust.cargo.toolchain.impl.CargoMetadataException;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.util.AutoInjectedCrates;
import org.rust.cargo.util.StdLibInfo;
import org.rust.openapiext.RsProcessExecutionException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/rust/cargo/project/workspace/StandardLibrary;", "", "workspaceData", "Lorg/rust/cargo/project/workspace/CargoWorkspaceData;", "isHardcoded", "", "isPartOfCargoProject", "<init>", "(Lorg/rust/cargo/project/workspace/CargoWorkspaceData;ZZ)V", "getWorkspaceData", "()Lorg/rust/cargo/project/workspace/CargoWorkspaceData;", "()Z", "crates", "", "Lorg/rust/cargo/project/workspace/CargoWorkspaceData$Package;", "getCrates", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nStandardLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StandardLibrary\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,522:1\n13#2:523\n*S KotlinDebug\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StandardLibrary\n*L\n61#1:523\n*E\n"})
public final class StandardLibrary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CargoWorkspaceData workspaceData;
    private final boolean isHardcoded;
    private final boolean isPartOfCargoProject;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> SRC_ROOTS;
    @NotNull
    private static final List<String> LIB_PATHS;

    public StandardLibrary(@NotNull CargoWorkspaceData workspaceData, boolean isHardcoded, boolean isPartOfCargoProject) {
        Intrinsics.checkNotNullParameter((Object)workspaceData, (String)"workspaceData");
        this.workspaceData = workspaceData;
        this.isHardcoded = isHardcoded;
        this.isPartOfCargoProject = isPartOfCargoProject;
    }

    public /* synthetic */ StandardLibrary(CargoWorkspaceData cargoWorkspaceData, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(cargoWorkspaceData, bl, bl2);
    }

    @NotNull
    public final CargoWorkspaceData getWorkspaceData() {
        return this.workspaceData;
    }

    public final boolean isHardcoded() {
        return this.isHardcoded;
    }

    public final boolean isPartOfCargoProject() {
        return this.isPartOfCargoProject;
    }

    @NotNull
    public final List<CargoWorkspaceData.Package> getCrates() {
        return this.workspaceData.getPackages();
    }

    @NotNull
    public final CargoWorkspaceData component1() {
        return this.workspaceData;
    }

    public final boolean component2() {
        return this.isHardcoded;
    }

    public final boolean component3() {
        return this.isPartOfCargoProject;
    }

    @NotNull
    public final StandardLibrary copy(@NotNull CargoWorkspaceData workspaceData, boolean isHardcoded, boolean isPartOfCargoProject) {
        Intrinsics.checkNotNullParameter((Object)workspaceData, (String)"workspaceData");
        return new StandardLibrary(workspaceData, isHardcoded, isPartOfCargoProject);
    }

    public static /* synthetic */ StandardLibrary copy$default(StandardLibrary standardLibrary, CargoWorkspaceData cargoWorkspaceData, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            cargoWorkspaceData = standardLibrary.workspaceData;
        }
        if ((n & 2) != 0) {
            bl = standardLibrary.isHardcoded;
        }
        if ((n & 4) != 0) {
            bl2 = standardLibrary.isPartOfCargoProject;
        }
        return standardLibrary.copy(cargoWorkspaceData, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "StandardLibrary(workspaceData=" + this.workspaceData + ", isHardcoded=" + this.isHardcoded + ", isPartOfCargoProject=" + this.isPartOfCargoProject + ")";
    }

    public int hashCode() {
        int result2 = this.workspaceData.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isHardcoded);
        result2 = result2 * 31 + Boolean.hashCode(this.isPartOfCargoProject);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StandardLibrary)) {
            return false;
        }
        StandardLibrary standardLibrary = (StandardLibrary)other;
        if (!Intrinsics.areEqual((Object)this.workspaceData, (Object)standardLibrary.workspaceData)) {
            return false;
        }
        if (this.isHardcoded != standardLibrary.isHardcoded) {
            return false;
        }
        return this.isPartOfCargoProject == standardLibrary.isPartOfCargoProject;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StandardLibrary.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"library", "src"};
        SRC_ROOTS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"src/lib.rs", "lib.rs"};
        LIB_PATHS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016JL\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0007Jb\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\"\u001a\u00020\u00142\b\b\u0002\u0010#\u001a\u00020\u0014H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/rust/cargo/project/workspace/StandardLibrary$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SRC_ROOTS", "", "", "LIB_PATHS", "fromPath", "Lorg/rust/cargo/project/workspace/StandardLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "path", "rustcInfo", "Lorg/rust/cargo/project/model/RustcInfo;", "cargoConfig", "Lorg/rust/cargo/CargoConfig;", "isPartOfCargoProject", "", "listener", "Lorg/rust/cargo/project/model/ProcessProgressListener;", "fromFile", "sources", "Lcom/intellij/openapi/vfs/VirtualFile;", "cargoProjectDirectory", "Ljava/nio/file/Path;", "findSrcDir", "fetchActualStdlib", "srcDir", "version", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "buildTargets", "cleanVendorDir", "cleanStdLibCopyDir", "fetchHardcodedStdlib", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nStandardLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StandardLibrary$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,522:1\n1#2:523\n382#3,7:524\n*S KotlinDebug\n*F\n+ 1 StandardLibrary.kt\norg/rust/cargo/project/workspace/StandardLibrary$Companion\n*L\n202#1:524,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final StandardLibrary fromPath(@NotNull Project project, @NotNull String path, @Nullable RustcInfo rustcInfo, @NotNull CargoConfig cargoConfig, boolean isPartOfCargoProject, @Nullable ProcessProgressListener listener2) {
            StandardLibrary standardLibrary;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)cargoConfig, (String)"cargoConfig");
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                VirtualFile it2 = virtualFile;
                boolean bl = false;
                standardLibrary = Companion.fromFile(project, it2, rustcInfo, it2.getFileSystem().getNioPath(it2), cargoConfig, isPartOfCargoProject, listener2);
            } else {
                standardLibrary = null;
            }
            return standardLibrary;
        }

        public static /* synthetic */ StandardLibrary fromPath$default(Companion companion, Project project, String string, RustcInfo rustcInfo, CargoConfig cargoConfig, boolean bl, ProcessProgressListener processProgressListener, int n, Object object) {
            if ((n & 8) != 0) {
                cargoConfig = CargoConfig.Companion.getDEFAULT();
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                processProgressListener = null;
            }
            return companion.fromPath(project, string, rustcInfo, cargoConfig, bl, processProgressListener);
        }

        @Nullable
        public final StandardLibrary fromFile(@NotNull Project project, @NotNull VirtualFile sources, @Nullable RustcInfo rustcInfo, @Nullable Path cargoProjectDirectory, @NotNull CargoConfig cargoConfig, boolean isPartOfCargoProject, @Nullable ProcessProgressListener listener2) {
            StandardLibrary stdlib;
            StandardLibrary standardLibrary;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
            Intrinsics.checkNotNullParameter((Object)cargoConfig, (String)"cargoConfig");
            VirtualFile virtualFile = this.findSrcDir(sources);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile srcDir = virtualFile;
            if (!isPartOfCargoProject) {
                SemVer semverVersion;
                RustcVersion rustcVersion;
                RustcInfo rustcInfo2 = rustcInfo;
                RustcVersion rustcVersion2 = rustcVersion = rustcInfo2 != null ? rustcInfo2.getVersion() : null;
                Object object = semverVersion = rustcVersion2 != null ? rustcVersion2.getSemver() : null;
                if (semverVersion == null) {
                    org.rust.cargo.project.workspace.StandardLibrary$Companion.fromFile$warn(listener2, RsBundle.INSTANCE.message("toolchain.version.is.unknown.hardcoded.stdlib.structure.will.be.used", new Object[0]));
                    standardLibrary = this.fetchHardcodedStdlib(srcDir);
                } else {
                    Collection collection;
                    Collection collection2 = cargoConfig.getBuildTargets();
                    if (collection2.isEmpty()) {
                        boolean bl = false;
                        collection = CollectionsKt.listOfNotNull((Object)rustcVersion.getHost());
                    } else {
                        collection = collection2;
                    }
                    List buildTargets = (List)collection;
                    StandardLibrary result2 = org.rust.cargo.project.workspace.StandardLibrary$Companion.fetchActualStdlib$default(this, project, srcDir, rustcVersion, buildTargets, rustcInfo, cargoProjectDirectory, listener2, false, false, 384, null);
                    if (result2 == null) {
                        org.rust.cargo.project.workspace.StandardLibrary$Companion.fromFile$warn(listener2, RsBundle.INSTANCE.message("fetching.actual.stdlib.info.failed.hardcoded.stdlib.structure.will.be.used", new Object[0]));
                    }
                    if ((standardLibrary = result2) == null) {
                        standardLibrary = this.fetchHardcodedStdlib(srcDir);
                    }
                }
            } else {
                LOG.info("Using a hardcoded stdlib because the project looks like rust-lang/rust");
                standardLibrary = this.fetchHardcodedStdlib(srcDir);
            }
            StandardLibrary standardLibrary2 = stdlib = standardLibrary;
            return standardLibrary2 != null ? StandardLibrary.copy$default(standardLibrary2, null, false, isPartOfCargoProject, 3, null) : null;
        }

        public static /* synthetic */ StandardLibrary fromFile$default(Companion companion, Project project, VirtualFile virtualFile, RustcInfo rustcInfo, Path path, CargoConfig cargoConfig, boolean bl, ProcessProgressListener processProgressListener, int n, Object object) {
            if ((n & 0x10) != 0) {
                cargoConfig = CargoConfig.Companion.getDEFAULT();
            }
            if ((n & 0x20) != 0) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                processProgressListener = null;
            }
            return companion.fromFile(project, virtualFile, rustcInfo, path, cargoConfig, bl, processProgressListener);
        }

        @VisibleForTesting
        @Nullable
        public final VirtualFile findSrcDir(@NotNull VirtualFile sources) {
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
            if (!sources.isDirectory()) {
                return null;
            }
            if (SRC_ROOTS.contains(sources.getName())) {
                virtualFile = sources;
            } else {
                virtualFile = StandardLibraryKt.access$findFirstFileByRelativePaths(sources, SRC_ROOTS);
                if (virtualFile == null) {
                    virtualFile = sources;
                }
            }
            return virtualFile;
        }

        private final StandardLibrary fetchActualStdlib(Project project, VirtualFile srcDir, RustcVersion version, List<String> buildTargets, RustcInfo rustcInfo, Path cargoProjectDirectory, ProcessProgressListener listener2, boolean cleanVendorDir, boolean cleanStdLibCopyDir) {
            try {
                RustcInfo rustcInfo2 = rustcInfo;
                StdlibDataFetcher stdlibDataFetcher = StdlibDataFetcher.Companion.create(project, srcDir, version, buildTargets, rustcInfo2 != null ? rustcInfo2.getRustupActiveToolchain() : null, listener2, cleanVendorDir);
                return stdlibDataFetcher != null ? stdlibDataFetcher.fetchStdlibData() : null;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                boolean willRetryWithVendorDirCleaning;
                boolean bl = willRetryWithVendorDirCleaning = !cleanVendorDir && e instanceof CargoMetadataException;
                if (willRetryWithVendorDirCleaning) {
                    LOG.warn(e);
                }
                if (willRetryWithVendorDirCleaning) {
                    return this.fetchActualStdlib(project, srcDir, version, buildTargets, rustcInfo, cargoProjectDirectory, listener2, true, cleanStdLibCopyDir);
                }
                if (cleanStdLibCopyDir && e instanceof RsProcessExecutionException.ProcessAborted) {
                    RustcInfo rustcInfo3 = rustcInfo;
                    if (StandardLibraryKt.access$tryRecopyStdLib(project, cargoProjectDirectory, rustcInfo3 != null ? rustcInfo3.getToolchain() : null, version)) {
                        return this.fetchActualStdlib(project, srcDir, version, buildTargets, rustcInfo, cargoProjectDirectory, listener2, true, false);
                    }
                }
                return null;
            }
        }

        static /* synthetic */ StandardLibrary fetchActualStdlib$default(Companion companion, Project project, VirtualFile virtualFile, RustcVersion rustcVersion, List list, RustcInfo rustcInfo, Path path, ProcessProgressListener processProgressListener, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 0x80) != 0) {
                bl = false;
            }
            if ((n & 0x100) != 0) {
                bl2 = true;
            }
            return companion.fetchActualStdlib(project, virtualFile, rustcVersion, list, rustcInfo, path, processProgressListener, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        private final StandardLibrary fetchHardcodedStdlib(VirtualFile srcDir) {
            Map crates = new LinkedHashMap();
            for (StdLibInfo libInfo : AutoInjectedCrates.INSTANCE.getStdlibCrates()) {
                VirtualFile libFile;
                VirtualFile packageSrcDir;
                Object[] objectArray = new String[]{libInfo.getName(), "lib" + libInfo.getName()};
                List packageSrcPaths = CollectionsKt.listOf((Object[])objectArray);
                VirtualFile virtualFile = StandardLibraryKt.access$findFirstFileByRelativePaths(srcDir, packageSrcPaths);
                VirtualFile virtualFile2 = packageSrcDir = virtualFile != null ? virtualFile.getCanonicalFile() : null;
                Object object = libFile = virtualFile2 != null ? StandardLibraryKt.access$findFirstFileByRelativePaths(virtualFile2, LIB_PATHS) : null;
                if (packageSrcDir == null || libFile == null) continue;
                String string = StandardLibraryKt.access$toStdlibId(libInfo.getName());
                String string2 = packageSrcDir.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                String string3 = libInfo.getName();
                String string4 = libFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getUrl(...)");
                CargoWorkspace.LibKind[] libKindArray = new CargoWorkspace.LibKind[]{CargoWorkspace.LibKind.LIB};
                CargoWorkspaceData.Package cratePkg = new CargoWorkspaceData.Package(string, string2, string3, "", CollectionsKt.listOf((Object)new CargoWorkspaceData.Target(string4, libInfo.getName(), new CargoWorkspace.TargetKind.Lib(libKindArray), CargoWorkspace.Edition.EDITION_2015, true, CollectionsKt.emptyList())), null, PackageOrigin.STDLIB, CargoWorkspace.Edition.EDITION_2015, MapsKt.emptyMap(), SetsKt.emptySet(), CfgOptions.Companion.getEMPTY(), MapsKt.emptyMap(), null, null, SetsKt.emptySet(), 8192, null);
                crates.put(cratePkg.getId(), cratePkg);
            }
            Map dependencies = new LinkedHashMap();
            List depKinds = CollectionsKt.listOf((Object)new CargoWorkspace.DepKindInfo(CargoWorkspace.DepKind.Stdlib, null, 2, null));
            for (StdLibInfo libInfo : AutoInjectedCrates.INSTANCE.getStdlibCrates()) {
                String pkgId = StandardLibraryKt.access$toStdlibId(libInfo.getName());
                if (crates.get(pkgId) == null) continue;
                for (String dependency : libInfo.getDependencies()) {
                    Object object;
                    void $this$getOrPut$iv;
                    String dependencyId = StandardLibraryKt.access$toStdlibId(dependency);
                    if (crates.get(dependencyId) == null) continue;
                    Object object2 = dependencies;
                    String key$iv = pkgId;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    object2 = (Collection)object;
                    object2.add(new CargoWorkspaceData.Dependency(dependencyId, null, depKinds, 2, null));
                }
            }
            if (crates.isEmpty()) {
                return null;
            }
            CargoWorkspaceData data2 = new CargoWorkspaceData(CollectionsKt.toList((Iterable)crates.values()), dependencies, MapsKt.emptyMap(), null, 8, null);
            return new StandardLibrary(data2, true, false, 4, null);
        }

        private static final void fromFile$warn(ProcessProgressListener $listener, String message) {
            block0: {
                LOG.warn(message);
                ProcessProgressListener processProgressListener = $listener;
                if (processProgressListener == null) break block0;
                processProgressListener.warning(message, "");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

